/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfp;
import com.google.android.gms.internal.zzcfx;
import com.google.android.gms.internal.zzcfz;
import com.google.android.gms.internal.zzcgb;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcje;
import com.google.android.gms.internal.zzcjf;
import com.google.android.gms.internal.zzcjg;
import com.google.android.gms.internal.zzcjh;
import com.google.android.gms.internal.zzcji;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcjm;
import com.google.android.gms.internal.zzcjn;
import com.google.android.gms.internal.zzcjo;
import com.google.android.gms.internal.zzcjp;
import com.google.android.gms.internal.zzcjq;
import com.google.android.gms.internal.zzcjr;
import com.google.android.gms.internal.zzckh;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckn;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcjd
extends zzcii {
    private final zzcjr zzjfh;
    private zzcgb zzjfi;
    private volatile Boolean zzjfj;
    private final zzcfp zzjfk;
    private final zzckh zzjfl;
    private final List<Runnable> zzjfm = new ArrayList<Runnable>();
    private final zzcfp zzjfn;

    protected zzcjd(zzchj zzchj2) {
        super(zzchj2);
        this.zzjfl = new zzckh(zzchj2.zzwh());
        this.zzjfh = new zzcjr(this);
        this.zzjfk = new zzcje(this, zzchj2);
        this.zzjfn = new zzcjj(this, zzchj2);
    }

    @Override
    protected final boolean zzaxn() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzcih)this).zzut();
        this.zzwu();
        return this.zzjfi != null;
    }

    @WorkerThread
    protected final void zzbae() {
        ((zzcih)this).zzut();
        this.zzwu();
        zzcff zzcff2 = this.zzbq(true);
        this.zzj(new zzcjk(this, zzcff2));
    }

    @WorkerThread
    final void zza(zzcgb zzcgb2, zzbej zzbej2, zzcff zzcff2) {
        ((zzcih)this).zzut();
        this.zzwu();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<zzbej> arrayList = new ArrayList<zzbej>();
            n = 0;
            List<zzbej> list = ((zzcih)this).zzawf().zzeb(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zzbej2 != null && n < 100) {
                arrayList.add(zzbej2);
            }
            ArrayList<zzbej> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                zzbej zzbej3 = (zzbej)e;
                if (zzbej3 instanceof zzcfx) {
                    try {
                        zzcgb2.zza((zzcfx)zzbej3, zzcff2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcih)this).zzawm().zzayr().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbej3 instanceof zzckk) {
                    try {
                        zzcgb2.zza((zzckk)zzbej3, zzcff2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcih)this).zzawm().zzayr().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbej3 instanceof zzcfi) {
                    try {
                        zzcgb2.zza((zzcfi)zzbej3, zzcff2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcih)this).zzawm().zzayr().zzj("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzcih)this).zzawm().zzayr().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzcfx zzcfx2, String string) {
        zzbq.checkNotNull((Object)((Object)zzcfx2));
        ((zzcih)this).zzut();
        this.zzwu();
        boolean bl = ((zzcih)this).zzawf().zza(zzcfx2);
        zzcff zzcff2 = this.zzbq(true);
        this.zzj(new zzcjl(this, true, bl, zzcfx2, zzcff2, string));
    }

    @WorkerThread
    protected final void zzf(zzcfi zzcfi2) {
        zzbq.checkNotNull((Object)((Object)zzcfi2));
        ((zzcih)this).zzut();
        this.zzwu();
        boolean bl = ((zzcih)this).zzawf().zzc(zzcfi2);
        zzcfi zzcfi3 = new zzcfi(zzcfi2);
        zzcff zzcff2 = this.zzbq(true);
        this.zzj(new zzcjm(this, true, bl, zzcfi3, zzcff2, zzcfi2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcfi>> atomicReference, String string, String string2, String string3) {
        ((zzcih)this).zzut();
        this.zzwu();
        zzcff zzcff2 = this.zzbq(false);
        this.zzj(new zzcjn(this, atomicReference, string, string2, string3, zzcff2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzckk>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzcih)this).zzut();
        this.zzwu();
        zzcff zzcff2 = this.zzbq(false);
        this.zzj(new zzcjo(this, atomicReference, string, string2, string3, bl, zzcff2));
    }

    @WorkerThread
    protected final void zzb(zzckk zzckk2) {
        ((zzcih)this).zzut();
        this.zzwu();
        boolean bl = ((zzcih)this).zzawf().zza(zzckk2);
        zzcff zzcff2 = this.zzbq(true);
        this.zzj(new zzcjp(this, bl, zzckk2, zzcff2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzckk>> atomicReference, boolean bl) {
        ((zzcih)this).zzut();
        this.zzwu();
        zzcff zzcff2 = this.zzbq(false);
        this.zzj(new zzcjq(this, atomicReference, zzcff2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzcih)this).zzut();
        this.zzwu();
        zzcff zzcff2 = this.zzbq(false);
        ((zzcih)this).zzawf().resetAnalyticsData();
        this.zzj(new zzcjf(this, zzcff2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzcih)this).zzut();
        this.zzwu();
        zzcff zzcff2 = this.zzbq(false);
        this.zzj(new zzcjg(this, atomicReference, zzcff2));
    }

    @WorkerThread
    protected final void zzbaf() {
        ((zzcih)this).zzut();
        this.zzwu();
        zzcff zzcff2 = this.zzbq(true);
        this.zzj(new zzcjh(this, zzcff2));
    }

    @WorkerThread
    protected final void zza(AppMeasurement.zzb zzb2) {
        ((zzcih)this).zzut();
        this.zzwu();
        this.zzj(new zzcji(this, zzb2));
    }

    @WorkerThread
    private final void zzxg() {
        ((zzcih)this).zzut();
        this.zzjfl.start();
        this.zzjfk.zzr(zzcfz.zziyo.get());
    }

    @WorkerThread
    final void zzxr() {
        Intent intent;
        Object object;
        zzcjd zzcjd2;
        ((zzcih)this).zzut();
        this.zzwu();
        if (this.isConnected()) {
            return;
        }
        if (this.zzjfj == null) {
            boolean bl;
            zzcjd2 = this;
            ((zzcih)zzcjd2).zzut();
            zzcjd2.zzwu();
            object = ((zzcih)zzcjd2).zzawn().zzazc();
            if (object != null && ((Boolean)object).booleanValue()) {
                bl = true;
            } else {
                boolean bl2;
                boolean bl3;
                if (((zzcih)zzcjd2).zzawb().zzayp() == 1) {
                    bl3 = true;
                    bl2 = true;
                } else {
                    ((zzcih)zzcjd2).zzawm().zzayx().log("Checking service availability");
                    zzckn zzckn2 = ((zzcih)zzcjd2).zzawi();
                    int n = zze.zzafm().isGooglePlayServicesAvailable(((zzcih)zzckn2).getContext());
                    switch (n) {
                        case 0: {
                            ((zzcih)zzcjd2).zzawm().zzayx().log("Service available");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 1: {
                            ((zzcih)zzcjd2).zzawm().zzayx().log("Service missing");
                            bl3 = false;
                            bl2 = true;
                            break;
                        }
                        case 18: {
                            ((zzcih)zzcjd2).zzawm().zzayt().log("Service updating");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 2: {
                            ((zzcih)zzcjd2).zzawm().zzayw().log("Service container out of date");
                            zzckn2 = ((zzcih)zzcjd2).zzawi();
                            zze.zzafm();
                            if (zze.zzcd((Context)((zzcih)zzckn2).getContext()) < 11400) {
                                bl3 = false;
                                bl2 = true;
                                break;
                            }
                            Boolean bl4 = ((zzcih)zzcjd2).zzawn().zzazc();
                            bl3 = bl4 == null || bl4 != false;
                            bl2 = false;
                            break;
                        }
                        case 3: {
                            ((zzcih)zzcjd2).zzawm().zzayt().log("Service disabled");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        case 9: {
                            ((zzcih)zzcjd2).zzawm().zzayt().log("Service invalid");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        default: {
                            ((zzcih)zzcjd2).zzawm().zzayt().zzj("Unexpected service status", n);
                            bl3 = false;
                            bl2 = false;
                        }
                    }
                }
                if (bl2) {
                    ((zzcih)zzcjd2).zzawn().zzbl(bl3);
                }
                bl = bl3;
            }
            this.zzjfj = bl;
        }
        if (this.zzjfj.booleanValue()) {
            this.zzjfh.zzbai();
            return;
        }
        zzcjd2 = this;
        object = ((zzcih)zzcjd2).getContext().getPackageManager();
        List list = object.queryIntentServices(intent = new Intent().setClassName(((zzcih)zzcjd2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
        if (list != null && list.size() > 0) {
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            intent2.setComponent(new ComponentName(((zzcih)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzjfh.zzn(intent2);
            return;
        }
        ((zzcih)this).zzawm().zzayr().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    final Boolean zzbag() {
        return this.zzjfj;
    }

    @WorkerThread
    protected final void zza(zzcgb zzcgb2) {
        ((zzcih)this).zzut();
        zzbq.checkNotNull((Object)zzcgb2);
        this.zzjfi = zzcgb2;
        this.zzxg();
        this.zzbah();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzcih)this).zzut();
        this.zzwu();
        try {
            zza.zzalq();
            zzcjr zzcjr2 = this.zzjfh;
            Context context = ((zzcih)this).getContext();
            context.unbindService((ServiceConnection)zzcjr2);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzjfi = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzcih)this).zzut();
        if (this.zzjfi != null) {
            this.zzjfi = null;
            ((zzcih)this).zzawm().zzayx().zzj("Disconnected from device MeasurementService", componentName);
            zzcjd zzcjd2 = this;
            ((zzcih)zzcjd2).zzut();
            zzcjd2.zzxr();
        }
    }

    @WorkerThread
    private final void zzxh() {
        ((zzcih)this).zzut();
        if (!this.isConnected()) {
            return;
        }
        ((zzcih)this).zzawm().zzayx().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzj(Runnable runnable) throws IllegalStateException {
        ((zzcih)this).zzut();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzjfm.size() >= 1000L) {
            ((zzcih)this).zzawm().zzayr().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzjfm.add(runnable);
        this.zzjfn.zzr(60000L);
        this.zzxr();
    }

    @WorkerThread
    private final void zzbah() {
        ((zzcih)this).zzut();
        ((zzcih)this).zzawm().zzayx().zzj("Processing queued up service tasks", this.zzjfm.size());
        for (Runnable runnable : this.zzjfm) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                ((zzcih)this).zzawm().zzayr().zzj("Task exception while flushing queue", throwable);
            }
        }
        this.zzjfm.clear();
        this.zzjfn.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzcff zzbq(boolean bl) {
        return ((zzcih)this).zzawb().zzja(bl ? ((zzcih)this).zzawm().zzayy() : null);
    }

    static /* synthetic */ zzcjr zza(zzcjd zzcjd2) {
        return zzcjd2.zzjfh;
    }

    static /* synthetic */ void zza(zzcjd zzcjd2, ComponentName componentName) {
        zzcjd2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzcgb zza(zzcjd zzcjd2, zzcgb zzcgb2) {
        zzcjd2.zzjfi = null;
        return null;
    }

    static /* synthetic */ void zzb(zzcjd zzcjd2) {
        zzcjd2.zzbah();
    }

    static /* synthetic */ void zzc(zzcjd zzcjd2) {
        zzcjd2.zzxh();
    }

    static /* synthetic */ zzcgb zzd(zzcjd zzcjd2) {
        return zzcjd2.zzjfi;
    }

    static /* synthetic */ void zze(zzcjd zzcjd2) {
        zzcjd2.zzxg();
    }
}

