/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzcgb;
import com.google.android.gms.internal.zzcgd;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcjd;
import com.google.android.gms.internal.zzcjs;
import com.google.android.gms.internal.zzcjt;
import com.google.android.gms.internal.zzcju;
import com.google.android.gms.internal.zzcjv;
import com.google.android.gms.internal.zzcjw;

public final class zzcjr
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zzjfv;
    private volatile zzcgi zzjfw;
    final /* synthetic */ zzcjd zzjfo;

    protected zzcjr(zzcjd zzcjd2) {
        this.zzjfo = zzcjd2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzn(Intent intent) {
        ((zzcih)this.zzjfo).zzut();
        Context context = ((zzcih)this.zzjfo).getContext();
        zza zza2 = zza.zzalq();
        zzcjr zzcjr2 = this;
        synchronized (zzcjr2) {
            if (this.zzjfv) {
                ((zzcih)this.zzjfo).zzawm().zzayx().log("Connection attempt already in progress");
                return;
            }
            ((zzcih)this.zzjfo).zzawm().zzayx().log("Using local app measurement service");
            this.zzjfv = true;
            zza2.zza(context, intent, (ServiceConnection)zzcjd.zza(this.zzjfo), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbq.zzfz((String)"MeasurementServiceConnection.onServiceConnected");
        zzcjr zzcjr2 = this;
        synchronized (zzcjr2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zzjfv = false;
                ((zzcih)this.zzjfo).zzawm().zzayr().log("Service connected with null binder");
                return;
            }
            zzcgb zzcgb2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzcgb2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzcgb ? (zzcgb)iInterface : new zzcgd(iBinder2));
                    ((zzcih)this.zzjfo).zzawm().zzayx().log("Bound to IMeasurementService interface");
                } else {
                    ((zzcih)this.zzjfo).zzawm().zzayr().zzj("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzcih)this.zzjfo).zzawm().zzayr().log("Service connect failed to get IMeasurementService");
            }
            if (zzcgb2 == null) {
                this.zzjfv = false;
                try {
                    zza.zzalq();
                    zzcjr zzcjr3 = zzcjd.zza(this.zzjfo);
                    iInterface = ((zzcih)this.zzjfo).getContext();
                    iInterface.unbindService((ServiceConnection)zzcjr3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzcgb2;
                ((zzcih)this.zzjfo).zzawl().zzg(new zzcjs(this, (zzcgb)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbq.zzfz((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzcih)this.zzjfo).zzawm().zzayw().log("Service disconnected");
        ((zzcih)this.zzjfo).zzawl().zzg(new zzcjt(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzbai() {
        ((zzcih)this.zzjfo).zzut();
        Context context = ((zzcih)this.zzjfo).getContext();
        zzcjr zzcjr2 = this;
        synchronized (zzcjr2) {
            if (this.zzjfv) {
                ((zzcih)this.zzjfo).zzawm().zzayx().log("Connection attempt already in progress");
                return;
            }
            if (this.zzjfw != null) {
                ((zzcih)this.zzjfo).zzawm().zzayx().log("Already awaiting connection attempt");
                return;
            }
            this.zzjfw = new zzcgi(context, Looper.getMainLooper(), this, this);
            ((zzcih)this.zzjfo).zzawm().zzayx().log("Connecting to remote service");
            this.zzjfv = true;
            this.zzjfw.zzajx();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        zzbq.zzfz((String)"MeasurementServiceConnection.onConnected");
        zzcjr zzcjr2 = this;
        synchronized (zzcjr2) {
            try {
                zzcgb zzcgb2 = (zzcgb)this.zzjfw.zzakb();
                this.zzjfw = null;
                ((zzcih)this.zzjfo).zzawl().zzg(new zzcju(this, zzcgb2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzjfw = null;
                this.zzjfv = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzbq.zzfz((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzcih)this.zzjfo).zzawm().zzayw().log("Service connection suspended");
        ((zzcih)this.zzjfo).zzawl().zzg(new zzcjv(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbq.zzfz((String)"MeasurementServiceConnection.onConnectionFailed");
        zzcgj zzcgj2 = this.zzjfo.zzitk.zzazl();
        if (zzcgj2 != null) {
            zzcgj2.zzayt().zzj("Service connection failed", connectionResult);
        }
        zzcjr zzcjr2 = this;
        synchronized (zzcjr2) {
            this.zzjfv = false;
            this.zzjfw = null;
        }
        ((zzcih)this.zzjfo).zzawl().zzg(new zzcjw(this));
    }

    static /* synthetic */ boolean zza(zzcjr zzcjr2, boolean bl) {
        zzcjr2.zzjfv = false;
        return false;
    }
}

