/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzchm;
import com.google.android.gms.internal.zzcie;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcim;

public final class zzcid {
    private final zzcif zzjds;

    public zzcid(zzcif zzcif2) {
        zzbq.checkNotNull((Object)zzcif2);
        this.zzjds = zzcif2;
    }

    public static boolean zzbk(Context context) {
        zzbq.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 2);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzcim zzcim2 = zzcim.zzdx(context);
        zzchm zzchm2 = zzcim2.zzawy();
        if (intent == null) {
            zzchm2.zzazf().log("Receiver called with null intent");
            return;
        }
        String string = intent.getAction();
        zzchm2.zzazj().zzj("Local receiver got", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzchm2.zzazj().log("Starting wakeful intent.");
            this.zzjds.doStartService(context, intent2);
            return;
        }
        if ("com.android.vending.INSTALL_REFERRER".equals(string)) {
            BroadcastReceiver.PendingResult pendingResult = this.zzjds.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzchm2.zzazj().log("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzchm2.zzazh().zzj("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzcim2.zzawu().zzp(uri);
            if (bundle == null) {
                zzchm2.zzazj().log("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzchm2.zzazf().log("Install referrer is missing timestamp");
                }
                zzcim2.zzawx().zzg(new zzcie(this, zzcim2, l, bundle, context, zzchm2, pendingResult));
            }
        }
    }
}

