/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.api.internal.zzbz;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbhf;
import com.google.android.gms.internal.zzcgd;
import com.google.android.gms.internal.zzcgh;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgn;
import com.google.android.gms.internal.zzcgo;
import com.google.android.gms.internal.zzcgq;
import com.google.android.gms.internal.zzcgu;
import com.google.android.gms.internal.zzcgv;
import com.google.android.gms.internal.zzcgw;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzchc;
import com.google.android.gms.internal.zzchh;
import com.google.android.gms.internal.zzchi;
import com.google.android.gms.internal.zzchk;
import com.google.android.gms.internal.zzchm;
import com.google.android.gms.internal.zzcho;
import com.google.android.gms.internal.zzchq;
import com.google.android.gms.internal.zzchu;
import com.google.android.gms.internal.zzchv;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzcid;
import com.google.android.gms.internal.zzcig;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcin;
import com.google.android.gms.internal.zzcio;
import com.google.android.gms.internal.zzcip;
import com.google.android.gms.internal.zzciq;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcjm;
import com.google.android.gms.internal.zzcjn;
import com.google.android.gms.internal.zzckb;
import com.google.android.gms.internal.zzckc;
import com.google.android.gms.internal.zzckg;
import com.google.android.gms.internal.zzcla;
import com.google.android.gms.internal.zzclf;
import com.google.android.gms.internal.zzcll;
import com.google.android.gms.internal.zzcln;
import com.google.android.gms.internal.zzclp;
import com.google.android.gms.internal.zzclq;
import com.google.android.gms.internal.zzcly;
import com.google.android.gms.internal.zzcma;
import com.google.android.gms.internal.zzcmb;
import com.google.android.gms.internal.zzcmc;
import com.google.android.gms.internal.zzcmd;
import com.google.android.gms.internal.zzcme;
import com.google.android.gms.internal.zzcmg;
import com.google.android.gms.internal.zzfjj;
import com.google.android.gms.internal.zzfjk;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzcim {
    private static volatile zzcim zzjev;
    private final Context mContext;
    private final zzcgn zzjew;
    private final zzchx zzjex;
    private final zzchm zzjey;
    private final zzcih zzjez;
    private final zzclf zzjfa;
    private final zzcig zzjfb;
    private final AppMeasurement zzjfc;
    private final FirebaseAnalytics zzjfd;
    private final zzclq zzjfe;
    private final zzchk zzjff;
    private final zzcgo zzjfg;
    private final zzchi zzjfh;
    private final zzchq zzjfi;
    private final zzd zzata;
    private final zzckc zzjfj;
    private final zzckg zzjfk;
    private final zzcgu zzjfl;
    private final zzcjn zzjfm;
    private final zzchh zzjfn;
    private final zzchv zzjfo;
    private final zzcll zzjfp;
    private final zzcgk zzjfq;
    private final zzcgd zzjfr;
    private boolean zzdtb = false;
    private boolean zzjfs;
    private Boolean zzjft;
    private long zzjfu;
    private FileLock zzjfv;
    private FileChannel zzjfw;
    private List<Long> zzjfx;
    private List<Runnable> zzjfy;
    private int zzjfz;
    private int zzjga;
    private long zzjgb;
    private long zzjgc;
    private boolean zzjgd;
    private boolean zzjge;
    private boolean zzjgf;
    private final long zzjgg;

    private zzcim(zzcjm zzcjm2) {
        zzcgd zzcgd2;
        zzbq.checkNotNull((Object)zzcjm2);
        this.mContext = zzcjm2.mContext;
        this.zzjgb = -1L;
        this.zzata = zzh.zzamg();
        this.zzjgg = this.zzata.currentTimeMillis();
        Object object = this;
        this.zzjew = new zzcgn((zzcim)object);
        object = this;
        zzchx zzchx2 = new zzchx((zzcim)object);
        zzchx2.initialize();
        this.zzjex = zzchx2;
        object = this;
        zzchm zzchm2 = new zzchm((zzcim)object);
        zzchm2.initialize();
        this.zzjey = zzchm2;
        object = this;
        zzclq zzclq2 = new zzclq((zzcim)object);
        zzclq2.initialize();
        this.zzjfe = zzclq2;
        object = this;
        zzchk zzchk2 = new zzchk((zzcim)object);
        zzchk2.initialize();
        this.zzjff = zzchk2;
        object = this;
        zzcgu zzcgu2 = new zzcgu((zzcim)object);
        zzcgu2.initialize();
        this.zzjfl = zzcgu2;
        object = this;
        zzchh zzchh2 = new zzchh((zzcim)object);
        zzchh2.initialize();
        this.zzjfn = zzchh2;
        object = this;
        zzcgo zzcgo2 = new zzcgo((zzcim)object);
        zzcgo2.initialize();
        this.zzjfg = zzcgo2;
        object = this;
        zzchi zzchi2 = new zzchi((zzcim)object);
        zzchi2.initialize();
        this.zzjfh = zzchi2;
        object = this;
        zzcgk zzcgk2 = new zzcgk((zzcim)object);
        zzcgk2.initialize();
        this.zzjfq = zzcgk2;
        object = this;
        this.zzjfr = zzcgd2 = new zzcgd((zzcim)object);
        object = this;
        zzchq zzchq2 = new zzchq((zzcim)object);
        zzchq2.initialize();
        this.zzjfi = zzchq2;
        object = this;
        zzckc zzckc2 = new zzckc((zzcim)object);
        zzckc2.initialize();
        this.zzjfj = zzckc2;
        object = this;
        zzckg zzckg2 = new zzckg((zzcim)object);
        zzckg2.initialize();
        this.zzjfk = zzckg2;
        object = this;
        zzcjn zzcjn2 = new zzcjn((zzcim)object);
        zzcjn2.initialize();
        this.zzjfm = zzcjn2;
        object = this;
        zzcll zzcll2 = new zzcll((zzcim)object);
        zzcll2.initialize();
        this.zzjfp = zzcll2;
        object = this;
        this.zzjfo = new zzchv((zzcim)object);
        object = this;
        this.zzjfc = new AppMeasurement((zzcim)object);
        object = this;
        this.zzjfd = new FirebaseAnalytics((zzcim)object);
        object = this;
        zzclf zzclf2 = new zzclf((zzcim)object);
        zzclf2.initialize();
        this.zzjfa = zzclf2;
        object = this;
        zzcig zzcig2 = new zzcig((zzcim)object);
        zzcig2.initialize();
        this.zzjfb = zzcig2;
        object = this;
        zzcih zzcih2 = new zzcih((zzcim)object);
        zzcih2.initialize();
        this.zzjez = zzcih2;
        if (this.mContext.getApplicationContext() instanceof Application) {
            object = this.zzawm();
            if (((zzcjk)object).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzcjk)object).getContext().getApplicationContext();
                if (((zzcjn)object).zzjgx == null) {
                    ((zzcjn)object).zzjgx = new zzckb((zzcjn)object, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcjn)object).zzjgx);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcjn)object).zzjgx);
                ((zzcjk)object).zzawy().zzazj().log("Registered activity lifecycle callback");
            }
        } else {
            this.zzawy().zzazf().log("Application context is not an Application");
        }
        this.zzjez.zzg(new zzcin(this));
    }

    final void zzxf() {
        if (!this.zzdtb) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzazv() {
        this.zzxf();
        ((zzcjk)this.zzawx()).zzve();
        if (this.zzjft == null || this.zzjfu == 0L || this.zzjft != null && !this.zzjft.booleanValue() && Math.abs(this.zzata.elapsedRealtime() - this.zzjfu) > 1000L) {
            this.zzjfu = this.zzata.elapsedRealtime();
            this.zzjft = this.zzawu().zzeb("android.permission.INTERNET") && this.zzawu().zzeb("android.permission.ACCESS_NETWORK_STATE") && (zzbhf.zzdb((Context)this.mContext).zzamu() || zzcid.zzbk(this.mContext) && zzcla.zzk(this.mContext, false));
            if (this.zzjft.booleanValue()) {
                this.zzjft = this.zzawu().zzkg(this.zzawn().getGmpAppId());
            }
        }
        return this.zzjft;
    }

    @WorkerThread
    private final void zzazw() {
        String string;
        zzcho zzcho2;
        ((zzcjk)this.zzawx()).zzve();
        this.zzjfe.zzazw();
        this.zzjex.zzazw();
        this.zzjfn.zzazw();
        this.zzawy().zzazh().zzj("App measurement is starting up, version", 11910L);
        this.zzawy().zzazh().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string2 = this.zzjfn.getAppId();
        if (this.zzawu().zzkj(string2)) {
            zzcho2 = this.zzawy().zzazh();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcho2 = this.zzawy().zzazh();
            String string3 = String.valueOf(string2);
            string = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcho2.log(string);
        this.zzawy().zzazi().log("Debug-level message logging enabled");
        if (this.zzjfz != this.zzjga) {
            this.zzawy().zzazd().zze("Not all components initialized", this.zzjfz, this.zzjga);
        }
        this.zzdtb = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzcjk)this.zzawx()).zzve();
        this.zzaws().zzayh();
        if (this.zzawz().zzjcr.get() == 0L) {
            this.zzawz().zzjcr.set(this.zzata.currentTimeMillis());
        }
        if (Long.valueOf(this.zzawz().zzjcw.get()) == 0L) {
            this.zzawy().zzazj().zzj("Persisting first open", this.zzjgg);
            this.zzawz().zzjcw.set(this.zzjgg);
        }
        if (!this.zzazv()) {
            if (this.isEnabled()) {
                if (!this.zzawu().zzeb("android.permission.INTERNET")) {
                    this.zzawy().zzazd().log("App is missing INTERNET permission");
                }
                if (!this.zzawu().zzeb("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzawy().zzazd().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!zzbhf.zzdb((Context)this.mContext).zzamu()) {
                    if (!zzcid.zzbk(this.mContext)) {
                        this.zzawy().zzazd().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzcla.zzk(this.mContext, false)) {
                        this.zzawy().zzazd().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzawy().zzazd().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzawn().getGmpAppId())) {
                String string = this.zzawz().zzazm();
                if (string == null) {
                    this.zzawz().zzjo(this.zzawn().getGmpAppId());
                } else if (!string.equals(this.zzawn().getGmpAppId())) {
                    this.zzawy().zzazh().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzawz().zzazp();
                    this.zzjfk.disconnect();
                    this.zzjfk.zzyc();
                    this.zzawz().zzjo(this.zzawn().getGmpAppId());
                    this.zzawz().zzjcw.set(this.zzjgg);
                    this.zzawz().zzjcx.zzjq(null);
                }
            }
            this.zzawm().zzjp(this.zzawz().zzjcx.zzazr());
            if (!TextUtils.isEmpty((CharSequence)this.zzawn().getGmpAppId())) {
                zzcjn zzcjn2 = this.zzawm();
                ((zzcjk)zzcjn2).zzve();
                zzcjn2.zzxf();
                if (zzcjn2.zziwf.zzazv()) {
                    ((zzcjk)zzcjn2).zzawp().zzbar();
                    String string = ((zzcjk)zzcjn2).zzawz().zzazq();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        ((zzcjk)zzcjn2).zzawo().zzxf();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzcjn2.zzc("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzawp().zza(new AtomicReference<String>());
            }
        }
        this.zzbaj();
    }

    public final zzcgn zzaxa() {
        return this.zzjew;
    }

    public final zzchx zzawz() {
        zzcim.zza((zzcjk)this.zzjex);
        return this.zzjex;
    }

    public final zzchm zzawy() {
        zzcim.zza(this.zzjey);
        return this.zzjey;
    }

    public final zzchm zzazx() {
        if (this.zzjey != null && this.zzjey.isInitialized()) {
            return this.zzjey;
        }
        return null;
    }

    public final zzcih zzawx() {
        zzcim.zza(this.zzjez);
        return this.zzjez;
    }

    public final zzclf zzaww() {
        zzcim.zza(this.zzjfa);
        return this.zzjfa;
    }

    public final zzcig zzawv() {
        zzcim.zza(this.zzjfb);
        return this.zzjfb;
    }

    final zzcih zzazy() {
        return this.zzjez;
    }

    public final zzcjn zzawm() {
        zzcim.zza(this.zzjfm);
        return this.zzjfm;
    }

    public final AppMeasurement zzazz() {
        return this.zzjfc;
    }

    public final FirebaseAnalytics zzbaa() {
        return this.zzjfd;
    }

    public final zzclq zzawu() {
        zzcim.zza((zzcjk)this.zzjfe);
        return this.zzjfe;
    }

    public final zzchk zzawt() {
        zzcim.zza((zzcjk)this.zzjff);
        return this.zzjff;
    }

    public final zzcgo zzaws() {
        zzcim.zza(this.zzjfg);
        return this.zzjfg;
    }

    public final zzchi zzawr() {
        zzcim.zza(this.zzjfh);
        return this.zzjfh;
    }

    public final zzchq zzbab() {
        zzcim.zza(this.zzjfi);
        return this.zzjfi;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final zzd zzws() {
        return this.zzata;
    }

    public final zzckc zzawq() {
        zzcim.zza(this.zzjfj);
        return this.zzjfj;
    }

    public final zzckg zzawp() {
        zzcim.zza(this.zzjfk);
        return this.zzjfk;
    }

    public final zzcgu zzawo() {
        zzcim.zza(this.zzjfl);
        return this.zzjfl;
    }

    public final zzchh zzawn() {
        zzcim.zza(this.zzjfn);
        return this.zzjfn;
    }

    private final zzchv zzbac() {
        if (this.zzjfo == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzjfo;
    }

    private final zzcll zzbad() {
        zzcim.zza(this.zzjfp);
        return this.zzjfp;
    }

    public final zzcgk zzawl() {
        zzcim.zza(this.zzjfq);
        return this.zzjfq;
    }

    public final zzcgd zzawk() {
        zzcim.zza(this.zzjfr);
        return this.zzjfr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzcim zzdx(Context context) {
        zzbq.checkNotNull((Object)context);
        zzbq.checkNotNull((Object)context.getApplicationContext());
        if (zzjev != null) return zzjev;
        Class<zzcim> clazz = zzcim.class;
        synchronized (zzcim.class) {
            if (zzjev != null) return zzjev;
            zzcjm zzcjm2 = new zzcjm(context);
            zzjev = new zzcim(zzcjm2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzjev;
        }
    }

    final void zzd(zzcgi zzcgi2) {
        this.zzaws().zzjb(zzcgi2.packageName);
        String string = zzcgi2.packageName;
        zzcgo zzcgo2 = this.zzaws();
        zzbq.zzgm((String)string);
        zzcgo2.zzve();
        zzcgo2.zzxf();
        try {
            SQLiteDatabase sQLiteDatabase = zzcgo2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
            if (n > 0) {
                zzcgo2.zzawy().zzazj().zze("Reset analytics data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzcgo2.zzawy().zzazd().zze("Error resetting analytics data. appId, error", zzchm.zzjk(string), (Object)sQLiteException);
        }
        zzcgi zzcgi3 = this.zza(this.mContext, zzcgi2.packageName, zzcgi2.zzixs, zzcgi2.zzixx, zzcgi2.zziye);
        this.zzf(zzcgi3);
    }

    private final zzcgi zza(Context context, String string, String string2, boolean bl, boolean bl2) {
        String string3 = "Unknown";
        String string4 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string5 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzawy().zzazd().log("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string3 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzawy().zzazd().zzj("Error retrieving installer package name. appId", zzchm.zzjk(string));
        }
        if (string3 == null) {
            string3 = "manual_install";
        } else if ("com.android.vending".equals(string3)) {
            string3 = "";
        }
        try {
            PackageInfo packageInfo = zzbhf.zzdb((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = zzbhf.zzdb((Context)context).zzgt(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string5 = charSequence.toString();
                }
                string4 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzawy().zzazd().zze("Error retrieving newly installed package info. appId, appName", zzchm.zzjk(string), string5);
            return null;
        }
        return new zzcgi(string, string2, string4, n, string3, 11910L, this.zzawu().zzaf(context, string), null, bl, false, "", 0L, 0L, 0, bl2);
    }

    private static void zza(zzcjl zzcjl2) {
        if (zzcjl2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcjl2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private static void zza(zzcjk zzcjk2) {
        if (zzcjk2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzbae() {
        ((zzcjk)this.zzawx()).zzve();
        String string = "google_app_measurement.db";
        File file = this.mContext.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzjfw = new RandomAccessFile(file2, "rw").getChannel();
            this.zzjfv = this.zzjfw.tryLock();
            if (this.zzjfv != null) {
                this.zzawy().zzazj().log("Storage concurrent access okay");
                return true;
            }
            this.zzawy().zzazd().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzawy().zzazd().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzawy().zzazd().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        ((zzcjk)this.zzawx()).zzve();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzawy().zzazd().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzawy().zzazf().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzawy().zzazd().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        ((zzcjk)this.zzawx()).zzve();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzawy().zzazd().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzawy().zzazd().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzawy().zzazd().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        if (this.zzjew.zzaya()) {
            return false;
        }
        Boolean bl = this.zzjew.zziy("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzbz.zzaji();
        return this.zzawz().zzbn(bl2);
    }

    final void zze(zzcgi zzcgi2) {
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        zzbq.zzgm((String)zzcgi2.packageName);
        this.zzg(zzcgi2);
    }

    final long zzbaf() {
        Long l = this.zzawz().zzjcw.get();
        if (l == 0L) {
            return this.zzjgg;
        }
        return Math.min(this.zzjgg, l);
    }

    private final long zzbag() {
        long l = this.zzata.currentTimeMillis();
        zzchx zzchx2 = this.zzawz();
        zzchx2.zzxf();
        zzchx2.zzve();
        long l2 = zzchx2.zzjcv.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzchx2.zzawu().zzbaz().nextInt(86400000);
            zzchx2.zzjcv.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzcgi zzjw(String string) {
        zzcgh zzcgh2 = this.zzaws().zzjb(string);
        if (zzcgh2 == null || TextUtils.isEmpty((CharSequence)zzcgh2.zzvj())) {
            this.zzawy().zzazi().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            String string2 = zzbhf.zzdb((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
            if (zzcgh2.zzvj() != null && !zzcgh2.zzvj().equals(string2)) {
                this.zzawy().zzazf().zzj("App version does not match; dropping. appId", zzchm.zzjk(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return new zzcgi(string, zzcgh2.getGmpAppId(), zzcgh2.zzvj(), zzcgh2.zzaxg(), zzcgh2.zzaxh(), zzcgh2.zzaxi(), zzcgh2.zzaxj(), null, zzcgh2.zzaxk(), false, zzcgh2.zzaxd(), zzcgh2.zzaxx(), 0L, 0, zzcgh2.zzaxy());
    }

    @WorkerThread
    final void zzb(zzcha zzcha2, String string) {
        Object object;
        zzcgh zzcgh2;
        block4: {
            zzcgh2 = this.zzaws().zzjb(string);
            if (zzcgh2 == null || TextUtils.isEmpty((CharSequence)zzcgh2.zzvj())) {
                this.zzawy().zzazi().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzbhf.zzdb((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
                if (zzcgh2.zzvj() != null && !zzcgh2.zzvj().equals(object)) {
                    this.zzawy().zzazf().zzj("App version does not match; dropping event. appId", zzchm.zzjk(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzcha2.name)) break block4;
                this.zzawy().zzazf().zzj("Could not find package. appId", zzchm.zzjk(string));
            }
        }
        object = new zzcgi(string, zzcgh2.getGmpAppId(), zzcgh2.zzvj(), zzcgh2.zzaxg(), zzcgh2.zzaxh(), zzcgh2.zzaxi(), zzcgh2.zzaxj(), null, zzcgh2.zzaxk(), false, zzcgh2.zzaxd(), zzcgh2.zzaxx(), 0L, 0, zzcgh2.zzaxy());
        this.zzb(zzcha2, (zzcgi)((Object)object));
    }

    @WorkerThread
    final void zzb(zzcha zzcha2, zzcgi zzcgi2) {
        zzbq.checkNotNull((Object)((Object)zzcgi2));
        zzbq.zzgm((String)zzcgi2.packageName);
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        String string = zzcgi2.packageName;
        long l = zzcha2.zzizu;
        this.zzawu();
        if (!zzclq.zzd(zzcha2, zzcgi2)) {
            return;
        }
        if (!zzcgi2.zzixx) {
            this.zzg(zzcgi2);
            return;
        }
        this.zzaws().beginTransaction();
        try {
            zzbfm zzbfm2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcgo zzcgo2 = this.zzaws();
            zzbq.zzgm((String)string3);
            zzcgo2.zzve();
            zzcgo2.zzxf();
            if (l2 < 0L) {
                zzcgo2.zzawy().zzazf().zze("Invalid time querying timed out conditional properties", zzchm.zzjk(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcgo2.zzc(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzawy().zzazi().zzd("User property timed out", object22.packageName, this.zzawt().zzjj(object22.zziyg.name), object22.zziyg.getValue());
                if (object22.zziyk != null) {
                    this.zzc(new zzcha(object22.zziyk, l), zzcgi2);
                }
                this.zzaws().zzai(string, object22.zziyg.name);
            }
            l2 = l;
            string3 = string;
            zzcgo2 = this.zzaws();
            zzbq.zzgm((String)string3);
            zzcgo2.zzve();
            zzcgo2.zzxf();
            if (l2 < 0L) {
                zzcgo2.zzawy().zzazf().zze("Invalid time querying expired conditional properties", zzchm.zzjk(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcgo2.zzc(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcgl)((Object)object4.next());
                if (object == null) continue;
                this.zzawy().zzazi().zzd("User property expired", object.packageName, this.zzawt().zzjj(object.zziyg.name), object.zziyg.getValue());
                this.zzaws().zzaf(string, object.zziyg.name);
                if (object.zziyo != null) {
                    object22.add(object.zziyo);
                }
                this.zzaws().zzai(string, object.zziyg.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcha)((Object)e);
                this.zzc(new zzcha((zzcha)((Object)object), l), zzcgi2);
            }
            long l3 = l;
            String string4 = zzcha2.name;
            string3 = string;
            zzcgo2 = this.zzaws();
            zzbq.zzgm((String)string3);
            zzbq.zzgm((String)string4);
            zzcgo2.zzve();
            zzcgo2.zzxf();
            if (l3 < 0L) {
                zzcgo2.zzawy().zzazf().zzd("Invalid time querying triggered conditional properties", zzchm.zzjk(string3), zzcgo2.zzawt().zzjh(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcgo2.zzc((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzbfm2 = (zzcgl)((Object)iterator.next());
                if (zzbfm2 == null) continue;
                zzcln zzcln2 = zzbfm2.zziyg;
                zzclp zzclp2 = new zzclp(zzbfm2.packageName, zzbfm2.zziyf, zzcln2.name, l, zzcln2.getValue());
                if (this.zzaws().zza(zzclp2)) {
                    this.zzawy().zzazi().zzd("User property triggered", zzbfm2.packageName, this.zzawt().zzjj(zzclp2.mName), zzclp2.mValue);
                } else {
                    this.zzawy().zzazd().zzd("Too many active user properties, ignoring", zzchm.zzjk(zzbfm2.packageName), this.zzawt().zzjj(zzclp2.mName), zzclp2.mValue);
                }
                if (zzbfm2.zziym != null) {
                    object.add(zzbfm2.zziym);
                }
                zzbfm2.zziyg = new zzcln(zzclp2);
                zzbfm2.zziyi = true;
                this.zzaws().zza((zzcgl)zzbfm2);
            }
            this.zzc(zzcha2, zzcgi2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzbfm2 = (zzcha)((Object)e);
                this.zzc(new zzcha((zzcha)zzbfm2, l), zzcgi2);
            }
            this.zzaws().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaws().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzc(zzcha var1_1, zzcgi var2_2) {
        zzbq.checkNotNull((Object)var2_2);
        zzbq.zzgm((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzawx().zzve();
        this.zzxf();
        var5_4 = var2_2.packageName;
        this.zzawu();
        if (!zzclq.zzd(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzixx) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzawv().zzan(var5_4, var1_1.name)) {
            this.zzawy().zzazf().zze("Dropping blacklisted event. appId", zzchm.zzjk(var5_4), this.zzawt().zzjh(var1_1.name));
            var6_5 = this.zzawu().zzkl(var5_4) != false || this.zzawu().zzkm(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzawu().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzaws().zzjb(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzaxn(), var7_7.zzaxm());
                if (Math.abs(this.zzata.currentTimeMillis() - var8_9) > zzchc.zzjbc.get()) {
                    this.zzawy().zzazi().log("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzawy().zzae(2)) {
            this.zzawy().zzazj().zzj("Logging event", this.zzawt().zzb(var1_1));
        }
        this.zzaws().beginTransaction();
        try {
            block45: {
                block46: {
                    this.zzg(var2_2);
                    if (("_iap".equals(var1_1.name) || "ecommerce_purchase".equals(var1_1.name)) && !this.zza(var5_4, var1_1)) {
                        this.zzaws().setTransactionSuccessful();
                        return;
                    }
                    var6_6 = zzclq.zzjz(var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzaws().zza(this.zzbag(), var5_4, true, var6_6, false, var7_8, false);
                    var9_11 = var8_10.zziyy - (long)zzchc.zzjan.get().intValue();
                    if (var9_11 > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzawy().zzazd().zze("Data loss. Too many events logged. appId, count", zzchm.zzjk(var5_4), var8_10.zziyy);
                        }
                        this.zzaws().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_11 = var8_10.zziyx - (long)zzchc.zzjap.get().intValue()) > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzawy().zzazd().zze("Data loss. Too many public events logged. appId, count", zzchm.zzjk(var5_4), var8_10.zziyx);
                        }
                        this.zzawu().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzaws().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_12 = var2_2.packageName;
                        var20_13 = this.zzjew.zzb((String)var19_12, zzchc.zzjao);
                        var9_11 = var8_10.zziza - (long)Math.max(0, var20_13 = Math.min(1000000, var20_13));
                        if (var9_11 > 0L) {
                            if (var9_11 == 1L) {
                                this.zzawy().zzazd().zze("Too many error events logged. appId, count", zzchm.zzjk(var5_4), var8_10.zziza);
                            }
                            this.zzaws().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_15 = var1_1.zzizt.zzayx();
                    this.zzawu().zza(var11_15, "_o", (Object)var1_1.zziyf);
                    if (this.zzawu().zzkj(var5_4)) {
                        this.zzawu().zza(var11_15, "_dbg", 1L);
                        this.zzawu().zza(var11_15, "_r", 1L);
                    }
                    if ((var12_16 = this.zzaws().zzjc(var5_4)) > 0L) {
                        this.zzawy().zzazf().zze("Data lost. Too many events stored on disk, deleted. appId", zzchm.zzjk(var5_4), var12_16);
                    }
                    var14_17 = new zzcgv(this, var1_1.zziyf, var5_4, var1_1.name, var1_1.zzizu, 0L, var11_15);
                    var15_18 = this.zzaws().zzae(var5_4, var14_17.mName);
                    if (var15_18 == null) {
                        if (this.zzaws().zzjf(var5_4) >= 500L && var6_6) {
                            this.zzawy().zzazd().zzd("Too many event names used, ignoring event. appId, name, supported count", zzchm.zzjk(var5_4), this.zzawt().zzjh(var14_17.mName), 500);
                            this.zzawu().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_19 = new zzcgw(var5_4, var14_17.mName, 0L, 0L, var14_17.zzfij, 0L, null, null, null);
                    } else {
                        var14_17 = var14_17.zza(this, var15_18.zzizm);
                        var16_19 = var15_18.zzbb(var14_17.zzfij);
                    }
                    this.zzaws().zza(var16_19);
                    var20_14 = var2_2;
                    var19_12 = var14_17;
                    var18_20 = this;
                    var18_20.zzawx().zzve();
                    var18_20.zzxf();
                    zzbq.checkNotNull((Object)var19_12);
                    zzbq.checkNotNull((Object)var20_14);
                    zzbq.zzgm((String)var19_12.mAppId);
                    zzbq.checkArgument((boolean)var19_12.mAppId.equals(var20_14.packageName));
                    var21_21 = new zzcme();
                    new zzcme().zzjlo = 1;
                    var21_21.zzjlw = "android";
                    var21_21.zzcn = var20_14.packageName;
                    var21_21.zzixt = var20_14.zzixt;
                    var21_21.zzifm = var20_14.zzifm;
                    var21_21.zzjmj = var20_14.zzixz == -2147483648L ? null : Integer.valueOf((int)var20_14.zzixz);
                    var21_21.zzjma = var20_14.zzixu;
                    var21_21.zzixs = var20_14.zzixs;
                    var21_21.zzjmf = var20_14.zzixv == 0L ? null : Long.valueOf(var20_14.zzixv);
                    var22_22 = var18_20.zzawz().zzjm(var20_14.packageName);
                    if (var22_22 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_22.first))) {
                        if (var20_14.zziye) {
                            var21_21.zzjmc = (String)var22_22.first;
                            var21_21.zzjmd = (Boolean)var22_22.second;
                        }
                    } else if (!var18_20.zzawo().zzdw(var18_20.mContext)) {
                        var23_23 = Settings.Secure.getString((ContentResolver)var18_20.mContext.getContentResolver(), (String)"android_id");
                        if (var23_23 == null) {
                            var18_20.zzawy().zzazf().zzj("null secure ID. appId", zzchm.zzjk(var21_21.zzcn));
                            var23_23 = "null";
                        } else if (var23_23.isEmpty()) {
                            var18_20.zzawy().zzazf().zzj("empty secure ID. appId", zzchm.zzjk(var21_21.zzcn));
                        }
                        var21_21.zzjmm = var23_23;
                    }
                    var18_20.zzawo().zzxf();
                    var21_21.zzjlx = Build.MODEL;
                    var18_20.zzawo().zzxf();
                    var21_21.zzdb = Build.VERSION.RELEASE;
                    var21_21.zzjlz = (int)var18_20.zzawo().zzayu();
                    var21_21.zzjly = var18_20.zzawo().zzayv();
                    var21_21.zzjmb = null;
                    var21_21.zzjlr = null;
                    var21_21.zzjls = null;
                    var21_21.zzjlt = null;
                    var21_21.zzfkk = var20_14.zziyb;
                    if (var18_20.isEnabled() && zzcgn.zzaye()) {
                        var18_20.zzawn();
                        var21_21.zzjmo = null;
                    }
                    if ((var23_23 = var18_20.zzaws().zzjb(var20_14.packageName)) == null) {
                        var23_23 = new zzcgh(var18_20, var20_14.packageName);
                        var23_23.zzir(var18_20.zzawn().zzayz());
                        var23_23.zziu(var20_14.zziya);
                        var23_23.zzis(var20_14.zzixs);
                        var23_23.zzit(var18_20.zzawz().zzjn(var20_14.packageName));
                        var23_23.zzaq(0L);
                        var23_23.zzal(0L);
                        var23_23.zzam(0L);
                        var23_23.setAppVersion(var20_14.zzifm);
                        var23_23.zzan(var20_14.zzixz);
                        var23_23.zziv(var20_14.zzixt);
                        var23_23.zzao(var20_14.zzixu);
                        var23_23.zzap(var20_14.zzixv);
                        var23_23.setMeasurementEnabled(var20_14.zzixx);
                        var23_23.zzaz(var20_14.zziyb);
                        var18_20.zzaws().zza((zzcgh)var23_23);
                    }
                    var21_21.zzjme = var23_23.getAppInstanceId();
                    var21_21.zziya = var23_23.zzaxd();
                    var24_24 = var18_20.zzaws().zzja(var20_14.packageName);
                    var21_21.zzjlq = new zzcmg[var24_24.size()];
                    for (var25_25 = 0; var25_25 < var24_24.size(); ++var25_25) {
                        var21_21.zzjlq[var25_25] = var26_27 = new zzcmg();
                        var26_27.name = var24_24.get((int)var25_25).mName;
                        var26_27.zzjms = var24_24.get((int)var25_25).zzjjm;
                        var18_20.zzawu().zza(var26_27, var24_24.get((int)var25_25).mValue);
                    }
                    try {
                        var25_26 = var18_20.zzaws().zza(var21_21);
                    }
                    catch (IOException var27_28) {
                        var18_20.zzawy().zzazd().zze("Data loss. Failed to insert raw event metadata. appId", zzchm.zzjk(var21_21.zzcn), var27_28);
                        break block45;
                    }
                    v0 = var18_20.zzaws();
                    var29_29 = var19_12;
                    var28_30 = var18_20;
                    if (var29_29.zzizj == null) ** GOTO lbl-1000
                    for (Object var31_33 : var29_29.zzizj) {
                        if (!"_r".equals(var31_33)) continue;
                        v1 = true;
                        break block46;
                    }
                    var30_32 = var28_30.zzawv().zzao(var29_29.mAppId, var29_29.mName);
                    var31_33 = var28_30.zzaws().zza(var28_30.zzbag(), var29_29.mAppId, false, false, false, false, false);
                    if (var30_32 && var31_33.zzizb < (long)var28_30.zzjew.zzix(var29_29.mAppId)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                }
                if (v0.zza((zzcgv)var19_12, var25_26, v1)) {
                    var18_20.zzjgc = 0L;
                }
            }
            this.zzaws().setTransactionSuccessful();
            if (this.zzawy().zzae(2)) {
                this.zzawy().zzazj().zzj("Event recorded", this.zzawt().zza(var14_17));
            }
        }
        finally {
            this.zzaws().endTransaction();
        }
        this.zzbaj();
        this.zzawy().zzazj().zzj("Background event processing time, ms", (System.nanoTime() - var3_3 + 500000L) / 1000000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zza(String string, zzcha zzcha2) {
        long l;
        String string2;
        block10: {
            string2 = zzcha2.zzizt.getString("currency");
            if ("ecommerce_purchase".equals(zzcha2.name)) {
                double d = zzcha2.zzizt.getDouble("value") * 1000000.0;
                if (d == 0.0) {
                    d = (double)zzcha2.zzizt.getLong("value").longValue() * 1000000.0;
                }
                if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                    l = Math.round(d);
                    break block10;
                } else {
                    this.zzawy().zzazf().zze("Data lost. Currency value is too big. appId", zzchm.zzjk(string), d);
                    return false;
                }
            }
            l = zzcha2.zzizt.getLong("value");
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
            String string3 = String.valueOf("_ltv_");
            String string4 = String.valueOf(string2);
            String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            zzclp zzclp2 = this.zzaws().zzag(string, string5);
            if (zzclp2 == null || !(zzclp2.mValue instanceof Long)) {
                String string6 = string;
                int n = this.zzjew.zzb(string6, zzchc.zzjbh) - 1;
                string6 = string;
                zzcgo zzcgo2 = this.zzaws();
                zzbq.zzgm((String)string6);
                zzcgo2.zzve();
                zzcgo2.zzxf();
                try {
                    zzcgo2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string6, string6, String.valueOf(n)});
                }
                catch (SQLiteException sQLiteException) {
                    zzcgo2.zzawy().zzazd().zze("Error pruning currencies. appId", zzchm.zzjk(string6), (Object)sQLiteException);
                }
                zzclp2 = new zzclp(string, zzcha2.zziyf, string5, this.zzata.currentTimeMillis(), l);
            } else {
                long l2 = (Long)zzclp2.mValue;
                zzclp2 = new zzclp(string, zzcha2.zziyf, string5, this.zzata.currentTimeMillis(), l2 + l);
            }
            if (!this.zzaws().zza(zzclp2)) {
                this.zzawy().zzazd().zzd("Too many unique user properties are set. Ignoring user property. appId", zzchm.zzjk(string), this.zzawt().zzjj(zzclp2.mName), zzclp2.mValue);
                this.zzawu().zza(string, 9, null, null, 0);
            }
        }
        return true;
    }

    @WorkerThread
    final void zzd(zzcgl zzcgl2) {
        zzcgi zzcgi2 = this.zzjw(zzcgl2.packageName);
        if (zzcgi2 != null) {
            this.zzb(zzcgl2, zzcgi2);
        }
    }

    @WorkerThread
    final void zzb(zzcgl zzcgl2, zzcgi zzcgi2) {
        zzbq.checkNotNull((Object)((Object)zzcgl2));
        zzbq.zzgm((String)zzcgl2.packageName);
        zzbq.checkNotNull((Object)zzcgl2.zziyf);
        zzbq.checkNotNull((Object)((Object)zzcgl2.zziyg));
        zzbq.zzgm((String)zzcgl2.zziyg.name);
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        if (TextUtils.isEmpty((CharSequence)zzcgi2.zzixs)) {
            return;
        }
        if (!zzcgi2.zzixx) {
            this.zzg(zzcgi2);
            return;
        }
        zzcgl zzcgl3 = new zzcgl(zzcgl2);
        new zzcgl(zzcgl2).zziyi = false;
        this.zzaws().beginTransaction();
        try {
            boolean bl = false;
            zzcgl zzcgl4 = this.zzaws().zzah(zzcgl3.packageName, zzcgl3.zziyg.name);
            if (zzcgl4 != null && !zzcgl4.zziyf.equals(zzcgl3.zziyf)) {
                this.zzawy().zzazf().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzawt().zzjj(zzcgl3.zziyg.name), zzcgl3.zziyf, zzcgl4.zziyf);
            }
            if (zzcgl4 != null && zzcgl4.zziyi) {
                zzcgl3.zziyf = zzcgl4.zziyf;
                zzcgl3.zziyh = zzcgl4.zziyh;
                zzcgl3.zziyl = zzcgl4.zziyl;
                zzcgl3.zziyj = zzcgl4.zziyj;
                zzcgl3.zziym = zzcgl4.zziym;
                zzcgl3.zziyi = zzcgl4.zziyi;
                zzcgl3.zziyg = new zzcln(zzcgl3.zziyg.name, zzcgl4.zziyg.zzjji, zzcgl3.zziyg.getValue(), zzcgl4.zziyg.zziyf);
            } else if (TextUtils.isEmpty((CharSequence)zzcgl3.zziyj)) {
                zzcgl3.zziyg = new zzcln(zzcgl3.zziyg.name, zzcgl3.zziyh, zzcgl3.zziyg.getValue(), zzcgl3.zziyg.zziyf);
                zzcgl3.zziyi = true;
                bl = true;
            }
            if (zzcgl3.zziyi) {
                zzcln zzcln2 = zzcgl3.zziyg;
                zzclp zzclp2 = new zzclp(zzcgl3.packageName, zzcgl3.zziyf, zzcln2.name, zzcln2.zzjji, zzcln2.getValue());
                if (this.zzaws().zza(zzclp2)) {
                    this.zzawy().zzazi().zzd("User property updated immediately", zzcgl3.packageName, this.zzawt().zzjj(zzclp2.mName), zzclp2.mValue);
                } else {
                    this.zzawy().zzazd().zzd("(2)Too many active user properties, ignoring", zzchm.zzjk(zzcgl3.packageName), this.zzawt().zzjj(zzclp2.mName), zzclp2.mValue);
                }
                if (bl && zzcgl3.zziym != null) {
                    zzcha zzcha2 = new zzcha(zzcgl3.zziym, zzcgl3.zziyh);
                    this.zzc(zzcha2, zzcgi2);
                }
            }
            if (this.zzaws().zza(zzcgl3)) {
                this.zzawy().zzazi().zzd("Conditional property added", zzcgl3.packageName, this.zzawt().zzjj(zzcgl3.zziyg.name), zzcgl3.zziyg.getValue());
            } else {
                this.zzawy().zzazd().zzd("Too many conditional properties, ignoring", zzchm.zzjk(zzcgl3.packageName), this.zzawt().zzjj(zzcgl3.zziyg.name), zzcgl3.zziyg.getValue());
            }
            this.zzaws().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaws().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzcgl zzcgl2) {
        zzcgi zzcgi2 = this.zzjw(zzcgl2.packageName);
        if (zzcgi2 != null) {
            this.zzc(zzcgl2, zzcgi2);
        }
    }

    @WorkerThread
    final void zzc(zzcgl zzcgl2, zzcgi zzcgi2) {
        zzbq.checkNotNull((Object)((Object)zzcgl2));
        zzbq.zzgm((String)zzcgl2.packageName);
        zzbq.checkNotNull((Object)((Object)zzcgl2.zziyg));
        zzbq.zzgm((String)zzcgl2.zziyg.name);
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        if (TextUtils.isEmpty((CharSequence)zzcgi2.zzixs)) {
            return;
        }
        if (!zzcgi2.zzixx) {
            this.zzg(zzcgi2);
            return;
        }
        this.zzaws().beginTransaction();
        try {
            this.zzg(zzcgi2);
            zzcgl zzcgl3 = this.zzaws().zzah(zzcgl2.packageName, zzcgl2.zziyg.name);
            if (zzcgl3 != null) {
                this.zzawy().zzazi().zze("Removing conditional user property", zzcgl2.packageName, this.zzawt().zzjj(zzcgl2.zziyg.name));
                this.zzaws().zzai(zzcgl2.packageName, zzcgl2.zziyg.name);
                if (zzcgl3.zziyi) {
                    this.zzaws().zzaf(zzcgl2.packageName, zzcgl2.zziyg.name);
                }
                if (zzcgl2.zziyo != null) {
                    Bundle bundle = null;
                    if (zzcgl2.zziyo.zzizt != null) {
                        bundle = zzcgl2.zziyo.zzizt.zzayx();
                    }
                    zzcha zzcha2 = this.zzawu().zza(zzcgl2.zziyo.name, bundle, zzcgl3.zziyf, zzcgl2.zziyo.zzizu, true, false);
                    this.zzc(zzcha2, zzcgi2);
                }
            } else {
                this.zzawy().zzazf().zze("Conditional user property doesn't exist", zzchm.zzjk(zzcgl2.packageName), this.zzawt().zzjj(zzcgl2.zziyg.name));
            }
            this.zzaws().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaws().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzcha zzcha2, @Size(min=1L) String string) {
        Object object;
        this.zzxf();
        ((zzcjk)this.zzawx()).zzve();
        zzcim.zzawi();
        zzbq.checkNotNull((Object)((Object)zzcha2));
        zzbq.zzgm((String)string);
        zzcmd zzcmd2 = new zzcmd();
        this.zzaws().beginTransaction();
        try {
            zzcgw zzcgw2;
            long l;
            Object object2;
            zzcgh zzcgh2 = this.zzaws().zzjb(string);
            if (zzcgh2 == null) {
                this.zzawy().zzazi().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzcgh2.zzaxk()) {
                this.zzawy().zzazi().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (("_iap".equals(zzcha2.name) || "ecommerce_purchase".equals(zzcha2.name)) && !this.zza(string, zzcha2)) {
                this.zzawy().zzazf().zzj("Failed to handle purchase event at single event bundle creation. appId", zzchm.zzjk(string));
            }
            object = new zzcme();
            zzcmd2.zzjlm = new zzcme[]{object};
            object.zzjlo = 1;
            object.zzjlw = "android";
            object.zzcn = zzcgh2.getAppId();
            object.zzixt = zzcgh2.zzaxh();
            object.zzifm = zzcgh2.zzvj();
            long l2 = zzcgh2.zzaxg();
            object.zzjmj = l2 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l2);
            object.zzjma = zzcgh2.zzaxi();
            object.zzixs = zzcgh2.getGmpAppId();
            object.zzjmf = zzcgh2.zzaxj();
            if (this.isEnabled() && zzcgn.zzaye() && this.zzjew.zziz(object.zzcn)) {
                this.zzawn();
                object.zzjmo = null;
            }
            Pair<String, Boolean> pair = this.zzawz().zzjm(zzcgh2.getAppId());
            if (zzcgh2.zzaxy() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                object.zzjmc = (String)pair.first;
                object.zzjmd = (Boolean)pair.second;
            }
            this.zzawo().zzxf();
            object.zzjlx = Build.MODEL;
            this.zzawo().zzxf();
            object.zzdb = Build.VERSION.RELEASE;
            object.zzjlz = (int)this.zzawo().zzayu();
            object.zzjly = this.zzawo().zzayv();
            object.zzjme = zzcgh2.getAppInstanceId();
            object.zziya = zzcgh2.zzaxd();
            List<zzclp> list = this.zzaws().zzja(zzcgh2.getAppId());
            object.zzjlq = new zzcmg[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                object2 = new zzcmg();
                object.zzjlq[i] = object2;
                ((zzcmg)((Object)object2)).name = list.get((int)i).mName;
                ((zzcmg)((Object)object2)).zzjms = list.get((int)i).zzjjm;
                this.zzawu().zza((zzcmg)((Object)object2), list.get((int)i).mValue);
            }
            Bundle bundle = zzcha2.zzizt.zzayx();
            if ("_iap".equals(zzcha2.name)) {
                bundle.putLong("_c", 1L);
                this.zzawy().zzazi().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcha2.zziyf);
            if (this.zzawu().zzkj(object.zzcn)) {
                this.zzawu().zza(bundle, "_dbg", 1L);
                this.zzawu().zza(bundle, "_r", 1L);
            }
            if ((object2 = this.zzaws().zzae(string, zzcha2.name)) == null) {
                l = 0L;
                zzcgw2 = new zzcgw(string, zzcha2.name, 1L, 0L, zzcha2.zzizu, 0L, null, null, null);
                this.zzaws().zza(zzcgw2);
            } else {
                l = ((zzcgw)object2).zzizm;
                zzcgw2 = ((zzcgw)object2).zzbb(zzcha2.zzizu).zzayw();
                this.zzaws().zza(zzcgw2);
            }
            zzcgv zzcgv2 = new zzcgv(this, zzcha2.zziyf, string, zzcha2.name, zzcha2.zzizu, l, bundle);
            zzcmb zzcmb2 = new zzcmb();
            object.zzjlp = new zzcmb[]{zzcmb2};
            zzcmb2.zzjli = zzcgv2.zzfij;
            zzcmb2.name = zzcgv2.mName;
            zzcmb2.zzjlj = zzcgv2.zzizi;
            zzcmb2.zzjlh = new zzcmc[zzcgv2.zzizj.size()];
            int n = 0;
            for (String string2 : zzcgv2.zzizj) {
                zzcmc zzcmc2 = new zzcmc();
                zzcmb2.zzjlh[n++] = zzcmc2;
                zzcmc2.name = string2;
                Object object3 = zzcgv2.zzizj.get(string2);
                this.zzawu().zza(zzcmc2, object3);
            }
            object.zzjmi = this.zza(zzcgh2.getAppId(), object.zzjlq, object.zzjlp);
            object.zzjls = zzcmb2.zzjli;
            object.zzjlt = zzcmb2.zzjli;
            long l3 = zzcgh2.zzaxf();
            object.zzjlv = l3 != 0L ? Long.valueOf(l3) : null;
            long l4 = zzcgh2.zzaxe();
            if (l4 == 0L) {
                l4 = l3;
            }
            object.zzjlu = l4 != 0L ? Long.valueOf(l4) : null;
            zzcgh2.zzaxo();
            object.zzjmg = (int)zzcgh2.zzaxl();
            object.zzjmb = 11910L;
            object.zzjlr = this.zzata.currentTimeMillis();
            object.zzjmh = Boolean.TRUE;
            zzcgh2.zzal(object.zzjls);
            zzcgh2.zzam(object.zzjlt);
            this.zzaws().zza(zzcgh2);
            this.zzaws().setTransactionSuccessful();
        }
        finally {
            this.zzaws().endTransaction();
        }
        try {
            byte[] byArray = new byte[zzcmd2.zzho()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzfjk zzfjk2 = zzfjk.zzo((byte[])byArray, (int)0, (int)byArray2.length);
            zzcmd2.zza(zzfjk2);
            zzfjk2.zzcwt();
            return this.zzawu().zzq((byte[])object);
        }
        catch (IOException iOException) {
            this.zzawy().zzazd().zze("Data loss. Failed to bundle and serialize. appId", zzchm.zzjk(string), iOException);
            return null;
        }
    }

    public final String zzjx(String string) {
        Future<String> future = this.zzawx().zzc(new zzcio(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzawy().zzazd().zze("Failed to get app instance id. appId", zzchm.zzjk(string), exception);
            return null;
        }
    }

    private static boolean zza(zzcmb zzcmb2, String string, Object object) {
        if (TextUtils.isEmpty((CharSequence)string) || object == null) {
            return false;
        }
        zzcmc[] zzcmcArray = zzcmb2.zzjlh;
        int n = zzcmb2.zzjlh.length;
        for (int i = 0; i < n; ++i) {
            zzcmc zzcmc2 = zzcmcArray[i];
            if (!string.equals(zzcmc2.name)) continue;
            return object instanceof Long && object.equals(zzcmc2.zzjll) || object instanceof String && object.equals(zzcmc2.zzgcc) || object instanceof Double && object.equals(zzcmc2.zzjjl);
        }
        return false;
    }

    static void zzawi() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzcln zzcln2, zzcgi zzcgi2) {
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        if (TextUtils.isEmpty((CharSequence)zzcgi2.zzixs)) {
            return;
        }
        if (!zzcgi2.zzixx) {
            this.zzg(zzcgi2);
            return;
        }
        int n = this.zzawu().zzkd(zzcln2.name);
        if (n != 0) {
            this.zzawu();
            String string = zzclq.zza(zzcln2.name, 24, true);
            int n2 = zzcln2.name != null ? zzcln2.name.length() : 0;
            this.zzawu().zza(zzcgi2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzawu().zzl(zzcln2.name, zzcln2.getValue());
        if (n != 0) {
            this.zzawu();
            String string = zzclq.zza(zzcln2.name, 24, true);
            Object object = zzcln2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzawu().zza(zzcgi2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzawu().zzm(zzcln2.name, zzcln2.getValue());
        if (object == null) {
            return;
        }
        zzclp zzclp2 = new zzclp(zzcgi2.packageName, zzcln2.zziyf, zzcln2.name, zzcln2.zzjji, object);
        this.zzawy().zzazi().zze("Setting user property", this.zzawt().zzjj(zzclp2.mName), object);
        this.zzaws().beginTransaction();
        try {
            this.zzg(zzcgi2);
            boolean bl = this.zzaws().zza(zzclp2);
            this.zzaws().setTransactionSuccessful();
            if (bl) {
                this.zzawy().zzazi().zze("User property set", this.zzawt().zzjj(zzclp2.mName), zzclp2.mValue);
            } else {
                this.zzawy().zzazd().zze("Too many unique user properties are set. Ignoring user property", this.zzawt().zzjj(zzclp2.mName), zzclp2.mValue);
                this.zzawu().zza(zzcgi2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzaws().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzcln zzcln2, zzcgi zzcgi2) {
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        if (TextUtils.isEmpty((CharSequence)zzcgi2.zzixs)) {
            return;
        }
        if (!zzcgi2.zzixx) {
            this.zzg(zzcgi2);
            return;
        }
        this.zzawy().zzazi().zzj("Removing user property", this.zzawt().zzjj(zzcln2.name));
        this.zzaws().beginTransaction();
        try {
            this.zzg(zzcgi2);
            this.zzaws().zzaf(zzcgi2.packageName, zzcln2.name);
            this.zzaws().setTransactionSuccessful();
            this.zzawy().zzazi().zzj("User property removed", this.zzawt().zzjj(zzcln2.name));
            return;
        }
        finally {
            this.zzaws().endTransaction();
        }
    }

    @WorkerThread
    public final void zzbah() {
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        this.zzjgf = true;
        try {
            String string;
            Boolean bl = this.zzawp().zzbas();
            if (bl == null) {
                this.zzawy().zzazf().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzawy().zzazd().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzjgc > 0L) {
                this.zzbaj();
                return;
            }
            Object object = this;
            ((zzcjk)((zzcim)object).zzawx()).zzve();
            if (((zzcim)object).zzjfx != null) {
                this.zzawy().zzazj().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzbab().zzzs()) {
                this.zzawy().zzazj().log("Network not connected, ignoring upload request");
                this.zzbaj();
                return;
            }
            long l = this.zzata.currentTimeMillis();
            long l2 = l - zzcgn.zzayc();
            this.zzg(null, l2);
            long l3 = this.zzawz().zzjcr.get();
            if (l3 != 0L) {
                this.zzawy().zzazi().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzaws().zzayf()))) {
                if (this.zzjgb == -1L) {
                    this.zzjgb = this.zzaws().zzaym();
                }
                Object object2 = string;
                int n = this.zzjew.zzb((String)object2, zzchc.zzjaj);
                object2 = string;
                object = this.zzjew;
                int n2 = Math.max(0, ((zzcgn)object).zzb((String)object2, zzchc.zzjak));
                List<Pair<zzcme, Long>> list = this.zzaws().zzl(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzcme zzcme2 = (zzcme)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzcme2.zzjmc)) continue;
                        string2 = zzcme2.zzjmc;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzcme)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzcme)((Object)object3)).zzjmc) || ((zzcme)((Object)object3)).zzjmc.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzcmd();
                    new zzcmd().zzjlm = new zzcme[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcgn.zzaye() && this.zzjew.zziz(string);
                    for (int i = 0; i < ((zzcmd)((Object)object4)).zzjlm.length; ++i) {
                        ((zzcmd)((Object)object4)).zzjlm[i] = (zzcme)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzcmd)((Object)object4)).zzjlm[i].zzjmb = 11910L;
                        ((zzcmd)((Object)object4)).zzjlm[i].zzjlr = l;
                        ((zzcmd)((Object)object4)).zzjlm[i].zzjmh = false;
                        if (bl2) continue;
                        ((zzcmd)((Object)object4)).zzjlm[i].zzjmo = null;
                    }
                    String string3 = null;
                    if (this.zzawy().zzae(2)) {
                        string3 = this.zzawt().zza((zzcmd)((Object)object4));
                    }
                    byte[] byArray = this.zzawu().zzb((zzcmd)((Object)object4));
                    String string4 = zzchc.zzjat.get();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbq.checkArgument((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzcim)object).zzjfx != null) {
                            ((zzcim)object).zzawy().zzazd().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzcim)object).zzjfx = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzawz().zzjcs.set(l);
                        String string5 = "?";
                        if (((zzcmd)((Object)object4)).zzjlm.length > 0) {
                            string5 = ((zzcmd)((Object)object4)).zzjlm[0].zzcn;
                        }
                        this.zzawy().zzazj().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzjge = true;
                        zzcip zzcip2 = new zzcip(this);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object2 = string;
                        object = this.zzbab();
                        ((zzcjk)object).zzve();
                        ((zzcjl)object).zzxf();
                        zzbq.checkNotNull((Object)uRL2);
                        zzbq.checkNotNull((Object)byArray2);
                        zzbq.checkNotNull((Object)zzcip2);
                        ((zzcjk)object).zzawx().zzh(new zzchu((zzchq)object, (String)object2, uRL2, byArray2, null, zzcip2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzawy().zzazd().zze("Failed to parse upload URL. Not uploading. appId", zzchm.zzjk(string), string4);
                    }
                }
            } else {
                zzcgh zzcgh2;
                this.zzjgb = -1L;
                String string6 = this.zzaws().zzba(l - zzcgn.zzayc());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzcgh2 = this.zzaws().zzjb(string6)) != null) {
                    this.zzb(zzcgh2);
                }
            }
            return;
        }
        finally {
            this.zzjgf = false;
            this.zzban();
        }
    }

    @WorkerThread
    private final void zzb(zzcgh zzcgh2) {
        ((zzcjk)this.zzawx()).zzve();
        if (TextUtils.isEmpty((CharSequence)zzcgh2.getGmpAppId())) {
            this.zzb(zzcgh2.getAppId(), 204, null, null, null);
            return;
        }
        Object object = zzcgh2.getAppInstanceId();
        String string = zzcgh2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzchc.zzjah.get()).encodedAuthority(zzchc.zzjai.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "11910");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzawy().zzazj().zzj("Fetching remote configuration", zzcgh2.getAppId());
            zzcly zzcly2 = this.zzawv().zzjs(zzcgh2.getAppId());
            ArrayMap arrayMap = null;
            String string4 = this.zzawv().zzjt(zzcgh2.getAppId());
            if (zzcly2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzjgd = true;
            zzciq zzciq2 = new zzciq(this);
            builder = arrayMap;
            object = uRL;
            string = zzcgh2.getAppId();
            zzchq zzchq2 = this.zzbab();
            ((zzcjk)zzchq2).zzve();
            zzchq2.zzxf();
            zzbq.checkNotNull((Object)object);
            zzbq.checkNotNull((Object)zzciq2);
            ((zzcjk)zzchq2).zzawx().zzh(new zzchu(zzchq2, string, (URL)object, null, (Map)builder, zzciq2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzawy().zzazd().zze("Failed to parse config URL. Not fetching. appId", zzchm.zzjk(zzcgh2.getAppId()), string3);
            return;
        }
    }

    private final boolean zzg(String string, long l) {
        this.zzaws().beginTransaction();
        try {
            block85: {
                zzcmc[] zzcmcArray;
                Object object;
                int zzcmb3;
                int n2;
                int n3;
                Object object2;
                String string2;
                zza zza2;
                block84: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzjgb;
                    long l3 = l;
                    string2 = null;
                    object2 = this.zzaws();
                    zzbq.checkNotNull((Object)zza3);
                    ((zzcjk)object2).zzve();
                    ((zzcjl)object2).zzxf();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcgo)object2).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block84;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block84;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzcjk)object2).zzawy().zzazd().zzj("Raw event metadata record is missing. appId", zzchm.zzjk(string2));
                            break block84;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = zzfjj.zzn((byte[])byArray, (int)0, (int)byArray.length);
                        zzcme zzcme2 = new zzcme();
                        try {
                            zzcme2.zza((zzfjj)string5);
                        }
                        catch (IOException iOException) {
                            ((zzcjk)object2).zzawy().zzazd().zze("Data loss. Failed to merge raw event metadata. appId", zzchm.zzjk(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block84;
                        }
                        if (cursor.moveToNext()) {
                            ((zzcjk)object2).zzawy().zzazf().zzj("Get multiple raw event metadata records, expected one. appId", zzchm.zzjk(string2));
                        }
                        cursor.close();
                        zza3.zzb(zzcme2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzcjk)object2).zzawy().zzazf().zzj("Raw event data disappeared while in transaction. appId", zzchm.zzjk(string2));
                            break block84;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = zzfjj.zzn((byte[])byArray, (int)0, (int)byArray.length);
                            zzcmb zzcmb2 = new zzcmb();
                            try {
                                zzcmb2.zza((zzfjj)string5);
                            }
                            catch (IOException iOException) {
                                ((zzcjk)object2).zzawy().zzazd().zze("Data loss. Failed to merge raw event. appId", zzchm.zzjk(string2), iOException);
                                continue;
                            }
                            zzcmb2.name = cursor.getString(1);
                            zzcmb2.zzjli = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcmb2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzapa == null || ((zza)object2).zzapa.isEmpty()) break block85;
                boolean bl = false;
                zzcme zzcme3 = zza2.zzjgi;
                zza2.zzjgi.zzjlp = new zzcmb[zza2.zzapa.size()];
                int n4 = 0;
                for (n3 = 0; n3 < zza2.zzapa.size(); ++n3) {
                    block87: {
                        zzcmc[] n8;
                        int n;
                        boolean bl2;
                        block86: {
                            bl2 = bl;
                            if (this.zzawv().zzan(zza2.zzjgi.zzcn, zza2.zzapa.get((int)n3).name)) {
                                this.zzawy().zzazf().zze("Dropping blacklisted raw event. appId", zzchm.zzjk(zza2.zzjgi.zzcn), this.zzawt().zzjh(zza2.zzapa.get((int)n3).name));
                                if (this.zzawu().zzkl(zza2.zzjgi.zzcn) || this.zzawu().zzkm(zza2.zzjgi.zzcn) || "_err".equals(zza2.zzapa.get((int)n3).name)) continue;
                                this.zzawu().zza(zza2.zzjgi.zzcn, 11, "_ev", zza2.zzapa.get((int)n3).name, 0);
                                continue;
                            }
                            n2 = this.zzawv().zzao(zza2.zzjgi.zzcn, zza2.zzapa.get((int)n3).name);
                            if (n2 != 0) break block86;
                            this.zzawu();
                            if (!zzclq.zzkn(zza2.zzapa.get((int)n3).name)) break block87;
                        }
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (zza2.zzapa.get((int)n3).zzjlh == null) {
                            zza2.zzapa.get((int)n3).zzjlh = new zzcmc[0];
                        }
                        zzcmc[] n7 = zza2.zzapa.get((int)n3).zzjlh;
                        zzcmb3 = zza2.zzapa.get((int)n3).zzjlh.length;
                        for (n = 0; n < zzcmb3; ++n) {
                            n8 = n7[n];
                            if ("_c".equals(n8.name)) {
                                n8.zzjll = 1L;
                                bl3 = true;
                                continue;
                            }
                            if (!"_r".equals(n8.name)) continue;
                            n8.zzjll = 1L;
                            bl4 = true;
                        }
                        if (!bl3 && n2 != 0) {
                            this.zzawy().zzazj().zzj("Marking event as conversion", this.zzawt().zzjh(zza2.zzapa.get((int)n3).name));
                            zzcmc[] zzcmcArray2 = Arrays.copyOf(zza2.zzapa.get((int)n3).zzjlh, zza2.zzapa.get((int)n3).zzjlh.length + 1);
                            zzcmc zzcmc2 = new zzcmc();
                            new zzcmc().name = "_c";
                            zzcmc2.zzjll = 1L;
                            zzcmcArray2[zzcmcArray2.length - 1] = zzcmc2;
                            zza2.zzapa.get((int)n3).zzjlh = zzcmcArray2;
                        }
                        if (!bl4) {
                            this.zzawy().zzazj().zzj("Marking event as real-time", this.zzawt().zzjh(zza2.zzapa.get((int)n3).name));
                            zzcmc[] zzcmcArray3 = Arrays.copyOf(zza2.zzapa.get((int)n3).zzjlh, zza2.zzapa.get((int)n3).zzjlh.length + 1);
                            zzcmc zzcmc3 = new zzcmc();
                            new zzcmc().name = "_r";
                            zzcmc3.zzjll = 1L;
                            zzcmcArray3[zzcmcArray3.length - 1] = zzcmc3;
                            zza2.zzapa.get((int)n3).zzjlh = zzcmcArray3;
                        }
                        bl = true;
                        if (this.zzaws().zza((long)this.zzbag(), (String)zza2.zzjgi.zzcn, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzizb > (long)this.zzjew.zzix(zza2.zzjgi.zzcn)) {
                            zzcmb zzcmb2 = zza2.zzapa.get(n3);
                            for (n = 0; n < zzcmb2.zzjlh.length; ++n) {
                                if (!"_r".equals(zzcmb2.zzjlh[n].name)) continue;
                                n8 = new zzcmc[zzcmb2.zzjlh.length - 1];
                                if (n > 0) {
                                    System.arraycopy(zzcmb2.zzjlh, 0, n8, 0, n);
                                }
                                if (n < n8.length) {
                                    System.arraycopy(zzcmb2.zzjlh, n + 1, n8, n, n8.length - n);
                                }
                                zzcmb2.zzjlh = n8;
                                break;
                            }
                            bl = bl2;
                        }
                        if (zzclq.zzjz(zza2.zzapa.get((int)n3).name) && n2 != 0 && this.zzaws().zza((long)this.zzbag(), (String)zza2.zzjgi.zzcn, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zziyz > (long)this.zzjew.zzb(string2 = zza2.zzjgi.zzcn, zzchc.zzjaq)) {
                            this.zzawy().zzazf().zzj("Too many conversions. Not logging as conversion. appId", zzchm.zzjk(zza2.zzjgi.zzcn));
                            zzcmb zzcmb4 = zza2.zzapa.get(n3);
                            boolean bl5 = false;
                            object = null;
                            zzcmcArray = zzcmb4.zzjlh;
                            int n5 = zzcmb4.zzjlh.length;
                            for (int i = 0; i < n5; ++i) {
                                zzcmc zzcmc4 = zzcmcArray[i];
                                if ("_c".equals(zzcmc4.name)) {
                                    object = zzcmc4;
                                    continue;
                                }
                                if (!"_err".equals(zzcmc4.name)) continue;
                                bl5 = true;
                            }
                            if (bl5 && object != null) {
                                zzcmb4.zzjlh = (zzcmc[])com.google.android.gms.common.util.zza.zza((Object[])zzcmb4.zzjlh, (Object[])new zzcmc[]{object});
                            } else if (object != null) {
                                ((zzcmc)((Object)object)).name = "_err";
                                ((zzcmc)((Object)object)).zzjll = 10L;
                            } else {
                                this.zzawy().zzazd().zzj("Did not find conversion parameter. appId", zzchm.zzjk(zza2.zzjgi.zzcn));
                            }
                        }
                    }
                    zzcme3.zzjlp[n4++] = zza2.zzapa.get(n3);
                }
                if (n4 < zza2.zzapa.size()) {
                    zzcme3.zzjlp = Arrays.copyOf(zzcme3.zzjlp, n4);
                }
                zzcme3.zzjmi = this.zza(zza2.zzjgi.zzcn, zza2.zzjgi.zzjlq, zzcme3.zzjlp);
                if (zzchc.zzjac.get().booleanValue()) {
                    string2 = zza2.zzjgi.zzcn;
                    object2 = this.zzjew;
                    if ("1".equals(((zzcjk)object2).zzawv().zzam(string2, "measurement.event_sampling_enabled"))) {
                        HashMap<String, zzcgw> hashMap = new HashMap<String, zzcgw>();
                        zzcmb[] zzcmbArray = new zzcmb[zzcme3.zzjlp.length];
                        n2 = 0;
                        SecureRandom secureRandom = this.zzawu().zzbaz();
                        zzcmb[] zzcmbArray2 = zzcme3.zzjlp;
                        int n = zzcme3.zzjlp.length;
                        for (zzcmb3 = 0; zzcmb3 < n; ++zzcmb3) {
                            zzcmb zzcmb5 = zzcmbArray2[zzcmb3];
                            if (zzcmb5.name.equals("_ep")) {
                                this.zzawu();
                                String string3 = (String)zzclq.zza(zzcmb5, "_en");
                                object = (zzcgw)hashMap.get(string3);
                                if (object == null) {
                                    object = this.zzaws().zzae(zza2.zzjgi.zzcn, string3);
                                    hashMap.put(string3, (zzcgw)object);
                                }
                                if (object.zzizo != null) continue;
                                if (object.zzizp > 1L) {
                                    this.zzawu();
                                    zzcmb5.zzjlh = zzclq.zza(zzcmb5.zzjlh, "_sr", object.zzizp);
                                }
                                if (object.zzizq != null && object.zzizq.booleanValue()) {
                                    this.zzawu();
                                    zzcmb5.zzjlh = zzclq.zza(zzcmb5.zzjlh, "_efs", 1L);
                                }
                                zzcmbArray[n2++] = zzcmb5;
                                continue;
                            }
                            int n6 = 1;
                            if (!zzcim.zza(zzcmb5, "_dbg", 1L)) {
                                n6 = this.zzawv().zzap(zza2.zzjgi.zzcn, zzcmb5.name);
                            }
                            if (n6 <= 0) {
                                this.zzawy().zzazf().zze("Sample rate must be positive. event, rate", zzcmb5.name, n6);
                                zzcmbArray[n2++] = zzcmb5;
                                continue;
                            }
                            object = (zzcgw)hashMap.get(zzcmb5.name);
                            if (object == null && (object = this.zzaws().zzae(zza2.zzjgi.zzcn, zzcmb5.name)) == null) {
                                this.zzawy().zzazf().zze("Event being bundled has no eventAggregate. appId, eventName", zza2.zzjgi.zzcn, zzcmb5.name);
                                object = new zzcgw(zza2.zzjgi.zzcn, zzcmb5.name, 1L, 1L, zzcmb5.zzjli, 0L, null, null, null);
                            }
                            this.zzawu();
                            zzcmcArray = (zzcmc[])zzclq.zza(zzcmb5, "_eid");
                            Boolean bl6 = zzcmcArray != null;
                            if (n6 == 1) {
                                zzcmbArray[n2++] = zzcmb5;
                                if (!bl6.booleanValue() || object.zzizo == null && object.zzizp == null && object.zzizq == null) continue;
                                object = object.zza(null, null, null);
                                hashMap.put(zzcmb5.name, (zzcgw)object);
                                continue;
                            }
                            if (secureRandom.nextInt(n6) == 0) {
                                this.zzawu();
                                zzcmb5.zzjlh = zzclq.zza(zzcmb5.zzjlh, "_sr", n6);
                                zzcmbArray[n2++] = zzcmb5;
                                if (bl6.booleanValue()) {
                                    object = object.zza(null, Long.valueOf(n6), null);
                                }
                                hashMap.put(zzcmb5.name, object.zzbc(zzcmb5.zzjli));
                                continue;
                            }
                            long l2 = object.zzizn;
                            if (Math.abs(zzcmb5.zzjli - l2) >= 86400000L) {
                                this.zzawu();
                                zzcmb5.zzjlh = zzclq.zza(zzcmb5.zzjlh, "_efs", 1L);
                                this.zzawu();
                                zzcmb5.zzjlh = zzclq.zza(zzcmb5.zzjlh, "_sr", n6);
                                zzcmbArray[n2++] = zzcmb5;
                                if (bl6.booleanValue()) {
                                    object = object.zza(null, Long.valueOf(n6), true);
                                }
                                hashMap.put(zzcmb5.name, object.zzbc(zzcmb5.zzjli));
                                continue;
                            }
                            if (!bl6.booleanValue()) continue;
                            hashMap.put(zzcmb5.name, object.zza((Long)zzcmcArray, null, null));
                        }
                        if (n2 < zzcme3.zzjlp.length) {
                            zzcme3.zzjlp = Arrays.copyOf(zzcmbArray, n2);
                        }
                        for (Map.Entry entry : hashMap.entrySet()) {
                            this.zzaws().zza((zzcgw)entry.getValue());
                        }
                    }
                }
                zzcme3.zzjls = Long.MAX_VALUE;
                zzcme3.zzjlt = Long.MIN_VALUE;
                for (n3 = 0; n3 < zzcme3.zzjlp.length; ++n3) {
                    zzcmb zzcmb6 = zzcme3.zzjlp[n3];
                    if (zzcmb6.zzjli < zzcme3.zzjls) {
                        zzcme3.zzjls = zzcmb6.zzjli;
                    }
                    if (zzcmb6.zzjli <= zzcme3.zzjlt) continue;
                    zzcme3.zzjlt = zzcmb6.zzjli;
                }
                String string7 = zza2.zzjgi.zzcn;
                zzcgh zzcgh2 = this.zzaws().zzjb(string7);
                if (zzcgh2 == null) {
                    this.zzawy().zzazd().zzj("Bundling raw events w/o app info. appId", zzchm.zzjk(zza2.zzjgi.zzcn));
                } else if (zzcme3.zzjlp.length > 0) {
                    long l6 = zzcgh2.zzaxf();
                    zzcme3.zzjlv = l6 != 0L ? Long.valueOf(l6) : null;
                    long l7 = zzcgh2.zzaxe();
                    if (l7 == 0L) {
                        l7 = l6;
                    }
                    zzcme3.zzjlu = l7 != 0L ? Long.valueOf(l7) : null;
                    zzcgh2.zzaxo();
                    zzcme3.zzjmg = (int)zzcgh2.zzaxl();
                    zzcgh2.zzal(zzcme3.zzjls);
                    zzcgh2.zzam(zzcme3.zzjlt);
                    zzcme3.zzixw = zzcgh2.zzaxw();
                    this.zzaws().zza(zzcgh2);
                }
                if (zzcme3.zzjlp.length > 0) {
                    zzcly zzcly2 = this.zzawv().zzjs(zza2.zzjgi.zzcn);
                    if (zzcly2 == null || zzcly2.zzjkw == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzjgi.zzixs)) {
                            zzcme3.zzjmn = -1L;
                        } else {
                            this.zzawy().zzazf().zzj("Did not find measurement config or missing version info. appId", zzchm.zzjk(zza2.zzjgi.zzcn));
                        }
                    } else {
                        zzcme3.zzjmn = zzcly2.zzjkw;
                    }
                    this.zzaws().zza(zzcme3, bl);
                }
                this.zzaws().zzah(zza2.zzjgj);
                string2 = string7;
                object2 = this.zzaws();
                SQLiteDatabase sQLiteDatabase = ((zzcgo)object2).getWritableDatabase();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzcjk)object2).zzawy().zzazd().zze("Failed to remove unused event metadata. appId", zzchm.zzjk(string2), (Object)sQLiteException);
                }
                this.zzaws().setTransactionSuccessful();
                return true;
            }
            this.zzaws().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzaws().endTransaction();
        }
    }

    private final zzcma[] zza(String string, zzcmg[] zzcmgArray, zzcmb[] zzcmbArray) {
        zzbq.zzgm((String)string);
        return this.zzawl().zza(string, zzcmbArray, zzcmgArray);
    }

    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        zzbq.zzgm((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzawy().zzazj().zzj("onConfigFetched. Response size", byArray.length);
            this.zzaws().beginTransaction();
            try {
                boolean bl;
                zzcgh zzcgh2 = this.zzaws().zzjb(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzcgh2 == null) {
                    this.zzawy().zzazf().zzj("App does not exist in onConfigFetched. appId", zzchm.zzjk(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzawv().zzjs(string) == null && !this.zzawv().zzb(string, null, null) : !this.zzawv().zzb(string, byArray, string2)) {
                        return;
                    }
                    zzcgh2.zzar(this.zzata.currentTimeMillis());
                    this.zzaws().zza(zzcgh2);
                    if (n == 404) {
                        this.zzawy().zzazg().zzj("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzawy().zzazj().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzbab().zzzs() && this.zzbai()) {
                        this.zzbah();
                    } else {
                        this.zzbaj();
                    }
                } else {
                    zzcgh2.zzas(this.zzata.currentTimeMillis());
                    this.zzaws().zza(zzcgh2);
                    this.zzawy().zzazj().zze("Fetching config failed. code, error", n, throwable);
                    this.zzawv().zzju(string);
                    this.zzawz().zzjcs.set(this.zzata.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzawz().zzjct.set(this.zzata.currentTimeMillis());
                    }
                    this.zzbaj();
                }
                this.zzaws().setTransactionSuccessful();
            }
            finally {
                this.zzaws().endTransaction();
            }
            return;
        }
        finally {
            this.zzjgd = false;
            this.zzban();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzjfx;
            this.zzjfx = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzawz().zzjcr.set(this.zzata.currentTimeMillis());
                    this.zzawz().zzjcs.set(0L);
                    this.zzbaj();
                    this.zzawy().zzazj().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzaws().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcgo zzcgo2 = this.zzaws();
                            zzcgo2.zzve();
                            zzcgo2.zzxf();
                            SQLiteDatabase sQLiteDatabase = zzcgo2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcgo2.zzawy().zzazd().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzaws().setTransactionSuccessful();
                    }
                    finally {
                        this.zzaws().endTransaction();
                    }
                    if (this.zzbab().zzzs() && this.zzbai()) {
                        this.zzbah();
                    } else {
                        this.zzjgb = -1L;
                        this.zzbaj();
                    }
                    this.zzjgc = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzawy().zzazd().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzjgc = this.zzata.elapsedRealtime();
                    this.zzawy().zzazj().zzj("Disable upload, time", this.zzjgc);
                }
            } else {
                this.zzawy().zzazj().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzawz().zzjcs.set(this.zzata.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzawz().zzjct.set(this.zzata.currentTimeMillis());
                }
                this.zzbaj();
            }
            return;
        }
        finally {
            this.zzjge = false;
            this.zzban();
        }
    }

    private final boolean zzbai() {
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        return this.zzaws().zzayk() || !TextUtils.isEmpty((CharSequence)this.zzaws().zzayf());
    }

    @WorkerThread
    private final void zzbaj() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            ((zzcjk)this.zzawx()).zzve();
            this.zzxf();
            if (!this.zzbam()) {
                return;
            }
            if (this.zzjgc > 0L) {
                l3 = this.zzata.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzjgc);
                if (l2 > 0L) {
                    this.zzawy().zzazj().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzbac().unregister();
                    this.zzbad().cancel();
                    return;
                }
                this.zzjgc = 0L;
            }
            if (!this.zzazv() || !this.zzbai()) {
                this.zzawy().zzazj().log("Nothing to upload or uploading impossible");
                this.zzbac().unregister();
                this.zzbad().cancel();
                return;
            }
            zzcim zzcim2 = this;
            long l4 = zzcim2.zzata.currentTimeMillis();
            long l5 = Math.max(0L, zzchc.zzjbd.get());
            boolean bl = zzcim2.zzaws().zzayl() || zzcim2.zzaws().zzayg();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzcim2.zzjew.zzayd())) && !".none.".equals(string) ? Math.max(0L, zzchc.zzjay.get()) : Math.max(0L, zzchc.zzjax.get())) : Math.max(0L, zzchc.zzjaw.get());
            long l7 = zzcim2.zzawz().zzjcr.get();
            long l8 = zzcim2.zzawz().zzjcs.get();
            long l9 = zzcim2.zzaws().zzayi();
            long l10 = zzcim2.zzaws().zzayj();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzcim2.zzawu().zzf(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, zzchc.zzjbf.get())); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, zzchc.zzjbe.get()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzawy().zzazj().log("Next upload time is 0");
            this.zzbac().unregister();
            this.zzbad().cancel();
            return;
        }
        if (!this.zzbab().zzzs()) {
            this.zzawy().zzazj().log("No network");
            this.zzbac().zzzp();
            this.zzbad().cancel();
            return;
        }
        l2 = this.zzawz().zzjct.get();
        long l16 = Math.max(0L, zzchc.zzjau.get());
        if (!this.zzawu().zzf(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzbac().unregister();
        long l17 = l3 - this.zzata.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, zzchc.zzjaz.get());
            this.zzawz().zzjcr.set(this.zzata.currentTimeMillis());
        }
        this.zzawy().zzazj().zzj("Upload scheduled in approximately ms", l17);
        this.zzbad().zzs(l17);
    }

    public final void zzbo(boolean bl) {
        this.zzbaj();
    }

    final void zzb(zzcjl zzcjl2) {
        ++this.zzjfz;
    }

    final void zzbak() {
        ++this.zzjga;
    }

    @WorkerThread
    public final void zzf(zzcgi zzcgi2) {
        int n;
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        zzbq.checkNotNull((Object)((Object)zzcgi2));
        zzbq.zzgm((String)zzcgi2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzcgi2.zzixs)) {
            return;
        }
        zzcgh zzcgh2 = this.zzaws().zzjb(zzcgi2.packageName);
        if (zzcgh2 != null && TextUtils.isEmpty((CharSequence)zzcgh2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzcgi2.zzixs)) {
            zzcgh2.zzar(0L);
            this.zzaws().zza(zzcgh2);
            this.zzawv().zzjv(zzcgi2.packageName);
        }
        if (!zzcgi2.zzixx) {
            this.zzg(zzcgi2);
            return;
        }
        long l = zzcgi2.zziyc;
        if (l == 0L) {
            l = this.zzata.currentTimeMillis();
        }
        if ((n = zzcgi2.zziyd) != 0 && n != 1) {
            this.zzawy().zzazf().zze("Incorrect app type, assuming installed app. appId, appType", zzchm.zzjk(zzcgi2.packageName), n);
            n = 0;
        }
        this.zzaws().beginTransaction();
        try {
            zzcha zzcha2;
            Object object;
            long l2 = l;
            zzcgi zzcgi3 = zzcgi2;
            zzcim zzcim2 = this;
            zzcgh zzcgh3 = zzcim2.zzaws().zzjb(zzcgi3.packageName);
            if (zzcgh3 != null && zzcgh3.getGmpAppId() != null && !zzcgh3.getGmpAppId().equals(zzcgi3.zzixs)) {
                zzcim2.zzawy().zzazf().zzj("New GMP App Id passed in. Removing cached database data. appId", zzchm.zzjk(zzcgh3.getAppId()));
                String string = zzcgh3.getAppId();
                zzcgo zzcgo2 = zzcim2.zzaws();
                zzcgo2.zzxf();
                zzcgo2.zzve();
                zzbq.zzgm((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcgo2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcgo2.zzawy().zzazj().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcgo2.zzawy().zzazd().zze("Error deleting application data. appId, error", zzchm.zzjk(string), (Object)sQLiteException);
                }
                zzcgh3 = null;
            }
            if (zzcgh3 != null && zzcgh3.zzvj() != null && !zzcgh3.zzvj().equals(zzcgi3.zzifm)) {
                object = new Bundle();
                object.putString("_pv", zzcgh3.zzvj());
                zzcha2 = new zzcha("_au", new zzcgx((Bundle)object), "auto", l2);
                zzcim2.zzb(zzcha2, zzcgi3);
            }
            this.zzg(zzcgi2);
            zzcgw zzcgw2 = null;
            if (n == 0) {
                zzcgw2 = this.zzaws().zzae(zzcgi2.packageName, "_f");
            } else if (n == 1) {
                zzcgw2 = this.zzaws().zzae(zzcgi2.packageName, "_v");
            }
            if (zzcgw2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzbfm zzbfm2;
                    zzcln zzcln2 = new zzcln("_fot", l, l3, "auto");
                    this.zzb(zzcln2, zzcgi2);
                    l2 = l;
                    zzcgi3 = zzcgi2;
                    zzcim2 = this;
                    ((zzcjk)zzcim2.zzawx()).zzve();
                    zzcim2.zzxf();
                    zzcgh3 = new Bundle();
                    zzcgh3.putLong("_c", 1L);
                    zzcgh3.putLong("_r", 1L);
                    zzcgh3.putLong("_uwa", 0L);
                    zzcgh3.putLong("_pfo", 0L);
                    zzcgh3.putLong("_sys", 0L);
                    zzcgh3.putLong("_sysu", 0L);
                    if (zzcim2.mContext.getPackageManager() == null) {
                        zzcim2.zzawy().zzazd().zzj("PackageManager is null, first open report might be inaccurate. appId", zzchm.zzjk(zzcgi3.packageName));
                    } else {
                        zzcha2 = null;
                        try {
                            zzcha2 = zzbhf.zzdb((Context)zzcim2.mContext).getPackageInfo(zzcgi3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzcim2.zzawy().zzazd().zze("Package info is null, first open report might be inaccurate. appId", zzchm.zzjk(zzcgi3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzcha2 != null && ((PackageInfo)zzcha2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcha2).firstInstallTime != ((PackageInfo)zzcha2).lastUpdateTime) {
                                zzcgh3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzbfm2 = new zzcln("_fi", l2, bl ? 1L : 0L, "auto");
                            zzcim2.zzb((zzcln)zzbfm2, zzcgi3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbhf.zzdb((Context)zzcim2.mContext).getApplicationInfo(zzcgi3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzcim2.zzawy().zzazd().zze("Application info is null, first open report might be inaccurate. appId", zzchm.zzjk(zzcgi3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzcgh3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzcgh3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzcgi3.packageName;
                    zzcgo zzcgo3 = zzcim2.zzaws();
                    zzbq.zzgm((String)string);
                    zzcgo3.zzve();
                    zzcgo3.zzxf();
                    long l4 = zzcgo3.zzal(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzcgh3.putLong("_pfo", l4);
                    }
                    zzbfm2 = new zzcha("_f", new zzcgx((Bundle)zzcgh3), "auto", l2);
                    zzcim2.zzb((zzcha)zzbfm2, zzcgi3);
                } else if (n == 1) {
                    zzcln zzcln3 = new zzcln("_fvt", l, l3, "auto");
                    this.zzb(zzcln3, zzcgi2);
                    l2 = l;
                    zzcgi3 = zzcgi2;
                    zzcim2 = this;
                    ((zzcjk)zzcim2.zzawx()).zzve();
                    zzcim2.zzxf();
                    zzcgh3 = new Bundle();
                    zzcgh3.putLong("_c", 1L);
                    zzcgh3.putLong("_r", 1L);
                    object = new zzcha("_v", new zzcgx((Bundle)zzcgh3), "auto", l2);
                    zzcim2.zzb((zzcha)((Object)object), zzcgi3);
                }
                l2 = l;
                zzcgi3 = zzcgi2;
                zzcim2 = this;
                zzcgh3 = new Bundle();
                zzcgh3.putLong("_et", 1L);
                object = new zzcha("_e", new zzcgx((Bundle)zzcgh3), "auto", l2);
                zzcim2.zzb((zzcha)((Object)object), zzcgi3);
            } else if (zzcgi2.zzixy) {
                l2 = l;
                zzcgi3 = zzcgi2;
                zzcim2 = this;
                zzcgh3 = new Bundle();
                object = new zzcha("_cd", new zzcgx((Bundle)zzcgh3), "auto", l2);
                zzcim2.zzb((zzcha)((Object)object), zzcgi3);
            }
            this.zzaws().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaws().endTransaction();
        }
    }

    @WorkerThread
    private final void zzg(zzcgi zzcgi2) {
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        zzbq.checkNotNull((Object)((Object)zzcgi2));
        zzbq.zzgm((String)zzcgi2.packageName);
        zzcgh zzcgh2 = this.zzaws().zzjb(zzcgi2.packageName);
        String string = this.zzawz().zzjn(zzcgi2.packageName);
        boolean bl = false;
        if (zzcgh2 == null) {
            zzcgh2 = new zzcgh(this, zzcgi2.packageName);
            zzcgh2.zzir(this.zzawn().zzayz());
            zzcgh2.zzit(string);
            bl = true;
        } else if (!string.equals(zzcgh2.zzaxc())) {
            zzcgh2.zzit(string);
            zzcgh2.zzir(this.zzawn().zzayz());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcgi2.zzixs) && !zzcgi2.zzixs.equals(zzcgh2.getGmpAppId())) {
            zzcgh2.zzis(zzcgi2.zzixs);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcgi2.zziya) && !zzcgi2.zziya.equals(zzcgh2.zzaxd())) {
            zzcgh2.zziu(zzcgi2.zziya);
            bl = true;
        }
        if (zzcgi2.zzixu != 0L && zzcgi2.zzixu != zzcgh2.zzaxi()) {
            zzcgh2.zzao(zzcgi2.zzixu);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcgi2.zzifm) && !zzcgi2.zzifm.equals(zzcgh2.zzvj())) {
            zzcgh2.setAppVersion(zzcgi2.zzifm);
            bl = true;
        }
        if (zzcgi2.zzixz != zzcgh2.zzaxg()) {
            zzcgh2.zzan(zzcgi2.zzixz);
            bl = true;
        }
        if (zzcgi2.zzixt != null && !zzcgi2.zzixt.equals(zzcgh2.zzaxh())) {
            zzcgh2.zziv(zzcgi2.zzixt);
            bl = true;
        }
        if (zzcgi2.zzixv != zzcgh2.zzaxj()) {
            zzcgh2.zzap(zzcgi2.zzixv);
            bl = true;
        }
        if (zzcgi2.zzixx != zzcgh2.zzaxk()) {
            zzcgh2.setMeasurementEnabled(zzcgi2.zzixx);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcgi2.zzixw) && !zzcgi2.zzixw.equals(zzcgh2.zzaxv())) {
            zzcgh2.zziw(zzcgi2.zzixw);
            bl = true;
        }
        if (zzcgi2.zziyb != zzcgh2.zzaxx()) {
            zzcgh2.zzaz(zzcgi2.zziyb);
            bl = true;
        }
        if (zzcgi2.zziye != zzcgh2.zzaxy()) {
            zzcgh2.zzbl(zzcgi2.zziye);
            bl = true;
        }
        if (bl) {
            this.zzaws().zza(zzcgh2);
        }
    }

    @WorkerThread
    final void zzbal() {
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        if (!this.zzjfs) {
            this.zzawy().zzazh().log("This instance being marked as an uploader");
            zzcim zzcim2 = this;
            ((zzcjk)zzcim2.zzawx()).zzve();
            zzcim2.zzxf();
            if (zzcim2.zzbam() && zzcim2.zzbae()) {
                int n;
                int n2 = zzcim2.zza(zzcim2.zzjfw);
                int n3 = n = zzcim2.zzawn().zzaza();
                int n4 = n2;
                zzcim zzcim3 = zzcim2;
                ((zzcjk)zzcim3.zzawx()).zzve();
                if (n4 > n3) {
                    zzcim3.zzawy().zzazd().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzcim3.zza(n3, zzcim3.zzjfw)) {
                        zzcim3.zzawy().zzazj().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzcim3.zzawy().zzazd().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzjfs = true;
            this.zzbaj();
        }
    }

    @WorkerThread
    private final boolean zzbam() {
        ((zzcjk)this.zzawx()).zzve();
        this.zzxf();
        return this.zzjfs;
    }

    @WorkerThread
    final void zzi(Runnable runnable) {
        ((zzcjk)this.zzawx()).zzve();
        if (this.zzjfy == null) {
            this.zzjfy = new ArrayList<Runnable>();
        }
        this.zzjfy.add(runnable);
    }

    @WorkerThread
    private final void zzban() {
        ((zzcjk)this.zzawx()).zzve();
        if (this.zzjgd || this.zzjge || this.zzjgf) {
            this.zzawy().zzazj().zzd("Not stopping services. fetch, network, upload", this.zzjgd, this.zzjge, this.zzjgf);
            return;
        }
        this.zzawy().zzazj().log("Stopping uploading service(s)");
        if (this.zzjfy == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzjfy.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzjfy.clear();
    }

    static /* synthetic */ void zza(zzcim zzcim2) {
        zzcim2.zzazw();
    }

    final class zza
    implements zzcgq {
        zzcme zzjgi;
        List<Long> zzjgj;
        List<zzcmb> zzapa;
        private long zzjgk;
        private /* synthetic */ zzcim zzjgh;

        private zza(zzcim zzcim2) {
            this.zzjgh = zzcim2;
        }

        @Override
        public final void zzb(zzcme zzcme2) {
            zzbq.checkNotNull((Object)((Object)zzcme2));
            this.zzjgi = zzcme2;
        }

        @Override
        public final boolean zza(long l, zzcmb zzcmb2) {
            zzbq.checkNotNull((Object)((Object)zzcmb2));
            if (this.zzapa == null) {
                this.zzapa = new ArrayList<zzcmb>();
            }
            if (this.zzjgj == null) {
                this.zzjgj = new ArrayList<Long>();
            }
            if (this.zzapa.size() > 0 && zza.zza(this.zzapa.get(0)) != zza.zza(zzcmb2)) {
                return false;
            }
            long l2 = this.zzjgk + (long)zzcmb2.zzho();
            if (l2 >= (long)Math.max(0, zzchc.zzjal.get())) {
                return false;
            }
            this.zzjgk = l2;
            this.zzapa.add(zzcmb2);
            this.zzjgj.add(l);
            return this.zzapa.size() < Math.max(1, zzchc.zzjam.get());
        }

        private static long zza(zzcmb zzcmb2) {
            return zzcmb2.zzjli / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzcim zzcim2, zzcin zzcin2) {
            this(zzcim2);
        }
    }
}

