/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.zzcgs;
import com.google.android.gms.internal.zzchc;
import com.google.android.gms.internal.zzcid;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcla;
import com.google.android.gms.internal.zzclm;

public final class zzcll
extends zzcjl {
    private final AlarmManager zzdvu = (AlarmManager)((zzcjk)this).getContext().getSystemService("alarm");
    private final zzcgs zzjjg;
    private Integer zzdvv;

    protected zzcll(zzcim zzcim2) {
        super(zzcim2);
        this.zzjjg = new zzclm(this, zzcim2);
    }

    @Override
    protected final boolean zzaxz() {
        this.zzdvu.cancel(this.zzzf());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzbax();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzbax() {
        JobScheduler jobScheduler = (JobScheduler)((zzcjk)this).getContext().getSystemService("jobscheduler");
        ((zzcjk)this).zzawy().zzazj().zzj("Cancelling job. JobID", this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzs(long l) {
        this.zzxf();
        if (!zzcid.zzbk(((zzcjk)this).getContext())) {
            ((zzcjk)this).zzawy().zzazi().log("Receiver not registered/enabled");
        }
        if (!zzcla.zzk(((zzcjk)this).getContext(), false)) {
            ((zzcjk)this).zzawy().zzazi().log("Service not registered/enabled");
        }
        this.cancel();
        long l2 = ((zzcjk)this).zzws().elapsedRealtime() + l;
        if (l < Math.max(0L, zzchc.zzjba.get()) && !this.zzjjg.zzdx()) {
            ((zzcjk)this).zzawy().zzazj().log("Scheduling upload with DelayedRunnable");
            this.zzjjg.zzs(l);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            ((zzcjk)this).zzawy().zzazj().log("Scheduling upload with JobScheduler");
            long l3 = l;
            zzcll zzcll2 = this;
            ComponentName componentName = new ComponentName(((zzcjk)zzcll2).getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)((zzcjk)zzcll2).getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzcll2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            ((zzcjk)zzcll2).zzawy().zzazj().zzj("Scheduling job. JobID", zzcll2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        ((zzcjk)this).zzawy().zzazj().log("Scheduling upload with AlarmManager");
        this.zzdvu.setInexactRepeating(2, l2, Math.max(zzchc.zzjav.get(), l), this.zzzf());
    }

    private final int getJobId() {
        if (this.zzdvv == null) {
            String string = String.valueOf(((zzcjk)this).getContext().getPackageName());
            this.zzdvv = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzdvv;
    }

    public final void cancel() {
        this.zzxf();
        this.zzdvu.cancel(this.zzzf());
        this.zzjjg.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzbax();
        }
    }

    private final PendingIntent zzzf() {
        Intent intent = new Intent().setClassName(((zzcjk)this).getContext(), "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)((zzcjk)this).getContext(), (int)0, (Intent)intent, (int)0);
    }
}

