/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzcjb;
import com.google.android.gms.internal.zzcjd;
import com.google.android.gms.internal.zzcji;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcme;
import com.google.android.gms.internal.zzcmt;
import com.google.android.gms.internal.zzcmu;
import com.google.android.gms.internal.zzcmv;
import com.google.android.gms.internal.zzcmw;
import com.google.android.gms.internal.zzcmx;

public final class zzcms
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zzjrp;
    private volatile zzcji zzjrq;
    final /* synthetic */ zzcme zzjri;

    protected zzcms(zzcme zzcme2) {
        this.zzjri = zzcme2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzm(Intent intent) {
        ((zzclh)this.zzjri).zzwj();
        Context context = ((zzclh)this.zzjri).getContext();
        zza zza2 = zza.zzanm();
        zzcms zzcms2 = this;
        synchronized (zzcms2) {
            if (this.zzjrp) {
                ((zzclh)this.zzjri).zzayp().zzbba().log("Connection attempt already in progress");
                return;
            }
            ((zzclh)this.zzjri).zzayp().zzbba().log("Using local app measurement service");
            this.zzjrp = true;
            zza2.zza(context, intent, (ServiceConnection)zzcme.zza(this.zzjri), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbq.zzgn((String)"MeasurementServiceConnection.onServiceConnected");
        zzcms zzcms2 = this;
        synchronized (zzcms2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zzjrp = false;
                ((zzclh)this.zzjri).zzayp().zzbau().log("Service connected with null binder");
                return;
            }
            zzcjb zzcjb2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzcjb2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzcjb ? (zzcjb)iInterface : new zzcjd(iBinder2));
                    ((zzclh)this.zzjri).zzayp().zzbba().log("Bound to IMeasurementService interface");
                } else {
                    ((zzclh)this.zzjri).zzayp().zzbau().zzj("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzclh)this.zzjri).zzayp().zzbau().log("Service connect failed to get IMeasurementService");
            }
            if (zzcjb2 == null) {
                this.zzjrp = false;
                try {
                    zza.zzanm();
                    zzcms zzcms3 = zzcme.zza(this.zzjri);
                    iInterface = ((zzclh)this.zzjri).getContext();
                    iInterface.unbindService((ServiceConnection)zzcms3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzcjb2;
                ((zzclh)this.zzjri).zzayo().zzh(new zzcmt(this, (zzcjb)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbq.zzgn((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzclh)this.zzjri).zzayp().zzbaz().log("Service disconnected");
        ((zzclh)this.zzjri).zzayo().zzh(new zzcmu(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzbcm() {
        ((zzclh)this.zzjri).zzwj();
        Context context = ((zzclh)this.zzjri).getContext();
        zzcms zzcms2 = this;
        synchronized (zzcms2) {
            if (this.zzjrp) {
                ((zzclh)this.zzjri).zzayp().zzbba().log("Connection attempt already in progress");
                return;
            }
            if (this.zzjrq != null) {
                ((zzclh)this.zzjri).zzayp().zzbba().log("Already awaiting connection attempt");
                return;
            }
            this.zzjrq = new zzcji(context, Looper.getMainLooper(), this, this);
            ((zzclh)this.zzjri).zzayp().zzbba().log("Connecting to remote service");
            this.zzjrp = true;
            this.zzjrq.zzals();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        zzbq.zzgn((String)"MeasurementServiceConnection.onConnected");
        zzcms zzcms2 = this;
        synchronized (zzcms2) {
            try {
                zzcjb zzcjb2 = (zzcjb)this.zzjrq.zzalw();
                this.zzjrq = null;
                ((zzclh)this.zzjri).zzayo().zzh(new zzcmv(this, zzcjb2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzjrq = null;
                this.zzjrp = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzbq.zzgn((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzclh)this.zzjri).zzayp().zzbaz().log("Service connection suspended");
        ((zzclh)this.zzjri).zzayo().zzh(new zzcmw(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbq.zzgn((String)"MeasurementServiceConnection.onConnectionFailed");
        zzcjj zzcjj2 = this.zzjri.zzjev.zzbbo();
        if (zzcjj2 != null) {
            zzcjj2.zzbaw().zzj("Service connection failed", connectionResult);
        }
        zzcms zzcms2 = this;
        synchronized (zzcms2) {
            this.zzjrp = false;
            this.zzjrq = null;
        }
        ((zzclh)this.zzjri).zzayo().zzh(new zzcmx(this));
    }

    static /* synthetic */ boolean zza(zzcms zzcms2, boolean bl) {
        zzcms2.zzjrp = false;
        return false;
    }
}

