/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzie;
import com.google.android.gms.internal.measurement.zzif;
import java.util.Map;

public final class zzdu
extends zzhg {
    private final Map<String, Long> zzadf;
    private final Map<String, Integer> zzadg = new ArrayMap();
    private long zzadh;

    public zzdu(zzgl zzgl2) {
        super(zzgl2);
        this.zzadf = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzhg)this).zzge().zzim().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzhg)this).zzbt().elapsedRealtime();
        ((zzhg)this).zzgd().zzc(new zzdv(this, string, l));
    }

    @WorkerThread
    private final void zza(String string, long l) {
        Integer n;
        ((zzhg)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzadg.isEmpty()) {
            this.zzadh = l;
        }
        if ((n = this.zzadg.get(string)) != null) {
            this.zzadg.put(string, n + 1);
            return;
        }
        if (this.zzadg.size() >= 100) {
            ((zzhg)this).zzge().zzip().log("Too many ads visible");
            return;
        }
        this.zzadg.put(string, 1);
        this.zzadf.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzhg)this).zzge().zzim().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzhg)this).zzbt().elapsedRealtime();
        ((zzhg)this).zzgd().zzc(new zzdw(this, string, l));
    }

    @WorkerThread
    private final void zzb(String string, long l) {
        ((zzhg)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        Integer n = this.zzadg.get(string);
        if (n != null) {
            zzie zzie2 = ((zzhg)this).zzfy().zzkc();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzadg.remove(string);
                Long l2 = this.zzadf.get(string);
                if (l2 == null) {
                    ((zzhg)this).zzge().zzim().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzadf.remove(string);
                    this.zza(string, l3, zzie2);
                }
                if (this.zzadg.isEmpty()) {
                    if (this.zzadh == 0L) {
                        ((zzhg)this).zzge().zzim().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzadh, zzie2);
                    this.zzadh = 0L;
                }
                return;
            }
            this.zzadg.put(string, n2);
            return;
        }
        ((zzhg)this).zzge().zzim().zzg("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, zzie zzie2) {
        if (zzie2 == null) {
            ((zzhg)this).zzge().zzit().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzhg)this).zzge().zzit().zzg("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzif.zza(zzie2, bundle, true);
        ((zzhg)this).zzfu().logEvent("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, zzie zzie2) {
        if (zzie2 == null) {
            ((zzhg)this).zzge().zzit().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzhg)this).zzge().zzit().zzg("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzif.zza(zzie2, bundle, true);
        ((zzhg)this).zzfu().logEvent("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzk(long l) {
        zzie zzie2 = ((zzhg)this).zzfy().zzkc();
        for (String string : this.zzadf.keySet()) {
            long l2 = this.zzadf.get(string);
            this.zza(string, l - l2, zzie2);
        }
        if (!this.zzadf.isEmpty()) {
            this.zza(l - this.zzadh, zzie2);
        }
        this.zzl(l);
    }

    @WorkerThread
    private final void zzl(long l) {
        for (String string : this.zzadf.keySet()) {
            this.zzadf.put(string, l);
        }
        if (!this.zzadf.isEmpty()) {
            this.zzadh = l;
        }
    }

    static /* synthetic */ void zza(zzdu zzdu2, String string, long l) {
        zzdu2.zza(string, l);
    }

    static /* synthetic */ void zzb(zzdu zzdu2, String string, long l) {
        zzdu2.zzb(string, l);
    }

    static /* synthetic */ void zza(zzdu zzdu2, long l) {
        zzdu2.zzl(l);
    }
}

