/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhg;
import java.lang.reflect.InvocationTargetException;

public final class zzef
extends zzhg {
    @NonNull
    private zzeh zzaet = zzeg.zzaeu;
    private Boolean zzxz;

    zzef(zzgl zzgl2) {
        super(zzgl2);
    }

    final void zza(@NonNull zzeh zzeh2) {
        this.zzaet = zzeh2;
    }

    @WorkerThread
    public final int zzar(@Size(min=1L) String string) {
        return this.zzb(string, zzew.zzagw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzds() {
        if (this.zzxz == null) {
            zzef zzef2 = this;
            synchronized (zzef2) {
                if (this.zzxz == null) {
                    ApplicationInfo applicationInfo = ((zzhg)this).getContext().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzxz = string2 != null && string2.equals(string);
                    }
                    if (this.zzxz == null) {
                        this.zzxz = Boolean.TRUE;
                        ((zzhg)this).zzge().zzim().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzxz;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzex<Long> zzex2) {
        if (string == null) {
            return zzex2.get();
        }
        String string2 = this.zzaet.zze(string, zzex2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzex2.get();
        }
        try {
            long l = Long.parseLong(string2);
            return zzex2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzex2.get();
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzex<Integer> zzex2) {
        if (string == null) {
            return zzex2.get();
        }
        String string2 = this.zzaet.zze(string, zzex2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzex2.get();
        }
        try {
            int n = Integer.parseInt(string2);
            return zzex2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzex2.get();
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzex<Double> zzex2) {
        if (string == null) {
            return zzex2.get();
        }
        String string2 = this.zzaet.zze(string, zzex2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzex2.get();
        }
        try {
            double d = Double.parseDouble(string2);
            return zzex2.get(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzex2.get();
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzex<Boolean> zzex2) {
        if (string == null) {
            return zzex2.get();
        }
        String string2 = this.zzaet.zze(string, zzex2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzex2.get();
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzex2.get(bl);
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzas(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            if (((zzhg)this).getContext().getPackageManager() == null) {
                ((zzhg)this).zzge().zzim().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzhg)this).getContext()).getApplicationInfo(((zzhg)this).getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzhg)this).zzge().zzim().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                ((zzhg)this).zzge().zzim().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzhg)this).zzge().zzim().zzg("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final boolean zzhg() {
        Boolean bl = this.zzas("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public static long zzhh() {
        return zzew.zzahl.get();
    }

    public static long zzhi() {
        return zzew.zzagl.get();
    }

    public final String zzhj() {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzhg)this).zzge().zzim().zzg("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzhg)this).zzge().zzim().zzg("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzhg)this).zzge().zzim().zzg("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzhg)this).zzge().zzim().zzg("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }

    public static boolean zzhk() {
        return zzew.zzagh.get();
    }

    public final boolean zzat(String string) {
        return "1".equals(this.zzaet.zze(string, "gaia_collection_enabled"));
    }

    public final boolean zzau(String string) {
        return "1".equals(this.zzaet.zze(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzav(String string) {
        return this.zzd(string, zzew.zzahu);
    }

    @WorkerThread
    final boolean zzaw(String string) {
        return this.zzd(string, zzew.zzahw);
    }

    @WorkerThread
    final boolean zzax(String string) {
        return this.zzd(string, zzew.zzahx);
    }

    @WorkerThread
    final boolean zzhl() {
        return this.zzd(((zzhg)this).zzfv().zzah(), zzew.zzahp);
    }

    @WorkerThread
    final String zzhm() {
        zzex<String> zzex2 = zzew.zzahq;
        String string = ((zzhg)this).zzfv().zzah();
        zzef zzef2 = this;
        if (string == null) {
            return zzex2.get();
        }
        return zzex2.get(zzef2.zzaet.zze(string, zzex2.getKey()));
    }

    final boolean zzay(String string) {
        return this.zzd(string, zzew.zzahy);
    }

    @WorkerThread
    final boolean zzaz(String string) {
        return this.zzd(string, zzew.zzahz);
    }

    @WorkerThread
    final boolean zzba(String string) {
        return this.zzd(string, zzew.zzaic);
    }
}

