/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzr;
import java.util.List;

public final class zzfx {
    private final zzgl zzacw;
    @VisibleForTesting
    volatile zzr zzakw;
    @VisibleForTesting
    private ServiceConnection zzakx;

    zzfx(zzgl zzgl2) {
        this.zzacw = zzgl2;
    }

    @WorkerThread
    protected final void zzjh() {
        ((zzjr)this.zzacw).zzab();
        if (!this.zzji()) {
            ((zzjr)this.zzacw).zzge().zzir().log("Install Referrer Reporter is not available");
            this.zzakx = null;
            return;
        }
        this.zzakx = new zzfz(this, null);
        ((zzjr)this.zzacw).zzge().zzir().log("Install Referrer Reporter is initializing");
        zzfx zzfx2 = this;
        ((zzjr)zzfx2.zzacw).zzab();
        Intent intent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
        intent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
        PackageManager packageManager = ((zzjr)zzfx2.zzacw).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzjr)zzfx2.zzacw).zzge().zzip().log("Failed to obtain Package Manager to verify binding conditions");
            return;
        }
        List list = packageManager.queryIntentServices(intent, 0);
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string = resolveInfo.serviceInfo.packageName;
                if (resolveInfo.serviceInfo.name != null && zzfx2.zzakx != null && "com.android.vending".equals(string) && zzfx2.zzji()) {
                    Intent intent2 = new Intent(intent);
                    try {
                        boolean bl = ConnectionTracker.getInstance().bindService(((zzjr)zzfx2.zzacw).getContext(), intent2, zzfx2.zzakx, 1);
                        ((zzjr)zzfx2.zzacw).zzge().zzir().zzg("Install Referrer Service is", bl ? "available" : "not available");
                        return;
                    }
                    catch (Exception exception) {
                        ((zzjr)zzfx2.zzacw).zzge().zzim().zzg("Exception occurred while binding to Install Referrer Service", exception.getMessage());
                        return;
                    }
                }
                ((zzjr)zzfx2.zzacw).zzge().zzir().log("Play Store missing or incompatible. Version 8.3.73 or later required");
            }
            return;
        }
        ((zzjr)zzfx2.zzacw).zzge().zzir().log("Play Service for fetching Install Referrer is unavailable on device");
    }

    @VisibleForTesting
    private final boolean zzji() {
        try {
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager((Context)((zzjr)this.zzacw).getContext());
            if (packageManagerWrapper == null) {
                ((zzjr)this.zzacw).zzge().zzir().log("Failed to retrieve Package Manager to check Play Store compatibility");
                return false;
            }
            return packageManagerWrapper.getPackageInfo((String)"com.android.vending", (int)128).versionCode >= 80837300;
        }
        catch (Exception exception) {
            ((zzjr)this.zzacw).zzge().zzir().zzg("Failed to retrieve Play Store version", exception);
            return false;
        }
    }

    @WorkerThread
    @Nullable
    @VisibleForTesting
    final Bundle zzjj() {
        Bundle bundle;
        ((zzjr)this.zzacw).zzab();
        if (this.zzakw == null) {
            ((zzjr)this.zzacw).zzge().zzip().log("Attempting to use Install Referrer Service while it is not initialized");
            return null;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putString("package_name", ((zzjr)this.zzacw).getContext().getPackageName());
        try {
            bundle = this.zzakw.zza(bundle2);
            if (bundle == null) {
                ((zzjr)this.zzacw).zzge().zzim().log("Install Referrer Service returned a null response");
                return null;
            }
        }
        catch (Exception exception) {
            ((zzjr)this.zzacw).zzge().zzim().zzg("Exception occurred while retrieving the Install Referrer", exception.getMessage());
            return null;
        }
        return bundle;
    }

    @WorkerThread
    @VisibleForTesting
    final void zzc(Bundle bundle) {
        long l;
        ((zzjr)this.zzacw).zzab();
        if (bundle == null) {
            return;
        }
        long l2 = bundle.getLong("install_begin_timestamp_seconds", 0L) * 1000L;
        if (l2 == 0L) {
            ((zzjr)this.zzacw).zzge().zzim().log("Service response is missing Install Referrer install timestamp");
            return;
        }
        String string = bundle.getString("install_referrer");
        if (string == null || string.isEmpty()) {
            ((zzjr)this.zzacw).zzge().zzim().log("No referrer defined in install referrer response");
            return;
        }
        ((zzjr)this.zzacw).zzge().zzit().zzg("InstallReferrer API result", string);
        String string2 = String.valueOf(string);
        Bundle bundle2 = ((zzjr)this.zzacw).zzgb().zza(Uri.parse((String)(string2.length() != 0 ? "?".concat(string2) : new String("?"))));
        if (bundle2 == null) {
            ((zzjr)this.zzacw).zzge().zzim().log("No campaign params defined in install referrer result");
            return;
        }
        String string3 = bundle2.getString("medium");
        if (string3 != null && !"(not set)".equalsIgnoreCase(string3) && !"organic".equalsIgnoreCase(string3)) {
            l = bundle.getLong("referrer_click_timestamp_seconds", 0L) * 1000L;
            if (l == 0L) {
                ((zzjr)this.zzacw).zzge().zzim().log("Install Referrer is missing click timestamp for ad campaign");
                return;
            }
            bundle2.putLong("click_timestamp", l);
        }
        if (l2 == (l = ((zzjr)this.zzacw).zzgf().zzaka.get())) {
            ((zzjr)this.zzacw).zzge().zzit().log("Campaign has already been logged");
            return;
        }
        bundle2.putString("_cis", "referrer API");
        ((zzjr)this.zzacw).zzgf().zzaka.set(l2);
        this.zzacw.zzfu().logEvent("auto", "_cmp", bundle2);
        if (this.zzakx != null) {
            ConnectionTracker.getInstance().unbindService(((zzjr)this.zzacw).getContext(), this.zzakx);
        }
    }

    static /* synthetic */ zzgl zza(zzfx zzfx2) {
        return zzfx2.zzacw;
    }
}

