/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.os.Looper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgj;
import com.google.android.gms.internal.measurement.zzgk;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzhh;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzgg
extends zzhh {
    private ExecutorService zzaln;
    private zzgk zzalo;
    private zzgk zzalp;
    private final PriorityBlockingQueue<zzgj<?>> zzalq;
    private final BlockingQueue<zzgj<?>> zzalr;
    private final Thread.UncaughtExceptionHandler zzals;
    private final Thread.UncaughtExceptionHandler zzalt;
    private final Object zzalu = new Object();
    private final Semaphore zzalv = new Semaphore(2);
    private volatile boolean zzalw;
    private static final AtomicLong zzalx = new AtomicLong(Long.MIN_VALUE);

    zzgg(zzgl zzgl2) {
        super(zzgl2);
        this.zzalq = new PriorityBlockingQueue();
        this.zzalr = new LinkedBlockingQueue();
        this.zzals = new zzgi(this, "Thread death: Uncaught exception on worker thread");
        this.zzalt = new zzgi(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzhf() {
        return false;
    }

    @Override
    public final void zzab() {
        if (Thread.currentThread() != this.zzalo) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzfs() {
        if (Thread.currentThread() != this.zzalp) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzjk() {
        return Thread.currentThread() == this.zzalo;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull(callable);
        zzgj zzgj2 = new zzgj(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzalo) {
            if (!this.zzalq.isEmpty()) {
                ((zzhg)this).zzge().zzip().log("Callable skipped the worker queue.");
            }
            zzgj2.run();
        } else {
            this.zza(zzgj2);
        }
        return zzgj2;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull(callable);
        zzgj zzgj2 = new zzgj(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzalo) {
            zzgj2.run();
        } else {
            this.zza(zzgj2);
        }
        return zzgj2;
    }

    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzgj(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzhg)this).zzgd().zzc(runnable);
            try {
                atomicReference.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzhg)this).zzge().zzip().log(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzhg)this).zzge().zzip().log(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzgj<?> zzgj2) {
        Object object = this.zzalu;
        synchronized (object) {
            this.zzalq.add(zzgj2);
            if (this.zzalo == null) {
                this.zzalo = new zzgk(this, "Measurement Worker", this.zzalq);
                this.zzalo.setUncaughtExceptionHandler(this.zzals);
                this.zzalo.start();
            } else {
                this.zzalo.zzjn();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd(Runnable runnable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull((Object)runnable);
        zzgj zzgj2 = new zzgj(this, runnable, false, "Task exception on network thread");
        zzgg zzgg2 = this;
        Object object = zzgg2.zzalu;
        synchronized (object) {
            zzgg2.zzalr.add(zzgj2);
            if (zzgg2.zzalp == null) {
                zzgg2.zzalp = new zzgk(zzgg2, "Measurement Network", zzgg2.zzalr);
                zzgg2.zzalp.setUncaughtExceptionHandler(zzgg2.zzalt);
                zzgg2.zzalp.start();
            } else {
                zzgg2.zzalp.zzjn();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzjl() {
        Object object = this.zzalu;
        synchronized (object) {
            if (this.zzaln == null) {
                this.zzaln = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzaln;
        }
    }

    static /* synthetic */ Semaphore zza(zzgg zzgg2) {
        return zzgg2.zzalv;
    }

    static /* synthetic */ boolean zzb(zzgg zzgg2) {
        return zzgg2.zzalw;
    }

    static /* synthetic */ Object zzc(zzgg zzgg2) {
        return zzgg2.zzalu;
    }

    static /* synthetic */ zzgk zzd(zzgg zzgg2) {
        return zzgg2.zzalo;
    }

    static /* synthetic */ zzgk zza(zzgg zzgg2, zzgk zzgk2) {
        zzgg2.zzalo = null;
        return null;
    }

    static /* synthetic */ zzgk zze(zzgg zzgg2) {
        return zzgg2.zzalp;
    }

    static /* synthetic */ zzgk zzb(zzgg zzgg2, zzgk zzgk2) {
        zzgg2.zzalp = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzjm() {
        return zzalx;
    }
}

