/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgo;
import com.google.android.gms.internal.measurement.zzgp;
import com.google.android.gms.internal.measurement.zzgq;
import com.google.android.gms.internal.measurement.zzgr;
import com.google.android.gms.internal.measurement.zzgs;
import com.google.android.gms.internal.measurement.zzgt;
import com.google.android.gms.internal.measurement.zzgu;
import com.google.android.gms.internal.measurement.zzgv;
import com.google.android.gms.internal.measurement.zzgw;
import com.google.android.gms.internal.measurement.zzgx;
import com.google.android.gms.internal.measurement.zzgy;
import com.google.android.gms.internal.measurement.zzgz;
import com.google.android.gms.internal.measurement.zzha;
import com.google.android.gms.internal.measurement.zzhb;
import com.google.android.gms.internal.measurement.zzhc;
import com.google.android.gms.internal.measurement.zzhd;
import com.google.android.gms.internal.measurement.zzhe;
import com.google.android.gms.internal.measurement.zzhf;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzjx;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzka;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzgn
extends zzez {
    private final zzjr zzajp;
    private Boolean zzanc;
    @Nullable
    private String zzand;

    public zzgn(zzjr zzjr2) {
        this(zzjr2, null);
    }

    private zzgn(zzjr zzjr2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzjr2);
        this.zzajp = zzjr2;
        this.zzand = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzdz zzdz2) {
        this.zzb(zzdz2, false);
        this.zze(new zzgo(this, zzdz2));
    }

    @Override
    @BinderThread
    public final void zza(zzeu zzeu2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzeu2));
        this.zzb(zzdz2, false);
        this.zze(new zzgy(this, zzeu2, zzdz2));
    }

    @Override
    @BinderThread
    public final void zza(zzeu zzeu2, String string, String string2) {
        Preconditions.checkNotNull((Object)((Object)zzeu2));
        Preconditions.checkNotEmpty((String)string);
        this.zzc(string, true);
        this.zze(new zzgz(this, zzeu2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzeu zzeu2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzeu2));
        this.zzc(string, true);
        this.zzajp.zzge().zzis().zzg("Log and bundle. event", this.zzajp.zzga().zzbj(zzeu2.name));
        long l = this.zzajp.zzbt().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzajp.zzgd().zzc(new zzha(this, zzeu2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzajp.zzge().zzim().zzg("Log and bundle returned null. appId", zzfg.zzbm(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzajp.zzbt().nanoTime() / 1000000L;
            this.zzajp.zzge().zzis().zzd("Log and bundle processed. event, size, time_ms", this.zzajp.zzga().zzbj(zzeu2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajp.zzge().zzim().zzd("Failed to log and bundle. appId, event, error", zzfg.zzbm(string), this.zzajp.zzga().zzbj(zzeu2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzjx zzjx2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzjx2));
        this.zzb(zzdz2, false);
        if (zzjx2.getValue() == null) {
            this.zze(new zzhb(this, zzjx2, zzdz2));
            return;
        }
        this.zze(new zzhc(this, zzjx2, zzdz2));
    }

    @Override
    @BinderThread
    public final List<zzjx> zza(zzdz zzdz2, boolean bl) {
        this.zzb(zzdz2, false);
        Future<List<zzjz>> future = this.zzajp.zzgd().zzb(new zzhd(this, zzdz2));
        try {
            List<zzjz> list = future.get();
            ArrayList<zzjx> arrayList = new ArrayList<zzjx>(list.size());
            for (zzjz zzjz2 : list) {
                if (!bl && zzka.zzci(zzjz2.name)) continue;
                arrayList.add(new zzjx(zzjz2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajp.zzge().zzim().zze("Failed to get user attributes. appId", zzfg.zzbm(zzdz2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzdz zzdz2) {
        this.zzb(zzdz2, false);
        this.zze(new zzhe(this, zzdz2));
    }

    @BinderThread
    private final void zzb(zzdz zzdz2, boolean bl) {
        Preconditions.checkNotNull((Object)((Object)zzdz2));
        this.zzc(zzdz2.packageName, false);
        this.zzajp.zzgb().zzcg(zzdz2.zzadm);
    }

    @BinderThread
    private final void zzc(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzajp.zzge().zzim().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzgn zzgn2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzgn2 = this;
                    if (!bl2) break block9;
                    if (zzgn2.zzanc == null) {
                        zzgn2.zzanc = "com.google.android.gms".equals(zzgn2.zzand) || UidVerifier.isGooglePlayServicesUid((Context)zzgn2.zzajp.getContext(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzgn2.zzajp.getContext()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzgn2.zzanc.booleanValue()) break block10;
                }
                if (zzgn2.zzand == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzgn2.zzajp.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzgn2.zzand = string2;
                }
                if (!string2.equals(zzgn2.zzand)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzajp.zzge().zzim().zzg("Measurement Service called with invalid calling package. appId", zzfg.zzbm(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zze(new zzhf(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzdz zzdz2) {
        this.zzb(zzdz2, false);
        return this.zzajp.zzh(zzdz2);
    }

    @Override
    @BinderThread
    public final void zza(zzed zzed2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzed2));
        Preconditions.checkNotNull((Object)((Object)zzed2.zzaep));
        this.zzb(zzdz2, false);
        zzed zzed3 = new zzed(zzed2);
        new zzed(zzed2).packageName = zzdz2.packageName;
        if (zzed2.zzaep.getValue() == null) {
            this.zze(new zzgp(this, zzed3, zzdz2));
            return;
        }
        this.zze(new zzgq(this, zzed3, zzdz2));
    }

    @Override
    @BinderThread
    public final void zzb(zzed zzed2) {
        Preconditions.checkNotNull((Object)((Object)zzed2));
        Preconditions.checkNotNull((Object)((Object)zzed2.zzaep));
        this.zzc(zzed2.packageName, true);
        zzed zzed3 = new zzed(zzed2);
        if (zzed2.zzaep.getValue() == null) {
            this.zze(new zzgr(this, zzed3));
            return;
        }
        this.zze(new zzgs(this, zzed3));
    }

    @Override
    @BinderThread
    public final List<zzjx> zza(String string, String string2, boolean bl, zzdz zzdz2) {
        this.zzb(zzdz2, false);
        Future<List<zzjz>> future = this.zzajp.zzgd().zzb(new zzgt(this, zzdz2, string, string2));
        try {
            List<zzjz> list = future.get();
            ArrayList<zzjx> arrayList = new ArrayList<zzjx>(list.size());
            for (zzjz zzjz2 : list) {
                if (!bl && zzka.zzci(zzjz2.name)) continue;
                arrayList.add(new zzjx(zzjz2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajp.zzge().zzim().zze("Failed to get user attributes. appId", zzfg.zzbm(zzdz2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzjx> zza(String string, String string2, String string3, boolean bl) {
        this.zzc(string, true);
        Future<List<zzjz>> future = this.zzajp.zzgd().zzb(new zzgu(this, string, string2, string3));
        try {
            List<zzjz> list = future.get();
            ArrayList<zzjx> arrayList = new ArrayList<zzjx>(list.size());
            for (zzjz zzjz2 : list) {
                if (!bl && zzka.zzci(zzjz2.name)) continue;
                arrayList.add(new zzjx(zzjz2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajp.zzge().zzim().zze("Failed to get user attributes. appId", zzfg.zzbm(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzed> zza(String string, String string2, zzdz zzdz2) {
        this.zzb(zzdz2, false);
        Future<List<zzed>> future = this.zzajp.zzgd().zzb(new zzgv(this, zzdz2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajp.zzge().zzim().zzg("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzed> zze(String string, String string2, String string3) {
        this.zzc(string, true);
        Future<List<zzed>> future = this.zzajp.zzgd().zzb(new zzgw(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajp.zzge().zzim().zzg("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final void zzd(zzdz zzdz2) {
        this.zzc(zzdz2.packageName, false);
        this.zze(new zzgx(this, zzdz2));
    }

    @VisibleForTesting
    private final void zze(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (zzew.zzaia.get().booleanValue() && this.zzajp.zzgd().zzjk()) {
            runnable.run();
            return;
        }
        this.zzajp.zzgd().zzc(runnable);
    }

    static /* synthetic */ zzjr zza(zzgn zzgn2) {
        return zzgn2.zzajp;
    }
}

