/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzie;
import com.google.android.gms.internal.measurement.zzig;
import com.google.android.gms.internal.measurement.zzih;
import com.google.android.gms.internal.measurement.zzka;
import java.util.Map;

public final class zzif
extends zzhh {
    @VisibleForTesting
    protected zzie zzaol;
    private volatile zzie zzaom;
    private zzie zzaon;
    private long zzaoo;
    private final Map<Activity, zzie> zzaop = new ArrayMap();
    private zzie zzaoq;
    private String zzaor;

    public zzif(zzgl zzgl2) {
        super(zzgl2);
    }

    @Override
    protected final boolean zzhf() {
        return false;
    }

    @WorkerThread
    public final zzie zzkc() {
        this.zzch();
        ((zzhg)this).zzab();
        return this.zzaol;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        ((zzhg)this).zzgd();
        if (!zzgg.isMainThread()) {
            ((zzhg)this).zzge().zzip().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzaom == null) {
            ((zzhg)this).zzge().zzip().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzaop.get(activity) == null) {
            ((zzhg)this).zzge().zzip().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzif.zzca(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzaom.zzaoi.equals(string2);
        boolean bl2 = zzka.zzs(this.zzaom.zzul, string);
        if (bl && bl2) {
            ((zzhg)this).zzge().zziq().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzhg)this).zzge().zzip().zzg("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzhg)this).zzge().zzip().zzg("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzhg)this).zzge().zzit().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzie zzie2 = new zzie(string, string2, ((zzhg)this).zzgb().zzlb());
        this.zzaop.put(activity, zzie2);
        this.zza(activity, zzie2, true);
    }

    public final zzie zzkd() {
        return this.zzaom;
    }

    @MainThread
    private final void zza(Activity activity, zzie zzie2, boolean bl) {
        zzie zzie3;
        zzie zzie4 = zzie3 = this.zzaom == null ? this.zzaon : this.zzaom;
        if (zzie2.zzaoi == null) {
            zzie2 = new zzie(zzie2.zzul, zzif.zzca(activity.getClass().getCanonicalName()), zzie2.zzaoj);
        }
        zzie zzie5 = zzie2;
        this.zzaon = this.zzaom;
        this.zzaoo = ((zzhg)this).zzbt().elapsedRealtime();
        this.zzaom = zzie5;
        ((zzhg)this).zzgd().zzc(new zzig(this, bl, zzie3, zzie5));
    }

    @WorkerThread
    private final void zza(@NonNull zzie zzie2) {
        ((zzhg)this).zzft().zzk(((zzhg)this).zzbt().elapsedRealtime());
        if (((zzhg)this).zzgc().zzl(zzie2.zzaok)) {
            zzie2.zzaok = false;
        }
    }

    public static void zza(zzie zzie2, Bundle bundle, boolean bl) {
        if (bundle != null && zzie2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzie2.zzul != null) {
                bundle.putString("_sn", zzie2.zzul);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzie2.zzaoi);
            bundle.putLong("_si", zzie2.zzaoj);
            return;
        }
        if (bundle != null && zzie2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzie zzie2) {
        ((zzhg)this).zzab();
        zzif zzif2 = this;
        synchronized (zzif2) {
            if (this.zzaor == null || this.zzaor.equals(string) || zzie2 != null) {
                this.zzaor = string;
                this.zzaoq = zzie2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zzca(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzie zze(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzie zzie2 = this.zzaop.get(activity);
        if (zzie2 == null) {
            String string = zzif.zzca(activity.getClass().getCanonicalName());
            zzie2 = new zzie(null, string, ((zzhg)this).zzgb().zzlb());
            this.zzaop.put(activity, zzie2);
        }
        return zzie2;
    }

    @MainThread
    public final void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.firebase.analytics.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzie zzie2 = new zzie(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzaop.put(activity, zzie2);
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzie zzie2 = this.zze(activity);
        this.zza(activity, zzie2, false);
        zzdu zzdu2 = ((zzhg)this).zzft();
        long l = ((zzhg)zzdu2).zzbt().elapsedRealtime();
        ((zzhg)zzdu2).zzgd().zzc(new zzdx(zzdu2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzie zzie2 = this.zze(activity);
        this.zzaon = this.zzaom;
        this.zzaoo = ((zzhg)this).zzbt().elapsedRealtime();
        this.zzaom = null;
        ((zzhg)this).zzgd().zzc(new zzih(this, zzie2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzie zzie2 = this.zzaop.get(activity);
        if (zzie2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzie2.zzaoj);
        bundle2.putString("name", zzie2.zzul);
        bundle2.putString("referrer_name", zzie2.zzaoi);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzaop.remove(activity);
    }

    static /* synthetic */ void zza(zzif zzif2, zzie zzie2) {
        zzif2.zza(zzie2);
    }
}

