/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzii;
import com.google.android.gms.internal.measurement.zzix;
import com.google.android.gms.internal.measurement.zziy;
import com.google.android.gms.internal.measurement.zziz;
import com.google.android.gms.internal.measurement.zzja;
import com.google.android.gms.internal.measurement.zzjb;

@VisibleForTesting
public final class zziw
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzapk;
    private volatile zzff zzapl;
    final /* synthetic */ zzii zzape;

    protected zziw(zzii zzii2) {
        this.zzape = zzii2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzc(Intent intent) {
        ((zzhg)this.zzape).zzab();
        Context context = ((zzhg)this.zzape).getContext();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zziw zziw2 = this;
        synchronized (zziw2) {
            if (this.zzapk) {
                ((zzhg)this.zzape).zzge().zzit().log("Connection attempt already in progress");
                return;
            }
            ((zzhg)this.zzape).zzge().zzit().log("Using local app measurement service");
            this.zzapk = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzii.zza(this.zzape), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zziw zziw2 = this;
        synchronized (zziw2) {
            String string;
            if (iBinder == null) {
                this.zzapk = false;
                ((zzhg)this.zzape).zzge().zzim().log("Service connected with null binder");
                return;
            }
            zzey zzey2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzey2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzey ? (zzey)iInterface : new zzfa(iBinder2));
                    ((zzhg)this.zzape).zzge().zzit().log("Bound to IMeasurementService interface");
                } else {
                    ((zzhg)this.zzape).zzge().zzim().zzg("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzhg)this.zzape).zzge().zzim().log("Service connect failed to get IMeasurementService");
            }
            if (zzey2 == null) {
                this.zzapk = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzhg)this.zzape).getContext(), (ServiceConnection)zzii.zza(this.zzape));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzey2;
                ((zzhg)this.zzape).zzgd().zzc(new zzix(this, (zzey)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzhg)this.zzape).zzge().zzis().log("Service disconnected");
        ((zzhg)this.zzape).zzgd().zzc(new zziy(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzkh() {
        ((zzhg)this.zzape).zzab();
        Context context = ((zzhg)this.zzape).getContext();
        zziw zziw2 = this;
        synchronized (zziw2) {
            if (this.zzapk) {
                ((zzhg)this.zzape).zzge().zzit().log("Connection attempt already in progress");
                return;
            }
            if (this.zzapl != null) {
                ((zzhg)this.zzape).zzge().zzit().log("Already awaiting connection attempt");
                return;
            }
            this.zzapl = new zzff(context, Looper.getMainLooper(), this, this);
            ((zzhg)this.zzape).zzge().zzit().log("Connecting to remote service");
            this.zzapk = true;
            this.zzapl.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zziw zziw2 = this;
        synchronized (zziw2) {
            try {
                zzey zzey2 = (zzey)this.zzapl.getService();
                this.zzapl = null;
                ((zzhg)this.zzape).zzgd().zzc(new zziz(this, zzey2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzapl = null;
                this.zzapk = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzhg)this.zzape).zzge().zzis().log("Service connection suspended");
        ((zzhg)this.zzape).zzgd().zzc(new zzja(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzfg zzfg2 = this.zzape.zzacw.zzjo();
        if (zzfg2 != null) {
            zzfg2.zzip().zzg("Service connection failed", connectionResult);
        }
        zziw zziw2 = this;
        synchronized (zziw2) {
            this.zzapk = false;
            this.zzapl = null;
        }
        ((zzhg)this.zzape).zzgd().zzc(new zzjb(this));
    }

    static /* synthetic */ boolean zza(zziw zziw2, boolean bl) {
        zziw2.zzapk = false;
        return false;
    }
}

