/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzjc;
import com.google.android.gms.internal.measurement.zzjo;
import com.google.android.gms.internal.measurement.zzjq;
import com.google.android.gms.internal.measurement.zzjr;

public final class zzjn
extends zzjq {
    private final AlarmManager zzyi = (AlarmManager)((zzhg)this).getContext().getSystemService("alarm");
    private final zzem zzapy;
    private Integer zzyj;

    protected zzjn(zzjr zzjr2) {
        super(zzjr2);
        this.zzapy = new zzjo(this, zzjr2.zzla(), zzjr2);
    }

    @Override
    protected final boolean zzhf() {
        this.zzyi.cancel(this.zzek());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzkl();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzkl() {
        JobScheduler jobScheduler = (JobScheduler)((zzhg)this).getContext().getSystemService("jobscheduler");
        ((zzhg)this).zzge().zzit().zzg("Cancelling job. JobID", this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzh(long l) {
        this.zzch();
        if (!zzgb.zza(((zzhg)this).getContext())) {
            ((zzhg)this).zzge().zzis().log("Receiver not registered/enabled");
        }
        if (!zzjc.zza(((zzhg)this).getContext(), false)) {
            ((zzhg)this).zzge().zzis().log("Service not registered/enabled");
        }
        this.cancel();
        long l2 = ((zzhg)this).zzbt().elapsedRealtime() + l;
        if (l < Math.max(0L, zzew.zzahf.get()) && !this.zzapy.zzef()) {
            ((zzhg)this).zzge().zzit().log("Scheduling upload with DelayedRunnable");
            this.zzapy.zzh(l);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            ((zzhg)this).zzge().zzit().log("Scheduling upload with JobScheduler");
            long l3 = l;
            zzjn zzjn2 = this;
            ComponentName componentName = new ComponentName(((zzhg)zzjn2).getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)((zzhg)zzjn2).getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzjn2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            ((zzhg)zzjn2).zzge().zzit().zzg("Scheduling job. JobID", zzjn2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        ((zzhg)this).zzge().zzit().log("Scheduling upload with AlarmManager");
        this.zzyi.setInexactRepeating(2, l2, Math.max(zzew.zzaha.get(), l), this.zzek());
    }

    private final int getJobId() {
        if (this.zzyj == null) {
            String string = String.valueOf(((zzhg)this).getContext().getPackageName());
            this.zzyj = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzyj;
    }

    public final void cancel() {
        this.zzch();
        this.zzyi.cancel(this.zzek());
        this.zzapy.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzkl();
        }
    }

    private final PendingIntent zzek() {
        Intent intent = new Intent().setClassName(((zzhg)this).getContext(), "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)((zzhg)this).getContext(), (int)0, (Intent)intent, (int)0);
    }
}

