/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzabv;
import com.google.android.gms.internal.measurement.zzabw;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzjn;
import com.google.android.gms.internal.measurement.zzjq;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzju;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.internal.measurement.zzjw;
import com.google.android.gms.internal.measurement.zzjx;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkk;
import com.google.android.gms.internal.measurement.zzkm;
import com.google.android.gms.internal.measurement.zzkn;
import com.google.android.gms.internal.measurement.zzko;
import com.google.android.gms.internal.measurement.zzkp;
import com.google.android.gms.internal.measurement.zzkq;
import com.google.android.gms.internal.measurement.zzks;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzjr
implements zzec {
    zzgf zzaqa;
    zzfk zzaqb;
    private zzei zzaqc;
    private zzfp zzaqd;
    private zzjn zzaqe;
    private zzeb zzaqf;
    private zzgl zzacw;
    private boolean zzvo = false;
    private boolean zzaqg;
    @VisibleForTesting
    private long zzaqh;
    private List<Runnable> zzaqi;
    private int zzaqj;
    private int zzaqk;
    private boolean zzaql;
    private boolean zzaqm;
    private boolean zzaqn;
    private FileLock zzaqo;
    private FileChannel zzaqp;
    private List<Long> zzaqq;
    private List<Long> zzaqr;
    long zzaqs;

    final void zza(zzgl zzgl2) {
        this.zzacw = zzgl2;
    }

    @WorkerThread
    final void zza(zzjw zzjw2) {
        this.zzab();
        zzgl zzgl2 = this.zzacw;
        zzei zzei2 = new zzei((zzjr)zzgl2);
        zzei2.zzm();
        this.zzaqc = zzei2;
        this.zzgg().zza(this.zzaqa);
        zzgl2 = this.zzacw;
        zzeb zzeb2 = new zzeb((zzjr)zzgl2);
        zzeb2.zzm();
        this.zzaqf = zzeb2;
        zzgl2 = this.zzacw;
        zzjn zzjn2 = new zzjn((zzjr)zzgl2);
        zzjn2.zzm();
        this.zzaqe = zzjn2;
        zzgl2 = this.zzacw;
        this.zzaqd = new zzfp(zzgl2);
        if (this.zzaqj != this.zzaqk) {
            this.zzge().zzim().zze("Not all upload components initialized", this.zzaqj, this.zzaqk);
        }
        this.zzvo = true;
    }

    @WorkerThread
    protected void start() {
        this.zzab();
        this.zzix().zzhp();
        if (this.zzgf().zzaju.get() == 0L) {
            this.zzgf().zzaju.set(this.zzbt().currentTimeMillis());
        }
        this.zzku();
    }

    public zzef zzgg() {
        return ((zzjr)this.zzacw).zzgg();
    }

    public zzfr zzgf() {
        return ((zzjr)this.zzacw).zzgf();
    }

    @Override
    public zzfg zzge() {
        return ((zzjr)this.zzacw).zzge();
    }

    @Override
    public zzgg zzgd() {
        return ((zzjr)this.zzacw).zzgd();
    }

    private final zzgf zzkm() {
        zzjr.zza(this.zzaqa);
        return this.zzaqa;
    }

    public final zzfk zzkn() {
        zzjr.zza(this.zzaqb);
        return this.zzaqb;
    }

    public final zzei zzix() {
        zzjr.zza(this.zzaqc);
        return this.zzaqc;
    }

    private final zzfp zzko() {
        if (this.zzaqd == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzaqd;
    }

    private final zzjn zzkp() {
        zzjr.zza(this.zzaqe);
        return this.zzaqe;
    }

    public final zzeb zziw() {
        zzjr.zza(this.zzaqf);
        return this.zzaqf;
    }

    public zzfe zzga() {
        return ((zzjr)this.zzacw).zzga();
    }

    @Override
    public Context getContext() {
        return ((zzjr)this.zzacw).getContext();
    }

    @Override
    public Clock zzbt() {
        return ((zzjr)this.zzacw).zzbt();
    }

    public zzka zzgb() {
        return ((zzjr)this.zzacw).zzgb();
    }

    public zzeo zzfw() {
        return ((zzjr)this.zzacw).zzfw();
    }

    @WorkerThread
    public void zzab() {
        ((zzhg)this.zzgd()).zzab();
    }

    final void zzkq() {
        if (!this.zzvo) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zza(zzjq zzjq2) {
        if (zzjq2 == null) {
            throw new IllegalStateException("Upload component not created");
        }
        if (!zzjq2.isInitialized()) {
            String string = String.valueOf(zzjq2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    final void zze(zzdz zzdz2) {
        this.zzab();
        this.zzkq();
        Preconditions.checkNotEmpty((String)zzdz2.packageName);
        this.zzg(zzdz2);
    }

    private final long zzkr() {
        long l = this.zzbt().currentTimeMillis();
        zzfr zzfr2 = this.zzgf();
        zzfr2.zzch();
        zzfr2.zzab();
        long l2 = zzfr2.zzajy.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzfr2.zzgb().zzlc().nextInt(86400000);
            zzfr2.zzajy.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zzc(zzeu zzeu2, String string) {
        zzdy zzdy2 = this.zzix().zzbc(string);
        if (zzdy2 == null || TextUtils.isEmpty((CharSequence)zzdy2.zzag())) {
            this.zzge().zzis().zzg("No app data available; dropping event", string);
            return;
        }
        Boolean bl = this.zzc(zzdy2);
        if (bl == null) {
            if (!"_ui".equals(zzeu2.name)) {
                this.zzge().zzip().zzg("Could not find package. appId", zzfg.zzbm(string));
            }
        } else if (!bl.booleanValue()) {
            this.zzge().zzim().zzg("App version does not match; dropping event. appId", zzfg.zzbm(string));
            return;
        }
        zzdz zzdz2 = new zzdz(string, zzdy2.getGmpAppId(), zzdy2.zzag(), zzdy2.zzgm(), zzdy2.zzgn(), zzdy2.zzgo(), zzdy2.zzgp(), null, zzdy2.isMeasurementEnabled(), false, zzdy2.zzgj(), zzdy2.zzhc(), 0L, 0, zzdy2.zzhd(), zzdy2.zzhe(), false);
        this.zzb(zzeu2, zzdz2);
    }

    @WorkerThread
    final void zzb(zzeu zzeu2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzdz2));
        Preconditions.checkNotEmpty((String)zzdz2.packageName);
        this.zzab();
        this.zzkq();
        String string = zzdz2.packageName;
        long l = zzeu2.zzagb;
        this.zzgb();
        if (!zzka.zzd(zzeu2, zzdz2)) {
            return;
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        this.zzix().beginTransaction();
        try {
            AbstractSafeParcelable abstractSafeParcelable;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzei zzei2 = this.zzix();
            Preconditions.checkNotEmpty((String)string3);
            zzei2.zzab();
            zzei2.zzch();
            if (l2 < 0L) {
                zzei2.zzge().zzip().zze("Invalid time querying timed out conditional properties", zzfg.zzbm(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzei2.zzb(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzge().zzis().zzd("User property timed out", object22.packageName, this.zzga().zzbl(object22.zzaep.name), object22.zzaep.getValue());
                if (object22.zzaeq != null) {
                    this.zzc(new zzeu(object22.zzaeq, l), zzdz2);
                }
                this.zzix().zzj(string, object22.zzaep.name);
            }
            l2 = l;
            string3 = string;
            zzei2 = this.zzix();
            Preconditions.checkNotEmpty((String)string3);
            zzei2.zzab();
            zzei2.zzch();
            if (l2 < 0L) {
                zzei2.zzge().zzip().zze("Invalid time querying expired conditional properties", zzfg.zzbm(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzei2.zzb(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzed)((Object)object4.next());
                if (object == null) continue;
                this.zzge().zzis().zzd("User property expired", object.packageName, this.zzga().zzbl(object.zzaep.name), object.zzaep.getValue());
                this.zzix().zzg(string, object.zzaep.name);
                if (object.zzaes != null) {
                    object22.add(object.zzaes);
                }
                this.zzix().zzj(string, object.zzaep.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzeu)((Object)e);
                this.zzc(new zzeu((zzeu)((Object)object), l), zzdz2);
            }
            long l3 = l;
            String string4 = zzeu2.name;
            string3 = string;
            zzei2 = this.zzix();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzei2.zzab();
            zzei2.zzch();
            if (l3 < 0L) {
                zzei2.zzge().zzip().zzd("Invalid time querying triggered conditional properties", zzfg.zzbm(string3), zzei2.zzga().zzbj(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzei2.zzb((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                abstractSafeParcelable = (zzed)((Object)iterator.next());
                if (abstractSafeParcelable == null) continue;
                zzjx zzjx2 = abstractSafeParcelable.zzaep;
                zzjz zzjz2 = new zzjz(abstractSafeParcelable.packageName, abstractSafeParcelable.origin, zzjx2.name, l, zzjx2.getValue());
                if (this.zzix().zza(zzjz2)) {
                    this.zzge().zzis().zzd("User property triggered", abstractSafeParcelable.packageName, this.zzga().zzbl(zzjz2.name), zzjz2.value);
                } else {
                    this.zzge().zzim().zzd("Too many active user properties, ignoring", zzfg.zzbm(abstractSafeParcelable.packageName), this.zzga().zzbl(zzjz2.name), zzjz2.value);
                }
                if (abstractSafeParcelable.zzaer != null) {
                    object.add(abstractSafeParcelable.zzaer);
                }
                abstractSafeParcelable.zzaep = new zzjx(zzjz2);
                abstractSafeParcelable.active = true;
                this.zzix().zza((zzed)abstractSafeParcelable);
            }
            this.zzc(zzeu2, zzdz2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                abstractSafeParcelable = (zzeu)((Object)e);
                this.zzc(new zzeu((zzeu)abstractSafeParcelable, l), zzdz2);
            }
            this.zzix().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzix().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzc(zzeu var1_1, zzdz var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzab();
        this.zzkq();
        var5_4 = var2_2.packageName;
        this.zzgb();
        if (!zzka.zzd(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzadw) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzkm().zzn(var5_4, var1_1.name)) {
            this.zzge().zzip().zze("Dropping blacklisted event. appId", zzfg.zzbm(var5_4), this.zzga().zzbj(var1_1.name));
            var6_5 = this.zzkm().zzby(var5_4) != false || this.zzkm().zzbz(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzgb().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzix().zzbc(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzgs(), var7_7.zzgr());
                if (Math.abs(this.zzbt().currentTimeMillis() - var8_9) > zzew.zzahh.get()) {
                    this.zzge().zzis().log("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzge().isLoggable(2)) {
            this.zzge().zzit().zzg("Logging event", this.zzga().zzb(var1_1));
        }
        this.zzix().beginTransaction();
        try {
            block45: {
                block46: {
                    this.zzg(var2_2);
                    if (("_iap".equals(var1_1.name) || "ecommerce_purchase".equals(var1_1.name)) && !this.zza(var5_4, var1_1)) {
                        this.zzix().setTransactionSuccessful();
                        return;
                    }
                    var6_6 = zzka.zzcc(var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzix().zza(this.zzkr(), var5_4, true, var6_6, false, var7_8, false);
                    var9_11 = var8_10.zzafe - (long)zzew.zzags.get().intValue();
                    if (var9_11 > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzge().zzim().zze("Data loss. Too many events logged. appId, count", zzfg.zzbm(var5_4), var8_10.zzafe);
                        }
                        this.zzix().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_11 = var8_10.zzafd - (long)zzew.zzagu.get().intValue()) > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzge().zzim().zze("Data loss. Too many public events logged. appId, count", zzfg.zzbm(var5_4), var8_10.zzafd);
                        }
                        this.zzgb().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzix().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_12 = var2_2.packageName;
                        var20_13 = this.zzgg().zzb((String)var19_12, zzew.zzagt);
                        var9_11 = var8_10.zzafg - (long)Math.max(0, var20_13 = Math.min(1000000, var20_13));
                        if (var9_11 > 0L) {
                            if (var9_11 == 1L) {
                                this.zzge().zzim().zze("Too many error events logged. appId, count", zzfg.zzbm(var5_4), var8_10.zzafg);
                            }
                            this.zzix().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_15 = var1_1.zzafq.zzif();
                    this.zzgb().zza(var11_15, "_o", (Object)var1_1.origin);
                    if (this.zzgb().zzcj(var5_4)) {
                        this.zzgb().zza(var11_15, "_dbg", 1L);
                        this.zzgb().zza(var11_15, "_r", 1L);
                    }
                    if ((var12_16 = this.zzix().zzbd(var5_4)) > 0L) {
                        this.zzge().zzip().zze("Data lost. Too many events stored on disk, deleted. appId", zzfg.zzbm(var5_4), var12_16);
                    }
                    var14_17 = new zzep(this.zzacw, var1_1.origin, var5_4, var1_1.name, var1_1.zzagb, 0L, var11_15);
                    var15_18 = this.zzix().zzf(var5_4, var14_17.name);
                    if (var15_18 == null) {
                        if (this.zzix().zzbg(var5_4) >= 500L && var6_6) {
                            this.zzge().zzim().zzd("Too many event names used, ignoring event. appId, name, supported count", zzfg.zzbm(var5_4), this.zzga().zzbj(var14_17.name), 500);
                            this.zzgb().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_19 = new zzeq(var5_4, var14_17.name, 0L, 0L, var14_17.timestamp, 0L, null, null, null);
                    } else {
                        var14_17 = var14_17.zza(this.zzacw, var15_18.zzaft);
                        var16_19 = var15_18.zzac(var14_17.timestamp);
                    }
                    this.zzix().zza(var16_19);
                    var20_14 = var2_2;
                    var19_12 = var14_17;
                    var18_20 = this;
                    var18_20.zzab();
                    var18_20.zzkq();
                    Preconditions.checkNotNull((Object)var19_12);
                    Preconditions.checkNotNull((Object)var20_14);
                    Preconditions.checkNotEmpty((String)var19_12.zzti);
                    Preconditions.checkArgument((boolean)var19_12.zzti.equals(var20_14.packageName));
                    var21_21 = new zzkq();
                    new zzkq().zzath = 1;
                    var21_21.zzatp = "android";
                    var21_21.zzti = var20_14.packageName;
                    var21_21.zzadt = var20_14.zzadt;
                    var21_21.zzth = var20_14.zzth;
                    var21_21.zzaub = var20_14.zzads == -2147483648L ? null : Integer.valueOf((int)var20_14.zzads);
                    var21_21.zzatt = var20_14.zzadu;
                    var21_21.zzadm = var20_14.zzadm;
                    var21_21.zzatx = var20_14.zzadv == 0L ? null : Long.valueOf(var20_14.zzadv);
                    var22_22 = var18_20.zzgf().zzbo(var20_14.packageName);
                    if (var22_22 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_22.first))) {
                        if (var20_14.zzady) {
                            var21_21.zzatv = (String)var22_22.first;
                            var21_21.zzatw = (Boolean)var22_22.second;
                        }
                    } else if (!var18_20.zzfw().zzf(var18_20.getContext()) && var20_14.zzadz) {
                        var23_23 = Settings.Secure.getString((ContentResolver)var18_20.getContext().getContentResolver(), (String)"android_id");
                        if (var23_23 == null) {
                            var18_20.zzge().zzip().zzg("null secure ID. appId", zzfg.zzbm(var21_21.zzti));
                            var23_23 = "null";
                        } else if (var23_23.isEmpty()) {
                            var18_20.zzge().zzip().zzg("empty secure ID. appId", zzfg.zzbm(var21_21.zzti));
                        }
                        var21_21.zzaue = var23_23;
                    }
                    var18_20.zzfw().zzch();
                    var21_21.zzatr = Build.MODEL;
                    var18_20.zzfw().zzch();
                    var21_21.zzatq = Build.VERSION.RELEASE;
                    var21_21.zzats = (int)var18_20.zzfw().zzic();
                    var21_21.zzafn = var18_20.zzfw().zzid();
                    var21_21.zzatu = null;
                    var21_21.zzatk = null;
                    var21_21.zzatl = null;
                    var21_21.zzatm = null;
                    var21_21.zzaug = var20_14.zzadx;
                    if (var18_20.zzacw.isEnabled() && zzef.zzhk()) {
                        var21_21.zzauh = null;
                    }
                    if ((var23_23 = var18_20.zzix().zzbc(var20_14.packageName)) == null) {
                        var23_23 = new zzdy(var18_20.zzacw, var20_14.packageName);
                        var23_23.zzal(var18_20.zzacw.zzfv().zzii());
                        var23_23.zzao(var20_14.zzado);
                        var23_23.zzam(var20_14.zzadm);
                        var23_23.zzan(var18_20.zzgf().zzbp(var20_14.packageName));
                        var23_23.zzr(0L);
                        var23_23.zzm(0L);
                        var23_23.zzn(0L);
                        var23_23.setAppVersion(var20_14.zzth);
                        var23_23.zzo(var20_14.zzads);
                        var23_23.zzap(var20_14.zzadt);
                        var23_23.zzp(var20_14.zzadu);
                        var23_23.zzq(var20_14.zzadv);
                        var23_23.setMeasurementEnabled(var20_14.zzadw);
                        var23_23.zzaa(var20_14.zzadx);
                        var18_20.zzix().zza((zzdy)var23_23);
                    }
                    var21_21.zzadl = var23_23.getAppInstanceId();
                    var21_21.zzado = var23_23.zzgj();
                    var24_24 = var18_20.zzix().zzbb(var20_14.packageName);
                    var21_21.zzatj = new zzks[var24_24.size()];
                    for (var25_25 = 0; var25_25 < var24_24.size(); ++var25_25) {
                        var21_21.zzatj[var25_25] = var26_27 = new zzks();
                        var26_27.name = var24_24.get((int)var25_25).name;
                        var26_27.zzaun = var24_24.get((int)var25_25).zzaqz;
                        var18_20.zzgb().zza(var26_27, var24_24.get((int)var25_25).value);
                    }
                    try {
                        var25_26 = var18_20.zzix().zza(var21_21);
                    }
                    catch (IOException var27_28) {
                        var18_20.zzge().zzim().zze("Data loss. Failed to insert raw event metadata. appId", zzfg.zzbm(var21_21.zzti), var27_28);
                        break block45;
                    }
                    v0 = var18_20.zzix();
                    var29_29 = var19_12;
                    var28_30 = var18_20;
                    if (var29_29.zzafq == null) ** GOTO lbl-1000
                    for (Object var31_33 : var29_29.zzafq) {
                        if (!"_r".equals(var31_33)) continue;
                        v1 = true;
                        break block46;
                    }
                    var30_32 = var28_30.zzkm().zzo(var29_29.zzti, var29_29.name);
                    var31_33 = var28_30.zzix().zza(var28_30.zzkr(), var29_29.zzti, false, false, false, false, false);
                    if (var30_32 && var31_33.zzafh < (long)var28_30.zzgg().zzar(var29_29.zzti)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                }
                if (v0.zza((zzep)var19_12, var25_26, v1)) {
                    var18_20.zzaqh = 0L;
                }
            }
            this.zzix().setTransactionSuccessful();
            if (this.zzge().isLoggable(2)) {
                this.zzge().zzit().zzg("Event recorded", this.zzga().zza(var14_17));
            }
        }
        finally {
            this.zzix().endTransaction();
        }
        this.zzku();
        this.zzge().zzit().zzg("Background event processing time, ms", (System.nanoTime() - var3_3 + 500000L) / 1000000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zza(String string, zzeu zzeu2) {
        long l;
        String string2;
        block10: {
            string2 = zzeu2.zzafq.getString("currency");
            if ("ecommerce_purchase".equals(zzeu2.name)) {
                double d = zzeu2.zzafq.zzbh("value") * 1000000.0;
                if (d == 0.0) {
                    d = (double)zzeu2.zzafq.getLong("value").longValue() * 1000000.0;
                }
                if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                    l = Math.round(d);
                    break block10;
                } else {
                    this.zzge().zzip().zze("Data lost. Currency value is too big. appId", zzfg.zzbm(string), d);
                    return false;
                }
            }
            l = zzeu2.zzafq.getLong("value");
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
            String string3 = String.valueOf("_ltv_");
            String string4 = String.valueOf(string2);
            String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            zzjz zzjz2 = this.zzix().zzh(string, string5);
            if (zzjz2 == null || !(zzjz2.value instanceof Long)) {
                String string6 = string;
                int n = this.zzgg().zzb(string6, zzew.zzahm) - 1;
                string6 = string;
                zzei zzei2 = this.zzix();
                Preconditions.checkNotEmpty((String)string6);
                zzei2.zzab();
                zzei2.zzch();
                try {
                    zzei2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string6, string6, String.valueOf(n)});
                }
                catch (SQLiteException sQLiteException) {
                    zzei2.zzge().zzim().zze("Error pruning currencies. appId", zzfg.zzbm(string6), (Object)sQLiteException);
                }
                zzjz2 = new zzjz(string, zzeu2.origin, string5, this.zzbt().currentTimeMillis(), l);
            } else {
                long l2 = (Long)zzjz2.value;
                zzjz2 = new zzjz(string, zzeu2.origin, string5, this.zzbt().currentTimeMillis(), l2 + l);
            }
            if (!this.zzix().zza(zzjz2)) {
                this.zzge().zzim().zzd("Too many unique user properties are set. Ignoring user property. appId", zzfg.zzbm(string), this.zzga().zzbl(zzjz2.name), zzjz2.value);
                this.zzgb().zza(string, 9, null, null, 0);
            }
        }
        return true;
    }

    @WorkerThread
    public final void zzks() {
        this.zzab();
        this.zzkq();
        this.zzaqn = true;
        try {
            String string;
            Boolean bl = this.zzacw.zzfx().zzkf();
            if (bl == null) {
                this.zzge().zzip().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzge().zzim().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzaqh > 0L) {
                this.zzku();
                return;
            }
            zzec zzec2 = this;
            ((zzjr)zzec2).zzab();
            if (((zzjr)zzec2).zzaqq != null) {
                this.zzge().zzit().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzkn().zzex()) {
                this.zzge().zzit().log("Network not connected, ignoring upload request");
                this.zzku();
                return;
            }
            long l = this.zzbt().currentTimeMillis();
            long l2 = l - zzef.zzhi();
            this.zzd(null, l2);
            long l3 = this.zzgf().zzaju.get();
            if (l3 != 0L) {
                this.zzge().zzis().zzg("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzix().zzhn()))) {
                if (this.zzaqs == -1L) {
                    this.zzaqs = this.zzix().zzhu();
                }
                Object object = string;
                int n = this.zzgg().zzb((String)object, zzew.zzago);
                object = string;
                zzec2 = this.zzgg();
                int n2 = Math.max(0, ((zzef)zzec2).zzb((String)object, zzew.zzagp));
                List<Pair<zzkq, Long>> list = this.zzix().zzb(string, n, n2);
                if (!list.isEmpty()) {
                    Object object2;
                    String string2 = null;
                    Object object3 = list.iterator();
                    while (object3.hasNext()) {
                        zzkq zzkq2 = (zzkq)((Object)object3.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzkq2.zzatv)) continue;
                        string2 = zzkq2.zzatv;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object2 = (zzkq)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzkq)((Object)object2)).zzatv) || ((zzkq)((Object)object2)).zzatv.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object3 = new zzkp();
                    new zzkp().zzatf = new zzkq[list.size()];
                    object2 = new ArrayList(list.size());
                    boolean bl2 = zzef.zzhk() && this.zzgg().zzat(string);
                    for (int i = 0; i < ((zzkp)((Object)object3)).zzatf.length; ++i) {
                        ((zzkp)((Object)object3)).zzatf[i] = (zzkq)((Object)list.get((int)i).first);
                        object2.add((Long)list.get((int)i).second);
                        ((zzkp)((Object)object3)).zzatf[i].zzatu = 12451L;
                        ((zzkp)((Object)object3)).zzatf[i].zzatk = l;
                        ((zzkp)((Object)object3)).zzatf[i].zzatz = false;
                        if (bl2) continue;
                        ((zzkp)((Object)object3)).zzatf[i].zzauh = null;
                    }
                    String string3 = null;
                    if (this.zzge().isLoggable(2)) {
                        string3 = this.zzga().zza((zzkp)((Object)object3));
                    }
                    byte[] byArray = this.zzgb().zzb((zzkp)((Object)object3));
                    String string4 = zzew.zzagy.get();
                    try {
                        URL uRL = new URL(string4);
                        object = object2;
                        zzec2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (((zzjr)zzec2).zzaqq != null) {
                            ((zzjr)zzec2).zzge().zzim().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzjr)zzec2).zzaqq = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzgf().zzajv.set(l);
                        String string5 = "?";
                        if (((zzkp)((Object)object3)).zzatf.length > 0) {
                            string5 = ((zzkp)((Object)object3)).zzatf[0].zzti;
                        }
                        this.zzge().zzit().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzaqm = true;
                        zzjs zzjs2 = new zzjs(this, string);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object = string;
                        zzec2 = this.zzkn();
                        ((zzhg)zzec2).zzab();
                        ((zzjq)zzec2).zzch();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)byArray2);
                        Preconditions.checkNotNull((Object)zzjs2);
                        ((zzhg)zzec2).zzgd().zzd(new zzfo((zzfk)zzec2, (String)object, uRL2, byArray2, null, zzjs2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzge().zzim().zze("Failed to parse upload URL. Not uploading. appId", zzfg.zzbm(string), string4);
                    }
                }
            } else {
                zzdy zzdy2;
                this.zzaqs = -1L;
                String string6 = this.zzix().zzab(l - zzef.zzhi());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzdy2 = this.zzix().zzbc(string6)) != null) {
                    this.zzb(zzdy2);
                }
            }
            return;
        }
        finally {
            this.zzaqn = false;
            this.zzkv();
        }
    }

    @WorkerThread
    private final boolean zzd(String string, long l) {
        this.zzix().beginTransaction();
        try {
            block101: {
                zzko[] zzkoArray;
                Object object;
                int n2;
                int n3;
                Object object2;
                Object object3;
                Object object4;
                zzjv zzjv2;
                block99: {
                    zzjv zzjv3 = zzjv2 = new zzjv(this, null);
                    long l2 = this.zzaqs;
                    long l3 = l;
                    object4 = null;
                    object3 = this.zzix();
                    Preconditions.checkNotNull((Object)zzjv3);
                    ((zzhg)object3).zzab();
                    ((zzjq)object3).zzch();
                    object2 = null;
                    try {
                        String[] stringArray;
                        String string2;
                        String string3;
                        String string4;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzei)object3).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string4 = l2 != -1L ? "rowid <= ? and " : "";
                            object2 = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!object2.moveToFirst()) break block99;
                            object4 = object2.getString(0);
                            string3 = object2.getString(1);
                            object2.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string4 = l2 != -1L ? " and rowid <= ?" : "";
                            object2 = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string4).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!object2.moveToFirst()) break block99;
                            string3 = object2.getString(0);
                            object2.close();
                        }
                        object2 = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{object4, string3}, null, null, "rowid", "2");
                        if (!object2.moveToFirst()) {
                            ((zzhg)object3).zzge().zzim().zzg("Raw event metadata record is missing. appId", zzfg.zzbm((String)object4));
                            break block99;
                        }
                        byte[] byArray = object2.getBlob(0);
                        string4 = zzabv.zza((byte[])byArray, (int)0, (int)byArray.length);
                        zzkq zzkq2 = new zzkq();
                        try {
                            zzkq2.zzb((zzabv)string4);
                        }
                        catch (IOException iOException) {
                            ((zzhg)object3).zzge().zzim().zze("Data loss. Failed to merge raw event metadata. appId", zzfg.zzbm((String)object4), iOException);
                            if (object2 != null) {
                                object2.close();
                            }
                            break block99;
                        }
                        if (object2.moveToNext()) {
                            ((zzhg)object3).zzge().zzip().zzg("Get multiple raw event metadata records, expected one. appId", zzfg.zzbm((String)object4));
                        }
                        object2.close();
                        zzjv3.zzb(zzkq2);
                        if (l2 != -1L) {
                            string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{object4, string3, String.valueOf(l2)};
                        } else {
                            string2 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{object4, string3};
                        }
                        object2 = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
                        if (!object2.moveToFirst()) {
                            ((zzhg)object3).zzge().zzip().zzg("Raw event data disappeared while in transaction. appId", zzfg.zzbm((String)object4));
                            break block99;
                        }
                        do {
                            long l4 = object2.getLong(0);
                            byArray = object2.getBlob(3);
                            string4 = zzabv.zza((byte[])byArray, (int)0, (int)byArray.length);
                            zzkn zzkn2 = new zzkn();
                            try {
                                zzkn2.zzb((zzabv)string4);
                            }
                            catch (IOException iOException) {
                                ((zzhg)object3).zzge().zzim().zze("Data loss. Failed to merge raw event. appId", zzfg.zzbm((String)object4), iOException);
                                continue;
                            }
                            zzkn2.name = object2.getString(1);
                            zzkn2.zzatb = object2.getLong(2);
                            if (!zzjv3.zza(l4, zzkn2)) break;
                        } while (object2.moveToNext());
                    }
                    catch (SQLiteException sQLiteException) {
                        ((zzhg)object3).zzge().zzim().zze("Data loss. Error selecting raw event. appId", zzfg.zzbm(object4), (Object)sQLiteException);
                    }
                    finally {
                        if (object2 != null) {
                            object2.close();
                        }
                    }
                }
                object3 = zzjv2;
                if (((zzjv)object3).zzaqx == null || ((zzjv)object3).zzaqx.isEmpty()) break block101;
                boolean bl = false;
                zzkq zzkq3 = zzjv2.zzaqv;
                zzjv2.zzaqv.zzati = new zzkn[zzjv2.zzaqx.size()];
                int n4 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzgg().zzav(zzkq3.zzti);
                for (n3 = 0; n3 < zzjv2.zzaqx.size(); ++n3) {
                    zzkn zzkn3;
                    block103: {
                        int zzkoArray3;
                        boolean bl3;
                        block102: {
                            bl3 = bl;
                            zzkn3 = zzjv2.zzaqx.get(n3);
                            if (this.zzkm().zzn(zzjv2.zzaqv.zzti, zzkn3.name)) {
                                this.zzge().zzip().zze("Dropping blacklisted raw event. appId", zzfg.zzbm(zzjv2.zzaqv.zzti), this.zzga().zzbj(zzkn3.name));
                                if (this.zzkm().zzby(zzjv2.zzaqv.zzti) || this.zzkm().zzbz(zzjv2.zzaqv.zzti) || "_err".equals(zzkn3.name)) continue;
                                this.zzgb().zza(zzjv2.zzaqv.zzti, 11, "_ev", zzkn3.name, 0);
                                continue;
                            }
                            n2 = this.zzkm().zzo(zzjv2.zzaqv.zzti, zzkn3.name);
                            if (n2 != 0) break block102;
                            this.zzgb();
                            if (!zzka.zzcl(zzkn3.name)) break block103;
                        }
                        boolean bl4 = false;
                        boolean n = false;
                        if (zzkn3.zzata == null) {
                            zzkn3.zzata = new zzko[0];
                        }
                        zzko[] i = zzkn3.zzata;
                        int zzko2 = zzkn3.zzata.length;
                        for (zzkoArray3 = 0; zzkoArray3 < zzko2; ++zzkoArray3) {
                            object = i[zzkoArray3];
                            if ("_c".equals(((zzko)((Object)object)).name)) {
                                ((zzko)((Object)object)).zzate = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(((zzko)((Object)object)).name)) continue;
                            ((zzko)((Object)object)).zzate = 1L;
                            n = true;
                        }
                        if (!bl4 && n2 != 0) {
                            this.zzge().zzit().zzg("Marking event as conversion", this.zzga().zzbj(zzkn3.name));
                            i = Arrays.copyOf(zzkn3.zzata, zzkn3.zzata.length + 1);
                            zzko zzko3 = new zzko();
                            new zzko().name = "_c";
                            zzko3.zzate = 1L;
                            i[i.length - 1] = zzko3;
                            zzkn3.zzata = i;
                        }
                        if (!n) {
                            this.zzge().zzit().zzg("Marking event as real-time", this.zzga().zzbj(zzkn3.name));
                            i = Arrays.copyOf(zzkn3.zzata, zzkn3.zzata.length + 1);
                            zzko zzkn4 = new zzko();
                            new zzko().name = "_r";
                            zzkn4.zzate = 1L;
                            i[i.length - 1] = zzkn4;
                            zzkn3.zzata = i;
                        }
                        bl = true;
                        if (this.zzix().zza((long)this.zzkr(), (String)zzjv2.zzaqv.zzti, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzafh > (long)this.zzgg().zzar(zzjv2.zzaqv.zzti)) {
                            for (zzko2 = 0; zzko2 < zzkn3.zzata.length; ++zzko2) {
                                if (!"_r".equals(zzkn3.zzata[zzko2].name)) continue;
                                zzko[] string5 = new zzko[zzkn3.zzata.length - 1];
                                if (zzko2 > 0) {
                                    System.arraycopy(zzkn3.zzata, 0, string5, 0, zzko2);
                                }
                                if (zzko2 < string5.length) {
                                    System.arraycopy(zzkn3.zzata, zzko2 + 1, string5, zzko2, string5.length - zzko2);
                                }
                                zzkn3.zzata = string5;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzka.zzcc(zzkn3.name) && n2 != 0) {
                            object4 = zzjv2.zzaqv.zzti;
                            if (this.zzix().zza((long)this.zzkr(), (String)zzjv2.zzaqv.zzti, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzaff > (long)this.zzgg().zzb((String)object4, zzew.zzagv)) {
                                this.zzge().zzip().zzg("Too many conversions. Not logging as conversion. appId", zzfg.zzbm(zzjv2.zzaqv.zzti));
                                zzkoArray3 = 0;
                                object = null;
                                zzkoArray = zzkn3.zzata;
                                int bl7 = zzkn3.zzata.length;
                                for (int j = 0; j < bl7; ++j) {
                                    zzko zzko3 = zzkoArray[j];
                                    if ("_c".equals(zzko3.name)) {
                                        object = zzko3;
                                        continue;
                                    }
                                    if (!"_err".equals(zzko3.name)) continue;
                                    zzkoArray3 = 1;
                                }
                                if (zzkoArray3 != 0 && object != null) {
                                    zzkn3.zzata = (zzko[])ArrayUtils.removeAll((Object[])zzkn3.zzata, (Object[])new zzko[]{object});
                                } else if (object != null) {
                                    ((zzko)((Object)object)).name = "_err";
                                    ((zzko)((Object)object)).zzate = 10L;
                                } else {
                                    this.zzge().zzim().zzg("Did not find conversion parameter. appId", zzfg.zzbm(zzjv2.zzaqv.zzti));
                                }
                            }
                        }
                    }
                    if (bl2 && "_e".equals(zzkn3.name)) {
                        if (zzkn3.zzata == null || zzkn3.zzata.length == 0) {
                            this.zzge().zzip().zzg("Engagement event does not contain any parameters. appId", zzfg.zzbm(zzjv2.zzaqv.zzti));
                        } else {
                            this.zzgb();
                            Long l6 = (Long)zzka.zzb(zzkn3, "_et");
                            if (l6 == null) {
                                this.zzge().zzip().zzg("Engagement event does not include duration. appId", zzfg.zzbm(zzjv2.zzaqv.zzti));
                            } else {
                                l5 += l6.longValue();
                            }
                        }
                    }
                    zzkq3.zzati[n4++] = zzkn3;
                }
                if (n4 < zzjv2.zzaqx.size()) {
                    zzkq3.zzati = Arrays.copyOf(zzkq3.zzati, n4);
                }
                if (bl2) {
                    zzjz zzjz2 = this.zzix().zzh(zzkq3.zzti, "_lte");
                    zzjz2 = zzjz2 == null || zzjz2.value == null ? new zzjz(zzkq3.zzti, "auto", "_lte", this.zzbt().currentTimeMillis(), l5) : new zzjz(zzkq3.zzti, "auto", "_lte", this.zzbt().currentTimeMillis(), (Long)zzjz2.value + l5);
                    zzks zzks2 = new zzks();
                    new zzks().name = "_lte";
                    zzks2.zzaun = this.zzbt().currentTimeMillis();
                    zzks2.zzate = (Long)zzjz2.value;
                    boolean bl5 = false;
                    for (n2 = 0; n2 < zzkq3.zzatj.length; ++n2) {
                        if (!"_lte".equals(zzkq3.zzatj[n2].name)) continue;
                        zzkq3.zzatj[n2] = zzks2;
                        bl5 = true;
                        break;
                    }
                    if (!bl5) {
                        zzkq3.zzatj = Arrays.copyOf(zzkq3.zzatj, zzkq3.zzatj.length + 1);
                        zzkq3.zzatj[zzjv2.zzaqv.zzatj.length - 1] = zzks2;
                    }
                    if (l5 > 0L) {
                        this.zzix().zza(zzjz2);
                        this.zzge().zzis().zzg("Updated lifetime engagement user property with value. Value", zzjz2.value);
                    }
                }
                zzkq3.zzaua = this.zza(zzkq3.zzti, zzkq3.zzatj, zzkq3.zzati);
                if (this.zzgg().zzau(zzjv2.zzaqv.zzti)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    zzkn[] zzknArray = new zzkn[zzkq3.zzati.length];
                    int n8 = 0;
                    SecureRandom secureRandom = this.zzgb().zzlc();
                    zzkn[] zzknArray2 = zzkq3.zzati;
                    int n = zzkq3.zzati.length;
                    for (int i = 0; i < n; ++i) {
                        boolean bl3;
                        int n5;
                        zzkn zzkn2;
                        block100: {
                            zzkn2 = zzknArray2[i];
                            if (zzkn2.name.equals("_ep")) {
                                this.zzgb();
                                String n9 = (String)zzka.zzb(zzkn2, "_en");
                                object = (zzeq)hashMap.get(n9);
                                if (object == null) {
                                    object = this.zzix().zzf(zzjv2.zzaqv.zzti, n9);
                                    hashMap.put(n9, object);
                                }
                                if (((zzeq)object).zzafv != null) continue;
                                if (((zzeq)object).zzafw > 1L) {
                                    this.zzgb();
                                    zzkn2.zzata = zzka.zza(zzkn2.zzata, "_sr", ((zzeq)object).zzafw);
                                }
                                if (((zzeq)object).zzafx != null && ((zzeq)object).zzafx.booleanValue()) {
                                    this.zzgb();
                                    zzkn2.zzata = zzka.zza(zzkn2.zzata, "_efs", 1L);
                                }
                                zzknArray[n8++] = zzkn2;
                                continue;
                            }
                            n5 = 1;
                            Long l7 = 1L;
                            object4 = "_dbg";
                            object3 = zzkn2;
                            if (TextUtils.isEmpty((CharSequence)object4) || l7 == null) {
                                bl3 = false;
                            } else {
                                zzko[] zzkoArray4 = ((zzkn)((Object)((Object)object3))).zzata;
                                int n6 = ((zzkn)((Object)((Object)object3))).zzata.length;
                                for (int j = 0; j < n6; ++j) {
                                    object2 = zzkoArray4[j];
                                    if (!((String)object4).equals(object2.name)) continue;
                                    bl3 = l7 instanceof Long && ((Object)l7).equals(object2.zzate) || l7 instanceof String && ((Object)l7).equals(object2.zzajf) || l7 instanceof Double && ((Object)l7).equals(object2.zzarc);
                                    break block100;
                                }
                                bl3 = false;
                            }
                        }
                        if (!bl3) {
                            n5 = this.zzkm().zzp(zzjv2.zzaqv.zzti, zzkn2.name);
                        }
                        if (n5 <= 0) {
                            this.zzge().zzip().zze("Sample rate must be positive. event, rate", zzkn2.name, n5);
                            zzknArray[n8++] = zzkn2;
                            continue;
                        }
                        object = (zzeq)hashMap.get(zzkn2.name);
                        if (object == null && (object = this.zzix().zzf(zzjv2.zzaqv.zzti, zzkn2.name)) == null) {
                            this.zzge().zzip().zze("Event being bundled has no eventAggregate. appId, eventName", zzjv2.zzaqv.zzti, zzkn2.name);
                            object = new zzeq(zzjv2.zzaqv.zzti, zzkn2.name, 1L, 1L, zzkn2.zzatb, 0L, null, null, null);
                        }
                        this.zzgb();
                        zzkoArray = (zzko[])zzka.zzb(zzkn2, "_eid");
                        Boolean bl4 = zzkoArray != null;
                        if (n5 == 1) {
                            zzknArray[n8++] = zzkn2;
                            if (!bl4.booleanValue() || ((zzeq)object).zzafv == null && ((zzeq)object).zzafw == null && ((zzeq)object).zzafx == null) continue;
                            object = ((zzeq)object).zza(null, null, null);
                            hashMap.put(zzkn2.name, object);
                            continue;
                        }
                        if (secureRandom.nextInt(n5) == 0) {
                            this.zzgb();
                            zzkn2.zzata = zzka.zza(zzkn2.zzata, "_sr", n5);
                            zzknArray[n8++] = zzkn2;
                            if (bl4.booleanValue()) {
                                object = ((zzeq)object).zza(null, Long.valueOf(n5), null);
                            }
                            hashMap.put(zzkn2.name, ((zzeq)object).zzad(zzkn2.zzatb));
                            continue;
                        }
                        long l2 = ((zzeq)object).zzafu;
                        if (Math.abs(zzkn2.zzatb - l2) >= 86400000L) {
                            this.zzgb();
                            zzkn2.zzata = zzka.zza(zzkn2.zzata, "_efs", 1L);
                            this.zzgb();
                            zzkn2.zzata = zzka.zza(zzkn2.zzata, "_sr", n5);
                            zzknArray[n8++] = zzkn2;
                            if (bl4.booleanValue()) {
                                object = ((zzeq)object).zza(null, Long.valueOf(n5), true);
                            }
                            hashMap.put(zzkn2.name, ((zzeq)object).zzad(zzkn2.zzatb));
                            continue;
                        }
                        if (!bl4.booleanValue()) continue;
                        hashMap.put(zzkn2.name, ((zzeq)object).zza((Long)zzkoArray, null, null));
                    }
                    if (n8 < zzkq3.zzati.length) {
                        zzkq3.zzati = Arrays.copyOf(zzknArray, n8);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.zzix().zza((zzeq)entry.getValue());
                    }
                }
                zzkq3.zzatl = Long.MAX_VALUE;
                zzkq3.zzatm = Long.MIN_VALUE;
                for (n3 = 0; n3 < zzkq3.zzati.length; ++n3) {
                    zzkn zzkn5 = zzkq3.zzati[n3];
                    if (zzkn5.zzatb < zzkq3.zzatl) {
                        zzkq3.zzatl = zzkn5.zzatb;
                    }
                    if (zzkn5.zzatb <= zzkq3.zzatm) continue;
                    zzkq3.zzatm = zzkn5.zzatb;
                }
                String string6 = zzjv2.zzaqv.zzti;
                zzdy zzdy2 = this.zzix().zzbc(string6);
                if (zzdy2 == null) {
                    this.zzge().zzim().zzg("Bundling raw events w/o app info. appId", zzfg.zzbm(zzjv2.zzaqv.zzti));
                } else if (zzkq3.zzati.length > 0) {
                    long l9 = zzdy2.zzgl();
                    zzkq3.zzato = l9 != 0L ? Long.valueOf(l9) : null;
                    long l10 = zzdy2.zzgk();
                    if (l10 == 0L) {
                        l10 = l9;
                    }
                    zzkq3.zzatn = l10 != 0L ? Long.valueOf(l10) : null;
                    zzdy2.zzgt();
                    zzkq3.zzaty = (int)zzdy2.zzgq();
                    zzdy2.zzm(zzkq3.zzatl);
                    zzdy2.zzn(zzkq3.zzatm);
                    zzkq3.zzaek = zzdy2.zzhb();
                    this.zzix().zza(zzdy2);
                }
                if (zzkq3.zzati.length > 0) {
                    zzkk zzkk2 = this.zzkm().zzbu(zzjv2.zzaqv.zzti);
                    if (zzkk2 == null || zzkk2.zzasp == null) {
                        if (TextUtils.isEmpty((CharSequence)zzjv2.zzaqv.zzadm)) {
                            zzkq3.zzauf = -1L;
                        } else {
                            this.zzge().zzip().zzg("Did not find measurement config or missing version info. appId", zzfg.zzbm(zzjv2.zzaqv.zzti));
                        }
                    } else {
                        zzkq3.zzauf = zzkk2.zzasp;
                    }
                    this.zzix().zza(zzkq3, bl);
                }
                object4 = zzjv2.zzaqw;
                object3 = this.zzix();
                Preconditions.checkNotNull((Object)object4);
                ((zzhg)object3).zzab();
                ((zzjq)object3).zzch();
                StringBuilder stringBuilder = new StringBuilder("rowid in (");
                for (int sQLiteException = 0; sQLiteException < object4.size(); ++sQLiteException) {
                    if (sQLiteException != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append((Long)object4.get(sQLiteException));
                }
                stringBuilder.append(")");
                int n11 = ((zzei)object3).getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
                if (n11 != object4.size()) {
                    ((zzhg)object3).zzge().zzim().zze("Deleted fewer rows from raw events table than expected", n11, object4.size());
                }
                object4 = string6;
                object3 = this.zzix();
                stringBuilder = ((zzei)object3).getWritableDatabase();
                try {
                    stringBuilder.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{object4, object4});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzhg)object3).zzge().zzim().zze("Failed to remove unused event metadata. appId", zzfg.zzbm((String)object4), (Object)sQLiteException);
                }
                this.zzix().setTransactionSuccessful();
                return true;
            }
            this.zzix().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzix().endTransaction();
        }
    }

    private final zzkm[] zza(String string, zzks[] zzksArray, zzkn[] zzknArray) {
        Preconditions.checkNotEmpty((String)string);
        return this.zziw().zza(string, zzknArray, zzksArray);
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzab();
        this.zzkq();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzaqq;
            this.zzaqq = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzgf().zzaju.set(this.zzbt().currentTimeMillis());
                    this.zzgf().zzajv.set(0L);
                    this.zzku();
                    this.zzge().zzit().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzix().beginTransaction();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzei zzei2 = this.zzix();
                                zzei2.zzab();
                                zzei2.zzch();
                                SQLiteDatabase sQLiteDatabase = zzei2.getWritableDatabase();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzei2.zzge().zzim().zzg("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzaqr != null && this.zzaqr.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzix().setTransactionSuccessful();
                    }
                    finally {
                        this.zzix().endTransaction();
                    }
                    this.zzaqr = null;
                    if (this.zzkn().zzex() && this.zzkt()) {
                        this.zzks();
                    } else {
                        this.zzaqs = -1L;
                        this.zzku();
                    }
                    this.zzaqh = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzge().zzim().zzg("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzaqh = this.zzbt().elapsedRealtime();
                    this.zzge().zzit().zzg("Disable upload, time", this.zzaqh);
                }
            } else {
                this.zzge().zzit().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzgf().zzajv.set(this.zzbt().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzgf().zzajw.set(this.zzbt().currentTimeMillis());
                }
                if (this.zzgg().zzax(string)) {
                    this.zzix().zzc(list);
                }
                this.zzku();
            }
            return;
        }
        finally {
            this.zzaqm = false;
            this.zzkv();
        }
    }

    private final boolean zzkt() {
        this.zzab();
        this.zzkq();
        return this.zzix().zzhs() || !TextUtils.isEmpty((CharSequence)this.zzix().zzhn());
    }

    @WorkerThread
    private final void zzb(zzdy zzdy2) {
        this.zzab();
        if (TextUtils.isEmpty((CharSequence)zzdy2.getGmpAppId())) {
            this.zzb(zzdy2.zzah(), 204, null, null, null);
            return;
        }
        Object object = zzdy2.getAppInstanceId();
        String string = zzdy2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzew.zzagm.get()).encodedAuthority(zzew.zzagn.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "12451");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzge().zzit().zzg("Fetching remote configuration", zzdy2.zzah());
            zzkk zzkk2 = this.zzkm().zzbu(zzdy2.zzah());
            ArrayMap arrayMap = null;
            String string4 = this.zzkm().zzbv(zzdy2.zzah());
            if (zzkk2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzaql = true;
            zzjt zzjt2 = new zzjt(this);
            builder = arrayMap;
            object = uRL;
            string = zzdy2.zzah();
            zzfk zzfk2 = this.zzkn();
            ((zzhg)zzfk2).zzab();
            zzfk2.zzch();
            Preconditions.checkNotNull((Object)object);
            Preconditions.checkNotNull((Object)zzjt2);
            ((zzhg)zzfk2).zzgd().zzd(new zzfo(zzfk2, string, (URL)object, null, (Map)builder, zzjt2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzge().zzim().zze("Failed to parse config URL. Not fetching. appId", zzfg.zzbm(zzdy2.zzah()), string3);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzab();
        this.zzkq();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzge().zzit().zzg("onConfigFetched. Response size", byArray.length);
            this.zzix().beginTransaction();
            try {
                boolean bl;
                zzdy zzdy2 = this.zzix().zzbc(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzdy2 == null) {
                    this.zzge().zzip().zzg("App does not exist in onConfigFetched. appId", zzfg.zzbm(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzkm().zzbu(string) == null && !this.zzkm().zza(string, null, null) : !this.zzkm().zza(string, byArray, string2)) {
                        return;
                    }
                    zzdy2.zzs(this.zzbt().currentTimeMillis());
                    this.zzix().zza(zzdy2);
                    if (n == 404) {
                        this.zzge().zziq().zzg("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzge().zzit().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzkn().zzex() && this.zzkt()) {
                        this.zzks();
                    } else {
                        this.zzku();
                    }
                } else {
                    zzdy2.zzt(this.zzbt().currentTimeMillis());
                    this.zzix().zza(zzdy2);
                    this.zzge().zzit().zze("Fetching config failed. code, error", n, throwable);
                    this.zzkm().zzbw(string);
                    this.zzgf().zzajv.set(this.zzbt().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzgf().zzajw.set(this.zzbt().currentTimeMillis());
                    }
                    this.zzku();
                }
                this.zzix().setTransactionSuccessful();
            }
            finally {
                this.zzix().endTransaction();
            }
            return;
        }
        finally {
            this.zzaql = false;
            this.zzkv();
        }
    }

    @WorkerThread
    private final void zzku() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzab();
            this.zzkq();
            if (!this.zzky()) {
                return;
            }
            if (this.zzaqh > 0L) {
                l3 = this.zzbt().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzaqh);
                if (l2 > 0L) {
                    this.zzge().zzit().zzg("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzko().unregister();
                    this.zzkp().cancel();
                    return;
                }
                this.zzaqh = 0L;
            }
            if (!this.zzacw.zzjv() || !this.zzkt()) {
                this.zzge().zzit().log("Nothing to upload or uploading impossible");
                this.zzko().unregister();
                this.zzkp().cancel();
                return;
            }
            zzjr zzjr2 = this;
            long l4 = zzjr2.zzbt().currentTimeMillis();
            long l5 = Math.max(0L, zzew.zzahi.get());
            boolean bl = zzjr2.zzix().zzht() || zzjr2.zzix().zzho();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzjr2.zzgg().zzhj())) && !".none.".equals(string) ? Math.max(0L, zzew.zzahd.get()) : Math.max(0L, zzew.zzahc.get())) : Math.max(0L, zzew.zzahb.get());
            long l7 = zzjr2.zzgf().zzaju.get();
            long l8 = zzjr2.zzgf().zzajv.get();
            long l9 = zzjr2.zzix().zzhq();
            long l10 = zzjr2.zzix().zzhr();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzjr2.zzgb().zza(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, zzew.zzahk.get())); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, zzew.zzahj.get()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzge().zzit().log("Next upload time is 0");
            this.zzko().unregister();
            this.zzkp().cancel();
            return;
        }
        if (!this.zzkn().zzex()) {
            this.zzge().zzit().log("No network");
            this.zzko().zzeu();
            this.zzkp().cancel();
            return;
        }
        l2 = this.zzgf().zzajw.get();
        long l16 = Math.max(0L, zzew.zzagz.get());
        if (!this.zzgb().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzko().unregister();
        long l17 = l3 - this.zzbt().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, zzew.zzahe.get());
            this.zzgf().zzaju.set(this.zzbt().currentTimeMillis());
        }
        this.zzge().zzit().zzg("Upload scheduled in approximately ms", l17);
        this.zzkp().zzh(l17);
    }

    @WorkerThread
    final void zzg(Runnable runnable) {
        this.zzab();
        if (this.zzaqi == null) {
            this.zzaqi = new ArrayList<Runnable>();
        }
        this.zzaqi.add(runnable);
    }

    @WorkerThread
    private final void zzkv() {
        this.zzab();
        if (this.zzaql || this.zzaqm || this.zzaqn) {
            this.zzge().zzit().zzd("Not stopping services. fetch, network, upload", this.zzaql, this.zzaqm, this.zzaqn);
            return;
        }
        this.zzge().zzit().log("Stopping uploading service(s)");
        if (this.zzaqi == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzaqi.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzaqi.clear();
    }

    @WorkerThread
    private final Boolean zzc(zzdy zzdy2) {
        try {
            if (zzdy2.zzgm() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.getContext()).getPackageInfo((String)zzdy2.zzah(), (int)0).versionCode;
                if (zzdy2.zzgm() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.getContext()).getPackageInfo((String)zzdy2.zzah(), (int)0).versionName;
                if (zzdy2.zzag() != null && zzdy2.zzag().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzkw() {
        this.zzab();
        String string = "google_app_measurement.db";
        File file = this.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzaqp = new RandomAccessFile(file2, "rw").getChannel();
            this.zzaqo = this.zzaqp.tryLock();
            if (this.zzaqo != null) {
                this.zzge().zzit().log("Storage concurrent access okay");
                return true;
            }
            this.zzge().zzim().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzge().zzim().zzg("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzge().zzim().zzg("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzab();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzge().zzim().log("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzge().zzip().zzg("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzge().zzim().zzg("Failed to read from channel", iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzab();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzge().zzim().log("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzge().zzim().zzg("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzge().zzim().zzg("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    final void zzkx() {
        this.zzab();
        this.zzkq();
        if (!this.zzaqg) {
            this.zzge().zzir().log("This instance being marked as an uploader");
            zzjr zzjr2 = this;
            zzjr2.zzab();
            zzjr2.zzkq();
            if (zzjr2.zzky() && zzjr2.zzkw()) {
                int n;
                int n2 = zzjr2.zza(zzjr2.zzaqp);
                int n3 = n = zzjr2.zzacw.zzfv().zzij();
                int n4 = n2;
                zzjr zzjr3 = zzjr2;
                zzjr3.zzab();
                if (n4 > n3) {
                    zzjr3.zzge().zzim().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzjr3.zza(n3, zzjr3.zzaqp)) {
                        zzjr3.zzge().zzit().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzjr3.zzge().zzim().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzaqg = true;
            this.zzku();
        }
    }

    @WorkerThread
    private final boolean zzky() {
        this.zzab();
        this.zzkq();
        return this.zzaqg;
    }

    @VisibleForTesting
    @WorkerThread
    final void zzd(zzdz zzdz2) {
        if (this.zzaqq != null) {
            this.zzaqr = new ArrayList<Long>();
            this.zzaqr.addAll(this.zzaqq);
        }
        String string = zzdz2.packageName;
        zzei zzei2 = this.zzix();
        Preconditions.checkNotEmpty((String)string);
        zzei2.zzab();
        zzei2.zzch();
        try {
            SQLiteDatabase sQLiteDatabase = zzei2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzei2.zzge().zzit().zze("Reset analytics data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzei2.zzge().zzim().zze("Error resetting analytics data. appId, error", zzfg.zzbm(string), (Object)sQLiteException);
        }
        zzdz zzdz3 = this.zza(this.getContext(), zzdz2.packageName, zzdz2.zzadm, zzdz2.zzadw, zzdz2.zzady, zzdz2.zzadz, zzdz2.zzaem);
        if (!this.zzgg().zzaz(zzdz2.packageName) || zzdz2.zzadw) {
            this.zzf(zzdz3);
        }
    }

    private final zzdz zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l) {
        String string3 = "Unknown";
        String string4 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string5 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzge().zzim().log("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string3 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzge().zzim().zzg("Error retrieving installer package name. appId", zzfg.zzbm(string));
        }
        if (string3 == null) {
            string3 = "manual_install";
        } else if ("com.android.vending".equals(string3)) {
            string3 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string5 = charSequence.toString();
                }
                string4 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzge().zzim().zze("Error retrieving newly installed package info. appId, appName", zzfg.zzbm(string), string5);
            return null;
        }
        long l2 = 0L;
        if (this.zzgg().zzba(string)) {
            l2 = l;
        }
        return new zzdz(string, string2, string4, n, string3, 12451L, this.zzgb().zzd(context, string), null, bl, false, "", 0L, l2, 0, bl2, bl3, false);
    }

    @WorkerThread
    final void zzb(zzjx zzjx2, zzdz zzdz2) {
        this.zzab();
        this.zzkq();
        if (TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            return;
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        int n = this.zzgb().zzcf(zzjx2.name);
        if (n != 0) {
            this.zzgb();
            String string = zzka.zza(zzjx2.name, 24, true);
            int n2 = zzjx2.name != null ? zzjx2.name.length() : 0;
            this.zzgb().zza(zzdz2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzgb().zzi(zzjx2.name, zzjx2.getValue());
        if (n != 0) {
            this.zzgb();
            String string = zzka.zza(zzjx2.name, 24, true);
            Object object = zzjx2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzgb().zza(zzdz2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzgb().zzj(zzjx2.name, zzjx2.getValue());
        if (object == null) {
            return;
        }
        zzjz zzjz2 = new zzjz(zzdz2.packageName, zzjx2.origin, zzjx2.name, zzjx2.zzaqz, object);
        this.zzge().zzis().zze("Setting user property", this.zzga().zzbl(zzjz2.name), object);
        this.zzix().beginTransaction();
        try {
            this.zzg(zzdz2);
            boolean bl = this.zzix().zza(zzjz2);
            this.zzix().setTransactionSuccessful();
            if (bl) {
                this.zzge().zzis().zze("User property set", this.zzga().zzbl(zzjz2.name), zzjz2.value);
            } else {
                this.zzge().zzim().zze("Too many unique user properties are set. Ignoring user property", this.zzga().zzbl(zzjz2.name), zzjz2.value);
                this.zzgb().zza(zzdz2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzix().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzjx zzjx2, zzdz zzdz2) {
        this.zzab();
        this.zzkq();
        if (TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            return;
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        this.zzge().zzis().zzg("Removing user property", this.zzga().zzbl(zzjx2.name));
        this.zzix().beginTransaction();
        try {
            this.zzg(zzdz2);
            this.zzix().zzg(zzdz2.packageName, zzjx2.name);
            this.zzix().setTransactionSuccessful();
            this.zzge().zzis().zzg("User property removed", this.zzga().zzbl(zzjx2.name));
            return;
        }
        finally {
            this.zzix().endTransaction();
        }
    }

    final void zzb(zzjq zzjq2) {
        ++this.zzaqj;
    }

    final void zzkz() {
        ++this.zzaqk;
    }

    final zzgl zzla() {
        return this.zzacw;
    }

    @WorkerThread
    public final void zzf(zzdz zzdz2) {
        int n;
        this.zzab();
        this.zzkq();
        Preconditions.checkNotNull((Object)((Object)zzdz2));
        Preconditions.checkNotEmpty((String)zzdz2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            return;
        }
        zzdy zzdy2 = this.zzix().zzbc(zzdz2.packageName);
        if (zzdy2 != null && TextUtils.isEmpty((CharSequence)zzdy2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            zzdy2.zzs(0L);
            this.zzix().zza(zzdy2);
            this.zzkm().zzbx(zzdz2.packageName);
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        long l = zzdz2.zzaem;
        if (l == 0L) {
            l = this.zzbt().currentTimeMillis();
        }
        if ((n = zzdz2.zzaen) != 0 && n != 1) {
            this.zzge().zzip().zze("Incorrect app type, assuming installed app. appId, appType", zzfg.zzbm(zzdz2.packageName), n);
            n = 0;
        }
        this.zzix().beginTransaction();
        try {
            zzeu zzeu2;
            Object object;
            long l2 = l;
            zzdz zzdz3 = zzdz2;
            zzjr zzjr2 = this;
            zzdy zzdy3 = zzjr2.zzix().zzbc(zzdz3.packageName);
            if (zzdy3 != null && zzdy3.getGmpAppId() != null && !zzdy3.getGmpAppId().equals(zzdz3.zzadm)) {
                zzjr2.zzge().zzip().zzg("New GMP App Id passed in. Removing cached database data. appId", zzfg.zzbm(zzdy3.zzah()));
                String string = zzdy3.zzah();
                zzei zzei2 = zzjr2.zzix();
                zzei2.zzch();
                zzei2.zzab();
                Preconditions.checkNotEmpty((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzei2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzei2.zzge().zzit().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzei2.zzge().zzim().zze("Error deleting application data. appId, error", zzfg.zzbm(string), (Object)sQLiteException);
                }
                zzdy3 = null;
            }
            if (zzdy3 != null) {
                if (zzdy3.zzgm() != Integer.MIN_VALUE) {
                    if (zzdy3.zzgm() != zzdz3.zzads) {
                        object = new Bundle();
                        object.putString("_pv", zzdy3.zzag());
                        zzeu2 = new zzeu("_au", new zzer((Bundle)object), "auto", l2);
                        zzjr2.zzb(zzeu2, zzdz3);
                    }
                } else if (zzdy3.zzag() != null && !zzdy3.zzag().equals(zzdz3.zzth)) {
                    object = new Bundle();
                    object.putString("_pv", zzdy3.zzag());
                    zzeu2 = new zzeu("_au", new zzer((Bundle)object), "auto", l2);
                    zzjr2.zzb(zzeu2, zzdz3);
                }
            }
            this.zzg(zzdz2);
            zzeq zzeq2 = null;
            if (n == 0) {
                zzeq2 = this.zzix().zzf(zzdz2.packageName, "_f");
            } else if (n == 1) {
                zzeq2 = this.zzix().zzf(zzdz2.packageName, "_v");
            }
            if (zzeq2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    AbstractSafeParcelable abstractSafeParcelable;
                    zzjx zzjx2 = new zzjx("_fot", l, l3, "auto");
                    this.zzb(zzjx2, zzdz2);
                    l2 = l;
                    zzdz3 = zzdz2;
                    zzjr2 = this;
                    zzjr2.zzab();
                    zzjr2.zzkq();
                    zzdy3 = new Bundle();
                    zzdy3.putLong("_c", 1L);
                    zzdy3.putLong("_r", 1L);
                    zzdy3.putLong("_uwa", 0L);
                    zzdy3.putLong("_pfo", 0L);
                    zzdy3.putLong("_sys", 0L);
                    zzdy3.putLong("_sysu", 0L);
                    if (zzjr2.zzgg().zzaz(zzdz3.packageName) && zzdz3.zzaeo) {
                        zzdy3.putLong("_dac", 1L);
                    }
                    if (zzjr2.getContext().getPackageManager() == null) {
                        zzjr2.zzge().zzim().zzg("PackageManager is null, first open report might be inaccurate. appId", zzfg.zzbm(zzdz3.packageName));
                    } else {
                        zzeu2 = null;
                        try {
                            zzeu2 = Wrappers.packageManager((Context)zzjr2.getContext()).getPackageInfo(zzdz3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjr2.zzge().zzim().zze("Package info is null, first open report might be inaccurate. appId", zzfg.zzbm(zzdz3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzeu2 != null && ((PackageInfo)zzeu2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzeu2).firstInstallTime != ((PackageInfo)zzeu2).lastUpdateTime) {
                                zzdy3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            abstractSafeParcelable = new zzjx("_fi", l2, bl ? 1L : 0L, "auto");
                            zzjr2.zzb((zzjx)abstractSafeParcelable, zzdz3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzjr2.getContext()).getApplicationInfo(zzdz3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjr2.zzge().zzim().zze("Application info is null, first open report might be inaccurate. appId", zzfg.zzbm(zzdz3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzdy3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzdy3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzdz3.packageName;
                    zzei zzei3 = zzjr2.zzix();
                    Preconditions.checkNotEmpty((String)string);
                    zzei3.zzab();
                    zzei3.zzch();
                    long l4 = zzei3.zzm(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzdy3.putLong("_pfo", l4);
                    }
                    abstractSafeParcelable = new zzeu("_f", new zzer((Bundle)zzdy3), "auto", l2);
                    zzjr2.zzb((zzeu)abstractSafeParcelable, zzdz3);
                } else if (n == 1) {
                    zzjx zzjx3 = new zzjx("_fvt", l, l3, "auto");
                    this.zzb(zzjx3, zzdz2);
                    l2 = l;
                    zzdz3 = zzdz2;
                    zzjr2 = this;
                    zzjr2.zzab();
                    zzjr2.zzkq();
                    zzdy3 = new Bundle();
                    zzdy3.putLong("_c", 1L);
                    zzdy3.putLong("_r", 1L);
                    if (zzjr2.zzgg().zzaz(zzdz3.packageName) && zzdz3.zzaeo) {
                        zzdy3.putLong("_dac", 1L);
                    }
                    object = new zzeu("_v", new zzer((Bundle)zzdy3), "auto", l2);
                    zzjr2.zzb((zzeu)((Object)object), zzdz3);
                }
                l2 = l;
                zzdz3 = zzdz2;
                zzjr2 = this;
                zzdy3 = new Bundle();
                zzdy3.putLong("_et", 1L);
                object = new zzeu("_e", new zzer((Bundle)zzdy3), "auto", l2);
                zzjr2.zzb((zzeu)((Object)object), zzdz3);
            } else if (zzdz2.zzael) {
                l2 = l;
                zzdz3 = zzdz2;
                zzjr2 = this;
                zzdy3 = new Bundle();
                object = new zzeu("_cd", new zzer((Bundle)zzdy3), "auto", l2);
                zzjr2.zzb((zzeu)((Object)object), zzdz3);
            }
            this.zzix().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzix().endTransaction();
        }
    }

    @WorkerThread
    final zzdz zzcb(String string) {
        zzdy zzdy2 = this.zzix().zzbc(string);
        if (zzdy2 == null || TextUtils.isEmpty((CharSequence)zzdy2.zzag())) {
            this.zzge().zzis().zzg("No app data available; dropping", string);
            return null;
        }
        Boolean bl = this.zzc(zzdy2);
        if (bl != null && !bl.booleanValue()) {
            this.zzge().zzim().zzg("App version does not match; dropping. appId", zzfg.zzbm(string));
            return null;
        }
        return new zzdz(string, zzdy2.getGmpAppId(), zzdy2.zzag(), zzdy2.zzgm(), zzdy2.zzgn(), zzdy2.zzgo(), zzdy2.zzgp(), null, zzdy2.isMeasurementEnabled(), false, zzdy2.zzgj(), zzdy2.zzhc(), 0L, 0, zzdy2.zzhd(), zzdy2.zzhe(), false);
    }

    @WorkerThread
    final void zzb(zzed zzed2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzed2));
        Preconditions.checkNotEmpty((String)zzed2.packageName);
        Preconditions.checkNotNull((Object)zzed2.origin);
        Preconditions.checkNotNull((Object)((Object)zzed2.zzaep));
        Preconditions.checkNotEmpty((String)zzed2.zzaep.name);
        this.zzab();
        this.zzkq();
        if (TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            return;
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        zzed zzed3 = new zzed(zzed2);
        new zzed(zzed2).active = false;
        this.zzix().beginTransaction();
        try {
            boolean bl = false;
            zzed zzed4 = this.zzix().zzi(zzed3.packageName, zzed3.zzaep.name);
            if (zzed4 != null && !zzed4.origin.equals(zzed3.origin)) {
                this.zzge().zzip().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzga().zzbl(zzed3.zzaep.name), zzed3.origin, zzed4.origin);
            }
            if (zzed4 != null && zzed4.active) {
                zzed3.origin = zzed4.origin;
                zzed3.creationTimestamp = zzed4.creationTimestamp;
                zzed3.triggerTimeout = zzed4.triggerTimeout;
                zzed3.triggerEventName = zzed4.triggerEventName;
                zzed3.zzaer = zzed4.zzaer;
                zzed3.active = zzed4.active;
                zzed3.zzaep = new zzjx(zzed3.zzaep.name, zzed4.zzaep.zzaqz, zzed3.zzaep.getValue(), zzed4.zzaep.origin);
            } else if (TextUtils.isEmpty((CharSequence)zzed3.triggerEventName)) {
                zzed3.zzaep = new zzjx(zzed3.zzaep.name, zzed3.creationTimestamp, zzed3.zzaep.getValue(), zzed3.zzaep.origin);
                zzed3.active = true;
                bl = true;
            }
            if (zzed3.active) {
                zzjx zzjx2 = zzed3.zzaep;
                zzjz zzjz2 = new zzjz(zzed3.packageName, zzed3.origin, zzjx2.name, zzjx2.zzaqz, zzjx2.getValue());
                if (this.zzix().zza(zzjz2)) {
                    this.zzge().zzis().zzd("User property updated immediately", zzed3.packageName, this.zzga().zzbl(zzjz2.name), zzjz2.value);
                } else {
                    this.zzge().zzim().zzd("(2)Too many active user properties, ignoring", zzfg.zzbm(zzed3.packageName), this.zzga().zzbl(zzjz2.name), zzjz2.value);
                }
                if (bl && zzed3.zzaer != null) {
                    zzeu zzeu2 = new zzeu(zzed3.zzaer, zzed3.creationTimestamp);
                    this.zzc(zzeu2, zzdz2);
                }
            }
            if (this.zzix().zza(zzed3)) {
                this.zzge().zzis().zzd("Conditional property added", zzed3.packageName, this.zzga().zzbl(zzed3.zzaep.name), zzed3.zzaep.getValue());
            } else {
                this.zzge().zzim().zzd("Too many conditional properties, ignoring", zzfg.zzbm(zzed3.packageName), this.zzga().zzbl(zzed3.zzaep.name), zzed3.zzaep.getValue());
            }
            this.zzix().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzix().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzed zzed2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzed2));
        Preconditions.checkNotEmpty((String)zzed2.packageName);
        Preconditions.checkNotNull((Object)((Object)zzed2.zzaep));
        Preconditions.checkNotEmpty((String)zzed2.zzaep.name);
        this.zzab();
        this.zzkq();
        if (TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            return;
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        this.zzix().beginTransaction();
        try {
            this.zzg(zzdz2);
            zzed zzed3 = this.zzix().zzi(zzed2.packageName, zzed2.zzaep.name);
            if (zzed3 != null) {
                this.zzge().zzis().zze("Removing conditional user property", zzed2.packageName, this.zzga().zzbl(zzed2.zzaep.name));
                this.zzix().zzj(zzed2.packageName, zzed2.zzaep.name);
                if (zzed3.active) {
                    this.zzix().zzg(zzed2.packageName, zzed2.zzaep.name);
                }
                if (zzed2.zzaes != null) {
                    Bundle bundle = null;
                    if (zzed2.zzaes.zzafq != null) {
                        bundle = zzed2.zzaes.zzafq.zzif();
                    }
                    zzeu zzeu2 = this.zzgb().zza(zzed2.zzaes.name, bundle, zzed3.origin, zzed2.zzaes.zzagb, true, false);
                    this.zzc(zzeu2, zzdz2);
                }
            } else {
                this.zzge().zzip().zze("Conditional user property doesn't exist", zzfg.zzbm(zzed2.packageName), this.zzga().zzbl(zzed2.zzaep.name));
            }
            this.zzix().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzix().endTransaction();
        }
    }

    @WorkerThread
    private final zzdy zzg(zzdz zzdz2) {
        this.zzab();
        this.zzkq();
        Preconditions.checkNotNull((Object)((Object)zzdz2));
        Preconditions.checkNotEmpty((String)zzdz2.packageName);
        zzdy zzdy2 = this.zzix().zzbc(zzdz2.packageName);
        String string = this.zzgf().zzbp(zzdz2.packageName);
        boolean bl = false;
        if (zzdy2 == null) {
            zzdy2 = new zzdy(this.zzacw, zzdz2.packageName);
            zzdy2.zzal(this.zzacw.zzfv().zzii());
            zzdy2.zzan(string);
            bl = true;
        } else if (!string.equals(zzdy2.zzgi())) {
            zzdy2.zzan(string);
            zzdy2.zzal(this.zzacw.zzfv().zzii());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzdz2.zzadm) && !zzdz2.zzadm.equals(zzdy2.getGmpAppId())) {
            zzdy2.zzam(zzdz2.zzadm);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzdz2.zzado) && !zzdz2.zzado.equals(zzdy2.zzgj())) {
            zzdy2.zzao(zzdz2.zzado);
            bl = true;
        }
        if (zzdz2.zzadu != 0L && zzdz2.zzadu != zzdy2.zzgo()) {
            zzdy2.zzp(zzdz2.zzadu);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzdz2.zzth) && !zzdz2.zzth.equals(zzdy2.zzag())) {
            zzdy2.setAppVersion(zzdz2.zzth);
            bl = true;
        }
        if (zzdz2.zzads != zzdy2.zzgm()) {
            zzdy2.zzo(zzdz2.zzads);
            bl = true;
        }
        if (zzdz2.zzadt != null && !zzdz2.zzadt.equals(zzdy2.zzgn())) {
            zzdy2.zzap(zzdz2.zzadt);
            bl = true;
        }
        if (zzdz2.zzadv != zzdy2.zzgp()) {
            zzdy2.zzq(zzdz2.zzadv);
            bl = true;
        }
        if (zzdz2.zzadw != zzdy2.isMeasurementEnabled()) {
            zzdy2.setMeasurementEnabled(zzdz2.zzadw);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzdz2.zzaek) && !zzdz2.zzaek.equals(zzdy2.zzha())) {
            zzdy2.zzaq(zzdz2.zzaek);
            bl = true;
        }
        if (zzdz2.zzadx != zzdy2.zzhc()) {
            zzdy2.zzaa(zzdz2.zzadx);
            bl = true;
        }
        if (zzdz2.zzady != zzdy2.zzhd()) {
            zzdy2.zzd(zzdz2.zzady);
            bl = true;
        }
        if (zzdz2.zzadz != zzdy2.zzhe()) {
            zzdy2.zze(zzdz2.zzadz);
            bl = true;
        }
        if (bl) {
            this.zzix().zza(zzdy2);
        }
        return zzdy2;
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzeu zzeu2, @Size(min=1L) String string) {
        Long l;
        this.zzkq();
        this.zzab();
        zzgl.zzfr();
        Preconditions.checkNotNull((Object)((Object)zzeu2));
        Preconditions.checkNotEmpty((String)string);
        zzkp zzkp2 = new zzkp();
        this.zzix().beginTransaction();
        try {
            zzeq zzeq2;
            long l2;
            Object object;
            zzdy zzdy2 = this.zzix().zzbc(string);
            if (zzdy2 == null) {
                this.zzge().zzis().zzg("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzdy2.isMeasurementEnabled()) {
                this.zzge().zzis().zzg("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (("_iap".equals(zzeu2.name) || "ecommerce_purchase".equals(zzeu2.name)) && !this.zza(string, zzeu2)) {
                this.zzge().zzip().zzg("Failed to handle purchase event at single event bundle creation. appId", zzfg.zzbm(string));
            }
            boolean bl = this.zzgg().zzav(string);
            l = 0L;
            if (bl && "_e".equals(zzeu2.name)) {
                if (zzeu2.zzafq == null || zzeu2.zzafq.size() == 0) {
                    this.zzge().zzip().zzg("The engagement event does not contain any parameters. appId", zzfg.zzbm(string));
                } else if (zzeu2.zzafq.getLong("_et") == null) {
                    this.zzge().zzip().zzg("The engagement event does not include duration. appId", zzfg.zzbm(string));
                } else {
                    l = zzeu2.zzafq.getLong("_et");
                }
            }
            zzkq zzkq2 = new zzkq();
            zzkp2.zzatf = new zzkq[]{zzkq2};
            zzkq2.zzath = 1;
            zzkq2.zzatp = "android";
            zzkq2.zzti = zzdy2.zzah();
            zzkq2.zzadt = zzdy2.zzgn();
            zzkq2.zzth = zzdy2.zzag();
            long l3 = zzdy2.zzgm();
            zzkq2.zzaub = l3 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l3);
            zzkq2.zzatt = zzdy2.zzgo();
            zzkq2.zzadm = zzdy2.getGmpAppId();
            zzkq2.zzatx = zzdy2.zzgp();
            if (this.zzacw.isEnabled() && zzef.zzhk() && this.zzgg().zzat(zzkq2.zzti)) {
                zzkq2.zzauh = null;
            }
            Pair<String, Boolean> pair = this.zzgf().zzbo(zzdy2.zzah());
            if (zzdy2.zzhd() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                zzkq2.zzatv = (String)pair.first;
                zzkq2.zzatw = (Boolean)pair.second;
            }
            this.zzfw().zzch();
            zzkq2.zzatr = Build.MODEL;
            this.zzfw().zzch();
            zzkq2.zzatq = Build.VERSION.RELEASE;
            zzkq2.zzats = (int)this.zzfw().zzic();
            zzkq2.zzafn = this.zzfw().zzid();
            zzkq2.zzadl = zzdy2.getAppInstanceId();
            zzkq2.zzado = zzdy2.zzgj();
            List<zzjz> list = this.zzix().zzbb(zzdy2.zzah());
            zzkq2.zzatj = new zzks[list.size()];
            zzjz zzjz2 = null;
            if (bl) {
                zzjz2 = this.zzix().zzh(zzkq2.zzti, "_lte");
                if (zzjz2 == null || zzjz2.value == null) {
                    zzjz2 = new zzjz(zzkq2.zzti, "auto", "_lte", this.zzbt().currentTimeMillis(), l);
                } else if (l > 0L) {
                    zzjz2 = new zzjz(zzkq2.zzti, "auto", "_lte", this.zzbt().currentTimeMillis(), (Long)zzjz2.value + l);
                }
            }
            zzks zzks2 = null;
            for (int i = 0; i < list.size(); ++i) {
                object = new zzks();
                zzkq2.zzatj[i] = object;
                ((zzks)((Object)object)).name = list.get((int)i).name;
                ((zzks)((Object)object)).zzaun = list.get((int)i).zzaqz;
                this.zzgb().zza((zzks)((Object)object), list.get((int)i).value);
                if (!bl || !"_lte".equals(((zzks)((Object)object)).name)) continue;
                zzks2 = object;
                ((zzks)((Object)object)).zzate = (Long)zzjz2.value;
                zzks2.zzaun = this.zzbt().currentTimeMillis();
            }
            if (bl && zzks2 == null) {
                zzks2 = new zzks();
                new zzks().name = "_lte";
                zzks2.zzaun = this.zzbt().currentTimeMillis();
                zzks2.zzate = (Long)zzjz2.value;
                zzkq2.zzatj = Arrays.copyOf(zzkq2.zzatj, zzkq2.zzatj.length + 1);
                zzkq2.zzatj[zzkq2.zzatj.length - 1] = zzks2;
            }
            if (l > 0L) {
                this.zzix().zza(zzjz2);
            }
            Bundle bundle = zzeu2.zzafq.zzif();
            if ("_iap".equals(zzeu2.name)) {
                bundle.putLong("_c", 1L);
                this.zzge().zzis().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzeu2.origin);
            if (this.zzgb().zzcj(zzkq2.zzti)) {
                this.zzgb().zza(bundle, "_dbg", 1L);
                this.zzgb().zza(bundle, "_r", 1L);
            }
            if ((object = this.zzix().zzf(string, zzeu2.name)) == null) {
                l2 = 0L;
                zzeq2 = new zzeq(string, zzeu2.name, 1L, 0L, zzeu2.zzagb, 0L, null, null, null);
                this.zzix().zza(zzeq2);
            } else {
                l2 = ((zzeq)object).zzaft;
                zzeq2 = ((zzeq)object).zzac(zzeu2.zzagb).zzie();
                this.zzix().zza(zzeq2);
            }
            zzep zzep2 = new zzep(this.zzacw, zzeu2.origin, string, zzeu2.name, zzeu2.zzagb, l2, bundle);
            zzkn zzkn2 = new zzkn();
            zzkq2.zzati = new zzkn[]{zzkn2};
            zzkn2.zzatb = zzep2.timestamp;
            zzkn2.name = zzep2.name;
            zzkn2.zzatc = zzep2.zzafp;
            zzkn2.zzata = new zzko[zzep2.zzafq.size()];
            int n = 0;
            for (String string2 : zzep2.zzafq) {
                zzko zzko2 = new zzko();
                zzkn2.zzata[n++] = zzko2;
                zzko2.name = string2;
                Object object2 = zzep2.zzafq.get(string2);
                this.zzgb().zza(zzko2, object2);
            }
            zzkq2.zzaua = this.zza(zzdy2.zzah(), zzkq2.zzatj, zzkq2.zzati);
            zzkq2.zzatl = zzkn2.zzatb;
            zzkq2.zzatm = zzkn2.zzatb;
            long l4 = zzdy2.zzgl();
            zzkq2.zzato = l4 != 0L ? Long.valueOf(l4) : null;
            long l5 = zzdy2.zzgk();
            if (l5 == 0L) {
                l5 = l4;
            }
            zzkq2.zzatn = l5 != 0L ? Long.valueOf(l5) : null;
            zzdy2.zzgt();
            zzkq2.zzaty = (int)zzdy2.zzgq();
            zzkq2.zzatu = 12451L;
            zzkq2.zzatk = this.zzbt().currentTimeMillis();
            zzkq2.zzatz = Boolean.TRUE;
            zzdy2.zzm(zzkq2.zzatl);
            zzdy2.zzn(zzkq2.zzatm);
            this.zzix().zza(zzdy2);
            this.zzix().setTransactionSuccessful();
        }
        finally {
            this.zzix().endTransaction();
        }
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzkp2.zzvm()];
            l = zzabw.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkp2.zza((zzabw)l);
            l.zzve();
            return this.zzgb().zza(byArray);
        }
        catch (IOException iOException) {
            this.zzge().zzim().zze("Data loss. Failed to bundle and serialize. appId", zzfg.zzbm(string), iOException);
            return null;
        }
    }

    public final String zzh(zzdz zzdz2) {
        Future<String> future = this.zzgd().zzb(new zzju(this, zzdz2));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzge().zzim().zze("Failed to get app instance id. appId", zzfg.zzbm(zzdz2.packageName), exception);
            return null;
        }
    }

    public final void zzm(boolean bl) {
        this.zzku();
    }

    static /* synthetic */ zzdy zza(zzjr zzjr2, zzdz zzdz2) {
        return zzjr2.zzg(zzdz2);
    }
}

