/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.support.annotation.GuardedBy;
import android.util.Log;
import com.google.android.gms.internal.measurement.zzwq;
import com.google.android.gms.internal.measurement.zzwr;
import com.google.android.gms.internal.measurement.zzws;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzwp {
    private static final ConcurrentHashMap<Uri, zzwp> zzbmt = new ConcurrentHashMap();
    private final ContentResolver zzbmu;
    private final Uri uri;
    private final ContentObserver zzbmv;
    private final Object zzbmw = new Object();
    private volatile Map<String, String> zzbmx;
    private final Object zzbmy = new Object();
    @GuardedBy(value="listenersLock")
    private final List<zzwr> zzbmz = new ArrayList<zzwr>();
    private static final String[] zzbna = new String[]{"key", "value"};

    private zzwp(ContentResolver contentResolver, Uri uri) {
        this.zzbmu = contentResolver;
        this.uri = uri;
        this.zzbmv = new zzwq(this, null);
    }

    public static zzwp zza(ContentResolver contentResolver, Uri uri) {
        zzwp zzwp2 = zzbmt.get(uri);
        if (zzwp2 == null) {
            zzwp2 = new zzwp(contentResolver, uri);
            zzwp zzwp3 = zzbmt.putIfAbsent(uri, zzwp2);
            if (zzwp3 == null) {
                zzwp2.zzbmu.registerContentObserver(zzwp2.uri, false, zzwp2.zzbmv);
            } else {
                zzwp2 = zzwp3;
            }
        }
        return zzwp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zzrt() {
        Map<String, String> map = zzws.zzd("gms:phenotype:phenotype_flag:debug_disable_caching", false) ? this.zzrv() : this.zzbmx;
        if (map == null) {
            Object object = this.zzbmw;
            synchronized (object) {
                map = this.zzbmx;
                if (map == null) {
                    map = this.zzrv();
                    this.zzbmx = map;
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzru() {
        Object object = this.zzbmw;
        synchronized (object) {
            this.zzbmx = null;
            return;
        }
    }

    private final Map<String, String> zzrv() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Cursor cursor = this.zzbmu.query(this.uri, zzbna, null, null, null);
            if (cursor != null) {
                try {
                    while (cursor.moveToNext()) {
                        hashMap.put(cursor.getString(0), cursor.getString(1));
                    }
                }
                finally {
                    cursor.close();
                }
            }
            return hashMap;
        }
        catch (SQLiteException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzrw() {
        Object object = this.zzbmy;
        synchronized (object) {
            Iterator<zzwr> iterator = this.zzbmz.iterator();
            while (iterator.hasNext()) {
                iterator.next().zzrx();
            }
            return;
        }
    }

    static /* synthetic */ void zza(zzwp zzwp2) {
        zzwp2.zzrw();
    }
}

