/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzif;
import com.google.android.gms.internal.measurement.zzig;
import java.util.Map;

public final class zzdu
extends zzhh {
    private final Map<String, Long> zzadf;
    private final Map<String, Integer> zzadg = new ArrayMap();
    private long zzadh;

    public zzdu(zzgm zzgm2) {
        super(zzgm2);
        this.zzadf = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzhh)this).zzgf().zzis().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzhh)this).zzbt().elapsedRealtime();
        ((zzhh)this).zzge().zzc(new zzdv(this, string, l));
    }

    @WorkerThread
    private final void zza(String string, long l) {
        Integer n;
        ((zzhh)this).zzfs();
        ((zzhh)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzadg.isEmpty()) {
            this.zzadh = l;
        }
        if ((n = this.zzadg.get(string)) != null) {
            this.zzadg.put(string, n + 1);
            return;
        }
        if (this.zzadg.size() >= 100) {
            ((zzhh)this).zzgf().zziv().log("Too many ads visible");
            return;
        }
        this.zzadg.put(string, 1);
        this.zzadf.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzhh)this).zzgf().zzis().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzhh)this).zzbt().elapsedRealtime();
        ((zzhh)this).zzge().zzc(new zzdw(this, string, l));
    }

    @WorkerThread
    private final void zzb(String string, long l) {
        ((zzhh)this).zzfs();
        ((zzhh)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        Integer n = this.zzadg.get(string);
        if (n != null) {
            zzif zzif2 = ((zzhh)this).zzfz().zzkk();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzadg.remove(string);
                Long l2 = this.zzadf.get(string);
                if (l2 == null) {
                    ((zzhh)this).zzgf().zzis().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzadf.remove(string);
                    this.zza(string, l3, zzif2);
                }
                if (this.zzadg.isEmpty()) {
                    if (this.zzadh == 0L) {
                        ((zzhh)this).zzgf().zzis().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzadh, zzif2);
                    this.zzadh = 0L;
                }
                return;
            }
            this.zzadg.put(string, n2);
            return;
        }
        ((zzhh)this).zzgf().zzis().zzg("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, zzif zzif2) {
        if (zzif2 == null) {
            ((zzhh)this).zzgf().zziz().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzhh)this).zzgf().zziz().zzg("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzig.zza(zzif2, bundle, true);
        ((zzhh)this).zzfv().logEvent("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, zzif zzif2) {
        if (zzif2 == null) {
            ((zzhh)this).zzgf().zziz().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzhh)this).zzgf().zziz().zzg("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzig.zza(zzif2, bundle, true);
        ((zzhh)this).zzfv().logEvent("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzk(long l) {
        zzif zzif2 = ((zzhh)this).zzfz().zzkk();
        for (String string : this.zzadf.keySet()) {
            long l2 = this.zzadf.get(string);
            this.zza(string, l - l2, zzif2);
        }
        if (!this.zzadf.isEmpty()) {
            this.zza(l - this.zzadh, zzif2);
        }
        this.zzl(l);
    }

    @WorkerThread
    private final void zzl(long l) {
        for (String string : this.zzadf.keySet()) {
            this.zzadf.put(string, l);
        }
        if (!this.zzadf.isEmpty()) {
            this.zzadh = l;
        }
    }

    static /* synthetic */ void zza(zzdu zzdu2, String string, long l) {
        zzdu2.zza(string, l);
    }

    static /* synthetic */ void zzb(zzdu zzdu2, String string, long l) {
        zzdu2.zzb(string, l);
    }

    static /* synthetic */ void zza(zzdu zzdu2, long l) {
        zzdu2.zzl(l);
    }
}

