/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhh;
import java.lang.reflect.InvocationTargetException;

public final class zzeg
extends zzhh {
    @NonNull
    private zzei zzaeu = zzeh.zzaev;
    private Boolean zzxz;

    zzeg(zzgm zzgm2) {
        super(zzgm2);
    }

    final void zza(@NonNull zzei zzei2) {
        this.zzaeu = zzei2;
    }

    static String zzhi() {
        return zzey.zzagp.get();
    }

    @WorkerThread
    public final int zzaq(@Size(min=1L) String string) {
        return this.zzb(string, zzey.zzahd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzds() {
        if (this.zzxz == null) {
            zzeg zzeg2 = this;
            synchronized (zzeg2) {
                if (this.zzxz == null) {
                    ApplicationInfo applicationInfo = ((zzhh)this).getContext().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzxz = string2 != null && string2.equals(string);
                    }
                    if (this.zzxz == null) {
                        this.zzxz = Boolean.TRUE;
                        ((zzhh)this).zzgf().zzis().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzxz;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzey.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzaeu.zze(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.parseLong(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzey.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzaeu.zze(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.parseInt(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzey.zza<Double> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzaeu.zze(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            double d = Double.parseDouble(string2);
            return zza2.get(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzey.zza<Boolean> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzaeu.zze(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zza2.get(bl);
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzar(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            if (((zzhh)this).getContext().getPackageManager() == null) {
                ((zzhh)this).zzgf().zzis().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzhh)this).getContext()).getApplicationInfo(((zzhh)this).getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzhh)this).zzgf().zzis().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                ((zzhh)this).zzgf().zzis().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzhh)this).zzgf().zzis().zzg("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final boolean zzhj() {
        zzec zzec2 = ((zzhh)this).zzgi();
        Boolean bl = this.zzar("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzhk() {
        zzec zzec2 = ((zzhh)this).zzgi();
        return this.zzar("firebase_analytics_collection_enabled");
    }

    public static long zzhl() {
        return zzey.zzahs.get();
    }

    public static long zzhm() {
        return zzey.zzags.get();
    }

    public final String zzhn() {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzhh)this).zzgf().zzis().zzg("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzhh)this).zzgf().zzis().zzg("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzhh)this).zzgf().zzis().zzg("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzhh)this).zzgf().zzis().zzg("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }

    public static boolean zzho() {
        return zzey.zzago.get();
    }

    public final boolean zzas(String string) {
        return "1".equals(this.zzaeu.zze(string, "gaia_collection_enabled"));
    }

    public final boolean zzat(String string) {
        return "1".equals(this.zzaeu.zze(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzau(String string) {
        return this.zzd(string, zzey.zzaib);
    }

    @WorkerThread
    final boolean zzav(String string) {
        return this.zzd(string, zzey.zzaid);
    }

    @WorkerThread
    final boolean zzaw(String string) {
        return this.zzd(string, zzey.zzaie);
    }

    @WorkerThread
    final boolean zzhp() {
        return this.zzd(((zzhh)this).zzfw().zzah(), zzey.zzahw);
    }

    @WorkerThread
    final String zzhq() {
        zzey.zza<String> zza2 = zzey.zzahx;
        String string = ((zzhh)this).zzfw().zzah();
        zzeg zzeg2 = this;
        if (string == null) {
            return zza2.get();
        }
        return zza2.get(zzeg2.zzaeu.zze(string, zza2.getKey()));
    }

    final boolean zzax(String string) {
        return this.zzd(string, zzey.zzaif);
    }

    @WorkerThread
    final boolean zzay(String string) {
        return this.zzd(string, zzey.zzaig);
    }

    @WorkerThread
    final boolean zzaz(String string) {
        return this.zzd(string, zzey.zzaij);
    }
}

