/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzabx;
import com.google.android.gms.internal.measurement.zzaby;
import com.google.android.gms.internal.measurement.zzaca;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzjn;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzkb;
import com.google.android.gms.internal.measurement.zzkc;
import com.google.android.gms.internal.measurement.zzkf;
import com.google.android.gms.internal.measurement.zzkg;
import com.google.android.gms.internal.measurement.zzkj;
import com.google.android.gms.internal.measurement.zzkp;
import com.google.android.gms.internal.measurement.zzkq;
import com.google.android.gms.internal.measurement.zzks;
import com.google.android.gms.internal.measurement.zzkt;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class zzej
extends zzjr {
    private static final String[] zzaew = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zzaex = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzaey = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;"};
    private static final String[] zzaez = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzafa = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzafb = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzem zzafc;
    private final zzjn zzafd = new zzjn(this.zzbt());

    zzej(zzjs zzjs2) {
        super(zzjs2);
        String string = "google_app_measurement.db";
        this.zzafc = new zzem(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzch();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzch();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzch();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzgf().zzis().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzab();
        try {
            return this.zzafc.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zziv().zzg("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzes zzf(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Boolean bl = null;
            if (!cursor.isNull(6)) {
                bl = cursor.getLong(6) == 1L;
            }
            zzes zzes2 = new zzes(string, string2, l, l2, l3, l4, l5, l6, bl);
            if (cursor.moveToNext()) {
                this.zzgf().zzis().zzg("Got multiple records for event aggregates, expected one. appId", zzfh.zzbl(string));
            }
            zzes zzes3 = zzes2;
            return zzes3;
        }
    }

    @WorkerThread
    public final void zza(zzes zzes2) {
        Preconditions.checkNotNull((Object)zzes2);
        this.zzab();
        this.zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzes2.zzti);
        contentValues.put("name", zzes2.name);
        contentValues.put("lifetime_count", Long.valueOf(zzes2.zzafs));
        contentValues.put("current_bundle_count", Long.valueOf(zzes2.zzaft));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzes2.zzafu));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzes2.zzafv));
        contentValues.put("last_sampled_complex_event_id", zzes2.zzafw);
        contentValues.put("last_sampling_rate", zzes2.zzafx);
        Long l = null;
        if (zzes2.zzafy != null && zzes2.zzafy.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzgf().zzis().zzg("Failed to insert/update event aggregates (got -1). appId", zzfh.zzbl(zzes2.zzti));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Error storing event aggregates. appId", zzfh.zzbl(zzes2.zzti), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzg(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzgf().zziz().zzg("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zzd("Error deleting user attribute. appId", zzfh.zzbl(string), this.zzgb().zzbk(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzkb zzkb2) {
        Preconditions.checkNotNull((Object)zzkb2);
        this.zzab();
        this.zzch();
        if (this.zzh(zzkb2.zzti, zzkb2.name) == null && (zzkc.zzcb(zzkb2.name) ? this.zza("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzkb2.zzti}) >= 25L : this.zza("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzkb2.zzti, zzkb2.origin}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzkb2.zzti);
        contentValues.put("origin", zzkb2.origin);
        contentValues.put("name", zzkb2.name);
        contentValues.put("set_timestamp", Long.valueOf(zzkb2.zzarl));
        zzej.zza(contentValues, "value", zzkb2.value);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzgf().zzis().zzg("Failed to insert/update user property (got -1). appId", zzfh.zzbl(zzkb2.zzti));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Error storing user property. appId", zzfh.zzbl(zzkb2.zzti), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzkb zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzkb zzkb2 = new zzkb(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzgf().zzis().zzg("Got multiple records for user property, expected one. appId", zzfh.zzbl(string));
            }
            zzkb zzkb3 = zzkb2;
            return zzkb3;
        }
    }

    @WorkerThread
    public final List<zzkb> zzba(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<zzkb> arrayList = new ArrayList<zzkb>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzkb> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzgf().zzis().zzg("Read invalid user property value, ignoring it. appId", zzfh.zzbl(string));
                    continue;
                }
                zzkb zzkb2 = new zzkb(string, string2, (String)object, l, object2);
                arrayList.add(zzkb2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzkb> zzb(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<zzkb> arrayList = new ArrayList<zzkb>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzkb> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgf().zzis().zzg("Read more than the max allowed user properties, ignoring excess", 1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzgf().zzis().zzd("(2)Read invalid user property value, ignoring it", zzfh.zzbl(string), string2, string3);
                    continue;
                }
                zzkb zzkb2 = new zzkb(string, string2, (String)object, l, object2);
                arrayList.add(zzkb2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzee zzee2) {
        Preconditions.checkNotNull((Object)((Object)zzee2));
        this.zzab();
        this.zzch();
        if (this.zzh(zzee2.packageName, zzee2.zzaeq.name) == null && this.zza("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzee2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzee2.packageName);
        contentValues.put("origin", zzee2.origin);
        contentValues.put("name", zzee2.zzaeq.name);
        zzej.zza(contentValues, "value", zzee2.zzaeq.getValue());
        contentValues.put("active", Boolean.valueOf(zzee2.active));
        contentValues.put("trigger_event_name", zzee2.triggerEventName);
        contentValues.put("trigger_timeout", Long.valueOf(zzee2.triggerTimeout));
        this.zzgc();
        contentValues.put("timed_out_event", zzkc.zza((Parcelable)zzee2.zzaer));
        contentValues.put("creation_timestamp", Long.valueOf(zzee2.creationTimestamp));
        this.zzgc();
        contentValues.put("triggered_event", zzkc.zza((Parcelable)zzee2.zzaes));
        contentValues.put("triggered_timestamp", Long.valueOf(zzee2.zzaeq.zzarl));
        contentValues.put("time_to_live", Long.valueOf(zzee2.timeToLive));
        this.zzgc();
        contentValues.put("expired_event", zzkc.zza((Parcelable)zzee2.zzaet));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzgf().zzis().zzg("Failed to insert/update conditional user property (got -1)", zzfh.zzbl(zzee2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Error storing conditional user property", zzfh.zzbl(zzee2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzee zzi(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzew zzew2 = this.zzgc().zza(cursor.getBlob(5), zzew.CREATOR);
            long l2 = cursor.getLong(6);
            zzew zzew3 = this.zzgc().zza(cursor.getBlob(7), zzew.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzew zzew4 = this.zzgc().zza(cursor.getBlob(10), zzew.CREATOR);
            zzjz zzjz2 = new zzjz(string2, l3, object, string3);
            zzee zzee2 = new zzee(string, string3, zzjz2, l2, bl, string4, zzew2, l, zzew3, l4, zzew4);
            if (cursor.moveToNext()) {
                this.zzgf().zzis().zze("Got multiple records for conditional property, expected one", zzfh.zzbl(string), this.zzgb().zzbk(string2));
            }
            zzee zzee3 = zzee2;
            return zzee3;
        }
    }

    @WorkerThread
    public final int zzj(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zzd("Error deleting conditional property", zzfh.zzbl(string), this.zzgb().zzbk(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzee> zzc(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzb(stringBuilder.toString(), stringArray);
    }

    public final List<zzee> zzb(String string, String[] stringArray) {
        this.zzab();
        this.zzch();
        ArrayList<zzee> arrayList = new ArrayList<zzee>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzee> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgf().zzis().zzg("Read more than the max allowed conditional properties, ignoring extra", 1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzew zzew2 = this.zzgc().zza(cursor.getBlob(7), zzew.CREATOR);
                long l2 = cursor.getLong(8);
                zzew zzew3 = this.zzgc().zza(cursor.getBlob(9), zzew.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzew zzew4 = this.zzgc().zza(cursor.getBlob(12), zzew.CREATOR);
                zzjz zzjz2 = new zzjz(string3, l3, object2, string2);
                zzee zzee2 = new zzee((String)object, string2, zzjz2, l2, bl, string4, zzew2, l, zzew3, l4, zzew4);
                arrayList.add(zzee2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzdy zzbb(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "ssaid_reporting_enabled"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzdy zzdy2 = new zzdy(this.zzajy.zzlj(), string);
            zzdy2.zzak(cursor.getString(0));
            zzdy2.zzal(cursor.getString(1));
            zzdy2.zzam(cursor.getString(2));
            zzdy2.zzr(cursor.getLong(3));
            zzdy2.zzm(cursor.getLong(4));
            zzdy2.zzn(cursor.getLong(5));
            zzdy2.setAppVersion(cursor.getString(6));
            zzdy2.zzao(cursor.getString(7));
            zzdy2.zzp(cursor.getLong(8));
            zzdy2.zzq(cursor.getLong(9));
            zzdy2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzdy2.zzu(cursor.getLong(11));
            zzdy2.zzv(cursor.getLong(12));
            zzdy2.zzw(cursor.getLong(13));
            zzdy2.zzx(cursor.getLong(14));
            zzdy2.zzs(cursor.getLong(15));
            zzdy2.zzt(cursor.getLong(16));
            zzdy2.zzo(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzdy2.zzan(cursor.getString(18));
            zzdy2.zzz(cursor.getLong(19));
            zzdy2.zzy(cursor.getLong(20));
            zzdy2.zzap(cursor.getString(21));
            zzdy2.zzaa(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzdy2.zzd(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzdy2.zze(cursor.isNull(24) || cursor.getInt(24) != 0);
            zzdy2.zzgj();
            if (cursor.moveToNext()) {
                this.zzgf().zzis().zzg("Got multiple records for app, expected one. appId", zzfh.zzbl(string));
            }
            zzdy zzdy3 = zzdy2;
            return zzdy3;
        }
    }

    @WorkerThread
    public final void zza(zzdy zzdy2) {
        Preconditions.checkNotNull((Object)zzdy2);
        this.zzab();
        this.zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzdy2.zzah());
        contentValues.put("app_instance_id", zzdy2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzdy2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzdy2.zzgk());
        contentValues.put("last_bundle_index", Long.valueOf(zzdy2.zzgs()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzdy2.zzgm()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzdy2.zzgn()));
        contentValues.put("app_version", zzdy2.zzag());
        contentValues.put("app_store", zzdy2.zzgp());
        contentValues.put("gmp_version", Long.valueOf(zzdy2.zzgq()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzdy2.zzgr()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzdy2.isMeasurementEnabled()));
        contentValues.put("day", Long.valueOf(zzdy2.zzgw()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzdy2.zzgx()));
        contentValues.put("daily_events_count", Long.valueOf(zzdy2.zzgy()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzdy2.zzgz()));
        contentValues.put("config_fetched_time", Long.valueOf(zzdy2.zzgt()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzdy2.zzgu()));
        contentValues.put("app_version_int", Long.valueOf(zzdy2.zzgo()));
        contentValues.put("firebase_instance_id", zzdy2.zzgl());
        contentValues.put("daily_error_events_count", Long.valueOf(zzdy2.zzhb()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzdy2.zzha()));
        contentValues.put("health_monitor_sample", zzdy2.zzhc());
        contentValues.put("android_id", Long.valueOf(zzdy2.zzhe()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzdy2.zzhf()));
        contentValues.put("ssaid_reporting_enabled", Boolean.valueOf(zzdy2.zzhg()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzdy2.zzah()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzgf().zzis().zzg("Failed to insert/update app (got -1). appId", zzfh.zzbl(zzdy2.zzah()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Error storing app. appId", zzfh.zzbl(zzdy2.zzah()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzbc(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzgh().zzb(string2, zzey.zzahe);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Error deleting over the limit events. appId", zzfh.zzbl(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzek zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        String[] stringArray = new String[]{string};
        zzek zzek2 = new zzek();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzgf().zziv().zzg("Not updating daily counts, app is not known. appId", zzfh.zzbl(string));
                zzek zzek3 = zzek2;
                return zzek3;
            }
            if (cursor.getLong(0) == l) {
                zzek2.zzaff = cursor.getLong(1);
                zzek2.zzafe = cursor.getLong(2);
                zzek2.zzafg = cursor.getLong(3);
                zzek2.zzafh = cursor.getLong(4);
                zzek2.zzafi = cursor.getLong(5);
            }
            if (bl) {
                ++zzek2.zzaff;
            }
            if (bl2) {
                ++zzek2.zzafe;
            }
            if (bl3) {
                ++zzek2.zzafg;
            }
            if (bl4) {
                ++zzek2.zzafh;
            }
            if (bl5) {
                ++zzek2.zzafi;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzek2.zzafe));
            contentValues.put("daily_events_count", Long.valueOf(zzek2.zzaff));
            contentValues.put("daily_conversions_count", Long.valueOf(zzek2.zzafg));
            contentValues.put("daily_error_events_count", Long.valueOf(zzek2.zzafh));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzek2.zzafi));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzek zzek4 = zzek2;
            return zzek4;
        }
    }

    @WorkerThread
    public final byte[] zzbd(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzgf().zzis().zzg("Got multiple records for app config, expected one. appId", zzfh.zzbl(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzks zzks2, boolean bl) {
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzks2));
        Preconditions.checkNotEmpty((String)zzks2.zzti);
        Preconditions.checkNotNull((Object)zzks2.zzaty);
        this.zzht();
        long l = this.zzbt().currentTimeMillis();
        if (zzks2.zzaty < l - zzeg.zzhl() || zzks2.zzaty > l + zzeg.zzhl()) {
            this.zzgf().zziv().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzfh.zzbl(zzks2.zzti), l, zzks2.zzaty);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzks2.zzvv()];
            zzaby zzaby2 = zzaby.zzb((byte[])byArray2, (int)0, (int)byArray3.length);
            zzks2.zza(zzaby2);
            zzaby2.zzvn();
            byArray = this.zzgc().zza(byArray2);
        }
        catch (IOException iOException) {
            this.zzgf().zzis().zze("Data loss. Failed to serialize bundle. appId", zzfh.zzbl(zzks2.zzti), iOException);
            return false;
        }
        this.zzgf().zziz().zzg("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzks2.zzti);
        contentValues.put("bundle_end_timestamp", zzks2.zzaty);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzks2.zzauv != null) {
            contentValues.put("retry_count", zzks2.zzauv);
        }
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzgf().zzis().zzg("Failed to insert bundle (got -1). appId", zzfh.zzbl(zzks2.zzti));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Error storing bundle. appId", zzfh.zzbl(zzks2.zzti), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzhr() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzhs() {
        return this.zza("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzks, Long>> zzb(String string, int n, int n2) {
        this.zzab();
        this.zzch();
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzks, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzks, Long>> arrayList = new ArrayList<Pair<zzks, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzgc().zzb((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzgf().zzis().zze("Failed to unzip queued bundle. appId", zzfh.zzbl(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzabx.zza((byte[])byArray, (int)0, (int)byArray2.length);
                zzks zzks2 = new zzks();
                try {
                    zzks2.zzb((zzabx)object);
                }
                catch (IOException iOException) {
                    this.zzgf().zzis().zze("Failed to merge queued bundle. appId", zzfh.zzbl(string), iOException);
                    continue;
                }
                if (!cursor.isNull(2)) {
                    zzks2.zzauv = cursor.getInt(2);
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzks, Long>)Pair.create((Object)((Object)zzks2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzks, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzht() {
        this.zzab();
        this.zzch();
        if (!this.zzhz()) {
            return;
        }
        long l = this.zzgg().zzakg.get();
        long l2 = this.zzbt().elapsedRealtime();
        if (Math.abs(l2 - l) > zzey.zzahn.get()) {
            this.zzgg().zzakg.set(l2);
            zzej zzej2 = this;
            zzej2.zzab();
            zzej2.zzch();
            if (zzej2.zzhz()) {
                SQLiteDatabase sQLiteDatabase = zzej2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzej2.zzbt().currentTimeMillis()), String.valueOf(zzeg.zzhl())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzej2.zzgf().zziz().zzg("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzc(List<Long> list) {
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzhz()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
        if (this.zza(new StringBuilder(80 + String.valueOf(string2).length()).append("SELECT COUNT(1) FROM queue WHERE rowid IN ").append(string2).append(" AND retry_count =  2147483647 LIMIT 1").toString(), (String[])null) > 0L) {
            this.zzgf().zziv().log("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            this.getWritableDatabase().execSQL(new StringBuilder(127 + String.valueOf(string2).length()).append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ").append(string2).append(" AND (retry_count IS NULL OR retry_count < 2147483647)").toString());
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zzg("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzkf[] zzkfArray) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzkfArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzej zzej2 = this;
            zzej2.zzch();
            zzej2.zzab();
            Preconditions.checkNotEmpty((String)string2);
            Object object = zzej2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzkfArray;
            int n2 = zzkfArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzkg zzkg2;
                int n3;
                int n4;
                zzkf zzkf2 = object2[n];
                object = zzkf2;
                string2 = string;
                zzej2 = this;
                zzej2.zzch();
                zzej2.zzab();
                Preconditions.checkNotEmpty((String)string2);
                Preconditions.checkNotNull((Object)object);
                Preconditions.checkNotNull((Object)object.zzarz);
                Preconditions.checkNotNull((Object)object.zzary);
                if (object.zzarx == null) {
                    zzej2.zzgf().zziv().zzg("Audience with no ID. appId", zzfh.zzbl(string2));
                    continue;
                }
                int n5 = object.zzarx;
                zzaca[] zzacaArray = object.zzarz;
                int n6 = object.zzarz.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzacaArray[n4].zzasb != null) continue;
                    zzej2.zzgf().zziv().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzfh.zzbl(string2), object.zzarx);
                    continue block3;
                }
                zzacaArray = object.zzary;
                n6 = object.zzary.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzacaArray[n4].zzasb != null) continue;
                    zzej2.zzgf().zziv().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzfh.zzbl(string2), object.zzarx);
                    continue block3;
                }
                boolean bl = true;
                zzaca[] zzacaArray2 = object.zzarz;
                n4 = object.zzarz.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzkg2 = zzacaArray2[n3];
                    if (zzej2.zza(string2, n5, zzkg2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzacaArray2 = object.zzary;
                    n4 = object.zzary.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzkg2 = zzacaArray2[n3];
                        if (zzej2.zza(string2, n5, (zzkj)((Object)zzkg2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzej zzej3 = zzej2;
                zzej3.zzch();
                zzej3.zzab();
                Preconditions.checkNotEmpty((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzej3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzkf[] zzkfArray2 = zzkfArray;
            n = zzkfArray.length;
            for (int i = 0; i < n; ++i) {
                zzkf zzkf3 = zzkfArray2[i];
                object2.add(zzkf3.zzarx);
            }
            this.zza(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzkg zzkg2) {
        byte[] byArray;
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzkg2));
        if (TextUtils.isEmpty((CharSequence)zzkg2.zzasc)) {
            this.zzgf().zziv().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzfh.zzbl(string), n, String.valueOf(zzkg2.zzasb));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzkg2.zzvv()];
            zzaby zzaby2 = zzaby.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkg2.zza(zzaby2);
            zzaby2.zzvn();
        }
        catch (IOException iOException) {
            this.zzgf().zzis().zze("Configuration loss. Failed to serialize event filter. appId", zzfh.zzbl(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzkg2.zzasb);
        contentValues.put("event_name", zzkg2.zzasc);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzgf().zzis().zzg("Failed to insert event filter (got -1). appId", zzfh.zzbl(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Error storing event filter. appId", zzfh.zzbl(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzkj zzkj2) {
        byte[] byArray;
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzkj2));
        if (TextUtils.isEmpty((CharSequence)zzkj2.zzasr)) {
            this.zzgf().zziv().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzfh.zzbl(string), n, String.valueOf(zzkj2.zzasb));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzkj2.zzvv()];
            zzaby zzaby2 = zzaby.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkj2.zza(zzaby2);
            zzaby2.zzvn();
        }
        catch (IOException iOException) {
            this.zzgf().zzis().zze("Configuration loss. Failed to serialize property filter. appId", zzfh.zzbl(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzkj2.zzasb);
        contentValues.put("property_name", zzkj2.zzasr);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzgf().zzis().zzg("Failed to insert property filter (got -1). appId", zzfh.zzbl(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Error storing property filter. appId", zzfh.zzbl(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzkg>> zzk(String string, String string2) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzkg>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzabx zzabx2 = zzabx.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzkg zzkg2 = new zzkg();
                try {
                    zzkg2.zzb(zzabx2);
                }
                catch (IOException iOException) {
                    this.zzgf().zzis().zze("Failed to merge filter. appId", zzfh.zzbl(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzkg> arrayList = (ArrayList<zzkg>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzkg>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzkg2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzkj>> zzl(String string, String string2) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzkj>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzabx zzabx2 = zzabx.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzkj zzkj2 = new zzkj();
                try {
                    zzkj2.zzb(zzabx2);
                }
                catch (IOException iOException) {
                    this.zzgf().zzis().zze("Failed to merge filter", zzfh.zzbl(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzkj> arrayList = (ArrayList<zzkj>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzkj>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzkj2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zza(String string, List<Integer> list) {
        Object object;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzch();
        this.zzab();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zza("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Database error querying filters. appId", zzfh.zzbl(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzgh().zzb(string2, zzey.zzahu);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzkt> zzbe(String string) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzabx zzabx2 = zzabx.zza((byte[])byArray, (int)0, (int)byArray.length);
                zzkt zzkt2 = new zzkt();
                try {
                    zzkt2.zzb(zzabx2);
                }
                catch (IOException iOException) {
                    this.zzgf().zzis().zzd("Failed to merge filter results. appId, audienceId, error", zzfh.zzbl(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzkt2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @VisibleForTesting
    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzgf().zzis().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzgf().zzis().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzgf().zzis().zzg("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzhu() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzm(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzab();
        this.zzch();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzgf().zzis().zze("Failed to insert column (got -1). appId", zzfh.zzbl(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzgf().zzis().zze("Failed to update column (got 0). appId", zzfh.zzbl(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zzd("Error inserting column. appId", zzfh.zzbl(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzhv() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzks zzks2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzks2));
        Preconditions.checkNotEmpty((String)zzks2.zzti);
        try {
            byArray = new byte[zzks2.zzvv()];
            object = byArray;
            zzaby zzaby2 = zzaby.zzb((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzks2.zza(zzaby2);
            zzaby2.zzvn();
        }
        catch (IOException iOException) {
            this.zzgf().zzis().zze("Data loss. Failed to serialize event metadata. appId", zzfh.zzbl(zzks2.zzti), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzgc();
        Preconditions.checkNotNull((Object)byArray2);
        ((zzhh)object).zzab();
        MessageDigest messageDigest = zzkc.getMessageDigest("MD5");
        if (messageDigest == null) {
            ((zzhh)object).zzgf().zzis().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzkc.zzc(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzks2.zzti);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Error storing raw event metadata. appId", zzfh.zzbl(zzks2.zzti), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzhw() {
        return this.zza("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzhx() {
        return this.zza("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final long zzbf(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzab(long l) {
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgf().zziz().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzhy() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzkp, Long> zza(String string, Long l) {
        this.zzab();
        this.zzch();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgf().zziz().log("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            byte[] byArray2 = byArray;
            zzabx zzabx2 = zzabx.zza((byte[])byArray, (int)0, (int)byArray2.length);
            zzkp zzkp2 = new zzkp();
            try {
                zzkp2.zzb(zzabx2);
            }
            catch (IOException iOException) {
                this.zzgf().zzis().zzd("Failed to merge main event. appId, eventId", zzfh.zzbl(string), l, iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzkp2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzkp zzkp2) {
        byte[] byArray;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)((Object)zzkp2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        try {
            byte[] byArray2 = byArray = new byte[zzkp2.zzvv()];
            zzaby zzaby2 = zzaby.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkp2.zza(zzaby2);
            zzaby2.zzvn();
        }
        catch (IOException iOException) {
            this.zzgf().zzis().zzd("Data loss. Failed to serialize event params/data. appId, eventId", zzfh.zzbl(string), l, iOException);
            return false;
        }
        this.zzgf().zziz().zze("Saving complex main event, appId, data size", this.zzgb().zzbi(string), byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzgf().zzis().zzg("Failed to insert complex main event (got -1). appId", zzfh.zzbl(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Error storing complex main event. appId", zzfh.zzbl(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzer zzer2, long l, boolean bl) {
        Object object;
        zzkq zzkq2;
        String string2;
        this.zzab();
        this.zzch();
        Preconditions.checkNotNull((Object)zzer2);
        Preconditions.checkNotEmpty((String)zzer2.zzti);
        zzkp zzkp2 = new zzkp();
        new zzkp().zzato = zzer2.zzafq;
        zzkp2.zzatm = new zzkq[zzer2.zzafr.size()];
        int n = 0;
        for (String string2 : zzer2.zzafr) {
            zzkq2 = new zzkq();
            zzkp2.zzatm[n++] = zzkq2;
            zzkq2.name = string2;
            Object object2 = zzer2.zzafr.get(string2);
            this.zzjc().zza(zzkq2, object2);
        }
        try {
            byte[] byArray = new byte[zzkp2.zzvv()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzkq2 = zzaby.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkp2.zza((zzaby)zzkq2);
            zzkq2.zzvn();
        }
        catch (IOException iOException) {
            this.zzgf().zzis().zze("Data loss. Failed to serialize event params/data. appId", zzfh.zzbl(zzer2.zzti), iOException);
            return false;
        }
        this.zzgf().zziz().zze("Saving event, name, data size", this.zzgb().zzbi(zzer2.name), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzer2.zzti);
        string2.put("name", zzer2.name);
        string2.put("timestamp", Long.valueOf(zzer2.timestamp));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzgf().zzis().zzg("Failed to insert raw event (got -1). appId", zzfh.zzbl(zzer2.zzti));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgf().zzis().zze("Error storing raw event. appId", zzfh.zzbl(zzer2.zzti), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzhz() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    static /* synthetic */ zzjn zza(zzej zzej2) {
        return zzej2.zzafd;
    }

    static /* synthetic */ String[] zzia() {
        return zzaew;
    }

    static /* synthetic */ String[] zzib() {
        return zzaex;
    }

    static /* synthetic */ String[] zzic() {
        return zzaey;
    }

    static /* synthetic */ String[] zzid() {
        return zzafa;
    }

    static /* synthetic */ String[] zzie() {
        return zzaez;
    }

    static /* synthetic */ String[] zzif() {
        return zzafb;
    }
}

