/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzkc;
import java.util.ArrayList;
import java.util.List;

public final class zzfd
extends zzhi {
    private final zzfe zzaip = new zzfe(this, ((zzhh)this).getContext(), "google_app_measurement_local.db");
    private boolean zzaiq;

    zzfd(zzgm zzgm2) {
        super(zzgm2);
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    @WorkerThread
    public final void resetAnalyticsData() {
        ((zzhh)this).zzfs();
        ((zzhh)this).zzab();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = 0 + sQLiteDatabase.delete("messages", null, null);
            if (n > 0) {
                ((zzhh)this).zzgf().zziz().zzg("Reset local analytics data. records", n);
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            ((zzhh)this).zzgf().zzis().zzg("Error resetting local analytics data. error", (Object)sQLiteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zza(int n, byte[] byArray) {
        ((zzhh)this).zzfs();
        ((zzhh)this).zzab();
        if (this.zzaiq) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block20: {
                if (n3 >= 5) {
                    ((zzhh)this).zzgf().zziv().log("Failed to write entry to local database");
                    return false;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.beginTransaction();
                        long l = 0L;
                        cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                        if (cursor != null && cursor.moveToFirst()) {
                            l = cursor.getLong(0);
                        }
                        if (l >= 100000L) {
                            ((zzhh)this).zzgf().zzis().log("Data loss, local db full");
                            long l2 = 100000L - l + 1L;
                            long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                            if (l3 != l2) {
                                ((zzhh)this).zzgf().zzis().zzd("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                            }
                        }
                        sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        return true;
                    }
                    this.zzaiq = true;
                    if (sQLiteDatabase == null) return false;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzhh)this).zzgf().zzis().zzg("Error writing entry to local database", (Object)sQLiteFullException);
                    this.zzaiq = true;
                    break block20;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block20;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzhh)this).zzgf().zzis().zzg("Error writing entry to local database", (Object)sQLiteException);
                    this.zzaiq = true;
                    break block20;
                }
                sQLiteDatabase.close();
                return false;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    public final boolean zza(zzew zzew2) {
        Parcel parcel = Parcel.obtain();
        zzew2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzhh)this).zzgf().zziv().log("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zza(0, byArray);
    }

    public final boolean zza(zzjz zzjz2) {
        Parcel parcel = Parcel.obtain();
        zzjz2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzhh)this).zzgf().zziv().log("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(1, byArray);
    }

    public final boolean zzc(zzee zzee2) {
        ((zzhh)this).zzgc();
        byte[] byArray = zzkc.zza((Parcelable)zzee2);
        if (byArray.length > 131072) {
            ((zzhh)this).zzgf().zziv().log("Conditional user property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(2, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List<AbstractSafeParcelable> zzp(int n) {
        ((zzhh)this).zzab();
        ((zzhh)this).zzfs();
        if (this.zzaiq) {
            return null;
        }
        ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
        if (!((zzhh)this).getContext().getDatabasePath("google_app_measurement_local.db").exists()) {
            return arrayList;
        }
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block41: {
                if (n3 >= 5) {
                    ((zzhh)this).zzgf().zziv().log("Failed to read events from database in reasonable time");
                    return null;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        Object object;
                        sQLiteDatabase.beginTransaction();
                        cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, null, null, null, null, "rowid asc", Integer.toString(100));
                        long l = -1L;
                        while (cursor.moveToNext()) {
                            AbstractSafeParcelable abstractSafeParcelable;
                            Parcel parcel;
                            l = cursor.getLong(0);
                            int n4 = cursor.getInt(1);
                            object = cursor.getBlob(2);
                            if (n4 == 0) {
                                parcel = Parcel.obtain();
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzew)((Object)zzew.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzhh)this).zzgf().zzis().log("Failed to load event from local database");
                                    continue;
                                }
                                finally {
                                    parcel.recycle();
                                    continue;
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            if (n4 == 1) {
                                parcel = Parcel.obtain();
                                abstractSafeParcelable = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzjz)((Object)zzjz.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzhh)this).zzgf().zzis().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            if (n4 == 2) {
                                parcel = Parcel.obtain();
                                abstractSafeParcelable = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzee)((Object)zzee.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzhh)this).zzgf().zzis().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            ((zzhh)this).zzgf().zzis().log("Unknown record type in local database");
                        }
                        if (sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l)}) < arrayList.size()) {
                            ((zzhh)this).zzgf().zzis().log("Fewer entries removed from local database than expected");
                        }
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        object = arrayList;
                        return object;
                    }
                    this.zzaiq = true;
                    if (sQLiteDatabase == null) return null;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzhh)this).zzgf().zzis().zzg("Error reading entries from local database", (Object)sQLiteFullException);
                    this.zzaiq = true;
                    break block41;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block41;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzhh)this).zzgf().zzis().zzg("Error reading entries from local database", (Object)sQLiteException);
                    this.zzaiq = true;
                    break block41;
                }
                sQLiteDatabase.close();
                return null;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    @VisibleForTesting
    @WorkerThread
    private final SQLiteDatabase getWritableDatabase() throws SQLiteException {
        if (this.zzaiq) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zzaip.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zzaiq = true;
            return null;
        }
        return sQLiteDatabase;
    }
}

