/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.support.annotation.GuardedBy;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.internal.measurement.zzgh;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.measurement.AppMeasurement;

public final class zzfh
extends zzhi {
    private char zzaiv = '\u0000';
    private long zzadu = -1L;
    @GuardedBy(value="this")
    private String zzaiw;
    private final zzfj zzaix = new zzfj(this, 6, false, false);
    private final zzfj zzaiy = new zzfj(this, 6, true, false);
    private final zzfj zzaiz = new zzfj(this, 6, false, true);
    private final zzfj zzaja = new zzfj(this, 5, false, false);
    private final zzfj zzajb = new zzfj(this, 5, true, false);
    private final zzfj zzajc = new zzfj(this, 5, false, true);
    private final zzfj zzajd = new zzfj(this, 4, false, false);
    private final zzfj zzaje = new zzfj(this, 3, false, false);
    private final zzfj zzajf = new zzfj(this, 2, false, false);

    zzfh(zzgm zzgm2) {
        super(zzgm2);
    }

    public final zzfj zzis() {
        return this.zzaix;
    }

    public final zzfj zzit() {
        return this.zzaiy;
    }

    public final zzfj zziu() {
        return this.zzaiz;
    }

    public final zzfj zziv() {
        return this.zzaja;
    }

    public final zzfj zziw() {
        return this.zzajc;
    }

    public final zzfj zzix() {
        return this.zzajd;
    }

    public final zzfj zziy() {
        return this.zzaje;
    }

    public final zzfj zziz() {
        return this.zzajf;
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    protected static Object zzbl(String string) {
        if (string == null) {
            return null;
        }
        return new zzfk(string);
    }

    protected final void zza(int n, boolean bl, boolean bl2, String string, Object object, Object object2, Object object3) {
        if (!bl && this.isLoggable(n)) {
            String string2 = zzfh.zza(false, string, object, object2, object3);
            this.zza(n, string2);
        }
        if (!bl2 && n >= 5) {
            Object object4 = object3;
            Object object5 = object2;
            Object object6 = object;
            String string3 = string;
            int n2 = n;
            zzfh zzfh2 = this;
            Preconditions.checkNotNull((Object)string3);
            zzgh zzgh2 = zzfh2.zzacw.zzjx();
            if (zzgh2 == null) {
                zzfh2.zza(6, "Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzgh2.isInitialized()) {
                zzfh2.zza(6, "Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= 9) {
                n2 = 8;
            }
            int n3 = n2;
            zzgh2.zzc(new zzfi(zzfh2, n3, string3, object6, object5, object4));
        }
    }

    @VisibleForTesting
    protected final boolean isLoggable(int n) {
        return Log.isLoggable((String)this.zzja(), (int)n);
    }

    @VisibleForTesting
    protected final void zza(int n, String string) {
        Log.println((int)n, (String)this.zzja(), (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String zzja() {
        zzfh zzfh2 = this;
        synchronized (zzfh2) {
            if (this.zzaiw == null) {
                this.zzaiw = zzeg.zzhi();
            }
            return this.zzaiw;
        }
    }

    static String zza(boolean bl, String string, Object object, Object object2, Object object3) {
        if (string == null) {
            string = "";
        }
        String string2 = zzfh.zza(bl, object);
        String string3 = zzfh.zza(bl, object2);
        String string4 = zzfh.zza(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string5 = ": ";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(string5);
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static String zza(boolean bl, Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            if (Math.abs((Long)object) < 100L) {
                return String.valueOf(object);
            }
            String string = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            String string2 = String.valueOf(Math.abs((Long)object));
            long l = Math.round(Math.pow(10.0, string2.length() - 1));
            long l2 = Math.round(Math.pow(10.0, string2.length()) - 1.0);
            return new StringBuilder(43 + String.valueOf(string).length() + String.valueOf(string).length()).append(string).append(l).append("...").append(string).append(l2).toString();
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StringBuilder stringBuilder = new StringBuilder(bl ? throwable.getClass().getName() : throwable.toString());
            String string = zzfh.zzbm(AppMeasurement.class.getCanonicalName());
            String string3 = zzfh.zzbm(zzgm.class.getCanonicalName());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string4;
                String string5;
                if (stackTraceElement.isNativeMethod() || (string5 = stackTraceElement.getClassName()) == null || !(string4 = zzfh.zzbm(string5)).equals(string) && !string4.equals(string3)) continue;
                stringBuilder.append(": ");
                stringBuilder.append(stackTraceElement);
                break;
            }
            return stringBuilder.toString();
        }
        if (object instanceof zzfk) {
            return zzfk.zza((zzfk)object);
        }
        if (bl) {
            return "-";
        }
        return String.valueOf(object);
    }

    private static String zzbm(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public final String zzjb() {
        Pair<String, Long> pair = ((zzhh)this).zzgg().zzakc.zzfi();
        if (pair == null || pair == zzfs.zzakb) {
            return null;
        }
        String string = String.valueOf(pair.second);
        String string2 = (String)pair.first;
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString();
    }

    static /* synthetic */ char zza(zzfh zzfh2) {
        return zzfh2.zzaiv;
    }

    static /* synthetic */ char zza(zzfh zzfh2, char c) {
        zzfh2.zzaiv = c;
        return zzfh2.zzaiv;
    }

    static /* synthetic */ long zzb(zzfh zzfh2) {
        return zzfh2.zzadu;
    }

    static /* synthetic */ long zza(zzfh zzfh2, long l) {
        zzfh2.zzadu = 12451L;
        return 12451L;
    }
}

