/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzga;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzr;
import java.util.List;

public final class zzfy {
    private final zzgm zzacw;
    @VisibleForTesting
    volatile zzr zzalf;
    @VisibleForTesting
    private ServiceConnection zzalg;

    zzfy(zzgm zzgm2) {
        this.zzacw = zzgm2;
    }

    @WorkerThread
    protected final void zzjo() {
        zzec zzec2 = this.zzacw.zzgi();
        ((zzhh)this.zzacw.zzge()).zzab();
        if (!this.zzjp()) {
            this.zzacw.zzgf().zzix().log("Install Referrer Reporter is not available");
            this.zzalg = null;
            return;
        }
        this.zzalg = new zzga(this, null);
        this.zzacw.zzgf().zzix().log("Install Referrer Reporter is initializing");
        zzfy zzfy2 = this;
        ((zzhh)zzfy2.zzacw.zzge()).zzab();
        Intent intent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
        intent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
        PackageManager packageManager = zzfy2.zzacw.getContext().getPackageManager();
        if (packageManager == null) {
            zzfy2.zzacw.zzgf().zziv().log("Failed to obtain Package Manager to verify binding conditions");
            return;
        }
        List list = packageManager.queryIntentServices(intent, 0);
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string = resolveInfo.serviceInfo.packageName;
                if (resolveInfo.serviceInfo.name != null && zzfy2.zzalg != null && "com.android.vending".equals(string) && zzfy2.zzjp()) {
                    Intent intent2 = new Intent(intent);
                    try {
                        boolean bl = ConnectionTracker.getInstance().bindService(zzfy2.zzacw.getContext(), intent2, zzfy2.zzalg, 1);
                        zzfy2.zzacw.zzgf().zzix().zzg("Install Referrer Service is", bl ? "available" : "not available");
                        return;
                    }
                    catch (Exception exception) {
                        zzfy2.zzacw.zzgf().zzis().zzg("Exception occurred while binding to Install Referrer Service", exception.getMessage());
                        return;
                    }
                }
                zzfy2.zzacw.zzgf().zzix().log("Play Store missing or incompatible. Version 8.3.73 or later required");
            }
            return;
        }
        zzfy2.zzacw.zzgf().zzix().log("Play Service for fetching Install Referrer is unavailable on device");
    }

    @VisibleForTesting
    private final boolean zzjp() {
        try {
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager((Context)this.zzacw.getContext());
            if (packageManagerWrapper == null) {
                this.zzacw.zzgf().zzix().log("Failed to retrieve Package Manager to check Play Store compatibility");
                return false;
            }
            return packageManagerWrapper.getPackageInfo((String)"com.android.vending", (int)128).versionCode >= 80837300;
        }
        catch (Exception exception) {
            this.zzacw.zzgf().zzix().zzg("Failed to retrieve Play Store version", exception);
            return false;
        }
    }

    @WorkerThread
    @Nullable
    @VisibleForTesting
    final Bundle zzjq() {
        Bundle bundle;
        ((zzhh)this.zzacw.zzge()).zzab();
        if (this.zzalf == null) {
            this.zzacw.zzgf().zziv().log("Attempting to use Install Referrer Service while it is not initialized");
            return null;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putString("package_name", this.zzacw.getContext().getPackageName());
        try {
            bundle = this.zzalf.zza(bundle2);
            if (bundle == null) {
                this.zzacw.zzgf().zzis().log("Install Referrer Service returned a null response");
                return null;
            }
        }
        catch (Exception exception) {
            this.zzacw.zzgf().zzis().zzg("Exception occurred while retrieving the Install Referrer", exception.getMessage());
            return null;
        }
        return bundle;
    }

    @WorkerThread
    @VisibleForTesting
    final void zzc(Bundle bundle) {
        long l;
        ((zzhh)this.zzacw.zzge()).zzab();
        if (bundle == null) {
            return;
        }
        long l2 = bundle.getLong("install_begin_timestamp_seconds", 0L) * 1000L;
        if (l2 == 0L) {
            this.zzacw.zzgf().zzis().log("Service response is missing Install Referrer install timestamp");
            return;
        }
        String string = bundle.getString("install_referrer");
        if (string == null || string.isEmpty()) {
            this.zzacw.zzgf().zzis().log("No referrer defined in install referrer response");
            return;
        }
        this.zzacw.zzgf().zziz().zzg("InstallReferrer API result", string);
        String string2 = String.valueOf(string);
        Bundle bundle2 = this.zzacw.zzgc().zza(Uri.parse((String)(string2.length() != 0 ? "?".concat(string2) : new String("?"))));
        if (bundle2 == null) {
            this.zzacw.zzgf().zzis().log("No campaign params defined in install referrer result");
            return;
        }
        String string3 = bundle2.getString("medium");
        if (string3 != null && !"(not set)".equalsIgnoreCase(string3) && !"organic".equalsIgnoreCase(string3)) {
            l = bundle.getLong("referrer_click_timestamp_seconds", 0L) * 1000L;
            if (l == 0L) {
                this.zzacw.zzgf().zzis().log("Install Referrer is missing click timestamp for ad campaign");
                return;
            }
            bundle2.putLong("click_timestamp", l);
        }
        if (l2 == (l = this.zzacw.zzgg().zzakj.get())) {
            this.zzacw.zzgf().zziz().log("Campaign has already been logged");
            return;
        }
        bundle2.putString("_cis", "referrer API");
        this.zzacw.zzgg().zzakj.set(l2);
        this.zzacw.zzfv().logEvent("auto", "_cmp", bundle2);
        if (this.zzalg != null) {
            ConnectionTracker.getInstance().unbindService(this.zzacw.getContext(), this.zzalg);
        }
    }

    static /* synthetic */ zzgm zza(zzfy zzfy2) {
        return zzfy2.zzacw;
    }
}

