/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzge;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzgm;

public final class zzgc {
    private final zzgf zzalj;

    public zzgc(zzgf zzgf2) {
        Preconditions.checkNotNull((Object)zzgf2);
        this.zzalj = zzgf2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzgm zzgm2 = zzgm.zza(context, null, null);
        zzfh zzfh2 = zzgm2.zzgf();
        if (intent == null) {
            zzfh2.zziv().log("Receiver called with null intent");
            return;
        }
        zzec zzec2 = zzgm2.zzgi();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzfh2.zziz().zzg("Device receiver got", string);
        } else {
            zzfh2.zziz().zzg("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzfh2.zziz().log("Starting wakeful intent.");
            this.zzalj.doStartService(context, intent2);
            return;
        }
        if (!bl && "com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                zzgm2.zzge().zzc(new zzgd(this, zzgm2, zzfh2));
            }
            catch (Exception exception) {
                zzfh2.zziv().zzg("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zzalj.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzfh2.zziz().log("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzfh2.zzix().zzg("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzgm2.zzgc().zza(uri);
            if (bundle == null) {
                zzfh2.zziz().log("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzfh2.zziv().log("Install referrer is missing timestamp");
                }
                zzgm2.zzge().zzc(new zzge(this, zzgm2, l, bundle, context, zzfh2, pendingResult));
            }
        }
    }
}

