/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzabx;
import com.google.android.gms.internal.measurement.zzaby;
import com.google.android.gms.internal.measurement.zzaca;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzjq;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzkc;
import com.google.android.gms.internal.measurement.zzkf;
import com.google.android.gms.internal.measurement.zzkg;
import com.google.android.gms.internal.measurement.zzkh;
import com.google.android.gms.internal.measurement.zzkj;
import com.google.android.gms.internal.measurement.zzkl;
import com.google.android.gms.internal.measurement.zzkm;
import com.google.android.gms.internal.measurement.zzkn;
import com.google.android.gms.measurement.AppMeasurement;
import java.io.IOException;
import java.util.Map;

public final class zzgg
extends zzjr
implements zzei {
    @VisibleForTesting
    private static int zzalo = 65535;
    @VisibleForTesting
    private static int zzalp = 2;
    private final Map<String, Map<String, String>> zzalq = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzalr = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzals = new ArrayMap();
    private final Map<String, zzkm> zzalt = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzalu;
    private final Map<String, String> zzalv = new ArrayMap();

    zzgg(zzjs zzjs2) {
        super(zzjs2);
        this.zzalu = new ArrayMap();
    }

    @WorkerThread
    private final void zzbs(String string) {
        this.zzch();
        ((zzhh)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzalt.get(string) == null) {
            byte[] byArray = ((zzjq)this).zzje().zzbd(string);
            if (byArray == null) {
                this.zzalq.put(string, null);
                this.zzalr.put(string, null);
                this.zzals.put(string, null);
                this.zzalt.put(string, null);
                this.zzalv.put(string, null);
                this.zzalu.put(string, null);
                return;
            }
            zzkm zzkm2 = this.zza(string, byArray);
            this.zzalq.put(string, zzgg.zza(zzkm2));
            this.zza(string, zzkm2);
            this.zzalt.put(string, zzkm2);
            this.zzalv.put(string, null);
        }
    }

    @WorkerThread
    protected final zzkm zzbt(String string) {
        this.zzch();
        ((zzhh)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        this.zzbs(string);
        return this.zzalt.get(string);
    }

    @WorkerThread
    protected final String zzbu(String string) {
        ((zzhh)this).zzab();
        return this.zzalv.get(string);
    }

    @WorkerThread
    protected final void zzbv(String string) {
        ((zzhh)this).zzab();
        this.zzalv.put(string, null);
    }

    @WorkerThread
    final void zzbw(String string) {
        ((zzhh)this).zzab();
        this.zzalt.remove(string);
    }

    @Override
    @WorkerThread
    public final String zze(String string, String string2) {
        ((zzhh)this).zzab();
        this.zzbs(string);
        Map<String, String> map = this.zzalq.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzkm zzkm2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzkm2 != null && zzkm2.zzatd != null) {
            zzkn[] zzknArray = zzkm2.zzatd;
            int n = zzkm2.zzatd.length;
            for (int i = 0; i < n; ++i) {
                zzkn zzkn2 = zzknArray[i];
                if (zzkn2 == null) continue;
                arrayMap.put(zzkn2.zzny, zzkn2.value);
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzkm zzkm2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zzkm2 != null && zzkm2.zzate != null) {
            zzkl[] zzklArray = zzkm2.zzate;
            int n = zzkm2.zzate.length;
            for (int i = 0; i < n; ++i) {
                zzkl zzkl2 = zzklArray[i];
                if (TextUtils.isEmpty((CharSequence)zzkl2.name)) {
                    ((zzhh)this).zzgf().zziv().log("EventConfig contained null event name");
                    continue;
                }
                String string2 = AppMeasurement.Event.zzaj(zzkl2.name);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzkl2.name = string2;
                }
                arrayMap.put(zzkl2.name, zzkl2.zzasy);
                arrayMap2.put(zzkl2.name, zzkl2.zzasz);
                if (zzkl2.zzata == null) continue;
                if (zzkl2.zzata < zzalp || zzkl2.zzata > zzalo) {
                    ((zzhh)this).zzgf().zziv().zze("Invalid sampling rate. Event name, sample rate", zzkl2.name, zzkl2.zzata);
                    continue;
                }
                arrayMap3.put(zzkl2.name, zzkl2.zzata);
            }
        }
        this.zzalr.put(string, (Map<String, Boolean>)arrayMap);
        this.zzals.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzalu.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzch();
        ((zzhh)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        zzkm zzkm2 = this.zza(string, byArray);
        if (zzkm2 == null) {
            return false;
        }
        this.zza(string, zzkm2);
        this.zzalt.put(string, zzkm2);
        this.zzalv.put(string, string2);
        this.zzalq.put(string, zzgg.zza(zzkm2));
        Object object = zzkm2.zzatf;
        String string3 = string;
        Object object2 = ((zzjq)this).zzjd();
        Preconditions.checkNotNull((Object)object);
        for (zzkf zzkf2 : object) {
            String string4;
            zzkg zzkg2;
            int n;
            zzaca[] zzacaArray = zzkf2.zzarz;
            int n2 = zzkf2.zzarz.length;
            for (n = 0; n < n2; ++n) {
                zzkg2 = zzacaArray[n];
                string4 = AppMeasurement.Event.zzaj(zzkg2.zzasc);
                if (string4 != null) {
                    zzkg2.zzasc = string4;
                }
                zzkh[] zzkhArray = zzkg2.zzasd;
                int n3 = zzkg2.zzasd.length;
                for (int i = 0; i < n3; ++i) {
                    zzkh zzkh2 = zzkhArray[i];
                    String string5 = AppMeasurement.Param.zzaj(zzkh2.zzask);
                    if (string5 == null) continue;
                    zzkh2.zzask = string5;
                }
            }
            zzacaArray = zzkf2.zzary;
            n2 = zzkf2.zzary.length;
            for (n = 0; n < n2; ++n) {
                zzkg2 = zzacaArray[n];
                string4 = AppMeasurement.UserProperty.zzaj(((zzkj)((Object)zzkg2)).zzasr);
                if (string4 == null) continue;
                ((zzkj)((Object)zzkg2)).zzasr = string4;
            }
        }
        ((zzjq)object2).zzje().zza(string3, (zzkf[])object);
        try {
            zzkm2.zzatf = null;
            byte[] byArray2 = new byte[zzkm2.zzvv()];
            object2 = byArray2;
            zzaby zzaby2 = zzaby.zzb((byte[])byArray2, (int)0, (int)((Object)object2).length);
            zzkm2.zza(zzaby2);
            byArray = byArray2;
        }
        catch (IOException iOException) {
            ((zzhh)this).zzgf().zziv().zze("Unable to serialize reduced-size config. Storing full config instead. appId", zzfh.zzbl(string), iOException);
        }
        object = byArray;
        string3 = string;
        object2 = ((zzjq)this).zzje();
        Preconditions.checkNotEmpty((String)string3);
        ((zzhh)object2).zzab();
        ((zzjr)object2).zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", (byte[])object);
        try {
            if ((long)((zzej)object2).getWritableDatabase().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                ((zzhh)object2).zzgf().zzis().zzg("Failed to update remote config (got 0). appId", zzfh.zzbl(string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            ((zzhh)object2).zzgf().zzis().zze("Error storing remote config. appId", zzfh.zzbl(string3), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    final boolean zzn(String string, String string2) {
        ((zzhh)this).zzab();
        this.zzbs(string);
        if (this.zzbx(string) && zzkc.zzch(string2)) {
            return true;
        }
        if (this.zzby(string) && zzkc.zzcb(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzalr.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzo(String string, String string2) {
        ((zzhh)this).zzab();
        this.zzbs(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzals.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzp(String string, String string2) {
        ((zzhh)this).zzab();
        this.zzbs(string);
        Map<String, Integer> map = this.zzalu.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    private final zzkm zza(String string, byte[] byArray) {
        if (byArray == null) {
            return new zzkm();
        }
        byte[] byArray2 = byArray;
        zzabx zzabx2 = zzabx.zza((byte[])byArray, (int)0, (int)byArray2.length);
        zzkm zzkm2 = new zzkm();
        try {
            zzkm2.zzb(zzabx2);
            ((zzhh)this).zzgf().zziz().zze("Parsed config. version, gmp_app_id", zzkm2.zzatb, zzkm2.zzadm);
        }
        catch (IOException iOException) {
            ((zzhh)this).zzgf().zziv().zze("Unable to merge remote config. appId", zzfh.zzbl(string), iOException);
            return new zzkm();
        }
        return zzkm2;
    }

    final boolean zzbx(String string) {
        return "1".equals(this.zze(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzby(String string) {
        return "1".equals(this.zze(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }
}

