/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzgj;
import com.google.android.gms.internal.measurement.zzgk;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhi;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzgh
extends zzhi {
    private ExecutorService zzalw;
    private zzgl zzalx;
    private zzgl zzaly;
    private final PriorityBlockingQueue<zzgk<?>> zzalz;
    private final BlockingQueue<zzgk<?>> zzama;
    private final Thread.UncaughtExceptionHandler zzamb;
    private final Thread.UncaughtExceptionHandler zzamc;
    private final Object zzamd = new Object();
    private final Semaphore zzame = new Semaphore(2);
    private volatile boolean zzamf;
    private static final AtomicLong zzamg = new AtomicLong(Long.MIN_VALUE);

    zzgh(zzgm zzgm2) {
        super(zzgm2);
        this.zzalz = new PriorityBlockingQueue();
        this.zzama = new LinkedBlockingQueue();
        this.zzamb = new zzgj(this, "Thread death: Uncaught exception on worker thread");
        this.zzamc = new zzgj(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    @Override
    public final void zzab() {
        if (Thread.currentThread() != this.zzalx) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzft() {
        if (Thread.currentThread() != this.zzaly) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzjr() {
        return Thread.currentThread() == this.zzalx;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull(callable);
        zzgk zzgk2 = new zzgk(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzalx) {
            if (!this.zzalz.isEmpty()) {
                ((zzhh)this).zzgf().zziv().log("Callable skipped the worker queue.");
            }
            zzgk2.run();
        } else {
            this.zza(zzgk2);
        }
        return zzgk2;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull(callable);
        zzgk zzgk2 = new zzgk(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzalx) {
            zzgk2.run();
        } else {
            this.zza(zzgk2);
        }
        return zzgk2;
    }

    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzgk(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzhh)this).zzge().zzc(runnable);
            try {
                atomicReference.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzhh)this).zzgf().zziv().log(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzhh)this).zzgf().zziv().log(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzgk<?> zzgk2) {
        Object object = this.zzamd;
        synchronized (object) {
            this.zzalz.add(zzgk2);
            if (this.zzalx == null) {
                this.zzalx = new zzgl(this, "Measurement Worker", this.zzalz);
                this.zzalx.setUncaughtExceptionHandler(this.zzamb);
                this.zzalx.start();
            } else {
                this.zzalx.zzju();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd(Runnable runnable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull((Object)runnable);
        zzgk zzgk2 = new zzgk(this, runnable, false, "Task exception on network thread");
        zzgh zzgh2 = this;
        Object object = zzgh2.zzamd;
        synchronized (object) {
            zzgh2.zzama.add(zzgk2);
            if (zzgh2.zzaly == null) {
                zzgh2.zzaly = new zzgl(zzgh2, "Measurement Network", zzgh2.zzama);
                zzgh2.zzaly.setUncaughtExceptionHandler(zzgh2.zzamc);
                zzgh2.zzaly.start();
            } else {
                zzgh2.zzaly.zzju();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzjs() {
        Object object = this.zzamd;
        synchronized (object) {
            if (this.zzalw == null) {
                this.zzalw = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzalw;
        }
    }

    static /* synthetic */ Semaphore zza(zzgh zzgh2) {
        return zzgh2.zzame;
    }

    static /* synthetic */ boolean zzb(zzgh zzgh2) {
        return zzgh2.zzamf;
    }

    static /* synthetic */ Object zzc(zzgh zzgh2) {
        return zzgh2.zzamd;
    }

    static /* synthetic */ zzgl zzd(zzgh zzgh2) {
        return zzgh2.zzalx;
    }

    static /* synthetic */ zzgl zza(zzgh zzgh2, zzgl zzgl2) {
        zzgh2.zzalx = null;
        return null;
    }

    static /* synthetic */ zzgl zze(zzgh zzgh2) {
        return zzgh2.zzaly;
    }

    static /* synthetic */ zzgl zzb(zzgh zzgh2, zzgl zzgl2) {
        zzgh2.zzaly = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzjt() {
        return zzamg;
    }
}

