/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzgp;
import com.google.android.gms.internal.measurement.zzgq;
import com.google.android.gms.internal.measurement.zzgr;
import com.google.android.gms.internal.measurement.zzgs;
import com.google.android.gms.internal.measurement.zzgt;
import com.google.android.gms.internal.measurement.zzgu;
import com.google.android.gms.internal.measurement.zzgv;
import com.google.android.gms.internal.measurement.zzgw;
import com.google.android.gms.internal.measurement.zzgx;
import com.google.android.gms.internal.measurement.zzgy;
import com.google.android.gms.internal.measurement.zzgz;
import com.google.android.gms.internal.measurement.zzha;
import com.google.android.gms.internal.measurement.zzhb;
import com.google.android.gms.internal.measurement.zzhc;
import com.google.android.gms.internal.measurement.zzhd;
import com.google.android.gms.internal.measurement.zzhe;
import com.google.android.gms.internal.measurement.zzhf;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzkb;
import com.google.android.gms.internal.measurement.zzkc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzgo
extends zzfa {
    private final zzjs zzajy;
    private Boolean zzanm;
    @Nullable
    private String zzann;

    public zzgo(zzjs zzjs2) {
        this(zzjs2, null);
    }

    private zzgo(zzjs zzjs2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzjs2);
        this.zzajy = zzjs2;
        this.zzann = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzdz zzdz2) {
        this.zzb(zzdz2, false);
        this.zze(new zzgp(this, zzdz2));
    }

    @Override
    @BinderThread
    public final void zza(zzew zzew2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzew2));
        this.zzb(zzdz2, false);
        this.zze(new zzgz(this, zzew2, zzdz2));
    }

    @Override
    @BinderThread
    public final void zza(zzew zzew2, String string, String string2) {
        Preconditions.checkNotNull((Object)((Object)zzew2));
        Preconditions.checkNotEmpty((String)string);
        this.zzc(string, true);
        this.zze(new zzha(this, zzew2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzew zzew2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzew2));
        this.zzc(string, true);
        this.zzajy.zzgf().zziy().zzg("Log and bundle. event", this.zzajy.zzgb().zzbi(zzew2.name));
        long l = this.zzajy.zzbt().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzajy.zzge().zzc(new zzhb(this, zzew2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzajy.zzgf().zzis().zzg("Log and bundle returned null. appId", zzfh.zzbl(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzajy.zzbt().nanoTime() / 1000000L;
            this.zzajy.zzgf().zziy().zzd("Log and bundle processed. event, size, time_ms", this.zzajy.zzgb().zzbi(zzew2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajy.zzgf().zzis().zzd("Failed to log and bundle. appId, event, error", zzfh.zzbl(string), this.zzajy.zzgb().zzbi(zzew2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzjz zzjz2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzjz2));
        this.zzb(zzdz2, false);
        if (zzjz2.getValue() == null) {
            this.zze(new zzhc(this, zzjz2, zzdz2));
            return;
        }
        this.zze(new zzhd(this, zzjz2, zzdz2));
    }

    @Override
    @BinderThread
    public final List<zzjz> zza(zzdz zzdz2, boolean bl) {
        this.zzb(zzdz2, false);
        Future<List<zzkb>> future = this.zzajy.zzge().zzb(new zzhe(this, zzdz2));
        try {
            List<zzkb> list = future.get();
            ArrayList<zzjz> arrayList = new ArrayList<zzjz>(list.size());
            for (zzkb zzkb2 : list) {
                if (!bl && zzkc.zzch(zzkb2.name)) continue;
                arrayList.add(new zzjz(zzkb2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajy.zzgf().zzis().zze("Failed to get user attributes. appId", zzfh.zzbl(zzdz2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzdz zzdz2) {
        this.zzb(zzdz2, false);
        this.zze(new zzhf(this, zzdz2));
    }

    @BinderThread
    private final void zzb(zzdz zzdz2, boolean bl) {
        Preconditions.checkNotNull((Object)((Object)zzdz2));
        this.zzc(zzdz2.packageName, false);
        this.zzajy.zzgc().zzcf(zzdz2.zzadm);
    }

    @BinderThread
    private final void zzc(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzajy.zzgf().zzis().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzgo zzgo2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzgo2 = this;
                    if (!bl2) break block9;
                    if (zzgo2.zzanm == null) {
                        zzgo2.zzanm = "com.google.android.gms".equals(zzgo2.zzann) || UidVerifier.isGooglePlayServicesUid((Context)zzgo2.zzajy.getContext(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzgo2.zzajy.getContext()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzgo2.zzanm.booleanValue()) break block10;
                }
                if (zzgo2.zzann == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzgo2.zzajy.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzgo2.zzann = string2;
                }
                if (!string2.equals(zzgo2.zzann)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzajy.zzgf().zzis().zzg("Measurement Service called with invalid calling package. appId", zzfh.zzbl(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zze(new zzhg(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzdz zzdz2) {
        this.zzb(zzdz2, false);
        return this.zzajy.zzh(zzdz2);
    }

    @Override
    @BinderThread
    public final void zza(zzee zzee2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzee2));
        Preconditions.checkNotNull((Object)((Object)zzee2.zzaeq));
        this.zzb(zzdz2, false);
        zzee zzee3 = new zzee(zzee2);
        new zzee(zzee2).packageName = zzdz2.packageName;
        if (zzee2.zzaeq.getValue() == null) {
            this.zze(new zzgq(this, zzee3, zzdz2));
            return;
        }
        this.zze(new zzgr(this, zzee3, zzdz2));
    }

    @Override
    @BinderThread
    public final void zzb(zzee zzee2) {
        Preconditions.checkNotNull((Object)((Object)zzee2));
        Preconditions.checkNotNull((Object)((Object)zzee2.zzaeq));
        this.zzc(zzee2.packageName, true);
        zzee zzee3 = new zzee(zzee2);
        if (zzee2.zzaeq.getValue() == null) {
            this.zze(new zzgs(this, zzee3));
            return;
        }
        this.zze(new zzgt(this, zzee3));
    }

    @Override
    @BinderThread
    public final List<zzjz> zza(String string, String string2, boolean bl, zzdz zzdz2) {
        this.zzb(zzdz2, false);
        Future<List<zzkb>> future = this.zzajy.zzge().zzb(new zzgu(this, zzdz2, string, string2));
        try {
            List<zzkb> list = future.get();
            ArrayList<zzjz> arrayList = new ArrayList<zzjz>(list.size());
            for (zzkb zzkb2 : list) {
                if (!bl && zzkc.zzch(zzkb2.name)) continue;
                arrayList.add(new zzjz(zzkb2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajy.zzgf().zzis().zze("Failed to get user attributes. appId", zzfh.zzbl(zzdz2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzjz> zza(String string, String string2, String string3, boolean bl) {
        this.zzc(string, true);
        Future<List<zzkb>> future = this.zzajy.zzge().zzb(new zzgv(this, string, string2, string3));
        try {
            List<zzkb> list = future.get();
            ArrayList<zzjz> arrayList = new ArrayList<zzjz>(list.size());
            for (zzkb zzkb2 : list) {
                if (!bl && zzkc.zzch(zzkb2.name)) continue;
                arrayList.add(new zzjz(zzkb2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajy.zzgf().zzis().zze("Failed to get user attributes. appId", zzfh.zzbl(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzee> zza(String string, String string2, zzdz zzdz2) {
        this.zzb(zzdz2, false);
        Future<List<zzee>> future = this.zzajy.zzge().zzb(new zzgw(this, zzdz2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajy.zzgf().zzis().zzg("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzee> zze(String string, String string2, String string3) {
        this.zzc(string, true);
        Future<List<zzee>> future = this.zzajy.zzge().zzb(new zzgx(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzajy.zzgf().zzis().zzg("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final void zzd(zzdz zzdz2) {
        this.zzc(zzdz2.packageName, false);
        this.zze(new zzgy(this, zzdz2));
    }

    @VisibleForTesting
    private final void zze(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (zzey.zzaih.get().booleanValue() && this.zzajy.zzge().zzjr()) {
            runnable.run();
            return;
        }
        this.zzajy.zzge().zzc(runnable);
    }

    static /* synthetic */ zzjs zza(zzgo zzgo2) {
        return zzgo2.zzajy;
    }
}

