/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzif;
import com.google.android.gms.internal.measurement.zzik;
import com.google.android.gms.internal.measurement.zzil;
import com.google.android.gms.internal.measurement.zzim;
import com.google.android.gms.internal.measurement.zzin;
import com.google.android.gms.internal.measurement.zzio;
import com.google.android.gms.internal.measurement.zzip;
import com.google.android.gms.internal.measurement.zziq;
import com.google.android.gms.internal.measurement.zzir;
import com.google.android.gms.internal.measurement.zzis;
import com.google.android.gms.internal.measurement.zzit;
import com.google.android.gms.internal.measurement.zziu;
import com.google.android.gms.internal.measurement.zziv;
import com.google.android.gms.internal.measurement.zziw;
import com.google.android.gms.internal.measurement.zzix;
import com.google.android.gms.internal.measurement.zzjn;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzkc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzij
extends zzhi {
    private final zzix zzapg;
    private zzez zzaph;
    private volatile Boolean zzapi;
    private final zzeo zzapj;
    private final zzjn zzapk;
    private final List<Runnable> zzapl = new ArrayList<Runnable>();
    private final zzeo zzapm;

    protected zzij(zzgm zzgm2) {
        super(zzgm2);
        this.zzapk = new zzjn(zzgm2.zzbt());
        this.zzapg = new zzix(this);
        this.zzapj = new zzik(this, zzgm2);
        this.zzapm = new zzip(this, zzgm2);
    }

    @Override
    protected final boolean zzhh() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzhh)this).zzab();
        this.zzch();
        return this.zzaph != null;
    }

    @WorkerThread
    protected final void zzkm() {
        ((zzhh)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(true);
        this.zzf(new zziq(this, zzdz2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzez zzez2, AbstractSafeParcelable abstractSafeParcelable, zzdz zzdz2) {
        ((zzhh)this).zzab();
        ((zzhh)this).zzfs();
        this.zzch();
        boolean bl = this.zzkn();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zzhh)this).zzga().zzp(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzew) {
                    try {
                        zzez2.zza((zzew)abstractSafeParcelable2, zzdz2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhh)this).zzgf().zzis().zzg("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzjz) {
                    try {
                        zzez2.zza((zzjz)abstractSafeParcelable2, zzdz2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhh)this).zzgf().zzis().zzg("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzee) {
                    try {
                        zzez2.zza((zzee)abstractSafeParcelable2, zzdz2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhh)this).zzgf().zzis().zzg("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzhh)this).zzgf().zzis().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzb(zzew zzew2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzew2));
        ((zzhh)this).zzab();
        this.zzch();
        boolean bl = this.zzkn();
        boolean bl2 = bl && ((zzhh)this).zzga().zza(zzew2);
        zzdz zzdz2 = this.zzk(true);
        this.zzf(new zzir(this, bl, bl2, zzew2, zzdz2, string));
    }

    @WorkerThread
    protected final void zzd(zzee zzee2) {
        Preconditions.checkNotNull((Object)((Object)zzee2));
        ((zzhh)this).zzab();
        this.zzch();
        zzec zzec2 = ((zzhh)this).zzgi();
        boolean bl = true;
        boolean bl2 = true && ((zzhh)this).zzga().zzc(zzee2);
        zzee zzee3 = new zzee(zzee2);
        zzdz zzdz2 = this.zzk(true);
        this.zzf(new zzis(this, bl, bl2, zzee3, zzdz2, zzee2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzee>> atomicReference, String string, String string2, String string3) {
        ((zzhh)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(false);
        this.zzf(new zzit(this, atomicReference, string, string2, string3, zzdz2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzjz>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzhh)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(false);
        this.zzf(new zziu(this, atomicReference, string, string2, string3, bl, zzdz2));
    }

    @WorkerThread
    protected final void zzb(zzjz zzjz2) {
        ((zzhh)this).zzab();
        this.zzch();
        boolean bl = this.zzkn() && ((zzhh)this).zzga().zza(zzjz2);
        zzdz zzdz2 = this.zzk(true);
        this.zzf(new zziv(this, bl, zzjz2, zzdz2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzjz>> atomicReference, boolean bl) {
        ((zzhh)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(false);
        this.zzf(new zziw(this, atomicReference, zzdz2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzhh)this).zzab();
        ((zzhh)this).zzfs();
        this.zzch();
        zzdz zzdz2 = this.zzk(false);
        if (this.zzkn()) {
            ((zzhh)this).zzga().resetAnalyticsData();
        }
        this.zzf(new zzil(this, zzdz2));
    }

    private final boolean zzkn() {
        zzec zzec2 = ((zzhh)this).zzgi();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzhh)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(false);
        this.zzf(new zzim(this, atomicReference, zzdz2));
    }

    @WorkerThread
    protected final void zzkj() {
        ((zzhh)this).zzab();
        this.zzch();
        zzdz zzdz2 = this.zzk(true);
        this.zzf(new zzin(this, zzdz2));
    }

    @WorkerThread
    protected final void zzb(zzif zzif2) {
        ((zzhh)this).zzab();
        this.zzch();
        this.zzf(new zzio(this, zzif2));
    }

    @WorkerThread
    private final void zzcu() {
        ((zzhh)this).zzab();
        this.zzapk.start();
        this.zzapj.zzh(zzey.zzahv.get());
    }

    @WorkerThread
    final void zzdf() {
        Intent intent;
        zzec zzec2;
        Boolean bl;
        zzij zzij2;
        ((zzhh)this).zzab();
        this.zzch();
        if (this.isConnected()) {
            return;
        }
        if (this.zzapi == null) {
            boolean bl2;
            zzij2 = this;
            ((zzhh)zzij2).zzab();
            zzij2.zzch();
            bl = ((zzhh)zzij2).zzgg().zzji();
            if (bl != null && bl.booleanValue()) {
                bl2 = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzec2 = ((zzhh)zzij2).zzgi();
                if (((zzhh)zzij2).zzfw().zziq() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzhh)zzij2).zzgf().zziz().log("Checking service availability");
                    zzkc zzkc2 = ((zzhh)zzij2).zzgc();
                    int n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzhh)zzkc2).getContext(), 12451000);
                    switch (n) {
                        case 0: {
                            ((zzhh)zzij2).zzgf().zziz().log("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzhh)zzij2).zzgf().zziz().log("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzhh)zzij2).zzgf().zziv().log("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzhh)zzij2).zzgf().zziy().log("Service container out of date");
                            if (((zzhh)zzij2).zzgc().zzlm() < 12600) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            Boolean bl5 = ((zzhh)zzij2).zzgg().zzji();
                            bl4 = bl5 == null || bl5 != false;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzhh)zzij2).zzgf().zziv().log("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzhh)zzij2).zzgf().zziv().log("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzhh)zzij2).zzgf().zziv().zzg("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (bl3) {
                    ((zzhh)zzij2).zzgg().zzf(bl4);
                }
                bl2 = bl4;
            }
            this.zzapi = bl2;
        }
        if (this.zzapi.booleanValue()) {
            this.zzapg.zzkq();
            return;
        }
        zzij2 = this;
        zzec2 = ((zzhh)zzij2).zzgi();
        bl = ((zzhh)zzij2).getContext().getPackageManager();
        List list = bl.queryIntentServices(intent = new Intent().setClassName(((zzhh)zzij2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
        if (list != null && list.size() > 0) {
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            zzec2 = ((zzhh)this).zzgi();
            intent2.setComponent(new ComponentName(((zzhh)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzapg.zzc(intent2);
            return;
        }
        ((zzhh)this).zzgf().zzis().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    final Boolean zzko() {
        return this.zzapi;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzez zzez2) {
        ((zzhh)this).zzab();
        Preconditions.checkNotNull((Object)zzez2);
        this.zzaph = zzez2;
        this.zzcu();
        this.zzkp();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzhh)this).zzab();
        this.zzch();
        try {
            ConnectionTracker.getInstance().unbindService(((zzhh)this).getContext(), (ServiceConnection)this.zzapg);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzaph = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzhh)this).zzab();
        if (this.zzaph != null) {
            this.zzaph = null;
            ((zzhh)this).zzgf().zziz().zzg("Disconnected from device MeasurementService", componentName);
            zzij zzij2 = this;
            ((zzhh)zzij2).zzab();
            zzij2.zzdf();
        }
    }

    @WorkerThread
    private final void zzcv() {
        ((zzhh)this).zzab();
        if (!this.isConnected()) {
            return;
        }
        ((zzhh)this).zzgf().zziz().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzf(Runnable runnable) throws IllegalStateException {
        ((zzhh)this).zzab();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzapl.size() >= 1000L) {
            ((zzhh)this).zzgf().zzis().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzapl.add(runnable);
        this.zzapm.zzh(60000L);
        this.zzdf();
    }

    @WorkerThread
    private final void zzkp() {
        ((zzhh)this).zzab();
        ((zzhh)this).zzgf().zziz().zzg("Processing queued up service tasks", this.zzapl.size());
        for (Runnable runnable : this.zzapl) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzhh)this).zzgf().zzis().zzg("Task exception while flushing queue", exception);
            }
        }
        this.zzapl.clear();
        this.zzapm.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzdz zzk(boolean bl) {
        zzec zzec2 = ((zzhh)this).zzgi();
        return ((zzhh)this).zzfw().zzbh(bl ? ((zzhh)this).zzgf().zzjb() : null);
    }

    static /* synthetic */ zzix zza(zzij zzij2) {
        return zzij2.zzapg;
    }

    static /* synthetic */ void zza(zzij zzij2, ComponentName componentName) {
        zzij2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzez zza(zzij zzij2, zzez zzez2) {
        zzij2.zzaph = null;
        return null;
    }

    static /* synthetic */ void zzb(zzij zzij2) {
        zzij2.zzkp();
    }

    static /* synthetic */ void zzc(zzij zzij2) {
        zzij2.zzcv();
    }

    static /* synthetic */ zzez zzd(zzij zzij2) {
        return zzij2.zzaph;
    }

    static /* synthetic */ void zze(zzij zzij2) {
        zzij2.zzcu();
    }
}

