/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzgc;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzjp;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzkc;

public final class zzjo
extends zzjr {
    private final AlarmManager zzyi = (AlarmManager)((zzhh)this).getContext().getSystemService("alarm");
    private final zzeo zzaqh;
    private Integer zzyj;

    protected zzjo(zzjs zzjs2) {
        super(zzjs2);
        this.zzaqh = new zzjp(this, zzjs2.zzlj(), zzjs2);
    }

    @Override
    protected final boolean zzhh() {
        this.zzyi.cancel(this.zzek());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzku();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzku() {
        JobScheduler jobScheduler = (JobScheduler)((zzhh)this).getContext().getSystemService("jobscheduler");
        ((zzhh)this).zzgf().zziz().zzg("Cancelling job. JobID", this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzh(long l) {
        this.zzch();
        zzec zzec2 = ((zzhh)this).zzgi();
        if (!zzgc.zza(((zzhh)this).getContext())) {
            ((zzhh)this).zzgf().zziy().log("Receiver not registered/enabled");
        }
        zzec2 = ((zzhh)this).zzgi();
        if (!zzkc.zza(((zzhh)this).getContext(), false)) {
            ((zzhh)this).zzgf().zziy().log("Service not registered/enabled");
        }
        this.cancel();
        long l2 = ((zzhh)this).zzbt().elapsedRealtime() + l;
        if (l < Math.max(0L, zzey.zzahm.get()) && !this.zzaqh.zzef()) {
            ((zzhh)this).zzgf().zziz().log("Scheduling upload with DelayedRunnable");
            this.zzaqh.zzh(l);
        }
        zzec2 = ((zzhh)this).zzgi();
        if (Build.VERSION.SDK_INT >= 24) {
            ((zzhh)this).zzgf().zziz().log("Scheduling upload with JobScheduler");
            long l3 = l;
            zzjo zzjo2 = this;
            ComponentName componentName = new ComponentName(((zzhh)zzjo2).getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)((zzhh)zzjo2).getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzjo2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            ((zzhh)zzjo2).zzgf().zziz().zzg("Scheduling job. JobID", zzjo2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        ((zzhh)this).zzgf().zziz().log("Scheduling upload with AlarmManager");
        this.zzyi.setInexactRepeating(2, l2, Math.max(zzey.zzahh.get(), l), this.zzek());
    }

    private final int getJobId() {
        if (this.zzyj == null) {
            String string = String.valueOf(((zzhh)this).getContext().getPackageName());
            this.zzyj = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzyj;
    }

    public final void cancel() {
        this.zzch();
        this.zzyi.cancel(this.zzek());
        this.zzaqh.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzku();
        }
    }

    private final PendingIntent zzek() {
        Intent intent = new Intent().setClassName(((zzhh)this).getContext(), "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)((zzhh)this).getContext(), (int)0, (Intent)intent, (int)0);
    }
}

