/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzabx;
import com.google.android.gms.internal.measurement.zzaby;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.internal.measurement.zzfq;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgh;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzjo;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzju;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.internal.measurement.zzjw;
import com.google.android.gms.internal.measurement.zzjx;
import com.google.android.gms.internal.measurement.zzjy;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzkb;
import com.google.android.gms.internal.measurement.zzkc;
import com.google.android.gms.internal.measurement.zzkm;
import com.google.android.gms.internal.measurement.zzko;
import com.google.android.gms.internal.measurement.zzkp;
import com.google.android.gms.internal.measurement.zzkq;
import com.google.android.gms.internal.measurement.zzkr;
import com.google.android.gms.internal.measurement.zzks;
import com.google.android.gms.internal.measurement.zzku;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzjs
implements zzed {
    private static volatile zzjs zzaqj;
    private zzgg zzaqk;
    private zzfl zzaql;
    private zzej zzaqm;
    private zzfq zzaqn;
    private zzjo zzaqo;
    private zzeb zzaqp;
    private final zzjy zzaqq;
    private final zzgm zzacw;
    private boolean zzvo = false;
    private boolean zzaqr;
    @VisibleForTesting
    private long zzaqs;
    private List<Runnable> zzaqt;
    private int zzaqu;
    private int zzaqv;
    private boolean zzaqw;
    private boolean zzaqx;
    private boolean zzaqy;
    private FileLock zzaqz;
    private FileChannel zzara;
    private List<Long> zzarb;
    private List<Long> zzarc;
    private long zzard;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzjs zzg(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzaqj != null) return zzaqj;
        Class<zzjs> clazz = zzjs.class;
        synchronized (zzjs.class) {
            if (zzaqj != null) return zzaqj;
            zzjx zzjx2 = new zzjx(context);
            zzaqj = new zzjs(zzjx2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaqj;
        }
    }

    private zzjs(zzjx zzjx2) {
        this(zzjx2, null);
    }

    private zzjs(zzjx zzjx2, zzgm zzgm2) {
        Preconditions.checkNotNull((Object)zzjx2);
        this.zzacw = zzgm2 = zzgm.zza(zzjx2.zzqx, null, null);
        this.zzard = -1L;
        zzjs zzjs2 = this;
        zzjy zzjy2 = new zzjy(zzjs2);
        zzjy2.zzm();
        this.zzaqq = zzjy2;
        zzjs2 = this;
        zzfl zzfl2 = new zzfl(zzjs2);
        zzfl2.zzm();
        this.zzaql = zzfl2;
        zzjs2 = this;
        zzgg zzgg2 = new zzgg(zzjs2);
        zzgg2.zzm();
        this.zzaqk = zzgg2;
        this.zzacw.zzge().zzc(new zzjt(this, zzjx2));
    }

    @WorkerThread
    private final void zza(zzjx zzjx2) {
        ((zzhh)this.zzacw.zzge()).zzab();
        zzjs zzjs2 = this;
        zzej zzej2 = new zzej(zzjs2);
        zzej2.zzm();
        this.zzaqm = zzej2;
        this.zzacw.zzgh().zza(this.zzaqk);
        zzjs2 = this;
        zzeb zzeb2 = new zzeb(zzjs2);
        zzeb2.zzm();
        this.zzaqp = zzeb2;
        zzjs2 = this;
        zzjo zzjo2 = new zzjo(zzjs2);
        zzjo2.zzm();
        this.zzaqo = zzjo2;
        zzjs2 = this;
        this.zzaqn = new zzfq(zzjs2);
        if (this.zzaqu != this.zzaqv) {
            this.zzacw.zzgf().zzis().zze("Not all upload components initialized", this.zzaqu, this.zzaqv);
        }
        this.zzvo = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzhh)this.zzacw.zzge()).zzab();
        this.zzje().zzht();
        if (this.zzacw.zzgg().zzakd.get() == 0L) {
            this.zzacw.zzgg().zzakd.set(this.zzacw.zzbt().currentTimeMillis());
        }
        this.zzld();
    }

    @Override
    public final zzec zzgi() {
        return this.zzacw.zzgi();
    }

    public final zzeg zzgh() {
        return this.zzacw.zzgh();
    }

    @Override
    public final zzfh zzgf() {
        return this.zzacw.zzgf();
    }

    @Override
    public final zzgh zzge() {
        return this.zzacw.zzge();
    }

    private final zzgg zzkv() {
        zzjs.zza(this.zzaqk);
        return this.zzaqk;
    }

    public final zzfl zzkw() {
        zzjs.zza(this.zzaql);
        return this.zzaql;
    }

    public final zzej zzje() {
        zzjs.zza(this.zzaqm);
        return this.zzaqm;
    }

    private final zzfq zzkx() {
        if (this.zzaqn == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzaqn;
    }

    private final zzjo zzky() {
        zzjs.zza(this.zzaqo);
        return this.zzaqo;
    }

    public final zzeb zzjd() {
        zzjs.zza(this.zzaqp);
        return this.zzaqp;
    }

    public final zzjy zzjc() {
        zzjs.zza(this.zzaqq);
        return this.zzaqq;
    }

    public final zzff zzgb() {
        return this.zzacw.zzgb();
    }

    @Override
    public final Context getContext() {
        return this.zzacw.getContext();
    }

    @Override
    public final Clock zzbt() {
        return this.zzacw.zzbt();
    }

    public final zzkc zzgc() {
        return this.zzacw.zzgc();
    }

    @WorkerThread
    private final void zzab() {
        ((zzhh)this.zzacw.zzge()).zzab();
    }

    final void zzkz() {
        if (!this.zzvo) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zza(zzjr zzjr2) {
        if (zzjr2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzjr2.isInitialized()) {
            String string = String.valueOf(zzjr2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    final void zze(zzdz zzdz2) {
        this.zzab();
        this.zzkz();
        Preconditions.checkNotEmpty((String)zzdz2.packageName);
        this.zzg(zzdz2);
    }

    private final long zzla() {
        long l = this.zzacw.zzbt().currentTimeMillis();
        zzfs zzfs2 = this.zzacw.zzgg();
        zzfs2.zzch();
        zzfs2.zzab();
        long l2 = zzfs2.zzakh.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzfs2.zzgc().zzll().nextInt(86400000);
            zzfs2.zzakh.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zzc(zzew zzew2, String string) {
        zzdy zzdy2 = this.zzje().zzbb(string);
        if (zzdy2 == null || TextUtils.isEmpty((CharSequence)zzdy2.zzag())) {
            this.zzacw.zzgf().zziy().zzg("No app data available; dropping event", string);
            return;
        }
        Boolean bl = this.zzc(zzdy2);
        if (bl == null) {
            if (!"_ui".equals(zzew2.name)) {
                this.zzacw.zzgf().zziv().zzg("Could not find package. appId", zzfh.zzbl(string));
            }
        } else if (!bl.booleanValue()) {
            this.zzacw.zzgf().zzis().zzg("App version does not match; dropping event. appId", zzfh.zzbl(string));
            return;
        }
        zzdz zzdz2 = new zzdz(string, zzdy2.getGmpAppId(), zzdy2.zzag(), zzdy2.zzgo(), zzdy2.zzgp(), zzdy2.zzgq(), zzdy2.zzgr(), null, zzdy2.isMeasurementEnabled(), false, zzdy2.zzgl(), zzdy2.zzhe(), 0L, 0, zzdy2.zzhf(), zzdy2.zzhg(), false);
        this.zzb(zzew2, zzdz2);
    }

    @WorkerThread
    final void zzb(zzew zzew2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzdz2));
        Preconditions.checkNotEmpty((String)zzdz2.packageName);
        this.zzab();
        this.zzkz();
        String string = zzdz2.packageName;
        long l = zzew2.zzagc;
        if (!this.zzacw.zzgc().zzd(zzew2, zzdz2)) {
            return;
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        this.zzje().beginTransaction();
        try {
            AbstractSafeParcelable abstractSafeParcelable;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzej zzej2 = this.zzje();
            Preconditions.checkNotEmpty((String)string3);
            zzej2.zzab();
            zzej2.zzch();
            if (l2 < 0L) {
                zzej2.zzgf().zziv().zze("Invalid time querying timed out conditional properties", zzfh.zzbl(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzej2.zzb(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzacw.zzgf().zziy().zzd("User property timed out", object22.packageName, this.zzacw.zzgb().zzbk(object22.zzaeq.name), object22.zzaeq.getValue());
                if (object22.zzaer != null) {
                    this.zzc(new zzew(object22.zzaer, l), zzdz2);
                }
                this.zzje().zzj(string, object22.zzaeq.name);
            }
            l2 = l;
            string3 = string;
            zzej2 = this.zzje();
            Preconditions.checkNotEmpty((String)string3);
            zzej2.zzab();
            zzej2.zzch();
            if (l2 < 0L) {
                zzej2.zzgf().zziv().zze("Invalid time querying expired conditional properties", zzfh.zzbl(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzej2.zzb(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzee)((Object)object4.next());
                if (object == null) continue;
                this.zzacw.zzgf().zziy().zzd("User property expired", object.packageName, this.zzacw.zzgb().zzbk(object.zzaeq.name), object.zzaeq.getValue());
                this.zzje().zzg(string, object.zzaeq.name);
                if (object.zzaet != null) {
                    object22.add(object.zzaet);
                }
                this.zzje().zzj(string, object.zzaeq.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzew)((Object)e);
                this.zzc(new zzew((zzew)((Object)object), l), zzdz2);
            }
            long l3 = l;
            String string4 = zzew2.name;
            string3 = string;
            zzej2 = this.zzje();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzej2.zzab();
            zzej2.zzch();
            if (l3 < 0L) {
                zzej2.zzgf().zziv().zzd("Invalid time querying triggered conditional properties", zzfh.zzbl(string3), zzej2.zzgb().zzbi(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzej2.zzb((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                abstractSafeParcelable = (zzee)((Object)iterator.next());
                if (abstractSafeParcelable == null) continue;
                zzjz zzjz2 = abstractSafeParcelable.zzaeq;
                zzkb zzkb2 = new zzkb(abstractSafeParcelable.packageName, abstractSafeParcelable.origin, zzjz2.name, l, zzjz2.getValue());
                if (this.zzje().zza(zzkb2)) {
                    this.zzacw.zzgf().zziy().zzd("User property triggered", abstractSafeParcelable.packageName, this.zzacw.zzgb().zzbk(zzkb2.name), zzkb2.value);
                } else {
                    this.zzacw.zzgf().zzis().zzd("Too many active user properties, ignoring", zzfh.zzbl(abstractSafeParcelable.packageName), this.zzacw.zzgb().zzbk(zzkb2.name), zzkb2.value);
                }
                if (abstractSafeParcelable.zzaes != null) {
                    object.add(abstractSafeParcelable.zzaes);
                }
                abstractSafeParcelable.zzaeq = new zzjz(zzkb2);
                abstractSafeParcelable.active = true;
                this.zzje().zza((zzee)abstractSafeParcelable);
            }
            this.zzc(zzew2, zzdz2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                abstractSafeParcelable = (zzew)((Object)e);
                this.zzc(new zzew((zzew)abstractSafeParcelable, l), zzdz2);
            }
            this.zzje().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzje().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzc(zzew var1_1, zzdz var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzab();
        this.zzkz();
        var5_4 = var2_2.packageName;
        if (!this.zzacw.zzgc().zzd(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzadw) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzkv().zzn(var5_4, var1_1.name)) {
            this.zzacw.zzgf().zziv().zze("Dropping blacklisted event. appId", zzfh.zzbl(var5_4), this.zzacw.zzgb().zzbi(var1_1.name));
            var6_5 = this.zzkv().zzbx(var5_4) != false || this.zzkv().zzby(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzacw.zzgc().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzje().zzbb(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzgu(), var7_7.zzgt());
                if (Math.abs(this.zzacw.zzbt().currentTimeMillis() - var8_9) > zzey.zzaho.get()) {
                    this.zzacw.zzgf().zziy().log("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzacw.zzgf().isLoggable(2)) {
            this.zzacw.zzgf().zziz().zzg("Logging event", this.zzacw.zzgb().zzb(var1_1));
        }
        this.zzje().beginTransaction();
        try {
            block45: {
                block46: {
                    this.zzg(var2_2);
                    if (("_iap".equals(var1_1.name) || "ecommerce_purchase".equals(var1_1.name)) && !this.zza(var5_4, var1_1)) {
                        this.zzje().setTransactionSuccessful();
                        return;
                    }
                    var6_6 = zzkc.zzcb(var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzje().zza(this.zzla(), var5_4, true, var6_6, false, var7_8, false);
                    var9_11 = var8_10.zzaff - (long)zzey.zzagz.get().intValue();
                    if (var9_11 > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzacw.zzgf().zzis().zze("Data loss. Too many events logged. appId, count", zzfh.zzbl(var5_4), var8_10.zzaff);
                        }
                        this.zzje().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_11 = var8_10.zzafe - (long)zzey.zzahb.get().intValue()) > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzacw.zzgf().zzis().zze("Data loss. Too many public events logged. appId, count", zzfh.zzbl(var5_4), var8_10.zzafe);
                        }
                        this.zzacw.zzgc().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzje().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_12 = var2_2.packageName;
                        var20_13 = this.zzacw.zzgh().zzb((String)var19_12, zzey.zzaha);
                        var9_11 = var8_10.zzafh - (long)Math.max(0, var20_13 = Math.min(1000000, var20_13));
                        if (var9_11 > 0L) {
                            if (var9_11 == 1L) {
                                this.zzacw.zzgf().zzis().zze("Too many error events logged. appId, count", zzfh.zzbl(var5_4), var8_10.zzafh);
                            }
                            this.zzje().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_15 = var1_1.zzafr.zzij();
                    this.zzacw.zzgc().zza(var11_15, "_o", (Object)var1_1.origin);
                    if (this.zzacw.zzgc().zzci(var5_4)) {
                        this.zzacw.zzgc().zza(var11_15, "_dbg", 1L);
                        this.zzacw.zzgc().zza(var11_15, "_r", 1L);
                    }
                    if ((var12_16 = this.zzje().zzbc(var5_4)) > 0L) {
                        this.zzacw.zzgf().zziv().zze("Data lost. Too many events stored on disk, deleted. appId", zzfh.zzbl(var5_4), var12_16);
                    }
                    var14_17 = new zzer(this.zzacw, var1_1.origin, var5_4, var1_1.name, var1_1.zzagc, 0L, var11_15);
                    var15_18 = this.zzje().zzf(var5_4, var14_17.name);
                    if (var15_18 == null) {
                        if (this.zzje().zzbf(var5_4) >= 500L && var6_6) {
                            this.zzacw.zzgf().zzis().zzd("Too many event names used, ignoring event. appId, name, supported count", zzfh.zzbl(var5_4), this.zzacw.zzgb().zzbi(var14_17.name), 500);
                            this.zzacw.zzgc().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_19 = new zzes(var5_4, var14_17.name, 0L, 0L, var14_17.timestamp, 0L, null, null, null);
                    } else {
                        var14_17 = var14_17.zza(this.zzacw, var15_18.zzafu);
                        var16_19 = var15_18.zzac(var14_17.timestamp);
                    }
                    this.zzje().zza(var16_19);
                    var20_14 = var2_2;
                    var19_12 = var14_17;
                    var18_20 = this;
                    var18_20.zzab();
                    var18_20.zzkz();
                    Preconditions.checkNotNull((Object)var19_12);
                    Preconditions.checkNotNull((Object)var20_14);
                    Preconditions.checkNotEmpty((String)var19_12.zzti);
                    Preconditions.checkArgument((boolean)var19_12.zzti.equals(var20_14.packageName));
                    var21_21 = new zzks();
                    new zzks().zzatt = 1;
                    var21_21.zzaub = "android";
                    var21_21.zzti = var20_14.packageName;
                    var21_21.zzadt = var20_14.zzadt;
                    var21_21.zzth = var20_14.zzth;
                    var21_21.zzaun = var20_14.zzads == -2147483648L ? null : Integer.valueOf((int)var20_14.zzads);
                    var21_21.zzauf = var20_14.zzadu;
                    var21_21.zzadm = var20_14.zzadm;
                    var21_21.zzauj = var20_14.zzadv == 0L ? null : Long.valueOf(var20_14.zzadv);
                    var22_22 = var18_20.zzacw.zzgg().zzbn(var20_14.packageName);
                    if (var22_22 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_22.first))) {
                        if (var20_14.zzady) {
                            var21_21.zzauh = (String)var22_22.first;
                            var21_21.zzaui = (Boolean)var22_22.second;
                        }
                    } else if (!var18_20.zzacw.zzfx().zzf(var18_20.zzacw.getContext()) && var20_14.zzadz) {
                        var23_23 = Settings.Secure.getString((ContentResolver)var18_20.zzacw.getContext().getContentResolver(), (String)"android_id");
                        if (var23_23 == null) {
                            var18_20.zzacw.zzgf().zziv().zzg("null secure ID. appId", zzfh.zzbl(var21_21.zzti));
                            var23_23 = "null";
                        } else if (var23_23.isEmpty()) {
                            var18_20.zzacw.zzgf().zziv().zzg("empty secure ID. appId", zzfh.zzbl(var21_21.zzti));
                        }
                        var21_21.zzauq = var23_23;
                    }
                    var18_20.zzacw.zzfx().zzch();
                    var21_21.zzaud = Build.MODEL;
                    var18_20.zzacw.zzfx().zzch();
                    var21_21.zzauc = Build.VERSION.RELEASE;
                    var21_21.zzaue = (int)var18_20.zzacw.zzfx().zzig();
                    var21_21.zzafo = var18_20.zzacw.zzfx().zzih();
                    var21_21.zzaug = null;
                    var21_21.zzatw = null;
                    var21_21.zzatx = null;
                    var21_21.zzaty = null;
                    var21_21.zzaus = var20_14.zzadx;
                    if (var18_20.zzacw.isEnabled() && zzeg.zzho()) {
                        var21_21.zzaut = null;
                    }
                    if ((var23_23 = var18_20.zzje().zzbb(var20_14.packageName)) == null) {
                        var23_23 = new zzdy(var18_20.zzacw, var20_14.packageName);
                        var23_23.zzak(var18_20.zzacw.zzfw().zzio());
                        var23_23.zzan(var20_14.zzado);
                        var23_23.zzal(var20_14.zzadm);
                        var23_23.zzam(var18_20.zzacw.zzgg().zzbo(var20_14.packageName));
                        var23_23.zzr(0L);
                        var23_23.zzm(0L);
                        var23_23.zzn(0L);
                        var23_23.setAppVersion(var20_14.zzth);
                        var23_23.zzo(var20_14.zzads);
                        var23_23.zzao(var20_14.zzadt);
                        var23_23.zzp(var20_14.zzadu);
                        var23_23.zzq(var20_14.zzadv);
                        var23_23.setMeasurementEnabled(var20_14.zzadw);
                        var23_23.zzaa(var20_14.zzadx);
                        var18_20.zzje().zza((zzdy)var23_23);
                    }
                    var21_21.zzadl = var23_23.getAppInstanceId();
                    var21_21.zzado = var23_23.zzgl();
                    var24_24 = var18_20.zzje().zzba(var20_14.packageName);
                    var21_21.zzatv = new zzku[var24_24.size()];
                    for (var25_25 = 0; var25_25 < var24_24.size(); ++var25_25) {
                        var21_21.zzatv[var25_25] = var26_27 = new zzku();
                        var26_27.name = var24_24.get((int)var25_25).name;
                        var26_27.zzauz = var24_24.get((int)var25_25).zzarl;
                        var18_20.zzjc().zza(var26_27, var24_24.get((int)var25_25).value);
                    }
                    try {
                        var25_26 = var18_20.zzje().zza(var21_21);
                    }
                    catch (IOException var27_28) {
                        var18_20.zzacw.zzgf().zzis().zze("Data loss. Failed to insert raw event metadata. appId", zzfh.zzbl(var21_21.zzti), var27_28);
                        break block45;
                    }
                    v0 = var18_20.zzje();
                    var29_29 = var19_12;
                    var28_30 = var18_20;
                    if (var29_29.zzafr == null) ** GOTO lbl-1000
                    for (Object var31_33 : var29_29.zzafr) {
                        if (!"_r".equals(var31_33)) continue;
                        v1 = true;
                        break block46;
                    }
                    var30_32 = var28_30.zzkv().zzo(var29_29.zzti, var29_29.name);
                    var31_33 = var28_30.zzje().zza(var28_30.zzla(), var29_29.zzti, false, false, false, false, false);
                    if (var30_32 && var31_33.zzafi < (long)var28_30.zzacw.zzgh().zzaq(var29_29.zzti)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                }
                if (v0.zza((zzer)var19_12, var25_26, v1)) {
                    var18_20.zzaqs = 0L;
                }
            }
            this.zzje().setTransactionSuccessful();
            if (this.zzacw.zzgf().isLoggable(2)) {
                this.zzacw.zzgf().zziz().zzg("Event recorded", this.zzacw.zzgb().zza(var14_17));
            }
        }
        finally {
            this.zzje().endTransaction();
        }
        this.zzld();
        this.zzacw.zzgf().zziz().zzg("Background event processing time, ms", (System.nanoTime() - var3_3 + 500000L) / 1000000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zza(String string, zzew zzew2) {
        long l;
        String string2;
        block10: {
            string2 = zzew2.zzafr.getString("currency");
            if ("ecommerce_purchase".equals(zzew2.name)) {
                double d = zzew2.zzafr.zzbg("value") * 1000000.0;
                if (d == 0.0) {
                    d = (double)zzew2.zzafr.getLong("value").longValue() * 1000000.0;
                }
                if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                    l = Math.round(d);
                    break block10;
                } else {
                    this.zzacw.zzgf().zziv().zze("Data lost. Currency value is too big. appId", zzfh.zzbl(string), d);
                    return false;
                }
            }
            l = zzew2.zzafr.getLong("value");
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
            String string3 = String.valueOf("_ltv_");
            String string4 = String.valueOf(string2);
            String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            zzkb zzkb2 = this.zzje().zzh(string, string5);
            if (zzkb2 == null || !(zzkb2.value instanceof Long)) {
                String string6 = string;
                int n = this.zzacw.zzgh().zzb(string6, zzey.zzaht) - 1;
                string6 = string;
                zzej zzej2 = this.zzje();
                Preconditions.checkNotEmpty((String)string6);
                zzej2.zzab();
                zzej2.zzch();
                try {
                    zzej2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string6, string6, String.valueOf(n)});
                }
                catch (SQLiteException sQLiteException) {
                    zzej2.zzgf().zzis().zze("Error pruning currencies. appId", zzfh.zzbl(string6), (Object)sQLiteException);
                }
                zzkb2 = new zzkb(string, zzew2.origin, string5, this.zzacw.zzbt().currentTimeMillis(), l);
            } else {
                long l2 = (Long)zzkb2.value;
                zzkb2 = new zzkb(string, zzew2.origin, string5, this.zzacw.zzbt().currentTimeMillis(), l2 + l);
            }
            if (!this.zzje().zza(zzkb2)) {
                this.zzacw.zzgf().zzis().zzd("Too many unique user properties are set. Ignoring user property. appId", zzfh.zzbl(string), this.zzacw.zzgb().zzbk(zzkb2.name), zzkb2.value);
                this.zzacw.zzgc().zza(string, 9, null, null, 0);
            }
        }
        return true;
    }

    @WorkerThread
    public final void zzlb() {
        this.zzab();
        this.zzkz();
        this.zzaqy = true;
        try {
            String string;
            zzec zzec2 = this.zzacw.zzgi();
            Boolean bl = this.zzacw.zzfy().zzko();
            if (bl == null) {
                this.zzacw.zzgf().zziv().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzacw.zzgf().zzis().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzaqs > 0L) {
                this.zzld();
                return;
            }
            zzed zzed2 = this;
            ((zzjs)zzed2).zzab();
            if (((zzjs)zzed2).zzarb != null) {
                this.zzacw.zzgf().zziz().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzkw().zzex()) {
                this.zzacw.zzgf().zziz().log("Network not connected, ignoring upload request");
                this.zzld();
                return;
            }
            long l = this.zzacw.zzbt().currentTimeMillis();
            long l2 = l - zzeg.zzhm();
            this.zzd(null, l2);
            long l3 = this.zzacw.zzgg().zzakd.get();
            if (l3 != 0L) {
                this.zzacw.zzgf().zziy().zzg("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzje().zzhr()))) {
                if (this.zzard == -1L) {
                    this.zzard = this.zzje().zzhy();
                }
                Object object = string;
                int n = this.zzacw.zzgh().zzb((String)object, zzey.zzagv);
                object = string;
                zzed2 = this.zzacw.zzgh();
                int n2 = Math.max(0, ((zzeg)zzed2).zzb((String)object, zzey.zzagw));
                List<Pair<zzks, Long>> list = this.zzje().zzb(string, n, n2);
                if (!list.isEmpty()) {
                    Object object2;
                    String string2 = null;
                    Object object3 = list.iterator();
                    while (object3.hasNext()) {
                        zzks zzks2 = (zzks)((Object)object3.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzks2.zzauh)) continue;
                        string2 = zzks2.zzauh;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object2 = (zzks)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzks)((Object)object2)).zzauh) || ((zzks)((Object)object2)).zzauh.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object3 = new zzkr();
                    new zzkr().zzatr = new zzks[list.size()];
                    object2 = new ArrayList(list.size());
                    boolean bl2 = zzeg.zzho() && this.zzacw.zzgh().zzas(string);
                    for (int i = 0; i < ((zzkr)((Object)object3)).zzatr.length; ++i) {
                        ((zzkr)((Object)object3)).zzatr[i] = (zzks)((Object)list.get((int)i).first);
                        object2.add((Long)list.get((int)i).second);
                        ((zzkr)((Object)object3)).zzatr[i].zzaug = 12451L;
                        ((zzkr)((Object)object3)).zzatr[i].zzatw = l;
                        zzec2 = this.zzacw.zzgi();
                        ((zzkr)((Object)object3)).zzatr[i].zzaul = false;
                        if (bl2) continue;
                        ((zzkr)((Object)object3)).zzatr[i].zzaut = null;
                    }
                    String string3 = null;
                    if (this.zzacw.zzgf().isLoggable(2)) {
                        string3 = this.zzjc().zzb((zzkr)((Object)object3));
                    }
                    byte[] byArray = this.zzjc().zza((zzkr)((Object)object3));
                    String string4 = zzey.zzahf.get();
                    try {
                        URL uRL = new URL(string4);
                        object = object2;
                        zzed2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (((zzjs)zzed2).zzarb != null) {
                            ((zzjs)zzed2).zzacw.zzgf().zzis().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzjs)zzed2).zzarb = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzacw.zzgg().zzake.set(l);
                        String string5 = "?";
                        if (((zzkr)((Object)object3)).zzatr.length > 0) {
                            string5 = ((zzkr)((Object)object3)).zzatr[0].zzti;
                        }
                        this.zzacw.zzgf().zziz().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzaqx = true;
                        zzju zzju2 = new zzju(this, string);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object = string;
                        zzed2 = this.zzkw();
                        ((zzhh)zzed2).zzab();
                        ((zzjr)zzed2).zzch();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)byArray2);
                        Preconditions.checkNotNull((Object)zzju2);
                        ((zzhh)zzed2).zzge().zzd(new zzfp((zzfl)zzed2, (String)object, uRL2, byArray2, null, zzju2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzacw.zzgf().zzis().zze("Failed to parse upload URL. Not uploading. appId", zzfh.zzbl(string), string4);
                    }
                }
            } else {
                zzdy zzdy2;
                this.zzard = -1L;
                String string6 = this.zzje().zzab(l - zzeg.zzhm());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzdy2 = this.zzje().zzbb(string6)) != null) {
                    this.zzb(zzdy2);
                }
            }
            return;
        }
        finally {
            this.zzaqy = false;
            this.zzle();
        }
    }

    @WorkerThread
    private final boolean zzd(String string, long l) {
        this.zzje().beginTransaction();
        try {
            block101: {
                zzkq[] zzkqArray;
                Object object;
                int n2;
                int n3;
                Object object2;
                Object object3;
                Object object4;
                zza zza2;
                block99: {
                    zza zza3 = zza2 = new zza(null);
                    long l2 = this.zzard;
                    long l3 = l;
                    object4 = null;
                    object3 = this.zzje();
                    Preconditions.checkNotNull((Object)zza3);
                    ((zzhh)object3).zzab();
                    ((zzjr)object3).zzch();
                    object2 = null;
                    try {
                        String[] stringArray;
                        String string2;
                        String string3;
                        String string4;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzej)object3).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string4 = l2 != -1L ? "rowid <= ? and " : "";
                            object2 = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!object2.moveToFirst()) break block99;
                            object4 = object2.getString(0);
                            string3 = object2.getString(1);
                            object2.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string4 = l2 != -1L ? " and rowid <= ?" : "";
                            object2 = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string4).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!object2.moveToFirst()) break block99;
                            string3 = object2.getString(0);
                            object2.close();
                        }
                        object2 = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{object4, string3}, null, null, "rowid", "2");
                        if (!object2.moveToFirst()) {
                            ((zzhh)object3).zzgf().zzis().zzg("Raw event metadata record is missing. appId", zzfh.zzbl((String)object4));
                            break block99;
                        }
                        byte[] byArray = object2.getBlob(0);
                        string4 = zzabx.zza((byte[])byArray, (int)0, (int)byArray.length);
                        zzks zzks2 = new zzks();
                        try {
                            zzks2.zzb((zzabx)string4);
                        }
                        catch (IOException iOException) {
                            ((zzhh)object3).zzgf().zzis().zze("Data loss. Failed to merge raw event metadata. appId", zzfh.zzbl((String)object4), iOException);
                            if (object2 != null) {
                                object2.close();
                            }
                            break block99;
                        }
                        if (object2.moveToNext()) {
                            ((zzhh)object3).zzgf().zziv().zzg("Get multiple raw event metadata records, expected one. appId", zzfh.zzbl((String)object4));
                        }
                        object2.close();
                        zza3.zzb(zzks2);
                        if (l2 != -1L) {
                            string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{object4, string3, String.valueOf(l2)};
                        } else {
                            string2 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{object4, string3};
                        }
                        object2 = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
                        if (!object2.moveToFirst()) {
                            ((zzhh)object3).zzgf().zziv().zzg("Raw event data disappeared while in transaction. appId", zzfh.zzbl((String)object4));
                            break block99;
                        }
                        do {
                            long l4 = object2.getLong(0);
                            byArray = object2.getBlob(3);
                            string4 = zzabx.zza((byte[])byArray, (int)0, (int)byArray.length);
                            zzkp zzkp2 = new zzkp();
                            try {
                                zzkp2.zzb((zzabx)string4);
                            }
                            catch (IOException iOException) {
                                ((zzhh)object3).zzgf().zzis().zze("Data loss. Failed to merge raw event. appId", zzfh.zzbl((String)object4), iOException);
                                continue;
                            }
                            zzkp2.name = object2.getString(1);
                            zzkp2.zzatn = object2.getLong(2);
                            if (!zza3.zza(l4, zzkp2)) break;
                        } while (object2.moveToNext());
                    }
                    catch (SQLiteException sQLiteException) {
                        ((zzhh)object3).zzgf().zzis().zze("Data loss. Error selecting raw event. appId", zzfh.zzbl(object4), (Object)sQLiteException);
                    }
                    finally {
                        if (object2 != null) {
                            object2.close();
                        }
                    }
                }
                object3 = zza2;
                if (((zza)object3).zzarj == null || ((zza)object3).zzarj.isEmpty()) break block101;
                boolean bl = false;
                zzks zzks3 = zza2.zzarh;
                zza2.zzarh.zzatu = new zzkp[zza2.zzarj.size()];
                int n4 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzacw.zzgh().zzau(zzks3.zzti);
                for (n3 = 0; n3 < zza2.zzarj.size(); ++n3) {
                    zzkp zzkp3;
                    block103: {
                        int zzkqArray3;
                        boolean bl3;
                        block102: {
                            bl3 = bl;
                            zzkp3 = zza2.zzarj.get(n3);
                            if (this.zzkv().zzn(zza2.zzarh.zzti, zzkp3.name)) {
                                this.zzacw.zzgf().zziv().zze("Dropping blacklisted raw event. appId", zzfh.zzbl(zza2.zzarh.zzti), this.zzacw.zzgb().zzbi(zzkp3.name));
                                if (this.zzkv().zzbx(zza2.zzarh.zzti) || this.zzkv().zzby(zza2.zzarh.zzti) || "_err".equals(zzkp3.name)) continue;
                                this.zzacw.zzgc().zza(zza2.zzarh.zzti, 11, "_ev", zzkp3.name, 0);
                                continue;
                            }
                            n2 = this.zzkv().zzo(zza2.zzarh.zzti, zzkp3.name);
                            if (n2 != 0) break block102;
                            this.zzacw.zzgc();
                            if (!zzkc.zzck(zzkp3.name)) break block103;
                        }
                        boolean bl4 = false;
                        boolean n = false;
                        if (zzkp3.zzatm == null) {
                            zzkp3.zzatm = new zzkq[0];
                        }
                        zzkq[] i = zzkp3.zzatm;
                        int zzkq2 = zzkp3.zzatm.length;
                        for (zzkqArray3 = 0; zzkqArray3 < zzkq2; ++zzkqArray3) {
                            object = i[zzkqArray3];
                            if ("_c".equals(((zzkq)((Object)object)).name)) {
                                ((zzkq)((Object)object)).zzatq = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(((zzkq)((Object)object)).name)) continue;
                            ((zzkq)((Object)object)).zzatq = 1L;
                            n = true;
                        }
                        if (!bl4 && n2 != 0) {
                            this.zzacw.zzgf().zziz().zzg("Marking event as conversion", this.zzacw.zzgb().zzbi(zzkp3.name));
                            i = Arrays.copyOf(zzkp3.zzatm, zzkp3.zzatm.length + 1);
                            zzkq zzkq3 = new zzkq();
                            new zzkq().name = "_c";
                            zzkq3.zzatq = 1L;
                            i[i.length - 1] = zzkq3;
                            zzkp3.zzatm = i;
                        }
                        if (!n) {
                            this.zzacw.zzgf().zziz().zzg("Marking event as real-time", this.zzacw.zzgb().zzbi(zzkp3.name));
                            i = Arrays.copyOf(zzkp3.zzatm, zzkp3.zzatm.length + 1);
                            zzkq zzkp4 = new zzkq();
                            new zzkq().name = "_r";
                            zzkp4.zzatq = 1L;
                            i[i.length - 1] = zzkp4;
                            zzkp3.zzatm = i;
                        }
                        bl = true;
                        if (this.zzje().zza((long)this.zzla(), (String)zza2.zzarh.zzti, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzafi > (long)this.zzacw.zzgh().zzaq(zza2.zzarh.zzti)) {
                            for (zzkq2 = 0; zzkq2 < zzkp3.zzatm.length; ++zzkq2) {
                                if (!"_r".equals(zzkp3.zzatm[zzkq2].name)) continue;
                                zzkq[] string5 = new zzkq[zzkp3.zzatm.length - 1];
                                if (zzkq2 > 0) {
                                    System.arraycopy(zzkp3.zzatm, 0, string5, 0, zzkq2);
                                }
                                if (zzkq2 < string5.length) {
                                    System.arraycopy(zzkp3.zzatm, zzkq2 + 1, string5, zzkq2, string5.length - zzkq2);
                                }
                                zzkp3.zzatm = string5;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzkc.zzcb(zzkp3.name) && n2 != 0) {
                            object4 = zza2.zzarh.zzti;
                            if (this.zzje().zza((long)this.zzla(), (String)zza2.zzarh.zzti, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzafg > (long)this.zzacw.zzgh().zzb((String)object4, zzey.zzahc)) {
                                this.zzacw.zzgf().zziv().zzg("Too many conversions. Not logging as conversion. appId", zzfh.zzbl(zza2.zzarh.zzti));
                                zzkqArray3 = 0;
                                object = null;
                                zzkqArray = zzkp3.zzatm;
                                int bl7 = zzkp3.zzatm.length;
                                for (int j = 0; j < bl7; ++j) {
                                    zzkq zzkq3 = zzkqArray[j];
                                    if ("_c".equals(zzkq3.name)) {
                                        object = zzkq3;
                                        continue;
                                    }
                                    if (!"_err".equals(zzkq3.name)) continue;
                                    zzkqArray3 = 1;
                                }
                                if (zzkqArray3 != 0 && object != null) {
                                    zzkp3.zzatm = (zzkq[])ArrayUtils.removeAll((Object[])zzkp3.zzatm, (Object[])new zzkq[]{object});
                                } else if (object != null) {
                                    ((zzkq)((Object)object)).name = "_err";
                                    ((zzkq)((Object)object)).zzatq = 10L;
                                } else {
                                    this.zzacw.zzgf().zzis().zzg("Did not find conversion parameter. appId", zzfh.zzbl(zza2.zzarh.zzti));
                                }
                            }
                        }
                    }
                    if (bl2 && "_e".equals(zzkp3.name)) {
                        if (zzkp3.zzatm == null || zzkp3.zzatm.length == 0) {
                            this.zzacw.zzgf().zziv().zzg("Engagement event does not contain any parameters. appId", zzfh.zzbl(zza2.zzarh.zzti));
                        } else {
                            this.zzjc();
                            Long l6 = (Long)zzjy.zzb(zzkp3, "_et");
                            if (l6 == null) {
                                this.zzacw.zzgf().zziv().zzg("Engagement event does not include duration. appId", zzfh.zzbl(zza2.zzarh.zzti));
                            } else {
                                l5 += l6.longValue();
                            }
                        }
                    }
                    zzks3.zzatu[n4++] = zzkp3;
                }
                if (n4 < zza2.zzarj.size()) {
                    zzks3.zzatu = Arrays.copyOf(zzks3.zzatu, n4);
                }
                if (bl2) {
                    zzkb zzkb2 = this.zzje().zzh(zzks3.zzti, "_lte");
                    zzkb2 = zzkb2 == null || zzkb2.value == null ? new zzkb(zzks3.zzti, "auto", "_lte", this.zzacw.zzbt().currentTimeMillis(), l5) : new zzkb(zzks3.zzti, "auto", "_lte", this.zzacw.zzbt().currentTimeMillis(), (Long)zzkb2.value + l5);
                    zzku zzku2 = new zzku();
                    new zzku().name = "_lte";
                    zzku2.zzauz = this.zzacw.zzbt().currentTimeMillis();
                    zzku2.zzatq = (Long)zzkb2.value;
                    boolean bl5 = false;
                    for (n2 = 0; n2 < zzks3.zzatv.length; ++n2) {
                        if (!"_lte".equals(zzks3.zzatv[n2].name)) continue;
                        zzks3.zzatv[n2] = zzku2;
                        bl5 = true;
                        break;
                    }
                    if (!bl5) {
                        zzks3.zzatv = Arrays.copyOf(zzks3.zzatv, zzks3.zzatv.length + 1);
                        zzks3.zzatv[zza2.zzarh.zzatv.length - 1] = zzku2;
                    }
                    if (l5 > 0L) {
                        this.zzje().zza(zzkb2);
                        this.zzacw.zzgf().zziy().zzg("Updated lifetime engagement user property with value. Value", zzkb2.value);
                    }
                }
                zzks3.zzaum = this.zza(zzks3.zzti, zzks3.zzatv, zzks3.zzatu);
                if (this.zzacw.zzgh().zzat(zza2.zzarh.zzti)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    zzkp[] zzkpArray = new zzkp[zzks3.zzatu.length];
                    int n8 = 0;
                    SecureRandom secureRandom = this.zzacw.zzgc().zzll();
                    zzkp[] zzkpArray2 = zzks3.zzatu;
                    int n = zzks3.zzatu.length;
                    for (int i = 0; i < n; ++i) {
                        boolean bl3;
                        int n5;
                        zzkp zzkp2;
                        block100: {
                            zzkp2 = zzkpArray2[i];
                            if (zzkp2.name.equals("_ep")) {
                                this.zzjc();
                                String n9 = (String)zzjy.zzb(zzkp2, "_en");
                                object = (zzes)hashMap.get(n9);
                                if (object == null) {
                                    object = this.zzje().zzf(zza2.zzarh.zzti, n9);
                                    hashMap.put(n9, object);
                                }
                                if (((zzes)object).zzafw != null) continue;
                                if (((zzes)object).zzafx > 1L) {
                                    this.zzjc();
                                    zzkp2.zzatm = zzjy.zza(zzkp2.zzatm, "_sr", ((zzes)object).zzafx);
                                }
                                if (((zzes)object).zzafy != null && ((zzes)object).zzafy.booleanValue()) {
                                    this.zzjc();
                                    zzkp2.zzatm = zzjy.zza(zzkp2.zzatm, "_efs", 1L);
                                }
                                zzkpArray[n8++] = zzkp2;
                                continue;
                            }
                            n5 = 1;
                            Long l7 = 1L;
                            object4 = "_dbg";
                            object3 = zzkp2;
                            if (TextUtils.isEmpty((CharSequence)object4) || l7 == null) {
                                bl3 = false;
                            } else {
                                zzkq[] zzkqArray4 = ((zzkp)((Object)((Object)object3))).zzatm;
                                int n6 = ((zzkp)((Object)((Object)object3))).zzatm.length;
                                for (int j = 0; j < n6; ++j) {
                                    object2 = zzkqArray4[j];
                                    if (!((String)object4).equals(object2.name)) continue;
                                    bl3 = l7 instanceof Long && ((Object)l7).equals(object2.zzatq) || l7 instanceof String && ((Object)l7).equals(object2.zzajo) || l7 instanceof Double && ((Object)l7).equals(object2.zzaro);
                                    break block100;
                                }
                                bl3 = false;
                            }
                        }
                        if (!bl3) {
                            n5 = this.zzkv().zzp(zza2.zzarh.zzti, zzkp2.name);
                        }
                        if (n5 <= 0) {
                            this.zzacw.zzgf().zziv().zze("Sample rate must be positive. event, rate", zzkp2.name, n5);
                            zzkpArray[n8++] = zzkp2;
                            continue;
                        }
                        object = (zzes)hashMap.get(zzkp2.name);
                        if (object == null && (object = this.zzje().zzf(zza2.zzarh.zzti, zzkp2.name)) == null) {
                            this.zzacw.zzgf().zziv().zze("Event being bundled has no eventAggregate. appId, eventName", zza2.zzarh.zzti, zzkp2.name);
                            object = new zzes(zza2.zzarh.zzti, zzkp2.name, 1L, 1L, zzkp2.zzatn, 0L, null, null, null);
                        }
                        this.zzjc();
                        zzkqArray = (zzkq[])zzjy.zzb(zzkp2, "_eid");
                        Boolean bl4 = zzkqArray != null;
                        if (n5 == 1) {
                            zzkpArray[n8++] = zzkp2;
                            if (!bl4.booleanValue() || ((zzes)object).zzafw == null && ((zzes)object).zzafx == null && ((zzes)object).zzafy == null) continue;
                            object = ((zzes)object).zza(null, null, null);
                            hashMap.put(zzkp2.name, object);
                            continue;
                        }
                        if (secureRandom.nextInt(n5) == 0) {
                            this.zzjc();
                            zzkp2.zzatm = zzjy.zza(zzkp2.zzatm, "_sr", n5);
                            zzkpArray[n8++] = zzkp2;
                            if (bl4.booleanValue()) {
                                object = ((zzes)object).zza(null, Long.valueOf(n5), null);
                            }
                            hashMap.put(zzkp2.name, ((zzes)object).zzad(zzkp2.zzatn));
                            continue;
                        }
                        long l2 = ((zzes)object).zzafv;
                        if (Math.abs(zzkp2.zzatn - l2) >= 86400000L) {
                            this.zzjc();
                            zzkp2.zzatm = zzjy.zza(zzkp2.zzatm, "_efs", 1L);
                            this.zzjc();
                            zzkp2.zzatm = zzjy.zza(zzkp2.zzatm, "_sr", n5);
                            zzkpArray[n8++] = zzkp2;
                            if (bl4.booleanValue()) {
                                object = ((zzes)object).zza(null, Long.valueOf(n5), true);
                            }
                            hashMap.put(zzkp2.name, ((zzes)object).zzad(zzkp2.zzatn));
                            continue;
                        }
                        if (!bl4.booleanValue()) continue;
                        hashMap.put(zzkp2.name, ((zzes)object).zza((Long)zzkqArray, null, null));
                    }
                    if (n8 < zzks3.zzatu.length) {
                        zzks3.zzatu = Arrays.copyOf(zzkpArray, n8);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.zzje().zza((zzes)entry.getValue());
                    }
                }
                zzks3.zzatx = Long.MAX_VALUE;
                zzks3.zzaty = Long.MIN_VALUE;
                for (n3 = 0; n3 < zzks3.zzatu.length; ++n3) {
                    zzkp zzkp5 = zzks3.zzatu[n3];
                    if (zzkp5.zzatn < zzks3.zzatx) {
                        zzks3.zzatx = zzkp5.zzatn;
                    }
                    if (zzkp5.zzatn <= zzks3.zzaty) continue;
                    zzks3.zzaty = zzkp5.zzatn;
                }
                String string6 = zza2.zzarh.zzti;
                zzdy zzdy2 = this.zzje().zzbb(string6);
                if (zzdy2 == null) {
                    this.zzacw.zzgf().zzis().zzg("Bundling raw events w/o app info. appId", zzfh.zzbl(zza2.zzarh.zzti));
                } else if (zzks3.zzatu.length > 0) {
                    long l9 = zzdy2.zzgn();
                    zzks3.zzaua = l9 != 0L ? Long.valueOf(l9) : null;
                    long l10 = zzdy2.zzgm();
                    if (l10 == 0L) {
                        l10 = l9;
                    }
                    zzks3.zzatz = l10 != 0L ? Long.valueOf(l10) : null;
                    zzdy2.zzgv();
                    zzks3.zzauk = (int)zzdy2.zzgs();
                    zzdy2.zzm(zzks3.zzatx);
                    zzdy2.zzn(zzks3.zzaty);
                    zzks3.zzaek = zzdy2.zzhd();
                    this.zzje().zza(zzdy2);
                }
                if (zzks3.zzatu.length > 0) {
                    zzec zzec2 = this.zzacw.zzgi();
                    zzkm zzkm2 = this.zzkv().zzbt(zza2.zzarh.zzti);
                    if (zzkm2 == null || zzkm2.zzatb == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzarh.zzadm)) {
                            zzks3.zzaur = -1L;
                        } else {
                            this.zzacw.zzgf().zziv().zzg("Did not find measurement config or missing version info. appId", zzfh.zzbl(zza2.zzarh.zzti));
                        }
                    } else {
                        zzks3.zzaur = zzkm2.zzatb;
                    }
                    this.zzje().zza(zzks3, bl);
                }
                object4 = zza2.zzari;
                object3 = this.zzje();
                Preconditions.checkNotNull((Object)object4);
                ((zzhh)object3).zzab();
                ((zzjr)object3).zzch();
                StringBuilder stringBuilder = new StringBuilder("rowid in (");
                for (int sQLiteException = 0; sQLiteException < object4.size(); ++sQLiteException) {
                    if (sQLiteException != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append((Long)object4.get(sQLiteException));
                }
                stringBuilder.append(")");
                int n11 = ((zzej)object3).getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
                if (n11 != object4.size()) {
                    ((zzhh)object3).zzgf().zzis().zze("Deleted fewer rows from raw events table than expected", n11, object4.size());
                }
                object4 = string6;
                object3 = this.zzje();
                stringBuilder = ((zzej)object3).getWritableDatabase();
                try {
                    stringBuilder.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{object4, object4});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzhh)object3).zzgf().zzis().zze("Failed to remove unused event metadata. appId", zzfh.zzbl((String)object4), (Object)sQLiteException);
                }
                this.zzje().setTransactionSuccessful();
                return true;
            }
            this.zzje().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzje().endTransaction();
        }
    }

    private final zzko[] zza(String string, zzku[] zzkuArray, zzkp[] zzkpArray) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzjd().zza(string, zzkpArray, zzkuArray);
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzab();
        this.zzkz();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzarb;
            this.zzarb = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzacw.zzgg().zzakd.set(this.zzacw.zzbt().currentTimeMillis());
                    this.zzacw.zzgg().zzake.set(0L);
                    this.zzld();
                    this.zzacw.zzgf().zziz().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzje().beginTransaction();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzej zzej2 = this.zzje();
                                zzej2.zzab();
                                zzej2.zzch();
                                SQLiteDatabase sQLiteDatabase = zzej2.getWritableDatabase();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzej2.zzgf().zzis().zzg("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzarc != null && this.zzarc.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzje().setTransactionSuccessful();
                    }
                    finally {
                        this.zzje().endTransaction();
                    }
                    this.zzarc = null;
                    if (this.zzkw().zzex() && this.zzlc()) {
                        this.zzlb();
                    } else {
                        this.zzard = -1L;
                        this.zzld();
                    }
                    this.zzaqs = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzacw.zzgf().zzis().zzg("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzaqs = this.zzacw.zzbt().elapsedRealtime();
                    this.zzacw.zzgf().zziz().zzg("Disable upload, time", this.zzaqs);
                }
            } else {
                this.zzacw.zzgf().zziz().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzacw.zzgg().zzake.set(this.zzacw.zzbt().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzacw.zzgg().zzakf.set(this.zzacw.zzbt().currentTimeMillis());
                }
                if (this.zzacw.zzgh().zzaw(string)) {
                    this.zzje().zzc(list);
                }
                this.zzld();
            }
            return;
        }
        finally {
            this.zzaqx = false;
            this.zzle();
        }
    }

    private final boolean zzlc() {
        this.zzab();
        this.zzkz();
        return this.zzje().zzhw() || !TextUtils.isEmpty((CharSequence)this.zzje().zzhr());
    }

    @WorkerThread
    private final void zzb(zzdy zzdy2) {
        this.zzab();
        if (TextUtils.isEmpty((CharSequence)zzdy2.getGmpAppId())) {
            this.zzb(zzdy2.zzah(), 204, null, null, null);
            return;
        }
        Object object = zzdy2.getAppInstanceId();
        String string = zzdy2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzey.zzagt.get()).encodedAuthority(zzey.zzagu.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "12451");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzacw.zzgf().zziz().zzg("Fetching remote configuration", zzdy2.zzah());
            zzkm zzkm2 = this.zzkv().zzbt(zzdy2.zzah());
            ArrayMap arrayMap = null;
            String string4 = this.zzkv().zzbu(zzdy2.zzah());
            if (zzkm2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzaqw = true;
            zzjv zzjv2 = new zzjv(this);
            builder = arrayMap;
            object = uRL;
            string = zzdy2.zzah();
            zzfl zzfl2 = this.zzkw();
            ((zzhh)zzfl2).zzab();
            zzfl2.zzch();
            Preconditions.checkNotNull((Object)object);
            Preconditions.checkNotNull((Object)zzjv2);
            ((zzhh)zzfl2).zzge().zzd(new zzfp(zzfl2, string, (URL)object, null, (Map)builder, zzjv2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzacw.zzgf().zzis().zze("Failed to parse config URL. Not fetching. appId", zzfh.zzbl(zzdy2.zzah()), string3);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzab();
        this.zzkz();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzacw.zzgf().zziz().zzg("onConfigFetched. Response size", byArray.length);
            this.zzje().beginTransaction();
            try {
                boolean bl;
                zzdy zzdy2 = this.zzje().zzbb(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzdy2 == null) {
                    this.zzacw.zzgf().zziv().zzg("App does not exist in onConfigFetched. appId", zzfh.zzbl(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzkv().zzbt(string) == null && !this.zzkv().zza(string, null, null) : !this.zzkv().zza(string, byArray, string2)) {
                        return;
                    }
                    zzdy2.zzs(this.zzacw.zzbt().currentTimeMillis());
                    this.zzje().zza(zzdy2);
                    if (n == 404) {
                        this.zzacw.zzgf().zziw().zzg("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzacw.zzgf().zziz().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzkw().zzex() && this.zzlc()) {
                        this.zzlb();
                    } else {
                        this.zzld();
                    }
                } else {
                    zzdy2.zzt(this.zzacw.zzbt().currentTimeMillis());
                    this.zzje().zza(zzdy2);
                    this.zzacw.zzgf().zziz().zze("Fetching config failed. code, error", n, throwable);
                    this.zzkv().zzbv(string);
                    this.zzacw.zzgg().zzake.set(this.zzacw.zzbt().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzacw.zzgg().zzakf.set(this.zzacw.zzbt().currentTimeMillis());
                    }
                    this.zzld();
                }
                this.zzje().setTransactionSuccessful();
            }
            finally {
                this.zzje().endTransaction();
            }
            return;
        }
        finally {
            this.zzaqw = false;
            this.zzle();
        }
    }

    @WorkerThread
    private final void zzld() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzab();
            this.zzkz();
            if (!this.zzlh()) {
                return;
            }
            if (this.zzaqs > 0L) {
                l3 = this.zzacw.zzbt().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzaqs);
                if (l2 > 0L) {
                    this.zzacw.zzgf().zziz().zzg("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzkx().unregister();
                    this.zzky().cancel();
                    return;
                }
                this.zzaqs = 0L;
            }
            if (!this.zzacw.zzkd() || !this.zzlc()) {
                this.zzacw.zzgf().zziz().log("Nothing to upload or uploading impossible");
                this.zzkx().unregister();
                this.zzky().cancel();
                return;
            }
            zzjs zzjs2 = this;
            long l4 = zzjs2.zzacw.zzbt().currentTimeMillis();
            long l5 = Math.max(0L, zzey.zzahp.get());
            boolean bl = zzjs2.zzje().zzhx() || zzjs2.zzje().zzhs();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzjs2.zzacw.zzgh().zzhn())) && !".none.".equals(string) ? Math.max(0L, zzey.zzahk.get()) : Math.max(0L, zzey.zzahj.get())) : Math.max(0L, zzey.zzahi.get());
            long l7 = zzjs2.zzacw.zzgg().zzakd.get();
            long l8 = zzjs2.zzacw.zzgg().zzake.get();
            long l9 = zzjs2.zzje().zzhu();
            long l10 = zzjs2.zzje().zzhv();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzjs2.zzacw.zzgc().zza(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, zzey.zzahr.get())); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, zzey.zzahq.get()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzacw.zzgf().zziz().log("Next upload time is 0");
            this.zzkx().unregister();
            this.zzky().cancel();
            return;
        }
        if (!this.zzkw().zzex()) {
            this.zzacw.zzgf().zziz().log("No network");
            this.zzkx().zzeu();
            this.zzky().cancel();
            return;
        }
        l2 = this.zzacw.zzgg().zzakf.get();
        long l16 = Math.max(0L, zzey.zzahg.get());
        if (!this.zzacw.zzgc().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzkx().unregister();
        long l17 = l3 - this.zzacw.zzbt().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, zzey.zzahl.get());
            this.zzacw.zzgg().zzakd.set(this.zzacw.zzbt().currentTimeMillis());
        }
        this.zzacw.zzgf().zziz().zzg("Upload scheduled in approximately ms", l17);
        this.zzky().zzh(l17);
    }

    @WorkerThread
    final void zzg(Runnable runnable) {
        this.zzab();
        if (this.zzaqt == null) {
            this.zzaqt = new ArrayList<Runnable>();
        }
        this.zzaqt.add(runnable);
    }

    @WorkerThread
    private final void zzle() {
        this.zzab();
        if (this.zzaqw || this.zzaqx || this.zzaqy) {
            this.zzacw.zzgf().zziz().zzd("Not stopping services. fetch, network, upload", this.zzaqw, this.zzaqx, this.zzaqy);
            return;
        }
        this.zzacw.zzgf().zziz().log("Stopping uploading service(s)");
        if (this.zzaqt == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzaqt.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzaqt.clear();
    }

    @WorkerThread
    private final Boolean zzc(zzdy zzdy2) {
        try {
            if (zzdy2.zzgo() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzacw.getContext()).getPackageInfo((String)zzdy2.zzah(), (int)0).versionCode;
                if (zzdy2.zzgo() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzacw.getContext()).getPackageInfo((String)zzdy2.zzah(), (int)0).versionName;
                if (zzdy2.zzag() != null && zzdy2.zzag().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzlf() {
        this.zzab();
        String string = "google_app_measurement.db";
        File file = this.zzacw.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzara = new RandomAccessFile(file2, "rw").getChannel();
            this.zzaqz = this.zzara.tryLock();
            if (this.zzaqz != null) {
                this.zzacw.zzgf().zziz().log("Storage concurrent access okay");
                return true;
            }
            this.zzacw.zzgf().zzis().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzacw.zzgf().zzis().zzg("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzacw.zzgf().zzis().zzg("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzab();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzacw.zzgf().zzis().log("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzacw.zzgf().zziv().zzg("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzacw.zzgf().zzis().zzg("Failed to read from channel", iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzab();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzacw.zzgf().zzis().log("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzacw.zzgf().zzis().zzg("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzacw.zzgf().zzis().zzg("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    final void zzlg() {
        this.zzab();
        this.zzkz();
        if (!this.zzaqr) {
            this.zzacw.zzgf().zzix().log("This instance being marked as an uploader");
            zzjs zzjs2 = this;
            zzjs2.zzab();
            zzjs2.zzkz();
            if (zzjs2.zzlh() && zzjs2.zzlf()) {
                int n;
                int n2 = zzjs2.zza(zzjs2.zzara);
                int n3 = n = zzjs2.zzacw.zzfw().zzip();
                int n4 = n2;
                zzjs zzjs3 = zzjs2;
                zzjs3.zzab();
                if (n4 > n3) {
                    zzjs3.zzacw.zzgf().zzis().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzjs3.zza(n3, zzjs3.zzara)) {
                        zzjs3.zzacw.zzgf().zziz().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzjs3.zzacw.zzgf().zzis().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzaqr = true;
            this.zzld();
        }
    }

    @WorkerThread
    private final boolean zzlh() {
        this.zzab();
        this.zzkz();
        return this.zzaqr;
    }

    @VisibleForTesting
    @WorkerThread
    final void zzd(zzdz zzdz2) {
        if (this.zzarb != null) {
            this.zzarc = new ArrayList<Long>();
            this.zzarc.addAll(this.zzarb);
        }
        String string = zzdz2.packageName;
        zzej zzej2 = this.zzje();
        Preconditions.checkNotEmpty((String)string);
        zzej2.zzab();
        zzej2.zzch();
        try {
            SQLiteDatabase sQLiteDatabase = zzej2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzej2.zzgf().zziz().zze("Reset analytics data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzej2.zzgf().zzis().zze("Error resetting analytics data. appId, error", zzfh.zzbl(string), (Object)sQLiteException);
        }
        zzdz zzdz3 = this.zza(this.zzacw.getContext(), zzdz2.packageName, zzdz2.zzadm, zzdz2.zzadw, zzdz2.zzady, zzdz2.zzadz, zzdz2.zzaem);
        if (!this.zzacw.zzgh().zzay(zzdz2.packageName) || zzdz2.zzadw) {
            this.zzf(zzdz3);
        }
    }

    private final zzdz zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l) {
        String string3 = "Unknown";
        String string4 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string5 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzacw.zzgf().zzis().log("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string3 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzacw.zzgf().zzis().zzg("Error retrieving installer package name. appId", zzfh.zzbl(string));
        }
        if (string3 == null) {
            string3 = "manual_install";
        } else if ("com.android.vending".equals(string3)) {
            string3 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string5 = charSequence.toString();
                }
                string4 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzacw.zzgf().zzis().zze("Error retrieving newly installed package info. appId, appName", zzfh.zzbl(string), string5);
            return null;
        }
        long l2 = 0L;
        zzec zzec2 = this.zzacw.zzgi();
        long l3 = 0L;
        if (this.zzacw.zzgh().zzaz(string)) {
            l3 = l;
        }
        return new zzdz(string, string2, string4, n, string3, 12451L, this.zzacw.zzgc().zzd(context, string), null, bl, false, "", l2, l3, 0, bl2, bl3, false);
    }

    @WorkerThread
    final void zzb(zzjz zzjz2, zzdz zzdz2) {
        this.zzab();
        this.zzkz();
        if (TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            return;
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        int n = this.zzacw.zzgc().zzce(zzjz2.name);
        if (n != 0) {
            this.zzacw.zzgc();
            String string = zzkc.zza(zzjz2.name, 24, true);
            int n2 = zzjz2.name != null ? zzjz2.name.length() : 0;
            this.zzacw.zzgc().zza(zzdz2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzacw.zzgc().zzi(zzjz2.name, zzjz2.getValue());
        if (n != 0) {
            this.zzacw.zzgc();
            String string = zzkc.zza(zzjz2.name, 24, true);
            Object object = zzjz2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzacw.zzgc().zza(zzdz2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzacw.zzgc().zzj(zzjz2.name, zzjz2.getValue());
        if (object == null) {
            return;
        }
        zzkb zzkb2 = new zzkb(zzdz2.packageName, zzjz2.origin, zzjz2.name, zzjz2.zzarl, object);
        this.zzacw.zzgf().zziy().zze("Setting user property", this.zzacw.zzgb().zzbk(zzkb2.name), object);
        this.zzje().beginTransaction();
        try {
            this.zzg(zzdz2);
            boolean bl = this.zzje().zza(zzkb2);
            this.zzje().setTransactionSuccessful();
            if (bl) {
                this.zzacw.zzgf().zziy().zze("User property set", this.zzacw.zzgb().zzbk(zzkb2.name), zzkb2.value);
            } else {
                this.zzacw.zzgf().zzis().zze("Too many unique user properties are set. Ignoring user property", this.zzacw.zzgb().zzbk(zzkb2.name), zzkb2.value);
                this.zzacw.zzgc().zza(zzdz2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzje().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzjz zzjz2, zzdz zzdz2) {
        this.zzab();
        this.zzkz();
        if (TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            return;
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        this.zzacw.zzgf().zziy().zzg("Removing user property", this.zzacw.zzgb().zzbk(zzjz2.name));
        this.zzje().beginTransaction();
        try {
            this.zzg(zzdz2);
            this.zzje().zzg(zzdz2.packageName, zzjz2.name);
            this.zzje().setTransactionSuccessful();
            this.zzacw.zzgf().zziy().zzg("User property removed", this.zzacw.zzgb().zzbk(zzjz2.name));
            return;
        }
        finally {
            this.zzje().endTransaction();
        }
    }

    final void zzb(zzjr zzjr2) {
        ++this.zzaqu;
    }

    final void zzli() {
        ++this.zzaqv;
    }

    final zzgm zzlj() {
        return this.zzacw;
    }

    @WorkerThread
    public final void zzf(zzdz zzdz2) {
        int n;
        this.zzab();
        this.zzkz();
        Preconditions.checkNotNull((Object)((Object)zzdz2));
        Preconditions.checkNotEmpty((String)zzdz2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            return;
        }
        zzdy zzdy2 = this.zzje().zzbb(zzdz2.packageName);
        if (zzdy2 != null && TextUtils.isEmpty((CharSequence)zzdy2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            zzdy2.zzs(0L);
            this.zzje().zza(zzdy2);
            this.zzkv().zzbw(zzdz2.packageName);
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        long l = zzdz2.zzaem;
        if (l == 0L) {
            l = this.zzacw.zzbt().currentTimeMillis();
        }
        if ((n = zzdz2.zzaen) != 0 && n != 1) {
            this.zzacw.zzgf().zziv().zze("Incorrect app type, assuming installed app. appId, appType", zzfh.zzbl(zzdz2.packageName), n);
            n = 0;
        }
        this.zzje().beginTransaction();
        try {
            zzew zzew2;
            Object object;
            long l2 = l;
            zzdz zzdz3 = zzdz2;
            zzjs zzjs2 = this;
            zzdy zzdy3 = zzjs2.zzje().zzbb(zzdz3.packageName);
            if (zzdy3 != null && zzdy3.getGmpAppId() != null && !zzdy3.getGmpAppId().equals(zzdz3.zzadm)) {
                zzjs2.zzacw.zzgf().zziv().zzg("New GMP App Id passed in. Removing cached database data. appId", zzfh.zzbl(zzdy3.zzah()));
                String string = zzdy3.zzah();
                zzej zzej2 = zzjs2.zzje();
                zzej2.zzch();
                zzej2.zzab();
                Preconditions.checkNotEmpty((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzej2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzej2.zzgf().zziz().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzej2.zzgf().zzis().zze("Error deleting application data. appId, error", zzfh.zzbl(string), (Object)sQLiteException);
                }
                zzdy3 = null;
            }
            if (zzdy3 != null) {
                if (zzdy3.zzgo() != Integer.MIN_VALUE) {
                    if (zzdy3.zzgo() != zzdz3.zzads) {
                        object = new Bundle();
                        object.putString("_pv", zzdy3.zzag());
                        zzew2 = new zzew("_au", new zzet((Bundle)object), "auto", l2);
                        zzjs2.zzb(zzew2, zzdz3);
                    }
                } else if (zzdy3.zzag() != null && !zzdy3.zzag().equals(zzdz3.zzth)) {
                    object = new Bundle();
                    object.putString("_pv", zzdy3.zzag());
                    zzew2 = new zzew("_au", new zzet((Bundle)object), "auto", l2);
                    zzjs2.zzb(zzew2, zzdz3);
                }
            }
            this.zzg(zzdz2);
            zzes zzes2 = null;
            if (n == 0) {
                zzes2 = this.zzje().zzf(zzdz2.packageName, "_f");
            } else if (n == 1) {
                zzes2 = this.zzje().zzf(zzdz2.packageName, "_v");
            }
            if (zzes2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    AbstractSafeParcelable abstractSafeParcelable;
                    zzjz zzjz2 = new zzjz("_fot", l, l3, "auto");
                    this.zzb(zzjz2, zzdz2);
                    l2 = l;
                    zzdz3 = zzdz2;
                    zzjs2 = this;
                    zzjs2.zzab();
                    zzjs2.zzkz();
                    zzdy3 = new Bundle();
                    zzdy3.putLong("_c", 1L);
                    zzdy3.putLong("_r", 1L);
                    zzdy3.putLong("_uwa", 0L);
                    zzdy3.putLong("_pfo", 0L);
                    zzdy3.putLong("_sys", 0L);
                    zzdy3.putLong("_sysu", 0L);
                    if (zzjs2.zzacw.zzgh().zzay(zzdz3.packageName) && zzdz3.zzaeo) {
                        zzdy3.putLong("_dac", 1L);
                    }
                    if (zzjs2.zzacw.getContext().getPackageManager() == null) {
                        zzjs2.zzacw.zzgf().zzis().zzg("PackageManager is null, first open report might be inaccurate. appId", zzfh.zzbl(zzdz3.packageName));
                    } else {
                        zzew2 = null;
                        try {
                            zzew2 = Wrappers.packageManager((Context)zzjs2.zzacw.getContext()).getPackageInfo(zzdz3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjs2.zzacw.zzgf().zzis().zze("Package info is null, first open report might be inaccurate. appId", zzfh.zzbl(zzdz3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzew2 != null && ((PackageInfo)zzew2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzew2).firstInstallTime != ((PackageInfo)zzew2).lastUpdateTime) {
                                zzdy3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            abstractSafeParcelable = new zzjz("_fi", l2, bl ? 1L : 0L, "auto");
                            zzjs2.zzb((zzjz)abstractSafeParcelable, zzdz3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzjs2.zzacw.getContext()).getApplicationInfo(zzdz3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjs2.zzacw.zzgf().zzis().zze("Application info is null, first open report might be inaccurate. appId", zzfh.zzbl(zzdz3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzdy3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzdy3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzdz3.packageName;
                    zzej zzej3 = zzjs2.zzje();
                    Preconditions.checkNotEmpty((String)string);
                    zzej3.zzab();
                    zzej3.zzch();
                    long l4 = zzej3.zzm(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzdy3.putLong("_pfo", l4);
                    }
                    abstractSafeParcelable = new zzew("_f", new zzet((Bundle)zzdy3), "auto", l2);
                    zzjs2.zzb((zzew)abstractSafeParcelable, zzdz3);
                } else if (n == 1) {
                    zzjz zzjz3 = new zzjz("_fvt", l, l3, "auto");
                    this.zzb(zzjz3, zzdz2);
                    l2 = l;
                    zzdz3 = zzdz2;
                    zzjs2 = this;
                    zzjs2.zzab();
                    zzjs2.zzkz();
                    zzdy3 = new Bundle();
                    zzdy3.putLong("_c", 1L);
                    zzdy3.putLong("_r", 1L);
                    if (zzjs2.zzacw.zzgh().zzay(zzdz3.packageName) && zzdz3.zzaeo) {
                        zzdy3.putLong("_dac", 1L);
                    }
                    object = new zzew("_v", new zzet((Bundle)zzdy3), "auto", l2);
                    zzjs2.zzb((zzew)((Object)object), zzdz3);
                }
                l2 = l;
                zzdz3 = zzdz2;
                zzjs2 = this;
                zzdy3 = new Bundle();
                zzdy3.putLong("_et", 1L);
                object = new zzew("_e", new zzet((Bundle)zzdy3), "auto", l2);
                zzjs2.zzb((zzew)((Object)object), zzdz3);
            } else if (zzdz2.zzael) {
                l2 = l;
                zzdz3 = zzdz2;
                zzjs2 = this;
                zzdy3 = new Bundle();
                object = new zzew("_cd", new zzet((Bundle)zzdy3), "auto", l2);
                zzjs2.zzb((zzew)((Object)object), zzdz3);
            }
            this.zzje().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzje().endTransaction();
        }
    }

    @WorkerThread
    final zzdz zzca(String string) {
        zzdy zzdy2 = this.zzje().zzbb(string);
        if (zzdy2 == null || TextUtils.isEmpty((CharSequence)zzdy2.zzag())) {
            this.zzacw.zzgf().zziy().zzg("No app data available; dropping", string);
            return null;
        }
        Boolean bl = this.zzc(zzdy2);
        if (bl != null && !bl.booleanValue()) {
            this.zzacw.zzgf().zzis().zzg("App version does not match; dropping. appId", zzfh.zzbl(string));
            return null;
        }
        return new zzdz(string, zzdy2.getGmpAppId(), zzdy2.zzag(), zzdy2.zzgo(), zzdy2.zzgp(), zzdy2.zzgq(), zzdy2.zzgr(), null, zzdy2.isMeasurementEnabled(), false, zzdy2.zzgl(), zzdy2.zzhe(), 0L, 0, zzdy2.zzhf(), zzdy2.zzhg(), false);
    }

    @WorkerThread
    final void zzb(zzee zzee2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzee2));
        Preconditions.checkNotEmpty((String)zzee2.packageName);
        Preconditions.checkNotNull((Object)zzee2.origin);
        Preconditions.checkNotNull((Object)((Object)zzee2.zzaeq));
        Preconditions.checkNotEmpty((String)zzee2.zzaeq.name);
        this.zzab();
        this.zzkz();
        if (TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            return;
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        zzee zzee3 = new zzee(zzee2);
        new zzee(zzee2).active = false;
        this.zzje().beginTransaction();
        try {
            boolean bl = false;
            zzee zzee4 = this.zzje().zzi(zzee3.packageName, zzee3.zzaeq.name);
            if (zzee4 != null && !zzee4.origin.equals(zzee3.origin)) {
                this.zzacw.zzgf().zziv().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzacw.zzgb().zzbk(zzee3.zzaeq.name), zzee3.origin, zzee4.origin);
            }
            if (zzee4 != null && zzee4.active) {
                zzee3.origin = zzee4.origin;
                zzee3.creationTimestamp = zzee4.creationTimestamp;
                zzee3.triggerTimeout = zzee4.triggerTimeout;
                zzee3.triggerEventName = zzee4.triggerEventName;
                zzee3.zzaes = zzee4.zzaes;
                zzee3.active = zzee4.active;
                zzee3.zzaeq = new zzjz(zzee3.zzaeq.name, zzee4.zzaeq.zzarl, zzee3.zzaeq.getValue(), zzee4.zzaeq.origin);
            } else if (TextUtils.isEmpty((CharSequence)zzee3.triggerEventName)) {
                zzee3.zzaeq = new zzjz(zzee3.zzaeq.name, zzee3.creationTimestamp, zzee3.zzaeq.getValue(), zzee3.zzaeq.origin);
                zzee3.active = true;
                bl = true;
            }
            if (zzee3.active) {
                zzjz zzjz2 = zzee3.zzaeq;
                zzkb zzkb2 = new zzkb(zzee3.packageName, zzee3.origin, zzjz2.name, zzjz2.zzarl, zzjz2.getValue());
                if (this.zzje().zza(zzkb2)) {
                    this.zzacw.zzgf().zziy().zzd("User property updated immediately", zzee3.packageName, this.zzacw.zzgb().zzbk(zzkb2.name), zzkb2.value);
                } else {
                    this.zzacw.zzgf().zzis().zzd("(2)Too many active user properties, ignoring", zzfh.zzbl(zzee3.packageName), this.zzacw.zzgb().zzbk(zzkb2.name), zzkb2.value);
                }
                if (bl && zzee3.zzaes != null) {
                    zzew zzew2 = new zzew(zzee3.zzaes, zzee3.creationTimestamp);
                    this.zzc(zzew2, zzdz2);
                }
            }
            if (this.zzje().zza(zzee3)) {
                this.zzacw.zzgf().zziy().zzd("Conditional property added", zzee3.packageName, this.zzacw.zzgb().zzbk(zzee3.zzaeq.name), zzee3.zzaeq.getValue());
            } else {
                this.zzacw.zzgf().zzis().zzd("Too many conditional properties, ignoring", zzfh.zzbl(zzee3.packageName), this.zzacw.zzgb().zzbk(zzee3.zzaeq.name), zzee3.zzaeq.getValue());
            }
            this.zzje().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzje().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzee zzee2, zzdz zzdz2) {
        Preconditions.checkNotNull((Object)((Object)zzee2));
        Preconditions.checkNotEmpty((String)zzee2.packageName);
        Preconditions.checkNotNull((Object)((Object)zzee2.zzaeq));
        Preconditions.checkNotEmpty((String)zzee2.zzaeq.name);
        this.zzab();
        this.zzkz();
        if (TextUtils.isEmpty((CharSequence)zzdz2.zzadm)) {
            return;
        }
        if (!zzdz2.zzadw) {
            this.zzg(zzdz2);
            return;
        }
        this.zzje().beginTransaction();
        try {
            this.zzg(zzdz2);
            zzee zzee3 = this.zzje().zzi(zzee2.packageName, zzee2.zzaeq.name);
            if (zzee3 != null) {
                this.zzacw.zzgf().zziy().zze("Removing conditional user property", zzee2.packageName, this.zzacw.zzgb().zzbk(zzee2.zzaeq.name));
                this.zzje().zzj(zzee2.packageName, zzee2.zzaeq.name);
                if (zzee3.active) {
                    this.zzje().zzg(zzee2.packageName, zzee2.zzaeq.name);
                }
                if (zzee2.zzaet != null) {
                    Bundle bundle = null;
                    if (zzee2.zzaet.zzafr != null) {
                        bundle = zzee2.zzaet.zzafr.zzij();
                    }
                    zzew zzew2 = this.zzacw.zzgc().zza(zzee2.zzaet.name, bundle, zzee3.origin, zzee2.zzaet.zzagc, true, false);
                    this.zzc(zzew2, zzdz2);
                }
            } else {
                this.zzacw.zzgf().zziv().zze("Conditional user property doesn't exist", zzfh.zzbl(zzee2.packageName), this.zzacw.zzgb().zzbk(zzee2.zzaeq.name));
            }
            this.zzje().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzje().endTransaction();
        }
    }

    @WorkerThread
    private final zzdy zzg(zzdz zzdz2) {
        this.zzab();
        this.zzkz();
        Preconditions.checkNotNull((Object)((Object)zzdz2));
        Preconditions.checkNotEmpty((String)zzdz2.packageName);
        zzdy zzdy2 = this.zzje().zzbb(zzdz2.packageName);
        String string = this.zzacw.zzgg().zzbo(zzdz2.packageName);
        boolean bl = false;
        if (zzdy2 == null) {
            zzdy2 = new zzdy(this.zzacw, zzdz2.packageName);
            zzdy2.zzak(this.zzacw.zzfw().zzio());
            zzdy2.zzam(string);
            bl = true;
        } else if (!string.equals(zzdy2.zzgk())) {
            zzdy2.zzam(string);
            zzdy2.zzak(this.zzacw.zzfw().zzio());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzdz2.zzadm) && !zzdz2.zzadm.equals(zzdy2.getGmpAppId())) {
            zzdy2.zzal(zzdz2.zzadm);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzdz2.zzado) && !zzdz2.zzado.equals(zzdy2.zzgl())) {
            zzdy2.zzan(zzdz2.zzado);
            bl = true;
        }
        if (zzdz2.zzadu != 0L && zzdz2.zzadu != zzdy2.zzgq()) {
            zzdy2.zzp(zzdz2.zzadu);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzdz2.zzth) && !zzdz2.zzth.equals(zzdy2.zzag())) {
            zzdy2.setAppVersion(zzdz2.zzth);
            bl = true;
        }
        if (zzdz2.zzads != zzdy2.zzgo()) {
            zzdy2.zzo(zzdz2.zzads);
            bl = true;
        }
        if (zzdz2.zzadt != null && !zzdz2.zzadt.equals(zzdy2.zzgp())) {
            zzdy2.zzao(zzdz2.zzadt);
            bl = true;
        }
        if (zzdz2.zzadv != zzdy2.zzgr()) {
            zzdy2.zzq(zzdz2.zzadv);
            bl = true;
        }
        if (zzdz2.zzadw != zzdy2.isMeasurementEnabled()) {
            zzdy2.setMeasurementEnabled(zzdz2.zzadw);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzdz2.zzaek) && !zzdz2.zzaek.equals(zzdy2.zzhc())) {
            zzdy2.zzap(zzdz2.zzaek);
            bl = true;
        }
        if (zzdz2.zzadx != zzdy2.zzhe()) {
            zzdy2.zzaa(zzdz2.zzadx);
            bl = true;
        }
        if (zzdz2.zzady != zzdy2.zzhf()) {
            zzdy2.zzd(zzdz2.zzady);
            bl = true;
        }
        if (zzdz2.zzadz != zzdy2.zzhg()) {
            zzdy2.zze(zzdz2.zzadz);
            bl = true;
        }
        if (bl) {
            this.zzje().zza(zzdy2);
        }
        return zzdy2;
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzew zzew2, @Size(min=1L) String string) {
        Long l;
        this.zzkz();
        this.zzab();
        this.zzacw.zzfr();
        Preconditions.checkNotNull((Object)((Object)zzew2));
        Preconditions.checkNotEmpty((String)string);
        zzkr zzkr2 = new zzkr();
        this.zzje().beginTransaction();
        try {
            zzes zzes2;
            long l2;
            Object object;
            zzdy zzdy2 = this.zzje().zzbb(string);
            if (zzdy2 == null) {
                this.zzacw.zzgf().zziy().zzg("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzdy2.isMeasurementEnabled()) {
                this.zzacw.zzgf().zziy().zzg("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (("_iap".equals(zzew2.name) || "ecommerce_purchase".equals(zzew2.name)) && !this.zza(string, zzew2)) {
                this.zzacw.zzgf().zziv().zzg("Failed to handle purchase event at single event bundle creation. appId", zzfh.zzbl(string));
            }
            boolean bl = this.zzacw.zzgh().zzau(string);
            l = 0L;
            if (bl && "_e".equals(zzew2.name)) {
                if (zzew2.zzafr == null || zzew2.zzafr.size() == 0) {
                    this.zzacw.zzgf().zziv().zzg("The engagement event does not contain any parameters. appId", zzfh.zzbl(string));
                } else if (zzew2.zzafr.getLong("_et") == null) {
                    this.zzacw.zzgf().zziv().zzg("The engagement event does not include duration. appId", zzfh.zzbl(string));
                } else {
                    l = zzew2.zzafr.getLong("_et");
                }
            }
            zzks zzks2 = new zzks();
            zzkr2.zzatr = new zzks[]{zzks2};
            zzks2.zzatt = 1;
            zzks2.zzaub = "android";
            zzks2.zzti = zzdy2.zzah();
            zzks2.zzadt = zzdy2.zzgp();
            zzks2.zzth = zzdy2.zzag();
            long l3 = zzdy2.zzgo();
            zzks2.zzaun = l3 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l3);
            zzks2.zzauf = zzdy2.zzgq();
            zzks2.zzadm = zzdy2.getGmpAppId();
            zzks2.zzauj = zzdy2.zzgr();
            if (this.zzacw.isEnabled() && zzeg.zzho() && this.zzacw.zzgh().zzas(zzks2.zzti)) {
                zzks2.zzaut = null;
            }
            Pair<String, Boolean> pair = this.zzacw.zzgg().zzbn(zzdy2.zzah());
            if (zzdy2.zzhf() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                zzks2.zzauh = (String)pair.first;
                zzks2.zzaui = (Boolean)pair.second;
            }
            this.zzacw.zzfx().zzch();
            zzks2.zzaud = Build.MODEL;
            this.zzacw.zzfx().zzch();
            zzks2.zzauc = Build.VERSION.RELEASE;
            zzks2.zzaue = (int)this.zzacw.zzfx().zzig();
            zzks2.zzafo = this.zzacw.zzfx().zzih();
            zzks2.zzadl = zzdy2.getAppInstanceId();
            zzks2.zzado = zzdy2.zzgl();
            List<zzkb> list = this.zzje().zzba(zzdy2.zzah());
            zzks2.zzatv = new zzku[list.size()];
            zzkb zzkb2 = null;
            if (bl) {
                zzkb2 = this.zzje().zzh(zzks2.zzti, "_lte");
                if (zzkb2 == null || zzkb2.value == null) {
                    zzkb2 = new zzkb(zzks2.zzti, "auto", "_lte", this.zzacw.zzbt().currentTimeMillis(), l);
                } else if (l > 0L) {
                    zzkb2 = new zzkb(zzks2.zzti, "auto", "_lte", this.zzacw.zzbt().currentTimeMillis(), (Long)zzkb2.value + l);
                }
            }
            zzku zzku2 = null;
            for (int i = 0; i < list.size(); ++i) {
                object = new zzku();
                zzks2.zzatv[i] = object;
                ((zzku)((Object)object)).name = list.get((int)i).name;
                ((zzku)((Object)object)).zzauz = list.get((int)i).zzarl;
                this.zzjc().zza((zzku)((Object)object), list.get((int)i).value);
                if (!bl || !"_lte".equals(((zzku)((Object)object)).name)) continue;
                zzku2 = object;
                ((zzku)((Object)object)).zzatq = (Long)zzkb2.value;
                zzku2.zzauz = this.zzacw.zzbt().currentTimeMillis();
            }
            if (bl && zzku2 == null) {
                zzku2 = new zzku();
                new zzku().name = "_lte";
                zzku2.zzauz = this.zzacw.zzbt().currentTimeMillis();
                zzku2.zzatq = (Long)zzkb2.value;
                zzks2.zzatv = Arrays.copyOf(zzks2.zzatv, zzks2.zzatv.length + 1);
                zzks2.zzatv[zzks2.zzatv.length - 1] = zzku2;
            }
            if (l > 0L) {
                this.zzje().zza(zzkb2);
            }
            Bundle bundle = zzew2.zzafr.zzij();
            if ("_iap".equals(zzew2.name)) {
                bundle.putLong("_c", 1L);
                this.zzacw.zzgf().zziy().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzew2.origin);
            if (this.zzacw.zzgc().zzci(zzks2.zzti)) {
                this.zzacw.zzgc().zza(bundle, "_dbg", 1L);
                this.zzacw.zzgc().zza(bundle, "_r", 1L);
            }
            if ((object = this.zzje().zzf(string, zzew2.name)) == null) {
                l2 = 0L;
                zzes2 = new zzes(string, zzew2.name, 1L, 0L, zzew2.zzagc, 0L, null, null, null);
                this.zzje().zza(zzes2);
            } else {
                l2 = ((zzes)object).zzafu;
                zzes2 = ((zzes)object).zzac(zzew2.zzagc).zzii();
                this.zzje().zza(zzes2);
            }
            zzer zzer2 = new zzer(this.zzacw, zzew2.origin, string, zzew2.name, zzew2.zzagc, l2, bundle);
            zzkp zzkp2 = new zzkp();
            zzks2.zzatu = new zzkp[]{zzkp2};
            zzkp2.zzatn = zzer2.timestamp;
            zzkp2.name = zzer2.name;
            zzkp2.zzato = zzer2.zzafq;
            zzkp2.zzatm = new zzkq[zzer2.zzafr.size()];
            int n = 0;
            for (String string2 : zzer2.zzafr) {
                zzkq zzkq2 = new zzkq();
                zzkp2.zzatm[n++] = zzkq2;
                zzkq2.name = string2;
                Object object2 = zzer2.zzafr.get(string2);
                this.zzjc().zza(zzkq2, object2);
            }
            zzks2.zzaum = this.zza(zzdy2.zzah(), zzks2.zzatv, zzks2.zzatu);
            zzks2.zzatx = zzkp2.zzatn;
            zzks2.zzaty = zzkp2.zzatn;
            long l4 = zzdy2.zzgn();
            zzks2.zzaua = l4 != 0L ? Long.valueOf(l4) : null;
            long l5 = zzdy2.zzgm();
            if (l5 == 0L) {
                l5 = l4;
            }
            zzks2.zzatz = l5 != 0L ? Long.valueOf(l5) : null;
            zzdy2.zzgv();
            zzks2.zzauk = (int)zzdy2.zzgs();
            zzks2.zzaug = 12451L;
            zzks2.zzatw = this.zzacw.zzbt().currentTimeMillis();
            zzks2.zzaul = Boolean.TRUE;
            zzdy2.zzm(zzks2.zzatx);
            zzdy2.zzn(zzks2.zzaty);
            this.zzje().zza(zzdy2);
            this.zzje().setTransactionSuccessful();
        }
        finally {
            this.zzje().endTransaction();
        }
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzkr2.zzvv()];
            l = zzaby.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkr2.zza((zzaby)l);
            l.zzvn();
            return this.zzacw.zzgc().zza(byArray);
        }
        catch (IOException iOException) {
            this.zzacw.zzgf().zzis().zze("Data loss. Failed to bundle and serialize. appId", zzfh.zzbl(string), iOException);
            return null;
        }
    }

    public final String zzh(zzdz zzdz2) {
        Future<String> future = this.zzacw.zzge().zzb(new zzjw(this, zzdz2));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzacw.zzgf().zzis().zze("Failed to get app instance id. appId", zzfh.zzbl(zzdz2.packageName), exception);
            return null;
        }
    }

    public final void zzm(boolean bl) {
        this.zzld();
    }

    static /* synthetic */ void zza(zzjs zzjs2, zzjx zzjx2) {
        zzjs2.zza(zzjx2);
    }

    static /* synthetic */ zzdy zza(zzjs zzjs2, zzdz zzdz2) {
        return zzjs2.zzg(zzdz2);
    }

    final class zza
    implements zzel {
        zzks zzarh;
        List<Long> zzari;
        List<zzkp> zzarj;
        private long zzark;

        private zza() {
        }

        @Override
        public final void zzb(zzks zzks2) {
            Preconditions.checkNotNull((Object)((Object)zzks2));
            this.zzarh = zzks2;
        }

        @Override
        public final boolean zza(long l, zzkp zzkp2) {
            Preconditions.checkNotNull((Object)((Object)zzkp2));
            if (this.zzarj == null) {
                this.zzarj = new ArrayList<zzkp>();
            }
            if (this.zzari == null) {
                this.zzari = new ArrayList<Long>();
            }
            if (this.zzarj.size() > 0 && zza.zza(this.zzarj.get(0)) != zza.zza(zzkp2)) {
                return false;
            }
            long l2 = this.zzark + (long)zzkp2.zzvv();
            if (l2 >= (long)Math.max(0, zzey.zzagx.get())) {
                return false;
            }
            this.zzark = l2;
            this.zzarj.add(zzkp2);
            this.zzari.add(l);
            return this.zzarj.size() < Math.max(1, zzey.zzagy.get());
        }

        private static long zza(zzkp zzkp2) {
            return zzkp2.zzatn / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzjt zzjt2) {
            this();
        }
    }
}

