/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzr;
import java.util.List;

public final class zzfz {
    private final zzgn zzacv;
    @VisibleForTesting
    volatile zzr zzamv;
    @VisibleForTesting
    private ServiceConnection zzamw;

    zzfz(zzgn zzgn2) {
        this.zzacv = zzgn2;
    }

    @WorkerThread
    protected final void zzjr() {
        zzee zzee2 = this.zzacv.zzgl();
        ((zzhi)this.zzacv.zzgh()).zzab();
        if (!this.zzjs()) {
            this.zzacv.zzgi().zzja().log("Install Referrer Reporter is not available");
            this.zzamw = null;
            return;
        }
        this.zzamw = new zzgb(this, null);
        this.zzacv.zzgi().zzja().log("Install Referrer Reporter is initializing");
        zzfz zzfz2 = this;
        ((zzhi)zzfz2.zzacv.zzgh()).zzab();
        Intent intent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
        intent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
        PackageManager packageManager = zzfz2.zzacv.getContext().getPackageManager();
        if (packageManager == null) {
            zzfz2.zzacv.zzgi().zziy().log("Failed to obtain Package Manager to verify binding conditions");
            return;
        }
        List list = packageManager.queryIntentServices(intent, 0);
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string = resolveInfo.serviceInfo.packageName;
                if (resolveInfo.serviceInfo.name != null && zzfz2.zzamw != null && "com.android.vending".equals(string) && zzfz2.zzjs()) {
                    Intent intent2 = new Intent(intent);
                    try {
                        boolean bl = ConnectionTracker.getInstance().bindService(zzfz2.zzacv.getContext(), intent2, zzfz2.zzamw, 1);
                        zzfz2.zzacv.zzgi().zzja().zzg("Install Referrer Service is", bl ? "available" : "not available");
                        return;
                    }
                    catch (Exception exception) {
                        zzfz2.zzacv.zzgi().zziv().zzg("Exception occurred while binding to Install Referrer Service", exception.getMessage());
                        return;
                    }
                }
                zzfz2.zzacv.zzgi().zzja().log("Play Store missing or incompatible. Version 8.3.73 or later required");
            }
            return;
        }
        zzfz2.zzacv.zzgi().zzja().log("Play Service for fetching Install Referrer is unavailable on device");
    }

    @VisibleForTesting
    private final boolean zzjs() {
        try {
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager((Context)this.zzacv.getContext());
            if (packageManagerWrapper == null) {
                this.zzacv.zzgi().zzja().log("Failed to retrieve Package Manager to check Play Store compatibility");
                return false;
            }
            return packageManagerWrapper.getPackageInfo((String)"com.android.vending", (int)128).versionCode >= 80837300;
        }
        catch (Exception exception) {
            this.zzacv.zzgi().zzja().zzg("Failed to retrieve Play Store version", exception);
            return false;
        }
    }

    @WorkerThread
    @Nullable
    @VisibleForTesting
    final Bundle zzjt() {
        Bundle bundle;
        ((zzhi)this.zzacv.zzgh()).zzab();
        if (this.zzamv == null) {
            this.zzacv.zzgi().zziy().log("Attempting to use Install Referrer Service while it is not initialized");
            return null;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putString("package_name", this.zzacv.getContext().getPackageName());
        try {
            bundle = this.zzamv.zza(bundle2);
            if (bundle == null) {
                this.zzacv.zzgi().zziv().log("Install Referrer Service returned a null response");
                return null;
            }
        }
        catch (Exception exception) {
            this.zzacv.zzgi().zziv().zzg("Exception occurred while retrieving the Install Referrer", exception.getMessage());
            return null;
        }
        return bundle;
    }

    @WorkerThread
    @VisibleForTesting
    final void zzc(Bundle bundle) {
        long l;
        ((zzhi)this.zzacv.zzgh()).zzab();
        if (bundle == null) {
            return;
        }
        long l2 = bundle.getLong("install_begin_timestamp_seconds", 0L) * 1000L;
        if (l2 == 0L) {
            this.zzacv.zzgi().zziv().log("Service response is missing Install Referrer install timestamp");
            return;
        }
        String string = bundle.getString("install_referrer");
        if (string == null || string.isEmpty()) {
            this.zzacv.zzgi().zziv().log("No referrer defined in install referrer response");
            return;
        }
        this.zzacv.zzgi().zzjc().zzg("InstallReferrer API result", string);
        String string2 = String.valueOf(string);
        Bundle bundle2 = this.zzacv.zzgg().zza(Uri.parse((String)(string2.length() != 0 ? "?".concat(string2) : new String("?"))));
        if (bundle2 == null) {
            this.zzacv.zzgi().zziv().log("No campaign params defined in install referrer result");
            return;
        }
        String string3 = bundle2.getString("medium");
        if (string3 != null && !"(not set)".equalsIgnoreCase(string3) && !"organic".equalsIgnoreCase(string3)) {
            l = bundle.getLong("referrer_click_timestamp_seconds", 0L) * 1000L;
            if (l == 0L) {
                this.zzacv.zzgi().zziv().log("Install Referrer is missing click timestamp for ad campaign");
                return;
            }
            bundle2.putLong("click_timestamp", l);
        }
        if (l2 == (l = this.zzacv.zzgj().zzalz.get())) {
            this.zzacv.zzgi().zzjc().log("Campaign has already been logged");
            return;
        }
        bundle2.putString("_cis", "referrer API");
        this.zzacv.zzgj().zzalz.set(l2);
        this.zzacv.zzfy().logEvent("auto", "_cmp", bundle2);
        if (this.zzamw != null) {
            ConnectionTracker.getInstance().unbindService(this.zzacv.getContext(), this.zzamw);
        }
    }

    static /* synthetic */ zzgn zza(zzfz zzfz2) {
        return zzfz2.zzacv;
    }
}

