/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzgk;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzhj;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzgi
extends zzhj {
    private ExecutorService executor;
    private zzgm zzanm;
    private zzgm zzann;
    private final PriorityBlockingQueue<zzgl<?>> zzano;
    private final BlockingQueue<zzgl<?>> zzanp;
    private final Thread.UncaughtExceptionHandler zzanq;
    private final Thread.UncaughtExceptionHandler zzanr;
    private final Object zzans = new Object();
    private final Semaphore zzant = new Semaphore(2);
    private volatile boolean zzanu;
    private static final AtomicLong zzanv = new AtomicLong(Long.MIN_VALUE);

    zzgi(zzgn zzgn2) {
        super(zzgn2);
        this.zzano = new PriorityBlockingQueue();
        this.zzanp = new LinkedBlockingQueue();
        this.zzanq = new zzgk(this, "Thread death: Uncaught exception on worker thread");
        this.zzanr = new zzgk(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzgn() {
        return false;
    }

    @Override
    public final void zzab() {
        if (Thread.currentThread() != this.zzanm) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzfw() {
        if (Thread.currentThread() != this.zzann) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzju() {
        return Thread.currentThread() == this.zzanm;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull(callable);
        zzgl zzgl2 = new zzgl(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzanm) {
            if (!this.zzano.isEmpty()) {
                ((zzhi)this).zzgi().zziy().log("Callable skipped the worker queue.");
            }
            zzgl2.run();
        } else {
            this.zza(zzgl2);
        }
        return zzgl2;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull(callable);
        zzgl zzgl2 = new zzgl(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzanm) {
            zzgl2.run();
        } else {
            this.zza(zzgl2);
        }
        return zzgl2;
    }

    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzgl(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzhi)this).zzgh().zzc(runnable);
            try {
                atomicReference.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzhi)this).zzgi().zziy().log(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzhi)this).zzgi().zziy().log(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzgl<?> zzgl2) {
        Object object = this.zzans;
        synchronized (object) {
            this.zzano.add(zzgl2);
            if (this.zzanm == null) {
                this.zzanm = new zzgm(this, "Measurement Worker", this.zzano);
                this.zzanm.setUncaughtExceptionHandler(this.zzanq);
                this.zzanm.start();
            } else {
                this.zzanm.zzjx();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd(Runnable runnable) throws IllegalStateException {
        this.zzch();
        Preconditions.checkNotNull((Object)runnable);
        zzgl zzgl2 = new zzgl(this, runnable, false, "Task exception on network thread");
        zzgi zzgi2 = this;
        Object object = zzgi2.zzans;
        synchronized (object) {
            zzgi2.zzanp.add(zzgl2);
            if (zzgi2.zzann == null) {
                zzgi2.zzann = new zzgm(zzgi2, "Measurement Network", zzgi2.zzanp);
                zzgi2.zzann.setUncaughtExceptionHandler(zzgi2.zzanr);
                zzgi2.zzann.start();
            } else {
                zzgi2.zzann.zzjx();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzjv() {
        Object object = this.zzans;
        synchronized (object) {
            if (this.executor == null) {
                this.executor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.executor;
        }
    }

    static /* synthetic */ Semaphore zza(zzgi zzgi2) {
        return zzgi2.zzant;
    }

    static /* synthetic */ boolean zzb(zzgi zzgi2) {
        return zzgi2.zzanu;
    }

    static /* synthetic */ Object zzc(zzgi zzgi2) {
        return zzgi2.zzans;
    }

    static /* synthetic */ zzgm zzd(zzgi zzgi2) {
        return zzgi2.zzanm;
    }

    static /* synthetic */ zzgm zza(zzgi zzgi2, zzgm zzgm2) {
        zzgi2.zzanm = null;
        return null;
    }

    static /* synthetic */ zzgm zze(zzgi zzgi2) {
        return zzgi2.zzann;
    }

    static /* synthetic */ zzgm zzb(zzgi zzgi2, zzgm zzgm2) {
        zzgi2.zzann = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzjw() {
        return zzanv;
    }
}

