/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzig;
import com.google.android.gms.internal.measurement.zzii;
import com.google.android.gms.internal.measurement.zzij;
import com.google.android.gms.internal.measurement.zzkd;
import java.util.Map;

public final class zzih
extends zzdz {
    @VisibleForTesting
    protected zzig zzaqd;
    private volatile zzig zzaqe;
    private zzig zzaqf;
    private final Map<Activity, zzig> zzaqg = new ArrayMap();
    private zzig zzaqh;
    private String zzaqi;

    public zzih(zzgn zzgn2) {
        super(zzgn2);
    }

    @Override
    protected final boolean zzgn() {
        return false;
    }

    @WorkerThread
    public final zzig zzkn() {
        this.zzch();
        ((zzhi)this).zzab();
        return this.zzaqd;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!zzee.isMainThread()) {
            ((zzhi)this).zzgi().zziy().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzaqe == null) {
            ((zzhi)this).zzgi().zziy().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzaqg.get(activity) == null) {
            ((zzhi)this).zzgi().zziy().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzih.zzcd(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzaqe.zzaqa.equals(string2);
        boolean bl2 = zzkd.zzs(this.zzaqe.zzuk, string);
        if (bl && bl2) {
            ((zzhi)this).zzgi().zziz().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzhi)this).zzgi().zziy().zzg("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzhi)this).zzgi().zziy().zzg("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzhi)this).zzgi().zzjc().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzig zzig2 = new zzig(string, string2, ((zzhi)this).zzgg().zzln());
        this.zzaqg.put(activity, zzig2);
        this.zza(activity, zzig2, true);
    }

    public final zzig zzko() {
        ((zzhi)this).zzfv();
        return this.zzaqe;
    }

    @MainThread
    private final void zza(Activity activity, zzig zzig2, boolean bl) {
        zzig zzig3;
        zzig zzig4 = zzig3 = this.zzaqe == null ? this.zzaqf : this.zzaqe;
        if (zzig2.zzaqa == null) {
            zzig2 = new zzig(zzig2.zzuk, zzih.zzcd(activity.getClass().getCanonicalName()), zzig2.zzaqb);
        }
        zzig zzig5 = zzig2;
        this.zzaqf = this.zzaqe;
        this.zzaqe = zzig5;
        ((zzhi)this).zzgh().zzc(new zzii(this, bl, zzig3, zzig5));
    }

    @WorkerThread
    private final void zza(@NonNull zzig zzig2) {
        ((zzdy)this).zzfx().zzp(((zzhi)this).zzbt().elapsedRealtime());
        if (((zzdy)this).zzgd().zzl(zzig2.zzaqc)) {
            zzig2.zzaqc = false;
        }
    }

    public static void zza(zzig zzig2, Bundle bundle, boolean bl) {
        if (bundle != null && zzig2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzig2.zzuk != null) {
                bundle.putString("_sn", zzig2.zzuk);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzig2.zzaqa);
            bundle.putLong("_si", zzig2.zzaqb);
            return;
        }
        if (bundle != null && zzig2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzig zzig2) {
        ((zzhi)this).zzab();
        zzih zzih2 = this;
        synchronized (zzih2) {
            if (this.zzaqi == null || this.zzaqi.equals(string) || zzig2 != null) {
                this.zzaqi = string;
                this.zzaqh = zzig2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zzcd(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzig zze(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzig zzig2 = this.zzaqg.get(activity);
        if (zzig2 == null) {
            String string = zzih.zzcd(activity.getClass().getCanonicalName());
            zzig2 = new zzig(null, string, ((zzhi)this).zzgg().zzln());
            this.zzaqg.put(activity, zzig2);
        }
        return zzig2;
    }

    @MainThread
    public final void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.firebase.analytics.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzig zzig2 = new zzig(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzaqg.put(activity, zzig2);
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzig zzig2 = this.zze(activity);
        this.zza(activity, zzig2, false);
        zzdu zzdu2 = ((zzdy)this).zzfx();
        long l = ((zzhi)zzdu2).zzbt().elapsedRealtime();
        ((zzhi)zzdu2).zzgh().zzc(new zzdx(zzdu2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzig zzig2 = this.zze(activity);
        this.zzaqf = this.zzaqe;
        this.zzaqe = null;
        ((zzhi)this).zzgh().zzc(new zzij(this, zzig2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzig zzig2 = this.zzaqg.get(activity);
        if (zzig2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzig2.zzaqb);
        bundle2.putString("name", zzig2.zzuk);
        bundle2.putString("referrer_name", zzig2.zzaqa);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzaqg.remove(activity);
    }

    static /* synthetic */ void zza(zzih zzih2, zzig zzig2) {
        zzih2.zza(zzig2);
    }
}

