/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzig;
import com.google.android.gms.internal.measurement.zzil;
import com.google.android.gms.internal.measurement.zzim;
import com.google.android.gms.internal.measurement.zzin;
import com.google.android.gms.internal.measurement.zzio;
import com.google.android.gms.internal.measurement.zzip;
import com.google.android.gms.internal.measurement.zziq;
import com.google.android.gms.internal.measurement.zzir;
import com.google.android.gms.internal.measurement.zzis;
import com.google.android.gms.internal.measurement.zzit;
import com.google.android.gms.internal.measurement.zziu;
import com.google.android.gms.internal.measurement.zziv;
import com.google.android.gms.internal.measurement.zziw;
import com.google.android.gms.internal.measurement.zzix;
import com.google.android.gms.internal.measurement.zziy;
import com.google.android.gms.internal.measurement.zzjo;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkd;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzik
extends zzdz {
    private final zziy zzaqo;
    private zzfa zzaqp;
    private volatile Boolean zzaqq;
    private final zzep zzaqr;
    private final zzjo zzaqs;
    private final List<Runnable> zzaqt = new ArrayList<Runnable>();
    private final zzep zzaqu;

    protected zzik(zzgn zzgn2) {
        super(zzgn2);
        this.zzaqs = new zzjo(zzgn2.zzbt());
        this.zzaqo = new zziy(this);
        this.zzaqr = new zzil(this, zzgn2);
        this.zzaqu = new zziq(this, zzgn2);
    }

    @Override
    protected final boolean zzgn() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzhi)this).zzab();
        this.zzch();
        return this.zzaqp != null;
    }

    @WorkerThread
    protected final void zzkp() {
        ((zzhi)this).zzab();
        this.zzch();
        zzeb zzeb2 = this.zzk(true);
        this.zzf(new zzir(this, zzeb2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzfa zzfa2, AbstractSafeParcelable abstractSafeParcelable, zzeb zzeb2) {
        ((zzhi)this).zzab();
        ((zzhi)this).zzfv();
        this.zzch();
        boolean bl = this.zzkq();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zzdy)this).zzgc().zzp(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzex) {
                    try {
                        zzfa2.zza((zzex)abstractSafeParcelable2, zzeb2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhi)this).zzgi().zziv().zzg("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzka) {
                    try {
                        zzfa2.zza((zzka)abstractSafeParcelable2, zzeb2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhi)this).zzgi().zziv().zzg("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzef) {
                    try {
                        zzfa2.zza((zzef)abstractSafeParcelable2, zzeb2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhi)this).zzgi().zziv().zzg("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzhi)this).zzgi().zziv().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzb(zzex zzex2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzex2));
        ((zzhi)this).zzab();
        this.zzch();
        boolean bl = this.zzkq();
        boolean bl2 = bl && ((zzdy)this).zzgc().zza(zzex2);
        zzeb zzeb2 = this.zzk(true);
        this.zzf(new zzis(this, bl, bl2, zzex2, zzeb2, string));
    }

    @WorkerThread
    protected final void zzd(zzef zzef2) {
        Preconditions.checkNotNull((Object)((Object)zzef2));
        ((zzhi)this).zzab();
        this.zzch();
        zzee zzee2 = ((zzhi)this).zzgl();
        boolean bl = true;
        boolean bl2 = true && ((zzdy)this).zzgc().zzc(zzef2);
        zzef zzef3 = new zzef(zzef2);
        zzeb zzeb2 = this.zzk(true);
        this.zzf(new zzit(this, bl, bl2, zzef3, zzeb2, zzef2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzef>> atomicReference, String string, String string2, String string3) {
        ((zzhi)this).zzab();
        this.zzch();
        zzeb zzeb2 = this.zzk(false);
        this.zzf(new zziu(this, atomicReference, string, string2, string3, zzeb2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzka>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzhi)this).zzab();
        this.zzch();
        zzeb zzeb2 = this.zzk(false);
        this.zzf(new zziv(this, atomicReference, string, string2, string3, bl, zzeb2));
    }

    @WorkerThread
    protected final void zzb(zzka zzka2) {
        ((zzhi)this).zzab();
        this.zzch();
        boolean bl = this.zzkq() && ((zzdy)this).zzgc().zza(zzka2);
        zzeb zzeb2 = this.zzk(true);
        this.zzf(new zziw(this, bl, zzka2, zzeb2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzka>> atomicReference, boolean bl) {
        ((zzhi)this).zzab();
        this.zzch();
        zzeb zzeb2 = this.zzk(false);
        this.zzf(new zzix(this, atomicReference, zzeb2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzhi)this).zzab();
        ((zzhi)this).zzfv();
        this.zzch();
        zzeb zzeb2 = this.zzk(false);
        if (this.zzkq()) {
            ((zzdy)this).zzgc().resetAnalyticsData();
        }
        this.zzf(new zzim(this, zzeb2));
    }

    private final boolean zzkq() {
        zzee zzee2 = ((zzhi)this).zzgl();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzhi)this).zzab();
        this.zzch();
        zzeb zzeb2 = this.zzk(false);
        this.zzf(new zzin(this, atomicReference, zzeb2));
    }

    @WorkerThread
    protected final void zzkm() {
        ((zzhi)this).zzab();
        this.zzch();
        zzeb zzeb2 = this.zzk(true);
        this.zzf(new zzio(this, zzeb2));
    }

    @WorkerThread
    protected final void zzb(zzig zzig2) {
        ((zzhi)this).zzab();
        this.zzch();
        this.zzf(new zzip(this, zzig2));
    }

    @WorkerThread
    private final void zzcu() {
        ((zzhi)this).zzab();
        this.zzaqs.start();
        this.zzaqr.zzh(zzez.zzajk.get());
    }

    @WorkerThread
    final void zzdf() {
        zzee zzee2;
        Boolean bl;
        zzik zzik2;
        ((zzhi)this).zzab();
        this.zzch();
        if (this.isConnected()) {
            return;
        }
        if (this.zzaqq == null) {
            boolean bl2;
            zzik2 = this;
            ((zzhi)zzik2).zzab();
            zzik2.zzch();
            bl = ((zzhi)zzik2).zzgj().zzjl();
            if (bl != null && bl.booleanValue()) {
                bl2 = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzee2 = ((zzhi)zzik2).zzgl();
                if (((zzdy)zzik2).zzfz().zzit() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzhi)zzik2).zzgi().zzjc().log("Checking service availability");
                    zzkd zzkd2 = ((zzhi)zzik2).zzgg();
                    int n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzhi)zzkd2).getContext(), 12451000);
                    switch (n) {
                        case 0: {
                            ((zzhi)zzik2).zzgi().zzjc().log("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzhi)zzik2).zzgi().zzjc().log("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzhi)zzik2).zzgi().zziy().log("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzhi)zzik2).zzgi().zzjb().log("Service container out of date");
                            if (((zzhi)zzik2).zzgg().zzlp() < 12600) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            Boolean bl5 = ((zzhi)zzik2).zzgj().zzjl();
                            bl4 = bl5 == null || bl5 != false;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzhi)zzik2).zzgi().zziy().log("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzhi)zzik2).zzgi().zziy().log("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzhi)zzik2).zzgi().zziy().zzg("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzhi)zzik2).zzgk().zzhu()) {
                    ((zzhi)zzik2).zzgi().zziv().log("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzhi)zzik2).zzgj().zzf(bl4);
                }
                bl2 = bl4;
            }
            this.zzaqq = bl2;
        }
        if (this.zzaqq.booleanValue()) {
            this.zzaqo.zzkt();
            return;
        }
        if (!((zzhi)this).zzgk().zzhu()) {
            Intent intent;
            zzik2 = this;
            zzee2 = ((zzhi)zzik2).zzgl();
            bl = ((zzhi)zzik2).getContext().getPackageManager();
            List list = bl.queryIntentServices(intent = new Intent().setClassName(((zzhi)zzik2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzee2 = ((zzhi)this).zzgl();
                intent2.setComponent(new ComponentName(((zzhi)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zzaqo.zzc(intent2);
                return;
            }
            ((zzhi)this).zzgi().zziv().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzkr() {
        return this.zzaqq;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzfa zzfa2) {
        ((zzhi)this).zzab();
        Preconditions.checkNotNull((Object)zzfa2);
        this.zzaqp = zzfa2;
        this.zzcu();
        this.zzks();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzhi)this).zzab();
        this.zzch();
        try {
            ConnectionTracker.getInstance().unbindService(((zzhi)this).getContext(), (ServiceConnection)this.zzaqo);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzaqp = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzhi)this).zzab();
        if (this.zzaqp != null) {
            this.zzaqp = null;
            ((zzhi)this).zzgi().zzjc().zzg("Disconnected from device MeasurementService", componentName);
            zzik zzik2 = this;
            ((zzhi)zzik2).zzab();
            zzik2.zzdf();
        }
    }

    @WorkerThread
    private final void zzcv() {
        ((zzhi)this).zzab();
        if (!this.isConnected()) {
            return;
        }
        ((zzhi)this).zzgi().zzjc().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzf(Runnable runnable) throws IllegalStateException {
        ((zzhi)this).zzab();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzaqt.size() >= 1000L) {
            ((zzhi)this).zzgi().zziv().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzaqt.add(runnable);
        this.zzaqu.zzh(60000L);
        this.zzdf();
    }

    @WorkerThread
    private final void zzks() {
        ((zzhi)this).zzab();
        ((zzhi)this).zzgi().zzjc().zzg("Processing queued up service tasks", this.zzaqt.size());
        for (Runnable runnable : this.zzaqt) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzhi)this).zzgi().zziv().zzg("Task exception while flushing queue", exception);
            }
        }
        this.zzaqt.clear();
        this.zzaqu.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzeb zzk(boolean bl) {
        zzee zzee2 = ((zzhi)this).zzgl();
        return ((zzdy)this).zzfz().zzbl(bl ? ((zzhi)this).zzgi().zzje() : null);
    }

    static /* synthetic */ zziy zza(zzik zzik2) {
        return zzik2.zzaqo;
    }

    static /* synthetic */ void zza(zzik zzik2, ComponentName componentName) {
        zzik2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzfa zza(zzik zzik2, zzfa zzfa2) {
        zzik2.zzaqp = null;
        return null;
    }

    static /* synthetic */ void zzb(zzik zzik2) {
        zzik2.zzks();
    }

    static /* synthetic */ void zzc(zzik zzik2) {
        zzik2.zzcv();
    }

    static /* synthetic */ zzfa zzd(zzik zzik2) {
        return zzik2.zzaqp;
    }

    static /* synthetic */ void zze(zzik zzik2) {
        zzik2.zzcu();
    }
}

