/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Binder;
import android.os.Build;
import android.support.v4.content.PermissionChecker;
import android.util.Log;
import com.google.android.gms.internal.measurement.zzws;
import com.google.android.gms.internal.measurement.zzwu;
import com.google.android.gms.internal.measurement.zzwy;
import com.google.android.gms.internal.measurement.zzwz;
import com.google.android.gms.internal.measurement.zzxa;
import com.google.android.gms.internal.measurement.zzxb;
import com.google.android.gms.internal.measurement.zzxc;
import com.google.android.gms.internal.measurement.zzxd;
import com.google.android.gms.internal.measurement.zzxe;
import com.google.android.gms.internal.measurement.zzxf;
import com.google.android.gms.internal.measurement.zzxg;
import com.google.android.gms.internal.measurement.zzxh;
import javax.annotation.Nullable;

public abstract class zzwx<T> {
    private static final Object zzbpg = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context zzqx = null;
    private static boolean zzbph = false;
    private static volatile Boolean zzbpi = null;
    private final zzxh zzbpj;
    final String zzbpk;
    private final String zzbpl;
    private final T zzbpm;
    private T zzbpn = null;
    private volatile zzwu zzbpo = null;
    private volatile SharedPreferences zzbpp = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context) {
        Object object = zzbpg;
        synchronized (object) {
            Context context2;
            if (Build.VERSION.SDK_INT >= 24 && context.isDeviceProtectedStorage()) {
                context2 = context;
            } else {
                context2 = context.getApplicationContext();
                if (context2 == null) {
                    context2 = context;
                }
            }
            if (zzqx != context2) {
                zzbpi = null;
            }
            zzqx = context2;
        }
        zzbph = false;
    }

    private zzwx(zzxh zzxh2, String string, T t) {
        zzxh zzxh3 = zzxh2;
        if (zzxh.zza(zzxh2) == null) {
            throw new IllegalArgumentException("Must pass a valid SharedPreferences file name or ContentProvider URI");
        }
        zzxh3 = zzxh2;
        this.zzbpj = zzxh2;
        String string2 = String.valueOf(zzxh.zzb(zzxh2));
        String string3 = String.valueOf(string);
        this.zzbpl = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        String string4 = String.valueOf(zzxh.zzc(zzxh2));
        String string5 = String.valueOf(string);
        this.zzbpk = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        this.zzbpm = t;
    }

    public final T get() {
        if (zzqx == null) {
            throw new IllegalStateException("Must call PhenotypeFlag.init() first");
        }
        zzxh zzxh2 = this.zzbpj;
        T t = this.zzsm();
        if (t != null) {
            return t;
        }
        t = this.zzsn();
        if (t != null) {
            return t;
        }
        return this.zzbpm;
    }

    @Nullable
    @TargetApi(value=24)
    private final T zzsm() {
        if (!zzwx.zzd("gms:phenotype:phenotype_flag:debug_bypass_phenotype", false)) {
            if (zzxh.zza(this.zzbpj) != null) {
                zzwu zzwu2;
                String string;
                zzwx zzwx2 = this;
                if (zzwx2.zzbpo == null) {
                    zzwx2.zzbpo = zzwu.zza(zzqx.getContentResolver(), zzxh.zza(zzwx2.zzbpj));
                }
                if ((string = (String)zzwx.zza(new zzwy(this, zzwu2 = zzwx2.zzbpo))) != null) {
                    return this.zzfa(string);
                }
            } else {
                zzxh zzxh2 = this.zzbpj;
            }
        } else {
            String string = String.valueOf(this.zzbpk);
            Log.w((String)"PhenotypeFlag", (String)(string.length() != 0 ? "Bypass reading Phenotype values for flag: ".concat(string) : new String("Bypass reading Phenotype values for flag: ")));
        }
        return null;
    }

    @Nullable
    private final T zzsn() {
        zzxh zzxh2 = this.zzbpj;
        if (zzwx.zzso()) {
            try {
                String string = (String)zzwx.zza(new zzwz(this));
                if (string != null) {
                    return this.zzfa(string);
                }
            }
            catch (SecurityException securityException) {
                String string = String.valueOf(this.zzbpk);
                Log.e((String)"PhenotypeFlag", (String)(string.length() != 0 ? "Unable to read GServices for flag: ".concat(string) : new String("Unable to read GServices for flag: ")), (Throwable)securityException);
            }
        }
        return null;
    }

    protected abstract T zzfa(String var1);

    private static <V> V zza(zzxg<V> zzxg2) {
        V v;
        try {
            v = zzxg2.zzsq();
        }
        catch (SecurityException securityException) {
            long l = Binder.clearCallingIdentity();
            try {
                v = zzxg2.zzsq();
            }
            finally {
                Binder.restoreCallingIdentity((long)l);
            }
        }
        return v;
    }

    static boolean zzd(String string, boolean bl) {
        try {
            if (zzwx.zzso()) {
                return (Boolean)zzwx.zza(new zzxa(string, false));
            }
            return false;
        }
        catch (SecurityException securityException) {
            Log.e((String)"PhenotypeFlag", (String)"Unable to read GServices, returning default value.", (Throwable)securityException);
            return false;
        }
    }

    private static boolean zzso() {
        if (zzbpi == null) {
            if (zzqx != null) {
                zzbpi = PermissionChecker.checkSelfPermission((Context)zzqx, (String)"com.google.android.providers.gsf.permission.READ_GSERVICES") == 0;
            } else {
                return false;
            }
        }
        return zzbpi;
    }

    private static zzwx<Long> zza(zzxh zzxh2, String string, long l) {
        return new zzxb(zzxh2, string, l);
    }

    private static zzwx<Integer> zza(zzxh zzxh2, String string, int n) {
        return new zzxc(zzxh2, string, n);
    }

    private static zzwx<Boolean> zza(zzxh zzxh2, String string, boolean bl) {
        return new zzxd(zzxh2, string, bl);
    }

    private static zzwx<Double> zza(zzxh zzxh2, String string, double d) {
        return new zzxe(zzxh2, string, d);
    }

    private static zzwx<String> zza(zzxh zzxh2, String string, String string2) {
        return new zzxf(zzxh2, string, string2);
    }

    static final /* synthetic */ Boolean zze(String string, boolean bl) {
        return zzws.zza(zzqx.getContentResolver(), string, bl);
    }

    final /* synthetic */ String zzsp() {
        return zzws.zza(zzqx.getContentResolver(), this.zzbpl, null);
    }

    static /* synthetic */ zzwx zzb(zzxh zzxh2, String string, long l) {
        return zzwx.zza(zzxh2, string, l);
    }

    static /* synthetic */ zzwx zzb(zzxh zzxh2, String string, boolean bl) {
        return zzwx.zza(zzxh2, string, bl);
    }

    static /* synthetic */ zzwx zzb(zzxh zzxh2, String string, int n) {
        return zzwx.zza(zzxh2, string, n);
    }

    static /* synthetic */ zzwx zzb(zzxh zzxh2, String string, double d) {
        return zzwx.zza(zzxh2, string, d);
    }

    static /* synthetic */ zzwx zzb(zzxh zzxh2, String string, String string2) {
        return zzwx.zza(zzxh2, string, string2);
    }

    /* synthetic */ zzwx(zzxh zzxh2, String string, Object object, zzxb zzxb2) {
        this(zzxh2, string, object);
    }
}

