/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzfk;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzba
extends zzcp {
    @VisibleForTesting
    static final Pair<String, Long> zzanc = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzabr;
    public zzbe zzand;
    public final zzbd zzane = new zzbd(this, "last_upload", 0L);
    public final zzbd zzanf = new zzbd(this, "last_upload_attempt", 0L);
    public final zzbd zzang = new zzbd(this, "backoff", 0L);
    public final zzbd zzanh = new zzbd(this, "last_delete_stale", 0L);
    public final zzbd zzani;
    public final zzbd zzanj;
    public final zzbd zzank;
    public final zzbf zzanl;
    private String zzanm;
    private boolean zzann;
    private long zzano;
    public final zzbd zzanp = new zzbd(this, "time_before_start", 10000L);
    public final zzbd zzanq = new zzbd(this, "session_timeout", 1800000L);
    public final zzbc zzanr = new zzbc(this, "start_new_session", true);
    public final zzbf zzans = new zzbf(this, "allow_ad_personalization", null);
    public final zzbd zzant = new zzbd(this, "last_pause_time", 0L);
    public final zzbd zzanu = new zzbd(this, "time_active", 0L);
    public boolean zzanv;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzby(String string) {
        this.zzaf();
        long l = this.zzbx().elapsedRealtime();
        if (this.zzanm != null && l < this.zzano) {
            return new Pair((Object)this.zzanm, (Object)this.zzann);
        }
        String string2 = string;
        this.zzano = l + this.zzgq().zza(string2, zzaf.zzaje);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzanm = info.getId();
                this.zzann = info.isLimitAdTrackingEnabled();
            }
            if (this.zzanm == null) {
                this.zzanm = "";
            }
        }
        catch (Exception exception) {
            this.zzgo().zzjk().zzg("Unable to get advertising id", exception);
            this.zzanm = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzanm, (Object)this.zzann);
    }

    @WorkerThread
    final String zzbz(String string) {
        this.zzaf();
        String string2 = (String)this.zzby((String)string).first;
        MessageDigest messageDigest = zzfk.getMessageDigest();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzba(zzbt zzbt2) {
        super(zzbt2);
        this.zzani = new zzbd(this, "midnight_offset", 0L);
        this.zzanj = new zzbd(this, "first_open_time", 0L);
        this.zzank = new zzbd(this, "app_install_time", 0L);
        this.zzanl = new zzbf(this, "app_instance_id", null);
    }

    @Override
    protected final boolean zzgt() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzgu() {
        this.zzabr = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzanv = this.zzabr.getBoolean("has_been_opened", false);
        if (!this.zzanv) {
            SharedPreferences.Editor editor = this.zzabr.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzand = new zzbe(this, "health_monitor", Math.max(0L, zzaf.zzajf.get()), null);
    }

    @WorkerThread
    private final SharedPreferences zzjr() {
        this.zzaf();
        this.zzcl();
        return this.zzabr;
    }

    @WorkerThread
    final void zzca(String string) {
        this.zzaf();
        SharedPreferences.Editor editor = this.zzjr().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzjs() {
        this.zzaf();
        return this.zzjr().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzcb(String string) {
        this.zzaf();
        SharedPreferences.Editor editor = this.zzjr().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzjt() {
        this.zzaf();
        return this.zzjr().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzju() {
        this.zzaf();
        if (!this.zzjr().contains("use_service")) {
            return null;
        }
        return this.zzjr().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzg(boolean bl) {
        this.zzaf();
        this.zzgo().zzjl().zzg("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzjr().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzjv() {
        this.zzaf();
        this.zzgo().zzjl().zzbx("Clearing collection preferences.");
        boolean bl = this.zzjr().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzh(true);
        }
        SharedPreferences.Editor editor = this.zzjr().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzaf();
        this.zzgo().zzjl().zzg("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzjr().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzh(boolean bl) {
        this.zzaf();
        return this.zzjr().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzjw() {
        this.zzaf();
        String string = this.zzjr().getString("previous_os_version", null);
        this.zzgk().zzcl();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzjr().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzi(boolean bl) {
        this.zzaf();
        this.zzgo().zzjl().zzg("Updating deferred analytics collection", bl);
        SharedPreferences.Editor editor = this.zzjr().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzjx() {
        this.zzaf();
        return this.zzjr().getBoolean("deferred_analytics_collection", false);
    }

    @WorkerThread
    final boolean zzjy() {
        return this.zzabr.contains("deferred_analytics_collection");
    }

    static /* synthetic */ SharedPreferences zza(zzba zzba2) {
        return zzba2.zzjr();
    }
}

