/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzu;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzcp;
import java.util.List;

public final class zzbh {
    final zzbu zzadp;

    zzbh(zzbu zzbu2) {
        this.zzadp = zzbu2;
    }

    @WorkerThread
    protected final void zzcg(String string) {
        if (string == null || string.isEmpty()) {
            this.zzadp.zzgt().zzjm().zzca("Install Referrer Reporter was called with invalid app package name");
            return;
        }
        ((zzcp)this.zzadp.zzgs()).zzaf();
        if (!this.zzke()) {
            this.zzadp.zzgt().zzjm().zzca("Install Referrer Reporter is not available");
            return;
        }
        this.zzadp.zzgt().zzjm().zzca("Install Referrer Reporter is initializing");
        zzbi zzbi2 = new zzbi(this, string);
        zzbh zzbh2 = this;
        ((zzcp)zzbh2.zzadp.zzgs()).zzaf();
        Intent intent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
        intent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
        PackageManager packageManager = zzbh2.zzadp.getContext().getPackageManager();
        if (packageManager == null) {
            zzbh2.zzadp.zzgt().zzjj().zzca("Failed to obtain Package Manager to verify binding conditions");
            return;
        }
        List list = packageManager.queryIntentServices(intent, 0);
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string2 = resolveInfo.serviceInfo.packageName;
                if (resolveInfo.serviceInfo.name != null && "com.android.vending".equals(string2) && zzbh2.zzke()) {
                    Intent intent2 = new Intent(intent);
                    try {
                        boolean bl = ConnectionTracker.getInstance().bindService(zzbh2.zzadp.getContext(), intent2, (ServiceConnection)zzbi2, 1);
                        zzbh2.zzadp.zzgt().zzjm().zzg("Install Referrer Service is", bl ? "available" : "not available");
                        return;
                    }
                    catch (Exception exception) {
                        zzbh2.zzadp.zzgt().zzjg().zzg("Exception occurred while binding to Install Referrer Service", exception.getMessage());
                        return;
                    }
                }
                zzbh2.zzadp.zzgt().zzjm().zzca("Play Store missing or incompatible. Version 8.3.73 or later required");
            }
            return;
        }
        zzbh2.zzadp.zzgt().zzjm().zzca("Play Service for fetching Install Referrer is unavailable on device");
    }

    @VisibleForTesting
    private final boolean zzke() {
        try {
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager((Context)this.zzadp.getContext());
            if (packageManagerWrapper == null) {
                this.zzadp.zzgt().zzjm().zzca("Failed to retrieve Package Manager to check Play Store compatibility");
                return false;
            }
            return packageManagerWrapper.getPackageInfo((String)"com.android.vending", (int)128).versionCode >= 80837300;
        }
        catch (Exception exception) {
            this.zzadp.zzgt().zzjm().zzg("Failed to retrieve Play Store version", exception);
            return false;
        }
    }

    @WorkerThread
    @Nullable
    @VisibleForTesting
    final Bundle zza(String string, zzu zzu2) {
        Bundle bundle;
        ((zzcp)this.zzadp.zzgs()).zzaf();
        if (zzu2 == null) {
            this.zzadp.zzgt().zzjj().zzca("Attempting to use Install Referrer Service while it is not initialized");
            return null;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putString("package_name", string);
        try {
            bundle = zzu2.zza(bundle2);
            if (bundle == null) {
                this.zzadp.zzgt().zzjg().zzca("Install Referrer Service returned a null response");
                return null;
            }
        }
        catch (Exception exception) {
            this.zzadp.zzgt().zzjg().zzg("Exception occurred while retrieving the Install Referrer", exception.getMessage());
            return null;
        }
        return bundle;
    }
}

