/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzbr;
import com.google.android.gms.measurement.internal.zzbs;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzcq;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzbp
extends zzcq {
    private ExecutorService zzaea;
    private zzbt zzapb;
    private zzbt zzapc;
    private final PriorityBlockingQueue<zzbs<?>> zzapd;
    private final BlockingQueue<zzbs<?>> zzape;
    private final Thread.UncaughtExceptionHandler zzapf;
    private final Thread.UncaughtExceptionHandler zzapg;
    private final Object zzaph = new Object();
    private final Semaphore zzapi = new Semaphore(2);
    private volatile boolean zzapj;
    private static final AtomicLong zzapk = new AtomicLong(Long.MIN_VALUE);

    zzbp(zzbu zzbu2) {
        super(zzbu2);
        this.zzapd = new PriorityBlockingQueue();
        this.zzape = new LinkedBlockingQueue();
        this.zzapf = new zzbr(this, "Thread death: Uncaught exception on worker thread");
        this.zzapg = new zzbr(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    @Override
    public final void zzaf() {
        if (Thread.currentThread() != this.zzapb) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzgh() {
        if (Thread.currentThread() != this.zzapc) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzkf() {
        return Thread.currentThread() == this.zzapb;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull(callable);
        zzbs zzbs2 = new zzbs(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzapb) {
            if (!this.zzapd.isEmpty()) {
                ((zzcp)this).zzgt().zzjj().zzca("Callable skipped the worker queue.");
            }
            zzbs2.run();
        } else {
            this.zza(zzbs2);
        }
        return zzbs2;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull(callable);
        zzbs zzbs2 = new zzbs(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzapb) {
            zzbs2.run();
        } else {
            this.zza(zzbs2);
        }
        return zzbs2;
    }

    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzbs(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzcp)this).zzgs().zzc(runnable);
            try {
                atomicReference.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzcp)this).zzgt().zzjj().zzca(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzcp)this).zzgt().zzjj().zzca(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzbs<?> zzbs2) {
        Object object = this.zzaph;
        synchronized (object) {
            this.zzapd.add(zzbs2);
            if (this.zzapb == null) {
                this.zzapb = new zzbt(this, "Measurement Worker", this.zzapd);
                this.zzapb.setUncaughtExceptionHandler(this.zzapf);
                this.zzapb.start();
            } else {
                this.zzapb.zzki();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd(Runnable runnable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull((Object)runnable);
        zzbs zzbs2 = new zzbs(this, runnable, false, "Task exception on network thread");
        zzbp zzbp2 = this;
        Object object = zzbp2.zzaph;
        synchronized (object) {
            zzbp2.zzape.add(zzbs2);
            if (zzbp2.zzapc == null) {
                zzbp2.zzapc = new zzbt(zzbp2, "Measurement Network", zzbp2.zzape);
                zzbp2.zzapc.setUncaughtExceptionHandler(zzbp2.zzapg);
                zzbp2.zzapc.start();
            } else {
                zzbp2.zzapc.zzki();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExecutorService zzkg() {
        Object object = this.zzaph;
        synchronized (object) {
            if (this.zzaea == null) {
                this.zzaea = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzaea;
        }
    }

    static /* synthetic */ Semaphore zza(zzbp zzbp2) {
        return zzbp2.zzapi;
    }

    static /* synthetic */ boolean zzb(zzbp zzbp2) {
        return zzbp2.zzapj;
    }

    static /* synthetic */ Object zzc(zzbp zzbp2) {
        return zzbp2.zzaph;
    }

    static /* synthetic */ zzbt zzd(zzbp zzbp2) {
        return zzbp2.zzapb;
    }

    static /* synthetic */ zzbt zza(zzbp zzbp2, zzbt zzbt2) {
        zzbp2.zzapb = null;
        return null;
    }

    static /* synthetic */ zzbt zze(zzbp zzbp2) {
        return zzbp2.zzapc;
    }

    static /* synthetic */ zzbt zzb(zzbp zzbp2, zzbt zzbt2) {
        zzbp2.zzapc = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzkh() {
        return zzapk;
    }
}

