/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzsx;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzbk;
import com.google.android.gms.measurement.internal.zzbp;
import com.google.android.gms.measurement.internal.zzbv;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzcq;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzcx;
import com.google.android.gms.measurement.internal.zzcy;
import com.google.android.gms.measurement.internal.zzds;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzy;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class zzbu
implements zzcr {
    private static volatile zzbu zzapr;
    private final Context zzri;
    private final String zzadx;
    private final String zzaps;
    private final String zzapt;
    private final boolean zzadv;
    private final zzl zzait;
    private final zzo zzapu;
    private final zzbb zzapv;
    private final zzaq zzapw;
    private final zzbp zzapx;
    private final zzez zzapy;
    private final AppMeasurement zzapz;
    private final zzfu zzaqa;
    private final zzao zzaqb;
    private final Clock zzrz;
    private final zzdw zzaqc;
    private final zzcy zzaqd;
    private final zza zzaqe;
    private zzam zzaqf;
    private zzdz zzaqg;
    private zzy zzaqh;
    private zzak zzaqi;
    private zzbh zzaqj;
    private boolean zzvz = false;
    private Boolean zzaqk;
    private long zzaql;
    private volatile Boolean zzaqm;
    @VisibleForTesting
    private Boolean zzaqn;
    @VisibleForTesting
    private Boolean zzaqo;
    private int zzaqp;
    private AtomicInteger zzaqq = new AtomicInteger(0);
    private final long zzaha;

    private zzbu(zzcx zzcx2) {
        Object object;
        Preconditions.checkNotNull((Object)zzcx2);
        Object object2 = zzcx2.zzri;
        this.zzait = new zzl((Context)object2);
        zzag.zza(this.zzait);
        this.zzri = zzcx2.zzri;
        this.zzadx = zzcx2.zzadx;
        this.zzaps = zzcx2.zzaps;
        this.zzapt = zzcx2.zzapt;
        this.zzadv = zzcx2.zzadv;
        this.zzaqm = zzcx2.zzaqm;
        zzal zzal2 = zzcx2.zzarj;
        if (zzal2 != null && zzal2.zzady != null) {
            object = zzal2.zzady.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzaqn = (Boolean)object;
            }
            if ((object = zzal2.zzady.get("measurementDeactivated")) instanceof Boolean) {
                this.zzaqo = (Boolean)object;
            }
        }
        zzsx.zzae(this.zzri);
        this.zzrz = DefaultClock.getInstance();
        this.zzaha = this.zzrz.currentTimeMillis();
        object2 = this;
        this.zzapu = new zzo((zzbu)object2);
        object2 = this;
        object = new zzbb((zzbu)object2);
        ((zzcq)object).zzq();
        this.zzapv = object;
        object2 = this;
        zzaq zzaq2 = new zzaq((zzbu)object2);
        zzaq2.zzq();
        this.zzapw = zzaq2;
        object2 = this;
        zzfu zzfu2 = new zzfu((zzbu)object2);
        zzfu2.zzq();
        this.zzaqa = zzfu2;
        object2 = this;
        zzao zzao2 = new zzao((zzbu)object2);
        zzao2.zzq();
        this.zzaqb = zzao2;
        object2 = this;
        this.zzaqe = new zza((zzbu)object2);
        object2 = this;
        zzdw zzdw2 = new zzdw((zzbu)object2);
        zzdw2.zzq();
        this.zzaqc = zzdw2;
        object2 = this;
        zzcy zzcy2 = new zzcy((zzbu)object2);
        zzcy2.zzq();
        this.zzaqd = zzcy2;
        object2 = this;
        this.zzapz = new AppMeasurement((zzbu)object2);
        object2 = this;
        zzez zzez2 = new zzez((zzbu)object2);
        zzez2.zzq();
        this.zzapy = zzez2;
        object2 = this;
        zzbp zzbp2 = new zzbp((zzbu)object2);
        zzbp2.zzq();
        this.zzapx = zzbp2;
        object2 = this;
        zzl zzl2 = ((zzbu)object2).zzait;
        if (((zzbu)object2).zzri.getApplicationContext() instanceof Application) {
            zzcy zzcy3 = ((zzbu)object2).zzgj();
            if (((zzcp)zzcy3).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzcp)zzcy3).getContext().getApplicationContext();
                if (zzcy3.zzark == null) {
                    zzcy3.zzark = new zzds(zzcy3, null);
                }
                zzds zzds2 = zzcy3.zzark;
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzds2);
                zzds2 = zzcy3.zzark;
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzds2);
                ((zzcp)zzcy3).zzgt().zzjo().zzca("Registered activity lifecycle callback");
            }
        } else {
            ((zzbu)object2).zzgt().zzjj().zzca("Application context is not an Application");
        }
        this.zzapx.zzc(new zzbv(this, zzcx2));
    }

    @WorkerThread
    private final void zza(zzcx zzcx2) {
        ((zzcp)this.zzgs()).zzaf();
        zzo.zzhy();
        zzbu zzbu2 = this;
        zzy zzy2 = new zzy(zzbu2);
        zzy2.zzq();
        this.zzaqh = zzy2;
        zzbu2 = this;
        zzak zzak2 = new zzak(zzbu2);
        zzak2.zzq();
        this.zzaqi = zzak2;
        zzbu2 = this;
        zzam zzam2 = new zzam(zzbu2);
        zzam2.zzq();
        this.zzaqf = zzam2;
        zzbu2 = this;
        zzdz zzdz2 = new zzdz(zzbu2);
        zzdz2.zzq();
        this.zzaqg = zzdz2;
        this.zzaqa.zzgx();
        this.zzapv.zzgx();
        zzbu2 = this;
        this.zzaqj = new zzbh(zzbu2);
        this.zzaqi.zzgx();
        this.zzgt().zzjm().zzg("App measurement is starting up, version", this.zzapu.zzhh());
        zzl zzl2 = this.zzait;
        this.zzgt().zzjm().zzca("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzl2 = this.zzait;
        String string = zzak2.zzal();
        if (TextUtils.isEmpty((CharSequence)this.zzadx)) {
            String string2;
            zzas zzas2;
            if (this.zzgr().zzdb(string)) {
                zzas2 = this.zzgt().zzjm();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzas2 = this.zzgt().zzjm();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzas2.zzca(string2);
        }
        this.zzgt().zzjn().zzca("Debug-level message logging enabled");
        if (this.zzaqp != this.zzaqq.get()) {
            this.zzgt().zzjg().zze("Not all components initialized", this.zzaqp, this.zzaqq.get());
        }
        this.zzvz = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzcp)this.zzgs()).zzaf();
        if (this.zzgu().zzanl.get() == 0L) {
            this.zzgu().zzanl.set(this.zzrz.currentTimeMillis());
        }
        if (Long.valueOf(this.zzgu().zzanq.get()) == 0L) {
            this.zzgt().zzjo().zzg("Persisting first open", this.zzaha);
            this.zzgu().zzanq.set(this.zzaha);
        }
        if (!this.zzkv()) {
            if (this.isEnabled()) {
                if (!this.zzgr().zzx("android.permission.INTERNET")) {
                    this.zzgt().zzjg().zzca("App is missing INTERNET permission");
                }
                if (!this.zzgr().zzx("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzgt().zzjg().zzca("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzl zzl2 = this.zzait;
                if (!Wrappers.packageManager((Context)this.zzri).isCallerInstantApp() && !this.zzapu.zzif()) {
                    if (!zzbk.zza(this.zzri)) {
                        this.zzgt().zzjg().zzca("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzfu.zza(this.zzri, false)) {
                        this.zzgt().zzjg().zzca("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzgt().zzjg().zzca("Uploading is not possible. App measurement disabled");
                return;
            }
        } else {
            zzl zzl3 = this.zzait;
            if (!TextUtils.isEmpty((CharSequence)this.zzgk().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzgk().zzhb())) {
                this.zzgr();
                if (zzfu.zza(this.zzgk().getGmpAppId(), this.zzgu().zzjv(), this.zzgk().zzhb(), this.zzgu().zzjw())) {
                    this.zzgt().zzjm().zzca("Rechecking which service to use due to a GMP App Id change");
                    this.zzgu().zzjy();
                    this.zzgn().resetAnalyticsData();
                    this.zzaqg.disconnect();
                    this.zzaqg.zzdj();
                    this.zzgu().zzanq.set(this.zzaha);
                    this.zzgu().zzans.zzcf(null);
                }
                this.zzgu().zzcd(this.zzgk().getGmpAppId());
                this.zzgu().zzce(this.zzgk().zzhb());
                if (this.zzapu.zzbk(this.zzgk().zzal())) {
                    this.zzapy.zzan(this.zzaha);
                }
            }
            this.zzgj().zzcr(this.zzgu().zzans.zzkd());
            zzl3 = this.zzait;
            if (!TextUtils.isEmpty((CharSequence)this.zzgk().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzgk().zzhb())) {
                boolean bl = this.isEnabled();
                if (!this.zzgu().zzkc() && !this.zzapu.zzhz()) {
                    this.zzgu().zzi(!bl);
                }
                if (!this.zzapu.zzbc(this.zzgk().zzal()) || bl) {
                    this.zzgj().zzld();
                }
                this.zzgl().zza(new AtomicReference<String>());
            }
        }
    }

    @Override
    public final zzl zzgw() {
        return this.zzait;
    }

    public final zzo zzgv() {
        return this.zzapu;
    }

    public final zzbb zzgu() {
        zzbu.zza((zzcp)this.zzapv);
        return this.zzapv;
    }

    @Override
    public final zzaq zzgt() {
        zzbu.zza(this.zzapw);
        return this.zzapw;
    }

    public final zzaq zzkj() {
        if (this.zzapw != null && this.zzapw.isInitialized()) {
            return this.zzapw;
        }
        return null;
    }

    @Override
    public final zzbp zzgs() {
        zzbu.zza(this.zzapx);
        return this.zzapx;
    }

    public final zzez zzgo() {
        zzbu.zza(this.zzapy);
        return this.zzapy;
    }

    public final zzbh zzkk() {
        return this.zzaqj;
    }

    final zzbp zzkl() {
        return this.zzapx;
    }

    public final zzcy zzgj() {
        zzbu.zza(this.zzaqd);
        return this.zzaqd;
    }

    public final AppMeasurement zzkm() {
        return this.zzapz;
    }

    public final zzfu zzgr() {
        zzbu.zza((zzcp)this.zzaqa);
        return this.zzaqa;
    }

    public final zzao zzgq() {
        zzbu.zza((zzcp)this.zzaqb);
        return this.zzaqb;
    }

    public final zzam zzgn() {
        zzbu.zza(this.zzaqf);
        return this.zzaqf;
    }

    @Override
    public final Context getContext() {
        return this.zzri;
    }

    public final boolean zzkn() {
        return TextUtils.isEmpty((CharSequence)this.zzadx);
    }

    public final String zzko() {
        return this.zzadx;
    }

    public final String zzkp() {
        return this.zzaps;
    }

    public final String zzkq() {
        return this.zzapt;
    }

    public final boolean zzkr() {
        return this.zzadv;
    }

    @Override
    public final Clock zzbx() {
        return this.zzrz;
    }

    public final zzdw zzgm() {
        zzbu.zza(this.zzaqc);
        return this.zzaqc;
    }

    public final zzdz zzgl() {
        zzbu.zza(this.zzaqg);
        return this.zzaqg;
    }

    public final zzy zzgp() {
        zzbu.zza(this.zzaqh);
        return this.zzaqh;
    }

    public final zzak zzgk() {
        zzbu.zza(this.zzaqi);
        return this.zzaqi;
    }

    public final zza zzgi() {
        if (this.zzaqe == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzaqe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbu zza(Context context, zzal zzal2) {
        if (zzal2 != null && (zzal2.origin == null || zzal2.zzadx == null)) {
            zzal2 = new zzal(zzal2.zzadt, zzal2.zzadu, zzal2.zzadv, zzal2.zzadw, null, null, zzal2.zzady);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzapr == null) {
            Class<zzbu> clazz = zzbu.class;
            synchronized (zzbu.class) {
                if (zzapr == null) {
                    zzcx zzcx2 = new zzcx(context, zzal2);
                    zzapr = new zzbu(zzcx2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzal2 != null && zzal2.zzady != null && zzal2.zzady.containsKey("dataCollectionDefaultEnabled")) {
            zzapr.zzd(zzal2.zzady.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzapr;
    }

    private final void zzcl() {
        if (!this.zzvz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zza(zzcq zzcq2) {
        if (zzcq2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcq2.isInitialized()) {
            String string = String.valueOf(zzcq2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzf zzf2) {
        if (zzf2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzf2.isInitialized()) {
            String string = String.valueOf(zzf2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzcp zzcp2) {
        if (zzcp2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zzd(boolean bl) {
        this.zzaqm = bl;
    }

    @WorkerThread
    public final boolean zzks() {
        return this.zzaqm != null && this.zzaqm != false;
    }

    @WorkerThread
    public final boolean isEnabled() {
        boolean bl;
        ((zzcp)this.zzgs()).zzaf();
        this.zzcl();
        if (this.zzapu.zza(zzag.zzalo)) {
            if (this.zzapu.zzhz()) {
                return false;
            }
            if (this.zzaqo != null && this.zzaqo.booleanValue()) {
                return false;
            }
            Boolean bl2 = this.zzgu().zzjz();
            if (bl2 != null) {
                return bl2;
            }
            Boolean bl3 = this.zzapu.zzia();
            if (bl3 != null) {
                return bl3;
            }
            if (this.zzaqn != null) {
                return this.zzaqn;
            }
            if (GoogleServices.isMeasurementExplicitlyDisabled()) {
                return false;
            }
            if (this.zzapu.zza(zzag.zzalk) && this.zzaqm != null) {
                return this.zzaqm;
            }
            return true;
        }
        if (this.zzapu.zzhz()) {
            return false;
        }
        Boolean bl4 = this.zzapu.zzia();
        if (bl4 != null) {
            bl = bl4;
        } else {
            bl = !GoogleServices.isMeasurementExplicitlyDisabled();
            if (bl && this.zzaqm != null && zzag.zzalk.get().booleanValue()) {
                bl = this.zzaqm;
            }
        }
        return this.zzgu().zzh(bl);
    }

    final long zzkt() {
        Long l = this.zzgu().zzanq.get();
        if (l == 0L) {
            return this.zzaha;
        }
        return Math.min(this.zzaha, l);
    }

    final void zzgg() {
        zzl zzl2 = this.zzait;
    }

    final void zzgf() {
        zzl zzl2 = this.zzait;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzb(zzcq zzcq2) {
        ++this.zzaqp;
    }

    final void zzb(zzf zzf2) {
        ++this.zzaqp;
    }

    final void zzku() {
        this.zzaqq.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzkv() {
        this.zzcl();
        ((zzcp)this.zzgs()).zzaf();
        if (this.zzaqk == null || this.zzaql == 0L || this.zzaqk != null && !this.zzaqk.booleanValue() && Math.abs(this.zzrz.elapsedRealtime() - this.zzaql) > 1000L) {
            this.zzaql = this.zzrz.elapsedRealtime();
            zzl zzl2 = this.zzait;
            this.zzaqk = this.zzgr().zzx("android.permission.INTERNET") && this.zzgr().zzx("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzri).isCallerInstantApp() || this.zzapu.zzif() || zzbk.zza(this.zzri) && zzfu.zza(this.zzri, false));
            if (this.zzaqk.booleanValue()) {
                this.zzaqk = this.zzgr().zzu(this.zzgk().getGmpAppId(), this.zzgk().zzhb()) || !TextUtils.isEmpty((CharSequence)this.zzgk().zzhb());
            }
        }
        return this.zzaqk;
    }

    static /* synthetic */ void zza(zzbu zzbu2, zzcx zzcx2) {
        zzbu2.zza(zzcx2);
    }
}

