/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzcs;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzcv;
import com.google.android.gms.measurement.internal.zzcw;
import com.google.android.gms.measurement.internal.zzcz;
import com.google.android.gms.measurement.internal.zzda;
import com.google.android.gms.measurement.internal.zzdb;
import com.google.android.gms.measurement.internal.zzdc;
import com.google.android.gms.measurement.internal.zzdd;
import com.google.android.gms.measurement.internal.zzde;
import com.google.android.gms.measurement.internal.zzdg;
import com.google.android.gms.measurement.internal.zzdh;
import com.google.android.gms.measurement.internal.zzdi;
import com.google.android.gms.measurement.internal.zzdj;
import com.google.android.gms.measurement.internal.zzdk;
import com.google.android.gms.measurement.internal.zzdl;
import com.google.android.gms.measurement.internal.zzdm;
import com.google.android.gms.measurement.internal.zzdn;
import com.google.android.gms.measurement.internal.zzdo;
import com.google.android.gms.measurement.internal.zzdp;
import com.google.android.gms.measurement.internal.zzdq;
import com.google.android.gms.measurement.internal.zzdr;
import com.google.android.gms.measurement.internal.zzds;
import com.google.android.gms.measurement.internal.zzdv;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcy
extends zzf {
    @VisibleForTesting
    protected zzds zzark;
    private zzcv zzarl;
    private final Set<zzcw> zzarm = new CopyOnWriteArraySet<zzcw>();
    private boolean zzarn;
    private final AtomicReference<String> zzaro = new AtomicReference();
    @VisibleForTesting
    protected boolean zzarp = true;

    protected zzcy(zzbu zzbu2) {
        super(zzbu2);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    public final void zzkw() {
        if (((zzcp)this).getContext().getApplicationContext() instanceof Application) {
            zzds zzds2 = this.zzark;
            ((Application)((zzcp)this).getContext().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzds2);
        }
    }

    public final Boolean zzkx() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)((zzcp)this).zzgs().zza(atomicReference, 15000L, "boolean test flag value", new zzcz(this, atomicReference));
    }

    public final String zzky() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)((zzcp)this).zzgs().zza(atomicReference, 15000L, "String test flag value", new zzdj(this, atomicReference));
    }

    public final Long zzkz() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)((zzcp)this).zzgs().zza(atomicReference, 15000L, "long test flag value", new zzdl(this, atomicReference));
    }

    public final Integer zzla() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)((zzcp)this).zzgs().zza(atomicReference, 15000L, "int test flag value", new zzdm(this, atomicReference));
    }

    public final Double zzlb() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)((zzcp)this).zzgs().zza(atomicReference, 15000L, "double test flag value", new zzdn(this, atomicReference));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzcl();
        ((zzcp)this).zzgg();
        ((zzcp)this).zzgs().zzc(new zzdo(this, bl));
    }

    public final void zzd(boolean bl) {
        this.zzcl();
        ((zzcp)this).zzgg();
        ((zzcp)this).zzgs().zzc(new zzdp(this, bl));
    }

    @WorkerThread
    private final void zzj(boolean bl) {
        ((zzcp)this).zzaf();
        ((zzcp)this).zzgg();
        this.zzcl();
        ((zzcp)this).zzgt().zzjn().zzg("Setting app measurement enabled (FE)", bl);
        ((zzcp)this).zzgu().setMeasurementEnabled(bl);
        this.zzlc();
    }

    @WorkerThread
    private final void zzlc() {
        if (((zzcp)this).zzgv().zzbc(((zze)this).zzgk().zzal()) && this.zzadp.isEnabled() && this.zzarp) {
            ((zzcp)this).zzgt().zzjn().zzca("Recording app launch after enabling measurement for the first time (FE)");
            this.zzld();
            return;
        }
        ((zzcp)this).zzgt().zzjn().zzca("Updating Scion state (FE)");
        ((zze)this).zzgl().zzlg();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzcp)this).zzgg();
        ((zzcp)this).zzgs().zzc(new zzdq(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzcp)this).zzgg();
        ((zzcp)this).zzgs().zzc(new zzdr(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        this.logEvent(string, string2, bundle, false, true, ((zzcp)this).zzbx().currentTimeMillis());
    }

    public final void logEvent(String string, String string2, Bundle bundle) {
        this.logEvent(string, string2, bundle, true, true, ((zzcp)this).zzbx().currentTimeMillis());
    }

    @WorkerThread
    final void zza(String string, String string2, Bundle bundle) {
        ((zzcp)this).zzgg();
        ((zzcp)this).zzaf();
        this.zza(string, string2, ((zzcp)this).zzbx().currentTimeMillis(), bundle);
    }

    @WorkerThread
    final void zza(String string, String string2, long l, Bundle bundle) {
        ((zzcp)this).zzgg();
        ((zzcp)this).zzaf();
        boolean bl = this.zzarl == null || zzfu.zzda(string2);
        this.zza(string, string2, l, bundle, true, bl, false, null);
    }

    @WorkerThread
    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        Object object2;
        Object object3;
        zzdv zzdv2;
        zzdv zzdv3;
        Object object4;
        Object object5;
        zzcp zzcp2;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        Preconditions.checkNotNull((Object)bundle);
        ((zzcp)this).zzaf();
        this.zzcl();
        if (!this.zzadp.isEnabled()) {
            ((zzcp)this).zzgt().zzjn().zzca("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzarn) {
            this.zzarn = true;
            zzcp2 = this;
            try {
                object5 = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                Class<?> clazz = object5;
                object4 = zzcp2;
                try {
                    clazz.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzcp)object4).getContext());
                }
                catch (Exception exception) {
                    ((zzcp)object4).zzgt().zzjj().zzg("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzcp2.zzgt().zzjm().zzca("Tag Manager is not found and thus will not be used");
            }
        }
        if (bl3) {
            object4 = ((zzcp)this).zzgw();
            if (!"_iap".equals(string2)) {
                int n;
                object5 = string2;
                zzcp2 = this.zzadp.zzgr();
                if ((!((zzfu)zzcp2).zzs("event", (String)object5) ? 2 : (!((zzfu)zzcp2).zza("event", zzcs.zzard, (String)object5) ? 13 : (n = !((zzfu)zzcp2).zza("event", 40, (String)object5) ? 2 : 0))) != 0) {
                    ((zzcp)this).zzgt().zzji().zzg("Invalid public event name. Event will not be logged (FE)", ((zzcp)this).zzgq().zzbv(string2));
                    this.zzadp.zzgr();
                    String string4 = zzfu.zza(string2, 40, true);
                    int n2 = string2 != null ? string2.length() : 0;
                    this.zzadp.zzgr().zza(n, "_ev", string4, n2);
                    return;
                }
            }
        }
        object4 = ((zzcp)this).zzgw();
        zzdv zzdv4 = ((zze)this).zzgm().zzle();
        if (zzdv4 != null && !bundle.containsKey("_sc")) {
            zzdv4.zzasc = true;
        }
        zzdv zzdv5 = zzdv4;
        zzdw.zza(zzdv5, bundle, bl && bl3);
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzfu.zzda(string2);
        if (bl && this.zzarl != null && !bl5 && !bl4) {
            ((zzcp)this).zzgt().zzjn().zze("Passing event to registered event handler (FE)", ((zzcp)this).zzgq().zzbv(string2), ((zzcp)this).zzgq().zzd(bundle));
            this.zzarl.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzadp.zzkv()) {
            return;
        }
        int n = ((zzcp)this).zzgr().zzcw(string2);
        if (n != 0) {
            ((zzcp)this).zzgt().zzji().zzg("Invalid event name. Event will not be logged (FE)", ((zzcp)this).zzgq().zzbv(string2));
            ((zzcp)this).zzgr();
            String string5 = zzfu.zza(string2, 40, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzadp.zzgr().zza(string3, n, "_ev", string5, n3);
            return;
        }
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        Bundle bundle3 = ((zzcp)this).zzgr().zza(string3, string2, bundle, list, bl3, true);
        zzcp2 = bundle3;
        if (bundle3 == null || !zzcp2.containsKey("_sc") || !zzcp2.containsKey("_si")) {
            zzdv3 = null;
        } else {
            object5 = zzcp2.getString("_sn");
            String string6 = zzcp2.getString("_sc");
            Long l2 = zzcp2.getLong("_si");
            zzdv3 = zzdv2 = new zzdv((String)object5, string6, l2);
        }
        if (zzdv3 == null) {
            zzdv2 = zzdv5;
        }
        if (((zzcp)this).zzgv().zzbm(string3)) {
            long l3;
            object4 = ((zzcp)this).zzgw();
            if (((zze)this).zzgm().zzle() != null && "_ae".equals(string2) && (l3 = ((zze)this).zzgo().zzlp()) > 0L) {
                ((zzcp)this).zzgr().zza(bundle3, l3);
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l4 = ((zzcp)this).zzgr().zzmk().nextLong();
        if (((zzcp)this).zzgv().zzbl(((zze)this).zzgk().zzal()) && bundle3.getLong("extend_session", 0L) == 1L) {
            ((zzcp)this).zzgt().zzjo().zzca("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            this.zzadp.zzgo().zza(l, true);
        }
        int n4 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = objectArray;
        int n5 = objectArray.length;
        for (int i = 0; i < n5; ++i) {
            object3 = objectArray2[i];
            object2 = bundle3.get((String)object3);
            ((zzcp)this).zzgr();
            object = zzfu.zzf(object2);
            if (object == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])object).length);
            for (int j = 0; j < ((Bundle[])object).length; ++j) {
                Bundle bundle4 = object[j];
                zzdw.zza(zzdv2, bundle4, true);
                bundle2 = ((zzcp)this).zzgr().zza(string3, "_ep", bundle4, list, bl3, false);
                bundle2.putString("_en", string2);
                bundle2.putLong("_eid", l4);
                bundle2.putString("_gn", (String)object3);
                bundle2.putInt("_ll", ((Bundle[])object).length);
                bundle2.putInt("_i", j);
                arrayList.add(bundle2);
            }
            n4 += ((Bundle[])object).length;
        }
        if (n4 != 0) {
            bundle3.putLong("_eid", l4);
            bundle3.putInt("_epc", n4);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle5 = (Bundle)arrayList.get(i);
            object3 = i != 0 ? "_ep" : string2;
            bundle5.putString("_o", string);
            object2 = bl2 ? ((zzcp)this).zzgr().zze(bundle5) : bundle5;
            ((zzcp)this).zzgt().zzjn().zze("Logging event (FE)", ((zzcp)this).zzgq().zzbv(string2), ((zzcp)this).zzgq().zzd((Bundle)object2));
            object = new zzae((String)object3, new zzab((Bundle)object2), string, l);
            ((zze)this).zzgl().zzc((zzae)((Object)object), string3);
            if (bl4) continue;
            for (zzcw zzcw2 : this.zzarm) {
                bundle2 = new Bundle((Bundle)object2);
                zzcw2.onEvent(string, string2, bundle2, l);
            }
        }
        object4 = ((zzcp)this).zzgw();
        if (((zze)this).zzgm().zzle() != null && "_ae".equals(string2)) {
            ((zze)this).zzgo().zza(true, true);
        }
    }

    public final void logEvent(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        ((zzcp)this).zzgg();
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        boolean bl3 = !bl2 || this.zzarl == null || zzfu.zzda(string2);
        this.zzb(string, string2, l, bundle, bl2, bl3, !bl, null);
    }

    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2 = zzfu.zzf(bundle);
        ((zzcp)this).zzgs().zzc(new zzda(this, string, string2, l, bundle2, bl, bl2, bl3, string3));
    }

    public final void zzb(String string, String string2, Object object, boolean bl) {
        this.zza(string, string2, object, bl, ((zzcp)this).zzbx().currentTimeMillis());
    }

    public final void zza(String string, String string2, Object object, boolean bl, long l) {
        int n;
        int n2;
        if (string == null) {
            string = "app";
        }
        if (bl) {
            n2 = ((zzcp)this).zzgr().zzcx(string2);
        } else {
            String string3 = string2;
            zzfu zzfu2 = ((zzcp)this).zzgr();
            n2 = !zzfu2.zzs("user property", string3) ? 6 : (!zzfu2.zza("user property", zzcu.zzarh, string3) ? 15 : (n = !zzfu2.zza("user property", 24, string3) ? 6 : 0));
        }
        if (n2 != 0) {
            ((zzcp)this).zzgr();
            String string4 = zzfu.zza(string2, 24, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzadp.zzgr().zza(n, "_ev", string4, n3);
            return;
        }
        if (object != null) {
            n = ((zzcp)this).zzgr().zzi(string2, object);
            if (n != 0) {
                ((zzcp)this).zzgr();
                String string5 = zzfu.zza(string2, 24, true);
                int n4 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n4 = String.valueOf(object).length();
                }
                this.zzadp.zzgr().zza(n, "_ev", string5, n4);
                return;
            }
            Object object2 = ((zzcp)this).zzgr().zzj(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, (Object)null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzcp)this).zzgs().zzc(new zzdb(this, string, string2, object, l));
    }

    @WorkerThread
    final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzcp)this).zzaf();
        ((zzcp)this).zzgg();
        this.zzcl();
        if (!this.zzadp.isEnabled()) {
            ((zzcp)this).zzgt().zzjn().zzca("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzadp.zzkv()) {
            return;
        }
        ((zzcp)this).zzgt().zzjn().zze("Setting user property (FE)", ((zzcp)this).zzgq().zzbv(string2), object);
        zzfr zzfr2 = new zzfr(string2, l, object, string);
        ((zze)this).zzgl().zzb(zzfr2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzfr> zzk(boolean bl) {
        ((zzcp)this).zzgg();
        this.zzcl();
        ((zzcp)this).zzgt().zzjn().zzca("Fetching user attributes (FE)");
        if (((zzcp)this).zzgs().zzkf()) {
            ((zzcp)this).zzgt().zzjg().zzca("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzl.isMainThread()) {
            ((zzcp)this).zzgt().zzjg().zzca("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzadp.zzgs().zzc(new zzdc(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcp)this).zzgt().zzjj().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcp)this).zzgt().zzjj().zzca("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    @Nullable
    public final String zzgc() {
        ((zzcp)this).zzgg();
        return this.zzaro.get();
    }

    @Nullable
    public final String zzak(long l) {
        if (((zzcp)this).zzgs().zzkf()) {
            ((zzcp)this).zzgt().zzjg().zzca("Cannot retrieve app instance id from analytics worker thread");
            return null;
        }
        if (zzl.isMainThread()) {
            ((zzcp)this).zzgt().zzjg().zzca("Cannot retrieve app instance id from main thread");
            return null;
        }
        long l2 = ((zzcp)this).zzbx().elapsedRealtime();
        String string = this.zzal(120000L);
        long l3 = ((zzcp)this).zzbx().elapsedRealtime() - l2;
        if (string == null && l3 < 120000L) {
            string = this.zzal(120000L - l3);
        }
        return string;
    }

    final void zzcr(@Nullable String string) {
        this.zzaro.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final String zzal(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzcp)this).zzgs().zzc(new zzdd(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzcp)this).zzgt().zzjj().zzca("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData(long l) {
        if (((zzcp)this).zzgv().zza(zzag.zzaln)) {
            this.zzcr(null);
        }
        ((zzcp)this).zzgs().zzc(new zzde(this, l));
    }

    @WorkerThread
    public final void zzld() {
        ((zzcp)this).zzaf();
        ((zzcp)this).zzgg();
        this.zzcl();
        if (!this.zzadp.zzkv()) {
            return;
        }
        ((zze)this).zzgl().zzld();
        this.zzarp = false;
        String string = ((zzcp)this).zzgu().zzka();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzcp)this).zzgp().zzcl();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.logEvent("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void zza(zzcv zzcv2) {
        ((zzcp)this).zzaf();
        ((zzcp)this).zzgg();
        this.zzcl();
        if (zzcv2 != null && zzcv2 != this.zzarl) {
            Preconditions.checkState((this.zzarl == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzarl = zzcv2;
    }

    public final void zza(zzcw zzcw2) {
        ((zzcp)this).zzgg();
        this.zzcl();
        Preconditions.checkNotNull((Object)zzcw2);
        if (!this.zzarm.add(zzcw2)) {
            ((zzcp)this).zzgt().zzjj().zzca("OnEventListener already registered");
        }
    }

    public final void zzb(zzcw zzcw2) {
        ((zzcp)this).zzgg();
        this.zzcl();
        Preconditions.checkNotNull((Object)zzcw2);
        if (!this.zzarm.remove(zzcw2)) {
            ((zzcp)this).zzgt().zzjj().zzca("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        ((zzcp)this).zzgg();
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzcp)this).zzgt().zzjj().zzca("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mAppId);
        ((zzcp)this).zzgf();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzcp)this).zzbx().currentTimeMillis();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzcp)this).zzgr().zzcx(string) != 0) {
            ((zzcp)this).zzgt().zzjg().zzg("Invalid conditional user property name", ((zzcp)this).zzgq().zzbx(string));
            return;
        }
        if (((zzcp)this).zzgr().zzi(string, object) != 0) {
            ((zzcp)this).zzgt().zzjg().zze("Invalid conditional user property value", ((zzcp)this).zzgq().zzbx(string), object);
            return;
        }
        Object object2 = ((zzcp)this).zzgr().zzj(string, object);
        if (object2 == null) {
            ((zzcp)this).zzgt().zzjg().zze("Unable to normalize conditional user property value", ((zzcp)this).zzgq().zzbx(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzcp)this).zzgt().zzjg().zze("Invalid conditional user property timeout", ((zzcp)this).zzgq().zzbx(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzcp)this).zzgt().zzjg().zze("Invalid conditional user property time to live", ((zzcp)this).zzgq().zzbx(string), l3);
            return;
        }
        ((zzcp)this).zzgs().zzc(new zzdg(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        ((zzcp)this).zzgg();
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzcp)this).zzgf();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzcp)this).zzbx().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzcp)this).zzgs().zzc(new zzdh(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzae zzae2;
        zzae zzae3;
        zzae zzae4;
        ((zzcp)this).zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mOrigin);
        Preconditions.checkNotNull((Object)conditionalUserProperty.mValue);
        if (!this.zzadp.isEnabled()) {
            ((zzcp)this).zzgt().zzjn().zzca("Conditional property not sent since collection is disabled");
            return;
        }
        zzfr zzfr2 = new zzfr(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzae4 = ((zzcp)this).zzgr().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzae3 = ((zzcp)this).zzgr().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzae2 = ((zzcp)this).zzgr().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzm zzm2 = new zzm(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzfr2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzae3, conditionalUserProperty.mTriggerTimeout, zzae4, conditionalUserProperty.mTimeToLive, zzae2);
        ((zze)this).zzgl().zzd(zzm2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzae zzae2;
        ((zzcp)this).zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        Preconditions.checkNotEmpty((String)conditionalUserProperty.mName);
        if (!this.zzadp.isEnabled()) {
            ((zzcp)this).zzgt().zzjn().zzca("Conditional property not cleared since collection is disabled");
            return;
        }
        zzfr zzfr2 = new zzfr(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzae2 = ((zzcp)this).zzgr().zza(conditionalUserProperty.mAppId, conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzm zzm2 = new zzm(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzfr2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzae2);
        ((zze)this).zzgl().zzd(zzm2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        ((zzcp)this).zzgg();
        return this.zzf(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzcp)this).zzgf();
        return this.zzf(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final List<AppMeasurement.ConditionalUserProperty> zzf(String string, String string2, String string3) {
        if (((zzcp)this).zzgs().zzkf()) {
            ((zzcp)this).zzgt().zzjg().zzca("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzl.isMainThread()) {
            ((zzcp)this).zzgt().zzjg().zzca("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzadp.zzgs().zzc(new zzdi(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcp)this).zzgt().zzjj().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcp)this).zzgt().zzjj().zzg("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzm zzm2 = (zzm)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = zzm2.packageName;
                conditionalUserProperty.mOrigin = zzm2.origin;
                conditionalUserProperty.mCreationTimestamp = zzm2.creationTimestamp;
                conditionalUserProperty.mName = zzm2.zzahe.name;
                conditionalUserProperty.mValue = zzm2.zzahe.getValue();
                conditionalUserProperty.mActive = zzm2.active;
                conditionalUserProperty.mTriggerEventName = zzm2.triggerEventName;
                if (zzm2.zzahf != null) {
                    conditionalUserProperty.mTimedOutEventName = zzm2.zzahf.name;
                    if (zzm2.zzahf.zzaig != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzm2.zzahf.zzaig.zziy();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzm2.triggerTimeout;
                if (zzm2.zzahg != null) {
                    conditionalUserProperty.mTriggeredEventName = zzm2.zzahg.name;
                    if (zzm2.zzahg.zzaig != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzm2.zzahg.zzaig.zziy();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzm2.zzahe.zzaux;
                conditionalUserProperty.mTimeToLive = zzm2.timeToLive;
                if (zzm2.zzahh != null) {
                    conditionalUserProperty.mExpiredEventName = zzm2.zzahh.name;
                    if (zzm2.zzahh.zzaig != null) {
                        conditionalUserProperty.mExpiredEventParams = zzm2.zzahh.zzaig.zziy();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        ((zzcp)this).zzgg();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzcp)this).zzgf();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzcp)this).zzgs().zzkf()) {
            ((zzcp)this).zzgt().zzjg().zzca("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        if (zzl.isMainThread()) {
            ((zzcp)this).zzgt().zzjg().zzca("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzadp.zzgs().zzc(new zzdk(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcp)this).zzgt().zzjj().zzg("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcp)this).zzgt().zzjj().zzca("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzfr zzfr2 = (zzfr)((Object)iterator.next());
                arrayMap.put(zzfr2.name, zzfr2.getValue());
            }
            return arrayMap;
        }
    }

    @Nullable
    public final String getCurrentScreenName() {
        zzdv zzdv2 = this.zzadp.zzgm().zzlf();
        if (zzdv2 != null) {
            return zzdv2.zzuw;
        }
        return null;
    }

    @Nullable
    public final String getCurrentScreenClass() {
        zzdv zzdv2 = this.zzadp.zzgm().zzlf();
        if (zzdv2 != null) {
            return zzdv2.zzasa;
        }
        return null;
    }

    @Nullable
    public final String getGmpAppId() {
        if (this.zzadp.zzko() != null) {
            return this.zzadp.zzko();
        }
        try {
            return GoogleServices.getGoogleAppId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzadp.zzgt().zzjg().zzg("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    static /* synthetic */ void zza(zzcy zzcy2, boolean bl) {
        zzcy2.zzj(bl);
    }

    static /* synthetic */ void zza(zzcy zzcy2) {
        zzcy2.zzlc();
    }

    static /* synthetic */ void zza(zzcy zzcy2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzcy2.zza(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzcy zzcy2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcy2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzcy zzcy2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcy2.zzc(conditionalUserProperty);
    }
}

