/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzdv;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfu;
import java.util.Map;

public final class zzdw
extends zzf {
    @VisibleForTesting
    protected zzdv zzasd;
    private volatile zzdv zzase;
    private zzdv zzasf;
    private final Map<Activity, zzdv> zzasg = new ArrayMap();
    private zzdv zzash;
    private String zzasi;

    public zzdw(zzbu zzbu2) {
        super(zzbu2);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    @WorkerThread
    public final zzdv zzle() {
        this.zzcl();
        ((zzcp)this).zzaf();
        return this.zzasd;
    }

    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzase == null) {
            ((zzcp)this).zzgt().zzjj().zzca("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzasg.get(activity) == null) {
            ((zzcp)this).zzgt().zzjj().zzca("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzdw.zzcs(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzase.zzasa.equals(string2);
        boolean bl2 = zzfu.zzv(this.zzase.zzuw, string);
        if (bl && bl2) {
            ((zzcp)this).zzgt().zzjl().zzca("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzcp)this).zzgt().zzjj().zzg("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzcp)this).zzgt().zzjj().zzg("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzcp)this).zzgt().zzjo().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzdv zzdv2 = new zzdv(string, string2, ((zzcp)this).zzgr().zzmj());
        this.zzasg.put(activity, zzdv2);
        this.zza(activity, zzdv2, true);
    }

    public final zzdv zzlf() {
        ((zzcp)this).zzgg();
        return this.zzase;
    }

    @MainThread
    private final void zza(Activity activity, zzdv zzdv2, boolean bl) {
        zzdv zzdv3;
        zzdv zzdv4 = zzdv3 = this.zzase == null ? this.zzasf : this.zzase;
        if (zzdv2.zzasa == null) {
            zzdv2 = new zzdv(zzdv2.zzuw, zzdw.zzcs(activity.getClass().getCanonicalName()), zzdv2.zzasb);
        }
        zzdv zzdv5 = zzdv2;
        this.zzasf = this.zzase;
        this.zzase = zzdv5;
        ((zzcp)this).zzgs().zzc(new zzdx(this, bl, zzdv3, zzdv5));
    }

    @WorkerThread
    private final void zza(@NonNull zzdv zzdv2, boolean bl) {
        ((zze)this).zzgi().zzq(((zzcp)this).zzbx().elapsedRealtime());
        if (((zze)this).zzgo().zza(zzdv2.zzasc, bl)) {
            zzdv2.zzasc = false;
        }
    }

    public static void zza(zzdv zzdv2, Bundle bundle, boolean bl) {
        if (bundle != null && zzdv2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzdv2.zzuw != null) {
                bundle.putString("_sn", zzdv2.zzuw);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzdv2.zzasa);
            bundle.putLong("_si", zzdv2.zzasb);
            return;
        }
        if (bundle != null && zzdv2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzdv zzdv2) {
        ((zzcp)this).zzaf();
        zzdw zzdw2 = this;
        synchronized (zzdw2) {
            if (this.zzasi == null || this.zzasi.equals(string) || zzdv2 != null) {
                this.zzasi = string;
                this.zzash = zzdv2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zzcs(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzdv zze(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzdv zzdv2 = this.zzasg.get(activity);
        if (zzdv2 == null) {
            String string = zzdw.zzcs(activity.getClass().getCanonicalName());
            zzdv2 = new zzdv(null, string, ((zzcp)this).zzgr().zzmj());
            this.zzasg.put(activity, zzdv2);
        }
        return zzdv2;
    }

    @MainThread
    public final void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzdv zzdv2 = new zzdv(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzasg.put(activity, zzdv2);
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzdv zzdv2 = this.zze(activity);
        this.zza(activity, zzdv2, false);
        zza zza2 = ((zze)this).zzgi();
        long l = ((zzcp)zza2).zzbx().elapsedRealtime();
        ((zzcp)zza2).zzgs().zzc(new zzd(zza2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzdv zzdv2 = this.zze(activity);
        this.zzasf = this.zzase;
        this.zzase = null;
        ((zzcp)this).zzgs().zzc(new zzdy(this, zzdv2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzdv zzdv2 = this.zzasg.get(activity);
        if (zzdv2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzdv2.zzasb);
        bundle2.putString("name", zzdv2.zzuw);
        bundle2.putString("referrer_name", zzdv2.zzasa);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzasg.remove(activity);
    }

    static /* synthetic */ void zza(zzdw zzdw2, zzdv zzdv2, boolean bl) {
        zzdw2.zza(zzdv2, bl);
    }
}

