/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzdv;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzec;
import com.google.android.gms.measurement.internal.zzed;
import com.google.android.gms.measurement.internal.zzee;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzdz
extends zzf {
    private final zzeo zzaso;
    private zzah zzasp;
    private volatile Boolean zzasq;
    private final zzw zzasr;
    private final zzff zzass;
    private final List<Runnable> zzast = new ArrayList<Runnable>();
    private final zzw zzasu;

    protected zzdz(zzbu zzbu2) {
        super(zzbu2);
        this.zzass = new zzff(zzbu2.zzbx());
        this.zzaso = new zzeo(this);
        this.zzasr = new zzea(this, zzbu2);
        this.zzasu = new zzeg(this, zzbu2);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzcp)this).zzaf();
        this.zzcl();
        return this.zzasp != null;
    }

    @WorkerThread
    protected final void zzlg() {
        ((zzcp)this).zzaf();
        this.zzcl();
        zzi zzi2 = this.zzl(true);
        this.zzf(new zzeh(this, zzi2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzah zzah2, AbstractSafeParcelable abstractSafeParcelable, zzi zzi2) {
        ((zzcp)this).zzaf();
        ((zzcp)this).zzgg();
        this.zzcl();
        boolean bl = this.zzlh();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zze)this).zzgn().zzr(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzae) {
                    try {
                        zzah2.zza((zzae)abstractSafeParcelable2, zzi2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcp)this).zzgt().zzjg().zzg("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzfr) {
                    try {
                        zzah2.zza((zzfr)abstractSafeParcelable2, zzi2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcp)this).zzgt().zzjg().zzg("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzm) {
                    try {
                        zzah2.zza((zzm)abstractSafeParcelable2, zzi2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcp)this).zzgt().zzjg().zzg("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzcp)this).zzgt().zzjg().zzca("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzae zzae2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzae2));
        ((zzcp)this).zzaf();
        this.zzcl();
        boolean bl = this.zzlh();
        boolean bl2 = bl && ((zze)this).zzgn().zza(zzae2);
        zzi zzi2 = this.zzl(true);
        this.zzf(new zzei(this, bl, bl2, zzae2, zzi2, string));
    }

    @WorkerThread
    protected final void zzd(zzm zzm2) {
        Preconditions.checkNotNull((Object)((Object)zzm2));
        ((zzcp)this).zzaf();
        this.zzcl();
        zzl zzl2 = ((zzcp)this).zzgw();
        boolean bl = true;
        boolean bl2 = true && ((zze)this).zzgn().zzc(zzm2);
        zzm zzm3 = new zzm(zzm2);
        zzi zzi2 = this.zzl(true);
        this.zzf(new zzej(this, bl, bl2, zzm3, zzi2, zzm2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzm>> atomicReference, String string, String string2, String string3) {
        ((zzcp)this).zzaf();
        this.zzcl();
        zzi zzi2 = this.zzl(false);
        this.zzf(new zzek(this, atomicReference, string, string2, string3, zzi2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzfr>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzcp)this).zzaf();
        this.zzcl();
        zzi zzi2 = this.zzl(false);
        this.zzf(new zzel(this, atomicReference, string, string2, string3, bl, zzi2));
    }

    @WorkerThread
    protected final void zzb(zzfr zzfr2) {
        ((zzcp)this).zzaf();
        this.zzcl();
        boolean bl = this.zzlh() && ((zze)this).zzgn().zza(zzfr2);
        zzi zzi2 = this.zzl(true);
        this.zzf(new zzem(this, bl, zzfr2, zzi2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzfr>> atomicReference, boolean bl) {
        ((zzcp)this).zzaf();
        this.zzcl();
        zzi zzi2 = this.zzl(false);
        this.zzf(new zzen(this, atomicReference, zzi2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzcp)this).zzaf();
        ((zzcp)this).zzgg();
        this.zzcl();
        zzi zzi2 = this.zzl(false);
        if (this.zzlh()) {
            ((zze)this).zzgn().resetAnalyticsData();
        }
        this.zzf(new zzeb(this, zzi2));
    }

    private final boolean zzlh() {
        zzl zzl2 = ((zzcp)this).zzgw();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzcp)this).zzaf();
        this.zzcl();
        zzi zzi2 = this.zzl(false);
        this.zzf(new zzec(this, atomicReference, zzi2));
    }

    @WorkerThread
    public final void getAppInstanceId(com.google.android.gms.internal.measurement.zzef zzef2) {
        ((zzcp)this).zzaf();
        this.zzcl();
        zzi zzi2 = this.zzl(false);
        this.zzf(new zzed(this, zzi2, zzef2));
    }

    @WorkerThread
    protected final void zzld() {
        ((zzcp)this).zzaf();
        this.zzcl();
        zzi zzi2 = this.zzl(true);
        this.zzf(new zzee(this, zzi2));
    }

    @WorkerThread
    protected final void zza(zzdv zzdv2) {
        ((zzcp)this).zzaf();
        this.zzcl();
        this.zzf(new zzef(this, zzdv2));
    }

    @WorkerThread
    private final void zzcy() {
        ((zzcp)this).zzaf();
        this.zzass.start();
        this.zzasr.zzh(zzag.zzakm.get());
    }

    @WorkerThread
    final void zzdj() {
        zzl zzl2;
        Boolean bl;
        zzdz zzdz2;
        ((zzcp)this).zzaf();
        this.zzcl();
        if (this.isConnected()) {
            return;
        }
        if (this.zzasq == null) {
            boolean bl2;
            zzdz2 = this;
            ((zzcp)zzdz2).zzaf();
            zzdz2.zzcl();
            bl = ((zzcp)zzdz2).zzgu().zzjx();
            if (bl != null && bl.booleanValue()) {
                bl2 = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzl2 = ((zzcp)zzdz2).zzgw();
                if (((zze)zzdz2).zzgk().zzje() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzcp)zzdz2).zzgt().zzjo().zzca("Checking service availability");
                    zzfu zzfu2 = ((zzcp)zzdz2).zzgr();
                    int n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzcp)zzfu2).getContext(), 12451000);
                    switch (n) {
                        case 0: {
                            ((zzcp)zzdz2).zzgt().zzjo().zzca("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzcp)zzdz2).zzgt().zzjo().zzca("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzcp)zzdz2).zzgt().zzjj().zzca("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzcp)zzdz2).zzgt().zzjn().zzca("Service container out of date");
                            if (((zzcp)zzdz2).zzgr().zzml() < 14500) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            Boolean bl5 = ((zzcp)zzdz2).zzgu().zzjx();
                            bl4 = bl5 == null || bl5 != false;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzcp)zzdz2).zzgt().zzjj().zzca("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzcp)zzdz2).zzgt().zzjj().zzca("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzcp)zzdz2).zzgt().zzjj().zzg("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzcp)zzdz2).zzgv().zzif()) {
                    ((zzcp)zzdz2).zzgt().zzjg().zzca("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzcp)zzdz2).zzgu().zzg(bl4);
                }
                bl2 = bl4;
            }
            this.zzasq = bl2;
        }
        if (this.zzasq.booleanValue()) {
            this.zzaso.zzll();
            return;
        }
        if (!((zzcp)this).zzgv().zzif()) {
            Intent intent;
            zzdz2 = this;
            zzl2 = ((zzcp)zzdz2).zzgw();
            bl = ((zzcp)zzdz2).getContext().getPackageManager();
            List list = bl.queryIntentServices(intent = new Intent().setClassName(((zzcp)zzdz2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzl2 = ((zzcp)this).zzgw();
                intent2.setComponent(new ComponentName(((zzcp)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zzaso.zzc(intent2);
                return;
            }
            ((zzcp)this).zzgt().zzjg().zzca("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzli() {
        return this.zzasq;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzah zzah2) {
        ((zzcp)this).zzaf();
        Preconditions.checkNotNull((Object)zzah2);
        this.zzasp = zzah2;
        this.zzcy();
        this.zzlj();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzcp)this).zzaf();
        this.zzcl();
        this.zzaso.zzlk();
        try {
            ConnectionTracker.getInstance().unbindService(((zzcp)this).getContext(), (ServiceConnection)this.zzaso);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzasp = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzcp)this).zzaf();
        if (this.zzasp != null) {
            this.zzasp = null;
            ((zzcp)this).zzgt().zzjo().zzg("Disconnected from device MeasurementService", componentName);
            zzdz zzdz2 = this;
            ((zzcp)zzdz2).zzaf();
            zzdz2.zzdj();
        }
    }

    @WorkerThread
    private final void zzcz() {
        ((zzcp)this).zzaf();
        if (!this.isConnected()) {
            return;
        }
        ((zzcp)this).zzgt().zzjo().zzca("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzf(Runnable runnable) throws IllegalStateException {
        ((zzcp)this).zzaf();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzast.size() >= 1000L) {
            ((zzcp)this).zzgt().zzjg().zzca("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzast.add(runnable);
        this.zzasu.zzh(60000L);
        this.zzdj();
    }

    @WorkerThread
    private final void zzlj() {
        ((zzcp)this).zzaf();
        ((zzcp)this).zzgt().zzjo().zzg("Processing queued up service tasks", this.zzast.size());
        for (Runnable runnable : this.zzast) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzcp)this).zzgt().zzjg().zzg("Task exception while flushing queue", exception);
            }
        }
        this.zzast.clear();
        this.zzasu.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzi zzl(boolean bl) {
        zzl zzl2 = ((zzcp)this).zzgw();
        return ((zze)this).zzgk().zzbu(bl ? ((zzcp)this).zzgt().zzjq() : null);
    }

    static /* synthetic */ zzeo zza(zzdz zzdz2) {
        return zzdz2.zzaso;
    }

    static /* synthetic */ void zza(zzdz zzdz2, ComponentName componentName) {
        zzdz2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzah zza(zzdz zzdz2, zzah zzah2) {
        zzdz2.zzasp = null;
        return null;
    }

    static /* synthetic */ void zzb(zzdz zzdz2) {
        zzdz2.zzlj();
    }

    static /* synthetic */ void zzc(zzdz zzdz2) {
        zzdz2.zzcz();
    }

    static /* synthetic */ zzah zzd(zzdz zzdz2) {
        return zzdz2.zzasp;
    }

    static /* synthetic */ void zze(zzdz zzdz2) {
        zzdz2.zzcy();
    }
}

