/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import java.lang.reflect.InvocationTargetException;

public final class zzo
extends zzcp {
    private Boolean zzahi;
    @NonNull
    private zzq zzahj = zzp.zzahk;
    private Boolean zzyk;

    zzo(zzbu zzbu2) {
        super(zzbu2);
        zzag.zza(zzbu2);
    }

    final void zza(@NonNull zzq zzq2) {
        this.zzahj = zzq2;
    }

    static String zzhy() {
        return zzag.zzajg.get();
    }

    @WorkerThread
    public final int zzas(@Size(min=1L) String string) {
        return this.zzb(string, zzag.zzaju);
    }

    public final long zzhh() {
        zzl zzl2 = ((zzcp)this).zzgw();
        return 14700L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzdw() {
        if (this.zzyk == null) {
            zzo zzo2 = this;
            synchronized (zzo2) {
                if (this.zzyk == null) {
                    ApplicationInfo applicationInfo = ((zzcp)this).getContext().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzyk = string2 != null && string2.equals(string);
                    }
                    if (this.zzyk == null) {
                        this.zzyk = Boolean.TRUE;
                        ((zzcp)this).zzgt().zzjg().zzca("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzyk;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzag.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzahj.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.parseLong(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzag.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzahj.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.parseInt(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzag.zza<Double> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzahj.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            double d = Double.parseDouble(string2);
            return zza2.get(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzag.zza<Boolean> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzahj.zzf(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zza2.get(bl);
    }

    public final boolean zze(String string, zzag.zza<Boolean> zza2) {
        return this.zzd(string, zza2);
    }

    public final boolean zza(zzag.zza<Boolean> zza2) {
        zzag.zza<Boolean> zza3 = zza2;
        return this.zzd(null, zza3);
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzat(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            if (((zzcp)this).getContext().getPackageManager() == null) {
                ((zzcp)this).zzgt().zzjg().zzca("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzcp)this).getContext()).getApplicationInfo(((zzcp)this).getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzcp)this).zzgt().zzjg().zzca("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                ((zzcp)this).zzgt().zzjg().zzca("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzcp)this).zzgt().zzjg().zzg("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final boolean zzhz() {
        zzl zzl2 = ((zzcp)this).zzgw();
        Boolean bl = this.zzat("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzia() {
        zzl zzl2 = ((zzcp)this).zzgw();
        return this.zzat("firebase_analytics_collection_enabled");
    }

    public static long zzib() {
        return zzag.zzakj.get();
    }

    public static long zzic() {
        return zzag.zzajj.get();
    }

    public final String zzid() {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzcp)this).zzgt().zzjg().zzg("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzcp)this).zzgt().zzjg().zzg("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzcp)this).zzgt().zzjg().zzg("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzcp)this).zzgt().zzjg().zzg("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }

    public static boolean zzie() {
        return zzag.zzajf.get();
    }

    public final boolean zzau(String string) {
        return "1".equals(this.zzahj.zzf(string, "gaia_collection_enabled"));
    }

    public final boolean zzav(String string) {
        return "1".equals(this.zzahj.zzf(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzaw(String string) {
        return this.zzd(string, zzag.zzakt);
    }

    @WorkerThread
    final boolean zzax(String string) {
        return this.zzd(string, zzag.zzakv);
    }

    @WorkerThread
    final boolean zzay(String string) {
        return this.zzd(string, zzag.zzakw);
    }

    @WorkerThread
    final boolean zzaz(String string) {
        return this.zzd(string, zzag.zzakn);
    }

    @WorkerThread
    final String zzba(String string) {
        zzag.zza<String> zza2 = zzag.zzako;
        String string2 = string;
        zzo zzo2 = this;
        if (string2 == null) {
            return zza2.get();
        }
        return zza2.get(zzo2.zzahj.zzf(string2, zza2.getKey()));
    }

    final boolean zzbb(String string) {
        return this.zzd(string, zzag.zzakx);
    }

    @WorkerThread
    final boolean zzbc(String string) {
        return this.zzd(string, zzag.zzaky);
    }

    final boolean zzbd(String string) {
        return this.zzd(string, zzag.zzala);
    }

    @WorkerThread
    final boolean zzbe(String string) {
        return this.zzd(string, zzag.zzalb);
    }

    @WorkerThread
    final boolean zzbf(String string) {
        return this.zzd(string, zzag.zzalc);
    }

    @WorkerThread
    final boolean zzbg(String string) {
        return this.zzd(string, zzag.zzale);
    }

    @WorkerThread
    final boolean zzif() {
        if (this.zzahi == null) {
            this.zzahi = this.zzat("app_measurement_lite");
            if (this.zzahi == null) {
                this.zzahi = false;
            }
        }
        return this.zzahi != false || !this.zzadp.zzkr();
    }

    @WorkerThread
    final boolean zzbh(String string) {
        return this.zzd(string, zzag.zzald);
    }

    @WorkerThread
    static boolean zzig() {
        return zzag.zzalf.get();
    }

    @WorkerThread
    final boolean zzbi(String string) {
        return this.zzd(string, zzag.zzalg);
    }

    @WorkerThread
    final boolean zzbj(String string) {
        return this.zzd(string, zzag.zzalh);
    }

    @WorkerThread
    final boolean zzbk(String string) {
        return this.zzd(string, zzag.zzali);
    }

    @WorkerThread
    final boolean zzbl(String string) {
        return this.zzd(string, zzag.zzalj);
    }

    @WorkerThread
    final boolean zzbm(String string) {
        return this.zzd(string, zzag.zzall);
    }
}

