/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzex;

@VisibleForTesting
public final class zzes
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzasr;
    private volatile zzar zzass;
    final /* synthetic */ zzeb zzasl;

    protected zzes(zzeb zzeb2) {
        this.zzasl = zzeb2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb(Intent intent) {
        ((zzcr)this.zzasl).zzaf();
        Context context = ((zzcr)this.zzasl).getContext();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzes zzes2 = this;
        synchronized (zzes2) {
            if (this.zzasr) {
                ((zzcr)this.zzasl).zzgt().zzjo().zzby("Connection attempt already in progress");
                return;
            }
            ((zzcr)this.zzasl).zzgt().zzjo().zzby("Using local app measurement service");
            this.zzasr = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzeb.zza(this.zzasl), 129);
            return;
        }
    }

    @WorkerThread
    public final void zzlk() {
        if (this.zzass != null && (this.zzass.isConnected() || this.zzass.isConnecting())) {
            this.zzass.disconnect();
        }
        this.zzass = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzes zzes2 = this;
        synchronized (zzes2) {
            String string;
            if (iBinder == null) {
                this.zzasr = false;
                ((zzcr)this.zzasl).zzgt().zzjg().zzby("Service connected with null binder");
                return;
            }
            zzaj zzaj2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzaj2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzaj ? (zzaj)iInterface : new zzal(iBinder2));
                    ((zzcr)this.zzasl).zzgt().zzjo().zzby("Bound to IMeasurementService interface");
                } else {
                    ((zzcr)this.zzasl).zzgt().zzjg().zzg("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzcr)this.zzasl).zzgt().zzjg().zzby("Service connect failed to get IMeasurementService");
            }
            if (zzaj2 == null) {
                this.zzasr = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzcr)this.zzasl).getContext(), (ServiceConnection)zzeb.zza(this.zzasl));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzaj2;
                ((zzcr)this.zzasl).zzgs().zzc(new zzet(this, (zzaj)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzcr)this.zzasl).zzgt().zzjn().zzby("Service disconnected");
        ((zzcr)this.zzasl).zzgs().zzc(new zzeu(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzll() {
        ((zzcr)this.zzasl).zzaf();
        Context context = ((zzcr)this.zzasl).getContext();
        zzes zzes2 = this;
        synchronized (zzes2) {
            if (this.zzasr) {
                ((zzcr)this.zzasl).zzgt().zzjo().zzby("Connection attempt already in progress");
                return;
            }
            if (this.zzass != null && (this.zzass.isConnecting() || this.zzass.isConnected())) {
                ((zzcr)this.zzasl).zzgt().zzjo().zzby("Already awaiting connection attempt");
                return;
            }
            this.zzass = new zzar(context, Looper.getMainLooper(), this, this);
            ((zzcr)this.zzasl).zzgt().zzjo().zzby("Connecting to remote service");
            this.zzasr = true;
            this.zzass.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzes zzes2 = this;
        synchronized (zzes2) {
            try {
                zzaj zzaj2 = (zzaj)this.zzass.getService();
                ((zzcr)this.zzasl).zzgs().zzc(new zzev(this, zzaj2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzass = null;
                this.zzasr = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzcr)this.zzasl).zzgt().zzjn().zzby("Service connection suspended");
        ((zzcr)this.zzasl).zzgs().zzc(new zzew(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzas zzas2 = this.zzasl.zzada.zzkj();
        if (zzas2 != null) {
            zzas2.zzjj().zzg("Service connection failed", connectionResult);
        }
        zzes zzes2 = this;
        synchronized (zzes2) {
            this.zzasr = false;
            this.zzass = null;
        }
        ((zzcr)this.zzasl).zzgs().zzc(new zzex(this));
    }

    static /* synthetic */ boolean zza(zzes zzes2, boolean bl) {
        zzes2.zzasr = false;
        return false;
    }
}

