/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.common.zzc;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class zzad
extends zzaa {
    private final zza zzbfx;
    private zzm zzbfy;
    private Boolean zzbfz;
    private final zzf zzbfA;
    private final zzah zzbfB;
    private final List<Runnable> zzbfC = new ArrayList<Runnable>();
    private final zzf zzbfD;

    protected zzad(zzx zzx2) {
        super(zzx2);
        this.zzbfB = new zzah(zzx2.zzlQ());
        this.zzbfx = new zza();
        this.zzbfA = new zzf(zzx2){

            @Override
            public void run() {
                zzad.this.zzmo();
            }
        };
        this.zzbfD = new zzf(zzx2){

            @Override
            public void run() {
                zzad.this.zzFm().zzFG().log("Tasks have been queued for a long time");
            }
        };
    }

    @Override
    protected void zzkO() {
    }

    @WorkerThread
    public boolean isConnected() {
        this.zzkN();
        this.zzma();
        return this.zzbfy != null;
    }

    @WorkerThread
    protected void zzGA() {
        this.zzkN();
        this.zzma();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.zzbfy;
                if (zzm2 == null) {
                    zzad.this.zzFm().zzFE().log("Failed to send measurementEnabled to service");
                    return;
                }
                try {
                    zzm2.zzb(zzad.this.zzFe().zzfs(zzad.this.zzFm().zzFM()));
                    zzad.this.zzmn();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzFm().zzFE().zzj("Failed to send measurementEnabled to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zzc(final EventParcel eventParcel, final String string) {
        com.google.android.gms.common.internal.zzaa.zzz((Object)((Object)eventParcel));
        this.zzkN();
        this.zzma();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.zzbfy;
                if (zzm2 == null) {
                    zzad.this.zzFm().zzFE().log("Discarding data. Failed to send event to service");
                    return;
                }
                try {
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        zzm2.zza(eventParcel, zzad.this.zzFe().zzfs(zzad.this.zzFm().zzFM()));
                    } else {
                        zzm2.zza(eventParcel, string, zzad.this.zzFm().zzFM());
                    }
                    zzad.this.zzmn();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzFm().zzFE().zzj("Failed to send event to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final UserAttributeParcel userAttributeParcel) {
        this.zzkN();
        this.zzma();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.zzbfy;
                if (zzm2 == null) {
                    zzad.this.zzFm().zzFE().log("Discarding data. Failed to set user attribute");
                    return;
                }
                try {
                    zzm2.zza(userAttributeParcel, zzad.this.zzFe().zzfs(zzad.this.zzFm().zzFM()));
                    zzad.this.zzmn();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzFm().zzFE().zzj("Failed to send attribute to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<UserAttributeParcel>> atomicReference, final boolean bl) {
        this.zzkN();
        this.zzma();
        this.zzi(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzm zzm2 = zzad.this.zzbfy;
                        if (zzm2 == null) {
                            zzad.this.zzFm().zzFE().log("Failed to get user properties");
                            return;
                        }
                        atomicReference.set(zzm2.zza(zzad.this.zzFe().zzfs(null), bl));
                        zzad.this.zzmn();
                    }
                    catch (RemoteException remoteException) {
                        zzad.this.zzFm().zzFE().zzj("Failed to get user properties", (Object)remoteException);
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zzGx() {
        this.zzkN();
        this.zzma();
        this.zzi(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.zzbfy;
                if (zzm2 == null) {
                    zzad.this.zzFm().zzFE().log("Discarding data. Failed to send app launch");
                    return;
                }
                try {
                    zzm2.zza(zzad.this.zzFe().zzfs(zzad.this.zzFm().zzFM()));
                    zzad.this.zzmn();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzFm().zzFE().zzj("Failed to send app launch to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    private void zzmn() {
        this.zzkN();
        this.zzbfB.start();
        if (!this.zzbbl.zzGh()) {
            this.zzbfA.zzv(this.zzFo().zznr());
        }
    }

    @WorkerThread
    void zzmC() {
        this.zzkN();
        this.zzma();
        if (this.isConnected()) {
            return;
        }
        if (this.zzbfz == null) {
            this.zzbfz = this.zzFn().zzFS();
            if (this.zzbfz == null) {
                this.zzFm().zzFL().log("State of service unknown");
                this.zzbfz = this.zzGC();
                this.zzFn().zzaw(this.zzbfz);
            }
        }
        if (this.zzbfz.booleanValue()) {
            this.zzFm().zzFL().log("Using measurement service");
            this.zzbfx.zzGF();
        } else {
            if (!this.zzbbl.zzGh() && this.zzGB()) {
                this.zzFm().zzFL().log("Using local app measurement service");
                Intent intent = new Intent("com.google.android.gms.measurement.START");
                intent.setComponent(new ComponentName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zzbfx.zzx(intent);
                return;
            }
            if (this.zzFo().zzmX()) {
                this.zzFm().zzFL().log("Using direct local measurement implementation");
                this.zza(new zzy(this.zzbbl, true));
            } else {
                this.zzFm().zzFE().log("Not in main process. Unable to use local measurement implementation. Please register the AppMeasurementService service in the app manifest");
            }
        }
    }

    private boolean zzGB() {
        Intent intent;
        PackageManager packageManager = this.getContext().getPackageManager();
        List list = packageManager.queryIntentServices(intent = new Intent().setClassName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
        return list != null && list.size() > 0;
    }

    @WorkerThread
    protected boolean zzGC() {
        this.zzkN();
        this.zzma();
        if (this.zzFo().zzmW()) {
            return true;
        }
        this.zzFm().zzFL().log("Checking service availability");
        int n = zzc.zzqV().isGooglePlayServicesAvailable(this.getContext());
        switch (n) {
            case 0: {
                this.zzFm().zzFL().log("Service available");
                return true;
            }
            case 1: {
                this.zzFm().zzFL().log("Service missing");
                return false;
            }
            case 18: {
                this.zzFm().zzFG().log("Service updating");
                return true;
            }
            case 2: {
                this.zzFm().zzFK().log("Service container out of date");
                return true;
            }
            case 3: {
                this.zzFm().zzFG().log("Service disabled");
                return false;
            }
            case 9: {
                this.zzFm().zzFG().log("Service invalid");
                return false;
            }
        }
        return false;
    }

    @WorkerThread
    private void zza(zzm zzm2) {
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzz((Object)zzm2);
        this.zzbfy = zzm2;
        this.zzmn();
        this.zzGE();
    }

    @WorkerThread
    public void disconnect() {
        this.zzkN();
        this.zzma();
        try {
            zzb zzb2 = zzb.zzuH();
            zzb2.zza(this.getContext(), (ServiceConnection)this.zzbfx);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
        this.zzbfy = null;
    }

    @WorkerThread
    private void onServiceDisconnected(ComponentName componentName) {
        this.zzkN();
        if (this.zzbfy != null) {
            this.zzbfy = null;
            this.zzFm().zzFL().zzj("Disconnected from device MeasurementService", componentName);
            this.zzGD();
        }
    }

    @WorkerThread
    private void zzmo() {
        this.zzkN();
        if (!this.isConnected()) {
            return;
        }
        this.zzFm().zzFL().log("Inactivity, disconnecting from AppMeasurementService");
        this.disconnect();
    }

    @WorkerThread
    private void zzGD() {
        this.zzkN();
        this.zzmC();
    }

    @WorkerThread
    private void zzi(Runnable runnable) throws IllegalStateException {
        this.zzkN();
        if (this.isConnected()) {
            runnable.run();
        } else {
            if ((long)this.zzbfC.size() >= this.zzFo().zzEQ()) {
                this.zzFm().zzFE().log("Discarding data. Max runnable queue size reached");
                return;
            }
            this.zzbfC.add(runnable);
            if (!this.zzbbl.zzGh()) {
                this.zzbfD.zzv(60000L);
            }
            this.zzmC();
        }
    }

    @WorkerThread
    private void zzGE() {
        this.zzkN();
        this.zzFm().zzFL().zzj("Processing queued up service tasks", this.zzbfC.size());
        for (Runnable runnable : this.zzbfC) {
            this.zzFl().zzg(runnable);
        }
        this.zzbfC.clear();
        this.zzbfD.cancel();
    }

    protected class zza
    implements ServiceConnection,
    zzd.zzb,
    zzd.zzc {
        private volatile boolean zzbfG;
        private volatile zzo zzbfH;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzx(Intent intent) {
            zzad.this.zzkN();
            Context context = zzad.this.getContext();
            zzb zzb2 = zzb.zzuH();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.zzbfG) {
                    zzad.this.zzFm().zzFL().log("Connection attempt already in progress");
                    return;
                }
                this.zzbfG = true;
                zzb2.zza(context, intent, (ServiceConnection)zzad.this.zzbfx, 129);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            com.google.android.gms.common.internal.zzaa.zzdc((String)"MeasurementServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                Object object;
                if (iBinder == null) {
                    this.zzbfG = false;
                    zzad.this.zzFm().zzFE().log("Service connected with null binder");
                    return;
                }
                zzm zzm2 = null;
                try {
                    object = iBinder.getInterfaceDescriptor();
                    if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(object)) {
                        zzm2 = zzm.zza.zzdv(iBinder);
                        zzad.this.zzFm().zzFL().log("Bound to IMeasurementService interface");
                    } else {
                        zzad.this.zzFm().zzFE().zzj("Got binder with a wrong descriptor", object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzFm().zzFE().log("Service connect failed to get IMeasurementService");
                }
                if (zzm2 == null) {
                    this.zzbfG = false;
                    try {
                        zzb.zzuH().zza(zzad.this.getContext(), (ServiceConnection)zzad.this.zzbfx);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    object = zzm2;
                    zzad.this.zzFl().zzg(new Runnable((zzm)object){
                        final /* synthetic */ zzm zzbfI;
                        {
                            this.zzbfI = zzm2;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.zzbfG = false;
                                if (!zzad.this.isConnected()) {
                                    zzad.this.zzFm().zzFL().log("Connected to service");
                                    zzad.this.zza(this.zzbfI);
                                }
                            }
                        }
                    });
                }
            }
        }

        @MainThread
        public void onServiceDisconnected(final ComponentName componentName) {
            com.google.android.gms.common.internal.zzaa.zzdc((String)"MeasurementServiceConnection.onServiceDisconnected");
            zzad.this.zzFm().zzFK().log("Service disconnected");
            zzad.this.zzFl().zzg(new Runnable(){

                @Override
                public void run() {
                    zzad.this.onServiceDisconnected(componentName);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzGF() {
            zzad.this.zzkN();
            Context context = zzad.this.getContext();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.zzbfG) {
                    zzad.this.zzFm().zzFL().log("Connection attempt already in progress");
                    return;
                }
                if (this.zzbfH != null) {
                    zzad.this.zzFm().zzFL().log("Already awaiting connection attempt");
                    return;
                }
                this.zzbfH = new zzo(context, Looper.getMainLooper(), this, this);
                zzad.this.zzFm().zzFL().log("Connecting to remote service");
                this.zzbfG = true;
                this.zzbfH.zztj();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnected(@Nullable Bundle bundle) {
            com.google.android.gms.common.internal.zzaa.zzdc((String)"MeasurementServiceConnection.onConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    final zzm zzm2 = (zzm)this.zzbfH.zztm();
                    this.zzbfH = null;
                    zzad.this.zzFl().zzg(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.zzbfG = false;
                                if (!zzad.this.isConnected()) {
                                    zzad.this.zzFm().zzFK().log("Connected to remote service");
                                    zzad.this.zza(zzm2);
                                }
                            }
                        }
                    });
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    this.zzbfH = null;
                    this.zzbfG = false;
                }
            }
        }

        @MainThread
        public void onConnectionSuspended(int n) {
            com.google.android.gms.common.internal.zzaa.zzdc((String)"MeasurementServiceConnection.onConnectionSuspended");
            zzad.this.zzFm().zzFK().log("Service connection suspended");
            zzad.this.zzFl().zzg(new Runnable(){

                @Override
                public void run() {
                    zzad.this.onServiceDisconnected(new ComponentName(zzad.this.getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            com.google.android.gms.common.internal.zzaa.zzdc((String)"MeasurementServiceConnection.onConnectionFailed");
            zzp zzp2 = zzad.this.zzbbl.zzFY();
            if (zzp2 != null) {
                zzp2.zzFG().zzj("Service connection failed", connectionResult);
            }
            zza zza2 = this;
            synchronized (zza2) {
                this.zzbfG = false;
                this.zzbfH = null;
            }
        }
    }
}

