/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.internal.zzamb;
import com.google.android.gms.internal.zzamc;
import com.google.android.gms.internal.zzsn;
import com.google.android.gms.internal.zzsp;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzx;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zze
extends zzaa {
    private static final Map<String, String> zzbbU = new ArrayMap(16);
    private final zzc zzbbV;
    private final zzah zzbbW = new zzah(this.zzlQ());

    zze(zzx zzx2) {
        super(zzx2);
        String string = this.zzmv();
        this.zzbbV = new zzc(this.getContext(), string);
    }

    @Override
    protected void zzkO() {
    }

    @WorkerThread
    public void beginTransaction() {
        this.zzma();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public void setTransactionSuccessful() {
        this.zzma();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public void endTransaction() {
        this.zzma();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzFm().zzFE().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            long l3 = l;
            return l;
        }
    }

    @WorkerThread
    SQLiteDatabase getWritableDatabase() {
        this.zzkN();
        try {
            return this.zzbbV.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFG().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    String zzmv() {
        if (!this.zzFo().zzmW()) {
            return this.zzFo().zznw();
        }
        if (this.zzFo().zzmX()) {
            return this.zzFo().zznw();
        }
        this.zzFm().zzFH().log("Using secondary database");
        return this.zzFo().zznx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzi zzO(String string, String string2) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        com.google.android.gms.common.internal.zzaa.zzdl((String)string2);
        this.zzkN();
        this.zzma();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var5_6 = null;
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzi zzi2 = new zzi(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzFm().zzFE().log("Got multiple records for event aggregates, expected one");
            }
            zzi zzi3 = zzi2;
            return zzi3;
        }
    }

    @WorkerThread
    public void zza(zzi zzi2) {
        com.google.android.gms.common.internal.zzaa.zzz((Object)zzi2);
        this.zzkN();
        this.zzma();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzi2.zzPx);
        contentValues.put("name", zzi2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzi2.zzbck));
        contentValues.put("current_bundle_count", Long.valueOf(zzi2.zzbcl));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzi2.zzbcm));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("events", null, contentValues, 5);
            if (l == -1L) {
                this.zzFm().zzFE().log("Failed to insert/update event aggregates (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Error storing event aggregates", (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzP(String string, String string2) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        com.google.android.gms.common.internal.zzaa.zzdl((String)string2);
        this.zzkN();
        this.zzma();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = sQLiteDatabase.delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzFm().zzFL().zzj("Deleted user attribute rows:", n);
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzd("Error deleting user attribute", string, string2, (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzy(String string, int n) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        this.zzkN();
        this.zzma();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string, string, String.valueOf(n)});
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zze("Error pruning currencies", string, (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public boolean zza(zzak zzak2) {
        long l;
        com.google.android.gms.common.internal.zzaa.zzz((Object)zzak2);
        this.zzkN();
        this.zzma();
        zzak zzak3 = this.zzQ(zzak2.zzPx, zzak2.mName);
        if (zzak3 == null && (zzal.zzfG(zzak2.mName) ? (l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzak2.zzPx})) >= (long)this.zzFo().zzEH() : (l = this.zzb("select count(1) from user_attributes where app_id=?", new String[]{zzak2.zzPx})) >= (long)this.zzFo().zzEI())) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzak2.zzPx);
        contentValues.put("name", zzak2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzak2.zzbgg));
        this.zza(contentValues, "value", zzak2.zzRF);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l2 = sQLiteDatabase.insertWithOnConflict("user_attributes", null, contentValues, 5);
            if (l2 == -1L) {
                this.zzFm().zzFE().log("Failed to insert/update user property (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Error storing user property", (Object)sQLiteException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzak zzQ(String string, String string2) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        com.google.android.gms.common.internal.zzaa.zzdl((String)string2);
        this.zzkN();
        this.zzma();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"set_timestamp", "value"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var5_6 = null;
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zzb(cursor, 1);
            zzak zzak2 = new zzak(string, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzFm().zzFE().log("Got multiple records for user property, expected one");
            }
            zzak zzak3 = zzak2;
            return zzak3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<zzak> zzfj(String string) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        this.zzkN();
        this.zzma();
        ArrayList<zzak> arrayList = new ArrayList<zzak>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"name", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(this.zzFo().zzEI()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzak> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zzb(cursor, 2);
                if (object2 == null) {
                    this.zzFm().zzFE().log("Read invalid user property value, ignoring it");
                    continue;
                }
                zzak zzak2 = new zzak(string, (String)object, l, object2);
                arrayList.add(zzak2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public com.google.android.gms.measurement.internal.zza zzfk(String string) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        this.zzkN();
        this.zzma();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_5 = null;
                return null;
            }
            com.google.android.gms.measurement.internal.zza zza2 = new com.google.android.gms.measurement.internal.zza(this.zzbbl, string);
            zza2.zzeV(cursor.getString(0));
            zza2.zzeW(cursor.getString(1));
            zza2.zzeX(cursor.getString(2));
            zza2.zzW(cursor.getLong(3));
            zza2.zzR(cursor.getLong(4));
            zza2.zzS(cursor.getLong(5));
            zza2.setAppVersion(cursor.getString(6));
            zza2.zzeZ(cursor.getString(7));
            zza2.zzU(cursor.getLong(8));
            zza2.zzV(cursor.getLong(9));
            zza2.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zza2.zzZ(cursor.getLong(11));
            zza2.zzaa(cursor.getLong(12));
            zza2.zzab(cursor.getLong(13));
            zza2.zzac(cursor.getLong(14));
            zza2.zzX(cursor.getLong(15));
            zza2.zzY(cursor.getLong(16));
            zza2.zzT(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zza2.zzeY(cursor.getString(18));
            zza2.zzad(cursor.getLong(19));
            zza2.zzEa();
            if (cursor.moveToNext()) {
                this.zzFm().zzFE().log("Got multiple records for app, expected one");
            }
            com.google.android.gms.measurement.internal.zza zza3 = zza2;
            return zza3;
        }
    }

    @WorkerThread
    public void zza(com.google.android.gms.measurement.internal.zza zza2) {
        com.google.android.gms.common.internal.zzaa.zzz((Object)zza2);
        this.zzkN();
        this.zzma();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zza2.zziC());
        contentValues.put("app_instance_id", zza2.zzvx());
        contentValues.put("gmp_app_id", zza2.zzEb());
        contentValues.put("resettable_device_id_hash", zza2.zzEc());
        contentValues.put("last_bundle_index", Long.valueOf(zza2.zzEl()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zza2.zzEe()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zza2.zzEf()));
        contentValues.put("app_version", zza2.zzkV());
        contentValues.put("app_store", zza2.zzEh());
        contentValues.put("gmp_version", Long.valueOf(zza2.zzEi()));
        contentValues.put("dev_cert_hash", Long.valueOf(zza2.zzEj()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zza2.zzEk()));
        contentValues.put("day", Long.valueOf(zza2.zzEp()));
        contentValues.put("daily_public_events_count", Long.valueOf(zza2.zzEq()));
        contentValues.put("daily_events_count", Long.valueOf(zza2.zzEr()));
        contentValues.put("daily_conversions_count", Long.valueOf(zza2.zzEs()));
        contentValues.put("config_fetched_time", Long.valueOf(zza2.zzEm()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zza2.zzEn()));
        contentValues.put("app_version_int", Long.valueOf(zza2.zzEg()));
        contentValues.put("firebase_instance_id", zza2.zzEd());
        contentValues.put("daily_error_events_count", Long.valueOf(zza2.zzEt()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5);
            if (l == -1L) {
                this.zzFm().zzFE().log("Failed to insert/update app (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Error storing app", (Object)sQLiteException);
        }
    }

    public long zzfl(String string) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        this.zzkN();
        this.zzma();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = String.valueOf(this.zzFo().zzfi(string));
            long l = sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string2});
            return l;
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Error deleting over the limit events", (Object)sQLiteException);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zza zza(long l, String string, boolean bl, boolean bl2, boolean bl3) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        this.zzkN();
        this.zzma();
        String[] stringArray = new String[]{string};
        zza zza2 = new zza();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzFm().zzFG().zzj("Not updating daily counts, app is not known", string);
                zza zza3 = zza2;
                return zza3;
            }
            long l2 = cursor.getLong(0);
            if (l2 == l) {
                zza2.zzbbY = cursor.getLong(1);
                zza2.zzbbX = cursor.getLong(2);
                zza2.zzbbZ = cursor.getLong(3);
                zza2.zzbca = cursor.getLong(4);
            }
            ++zza2.zzbbY;
            if (bl) {
                ++zza2.zzbbX;
            }
            if (bl2) {
                ++zza2.zzbbZ;
            }
            if (bl3) {
                ++zza2.zzbca;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zza2.zzbbX));
            contentValues.put("daily_events_count", Long.valueOf(zza2.zzbbY));
            contentValues.put("daily_conversions_count", Long.valueOf(zza2.zzbbZ));
            contentValues.put("daily_error_events_count", Long.valueOf(zza2.zzbca));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zza zza4 = zza2;
            return zza4;
        }
    }

    @WorkerThread
    public void zzd(String string, byte[] byArray) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        this.zzkN();
        this.zzma();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{string});
            if (l == 0L) {
                this.zzFm().zzFE().log("Failed to update remote config (got 0)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Error storing remote config", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zzfm(String string) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        this.zzkN();
        this.zzma();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_5 = null;
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzFm().zzFE().log("Got multiple records for app config, expected one");
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public void zza(zzsp.zze zze2) {
        byte[] byArray;
        Object object;
        this.zzkN();
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzz((Object)zze2);
        com.google.android.gms.common.internal.zzaa.zzdl((String)zze2.appId);
        com.google.android.gms.common.internal.zzaa.zzz((Object)zze2.zzbhi);
        this.zzFq();
        long l = this.zzlQ().currentTimeMillis();
        if (zze2.zzbhi < l - this.zzFo().zzEO() || zze2.zzbhi > l + this.zzFo().zzEO()) {
            this.zzFm().zzFG().zze("Storing bundle outside of the max uploading time span. now, timestamp", l, zze2.zzbhi);
        }
        try {
            int n = zze2.getSerializedSize();
            object = new byte[n];
            zzamc zzamc2 = zzamc.zzO((byte[])object);
            zze2.writeTo(zzamc2);
            zzamc2.zzWU();
            byArray = this.zzFi().zzh((byte[])object);
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Data loss. Failed to serialize bundle", iOException);
            return;
        }
        this.zzFm().zzFL().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.appId);
        contentValues.put("bundle_end_timestamp", zze2.zzbhi);
        contentValues.put("data", byArray);
        try {
            object = this.getWritableDatabase();
            long l2 = object.insert("queue", null, contentValues);
            if (l2 == -1L) {
                this.zzFm().zzFE().log("Failed to insert bundle (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Error storing bundle", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public String zzFp() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue where app_id not in (select app_id from apps where measurement_enabled=0) order by rowid limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            Object var4_6 = null;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<Pair<zzsp.zze, Long>> zzn(String string, int n, int n2) {
        this.zzkN();
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzaj((n > 0 ? 1 : 0) != 0);
        com.google.android.gms.common.internal.zzaa.zzaj((n2 > 0 ? 1 : 0) != 0);
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzsp.zze, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzsp.zze, Long>> arrayList = new ArrayList<Pair<zzsp.zze, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzFi().zzr((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzFm().zzFE().zze("Failed to unzip queued bundle", string, iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                object = zzamb.zzN((byte[])byArray);
                zzsp.zze zze2 = new zzsp.zze();
                try {
                    zzsp.zze cfr_ignored_0 = (zzsp.zze)zze2.mergeFrom((zzamb)object);
                }
                catch (IOException iOException) {
                    this.zzFm().zzFE().zze("Failed to merge queued bundle", string, iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzsp.zze, Long>)Pair.create((Object)zze2, (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzsp.zze, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    public void zzae(long l) {
        this.zzkN();
        this.zzma();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(l)};
        int n = sQLiteDatabase.delete("queue", "rowid=?", stringArray);
        if (n != 1) {
            this.zzFm().zzFE().log("Deleted fewer rows from queue than expected");
        }
    }

    @WorkerThread
    void zzFq() {
        this.zzkN();
        this.zzma();
        if (!this.zzFv()) {
            return;
        }
        long l = this.zzFn().zzbdJ.get();
        long l2 = this.zzlQ().elapsedRealtime();
        if (Math.abs(l2 - l) > this.zzFo().zzEP()) {
            this.zzFn().zzbdJ.set(l2);
            this.zzFr();
        }
    }

    @WorkerThread
    void zzFr() {
        this.zzkN();
        this.zzma();
        if (!this.zzFv()) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(this.zzlQ().currentTimeMillis()), String.valueOf(this.zzFo().zzEO())};
        int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
        if (n > 0) {
            this.zzFm().zzFL().zzj("Deleted stale rows. rowsDeleted", n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, zzsn.zza[] zzaArray) {
        this.zzma();
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        com.google.android.gms.common.internal.zzaa.zzz((Object)zzaArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            this.zzfn(string);
            for (zzsn.zza zza2 : zzaArray) {
                this.zza(string, zza2);
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    void zzfn(String string) {
        this.zzma();
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=?", new String[]{string});
        sQLiteDatabase.delete("event_filters", "app_id=?", new String[]{string});
    }

    void zzz(String string, int n) {
        this.zzma();
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
        sQLiteDatabase.delete("event_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private void zza(String string, zzsn.zza zza2) {
        void var7_13;
        this.zzma();
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        com.google.android.gms.common.internal.zzaa.zzz((Object)zza2);
        com.google.android.gms.common.internal.zzaa.zzz((Object)zza2.zzbgk);
        com.google.android.gms.common.internal.zzaa.zzz((Object)zza2.zzbgj);
        if (zza2.zzbgi == null) {
            this.zzFm().zzFG().log("Audience with no ID");
            return;
        }
        int n = zza2.zzbgi;
        for (zzsn.zzb zzb2 : zza2.zzbgk) {
            if (zzb2.zzbgm != null) continue;
            this.zzFm().zzFG().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", string, zza2.zzbgi);
            return;
        }
        for (zzsn.zzb zzb2 : zza2.zzbgj) {
            if (zzb2.zzbgm != null) continue;
            this.zzFm().zzFG().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", string, zza2.zzbgi);
            return;
        }
        boolean bl = true;
        zzsn.zzb[] zzbArray = zza2.zzbgk;
        int n2 = zzbArray.length;
        boolean bl2 = false;
        while (var7_13 < n2) {
            zzsn.zzb zzb3 = zzbArray[var7_13];
            if (!this.zza(string, n, zzb3)) {
                bl = false;
                break;
            }
            ++var7_13;
        }
        if (bl) {
            void var7_15;
            zzbArray = zza2.zzbgj;
            n2 = zzbArray.length;
            boolean bl3 = false;
            while (var7_15 < n2) {
                zzsn.zzb zzb4 = zzbArray[var7_15];
                if (!this.zza(string, n, (zzsn.zze)zzb4)) {
                    bl = false;
                    break;
                }
                ++var7_15;
            }
        }
        if (!bl) {
            this.zzz(string, n);
        }
    }

    @WorkerThread
    private boolean zza(String string, int n, zzsn.zzb zzb2) {
        zzamc zzamc2;
        byte[] byArray;
        this.zzma();
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        com.google.android.gms.common.internal.zzaa.zzz((Object)zzb2);
        if (TextUtils.isEmpty((CharSequence)zzb2.zzbgn)) {
            this.zzFm().zzFG().zze("Event filter had no event name. Audience definition ignored. audienceId, filterId", n, String.valueOf(zzb2.zzbgm));
            return false;
        }
        try {
            int n2 = zzb2.getSerializedSize();
            byArray = new byte[n2];
            zzamc2 = zzamc.zzO((byte[])byArray);
            zzb2.writeTo(zzamc2);
            zzamc2.zzWU();
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Configuration loss. Failed to serialize event filter", iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.zzbgm);
        contentValues.put("event_name", zzb2.zzbgn);
        contentValues.put("data", byArray);
        try {
            zzamc2 = this.getWritableDatabase();
            long l = zzamc2.insertWithOnConflict("event_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzFm().zzFE().log("Failed to insert event filter (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Error storing event filter", (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private boolean zza(String string, int n, zzsn.zze zze2) {
        zzamc zzamc2;
        byte[] byArray;
        this.zzma();
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        com.google.android.gms.common.internal.zzaa.zzz((Object)zze2);
        if (TextUtils.isEmpty((CharSequence)zze2.zzbgC)) {
            this.zzFm().zzFG().zze("Property filter had no property name. Audience definition ignored. audienceId, filterId", n, String.valueOf(zze2.zzbgm));
            return false;
        }
        try {
            int n2 = zze2.getSerializedSize();
            byArray = new byte[n2];
            zzamc2 = zzamc.zzO((byte[])byArray);
            zze2.writeTo(zzamc2);
            zzamc2.zzWU();
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Configuration loss. Failed to serialize property filter", iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.zzbgm);
        contentValues.put("property_name", zze2.zzbgC);
        contentValues.put("data", byArray);
        try {
            zzamc2 = this.getWritableDatabase();
            long l = zzamc2.insertWithOnConflict("property_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzFm().zzFE().log("Failed to insert property filter (got -1)");
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Error storing property filter", (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzsn.zzb>> zzR(String string, String string2) {
        this.zzma();
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        com.google.android.gms.common.internal.zzaa.zzdl((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzsn.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzamb zzamb2 = zzamb.zzN((byte[])byArray);
                zzsn.zzb zzb2 = new zzsn.zzb();
                try {
                    zzsn.zzb cfr_ignored_0 = (zzsn.zzb)zzb2.mergeFrom(zzamb2);
                }
                catch (IOException iOException) {
                    this.zzFm().zzFE().zze("Failed to merge filter", string, iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzsn.zzb> arrayList = (ArrayList<zzsn.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzsn.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzsn.zze>> zzS(String string, String string2) {
        this.zzma();
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        com.google.android.gms.common.internal.zzaa.zzdl((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzsn.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzamb zzamb2 = zzamb.zzN((byte[])byArray);
                zzsn.zze zze2 = new zzsn.zze();
                try {
                    zzsn.zze cfr_ignored_0 = (zzsn.zze)zze2.mergeFrom(zzamb2);
                }
                catch (IOException iOException) {
                    this.zzFm().zzFE().zze("Failed to merge filter", string, iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzsn.zze> arrayList = (ArrayList<zzsn.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzsn.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    void zza(String string, int n, zzsp.zzf zzf2) {
        zzamc zzamc2;
        byte[] byArray;
        this.zzma();
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        com.google.android.gms.common.internal.zzaa.zzz((Object)zzf2);
        try {
            int n2 = zzf2.getSerializedSize();
            byArray = new byte[n2];
            zzamc2 = zzamc.zzO((byte[])byArray);
            zzf2.writeTo(zzamc2);
            zzamc2.zzWU();
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Configuration loss. Failed to serialize filter results", iOException);
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("current_results", byArray);
        try {
            zzamc2 = this.getWritableDatabase();
            long l = zzamc2.insertWithOnConflict("audience_filter_values", null, contentValues, 5);
            if (l == -1L) {
                this.zzFm().zzFE().log("Failed to insert filter results (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Error storing filter results", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, zzsp.zzf> zzfo(String string) {
        this.zzma();
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_4 = null;
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzamb zzamb2 = zzamb.zzN((byte[])byArray);
                zzsp.zzf zzf2 = new zzsp.zzf();
                try {
                    zzsp.zzf cfr_ignored_0 = (zzsp.zzf)zzf2.mergeFrom(zzamb2);
                }
                catch (IOException iOException) {
                    this.zzFm().zzFE().zzd("Failed to merge filter results. appId, audienceId, error", string, n, iOException);
                    continue;
                }
                arrayMap.put(n, zzf2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    void zzfp(String string) {
        this.zzma();
        this.zzkN();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = 0;
            String[] stringArray = new String[]{string};
            n = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("apps", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("event_filters", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("property_filters", "app_id=?", stringArray);
            if ((n += sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray)) > 0) {
                this.zzFm().zzFL().zze("Deleted application data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zze("Error deleting application data. appId, error", string, (Object)sQLiteException);
        }
    }

    @WorkerThread
    void zza(ContentValues contentValues, String string, Object object) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        com.google.android.gms.common.internal.zzaa.zzz((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
        } else if (object instanceof Long) {
            contentValues.put(string, (Long)object);
        } else if (object instanceof Double) {
            contentValues.put(string, (Double)object);
        } else {
            throw new IllegalArgumentException("Invalid value type");
        }
    }

    @WorkerThread
    @TargetApi(value=11)
    static int zza(Cursor cursor, int n) {
        int n2;
        if (Build.VERSION.SDK_INT >= 11) {
            return cursor.getType(n);
        }
        SQLiteCursor sQLiteCursor = (SQLiteCursor)cursor;
        CursorWindow cursorWindow = sQLiteCursor.getWindow();
        if (cursorWindow.isNull(n2 = cursor.getPosition(), n)) {
            return 0;
        }
        if (cursorWindow.isLong(n2, n)) {
            return 1;
        }
        if (cursorWindow.isFloat(n2, n)) {
            return 2;
        }
        if (cursorWindow.isString(n2, n)) {
            return 3;
        }
        if (cursorWindow.isBlob(n2, n)) {
            return 4;
        }
        return -1;
    }

    @WorkerThread
    Object zzb(Cursor cursor, int n) {
        int n2 = zze.zza(cursor, n);
        switch (n2) {
            case 0: {
                this.zzFm().zzFE().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzFm().zzFE().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzFm().zzFE().zzj("Loaded invalid unknown value type, ignoring it", n2);
        return null;
    }

    @WorkerThread
    public long zzFs() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    public long zzFt() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public long zzb(zzsp.zze zze2) throws IOException {
        byte[] byArray;
        this.zzkN();
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzz((Object)zze2);
        com.google.android.gms.common.internal.zzaa.zzdl((String)zze2.appId);
        try {
            int n = zze2.getSerializedSize();
            byArray = new byte[n];
            zzamc zzamc2 = zzamc.zzO((byte[])byArray);
            zze2.writeTo(zzamc2);
            zzamc2.zzWU();
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Data loss. Failed to serialize event metadata", iOException);
            throw iOException;
        }
        long l = this.zzFi().zzt(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.appId);
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Error storing raw event metadata", (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    public boolean zzFu() {
        long l = this.zzb("select count(1) > 0 from raw_events", (String[])null);
        return l != 0L;
    }

    public void zzC(List<Long> list) {
        com.google.android.gms.common.internal.zzaa.zzz(list);
        this.zzkN();
        this.zzma();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzFm().zzFE().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public void zzfq(String string) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string, string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Failed to remove unused event metadata", (Object)sQLiteException);
        }
    }

    public long zzfr(String string) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzaf(long l) {
        this.zzkN();
        this.zzma();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzFm().zzFL().log("No expired configs for apps with pending events");
                Object var5_5 = null;
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string, long l, zzb zzb2) {
        com.google.android.gms.common.internal.zzaa.zzz((Object)zzb2);
        this.zzkN();
        this.zzma();
        try (Cursor cursor = null;){
            String string2;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if (TextUtils.isEmpty((CharSequence)string)) {
                cursor = sQLiteDatabase.rawQuery("select app_id, metadata_fingerprint from raw_events where app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", new String[]{String.valueOf(l)});
                if (!cursor.moveToFirst()) {
                    return;
                }
                string = cursor.getString(0);
                string2 = cursor.getString(1);
                cursor.close();
            } else {
                cursor = sQLiteDatabase.rawQuery("select metadata_fingerprint from raw_events where app_id = ? order by rowid limit 1;", new String[]{string});
                if (!cursor.moveToFirst()) {
                    return;
                }
                string2 = cursor.getString(0);
                cursor.close();
            }
            cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id=? and metadata_fingerprint=?", new String[]{string, string2}, null, null, "rowid", "2");
            if (!cursor.moveToFirst()) {
                this.zzFm().zzFE().log("Raw event metadata record is missing");
                return;
            }
            byte[] byArray = cursor.getBlob(0);
            zzamb zzamb2 = zzamb.zzN((byte[])byArray);
            zzsp.zze zze2 = new zzsp.zze();
            try {
                zzsp.zze cfr_ignored_0 = (zzsp.zze)zze2.mergeFrom(zzamb2);
            }
            catch (IOException iOException) {
                this.zzFm().zzFE().zze("Data loss. Failed to merge raw event metadata", string, iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return;
            }
            if (cursor.moveToNext()) {
                this.zzFm().zzFG().log("Get multiple raw event metadata records, expected one");
            }
            cursor.close();
            zzb2.zzc(zze2);
            cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, "app_id=? and metadata_fingerprint=?", new String[]{string, string2}, null, null, "rowid", null);
            if (!cursor.moveToFirst()) {
                this.zzFm().zzFG().log("Raw event data disappeared while in transaction");
                return;
            }
            do {
                long l2 = cursor.getLong(0);
                byArray = cursor.getBlob(3);
                zzamb2 = zzamb.zzN((byte[])byArray);
                zzsp.zzb zzb3 = new zzsp.zzb();
                try {
                    zzsp.zzb cfr_ignored_1 = (zzsp.zzb)zzb3.mergeFrom(zzamb2);
                }
                catch (IOException iOException) {
                    this.zzFm().zzFE().zze("Data loss. Failed to merge raw event", string, iOException);
                    continue;
                }
                zzb3.name = cursor.getString(1);
                zzb3.zzbgX = cursor.getLong(2);
                if (zzb2.zza(l2, zzb3)) continue;
                return;
            } while (cursor.moveToNext());
        }
    }

    public void zza(zzh zzh2, long l) {
        Object object;
        zzsp.zzc zzc2;
        this.zzkN();
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzz((Object)zzh2);
        com.google.android.gms.common.internal.zzaa.zzdl((String)zzh2.zzPx);
        zzsp.zzb zzb2 = new zzsp.zzb();
        zzb2.zzbgY = zzh2.zzbci;
        zzb2.zzbgW = new zzsp.zzc[zzh2.zzbcj.size()];
        int n = 0;
        for (String string : zzh2.zzbcj) {
            zzc2 = new zzsp.zzc();
            zzb2.zzbgW[n++] = zzc2;
            zzc2.name = string;
            Object object2 = zzh2.zzbcj.get(string);
            this.zzFi().zza(zzc2, object2);
        }
        try {
            int n2 = zzb2.getSerializedSize();
            object = new byte[n2];
            zzc2 = zzamc.zzO((byte[])object);
            zzb2.writeTo((zzamc)zzc2);
            zzc2.zzWU();
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Data loss. Failed to serialize event params/data", iOException);
            return;
        }
        this.zzFm().zzFL().zze("Saving event, name, data size", zzh2.mName, ((Object)object).length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzh2.zzPx);
        contentValues.put("name", zzh2.mName);
        contentValues.put("timestamp", Long.valueOf(zzh2.zzajg));
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("data", (byte[])object);
        try {
            zzc2 = this.getWritableDatabase();
            long l2 = zzc2.insert("raw_events", null, contentValues);
            if (l2 == -1L) {
                this.zzFm().zzFE().log("Failed to insert raw event (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzFm().zzFE().zzj("Error storing raw event", (Object)sQLiteException);
        }
    }

    private boolean zzFv() {
        return this.getContext().getDatabasePath(this.zzmv()).exists();
    }

    static {
        zzbbU.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        zzbbU.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        zzbbU.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        zzbbU.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        zzbbU.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        zzbbU.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        zzbbU.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        zzbbU.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        zzbbU.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        zzbbU.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        zzbbU.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        zzbbU.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        zzbbU.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
        zzbbU.put("app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;");
        zzbbU.put("firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;");
        zzbbU.put("daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;");
    }

    private class zzc
    extends SQLiteOpenHelper {
        zzc(Context context, String string) {
            super(context, string, null, 1);
        }

        @WorkerThread
        public SQLiteDatabase getWritableDatabase() {
            if (!zze.this.zzbbW.zzx(zze.this.zzFo().zzEJ())) {
                throw new SQLiteException("Database open failed");
            }
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zze.this.zzbbW.start();
                zze.this.zzFm().zzFE().log("Opening the database failed, dropping and recreating it");
                String string = zze.this.zzmv();
                zze.this.getContext().getDatabasePath(string).delete();
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zze.this.zzbbW.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zze.this.zzFm().zzFE().zzj("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
            try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
                Collections.addAll(hashSet, cursor.getColumnNames());
            }
            return hashSet;
        }

        @WorkerThread
        private void zza(SQLiteDatabase sQLiteDatabase, String string, String string2, Map<String, String> map) throws SQLiteException {
            Set<String> set = this.zzb(sQLiteDatabase, string);
            for (String string3 : string2.split(",")) {
                if (set.remove(string3)) continue;
                throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
            }
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    if (set.remove(entry.getKey())) continue;
                    sQLiteDatabase.execSQL((String)entry.getValue());
                }
            }
            if (!set.isEmpty()) {
                throw new SQLiteException(new StringBuilder(30 + String.valueOf(string).length()).append("Table ").append(string).append(" table has extra columns").toString());
            }
        }

        @WorkerThread
        private void zza(SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, Map<String, String> map) throws SQLiteException {
            if (!this.zza(sQLiteDatabase, string)) {
                sQLiteDatabase.execSQL(string2);
            }
            try {
                this.zza(sQLiteDatabase, string, string3, map);
            }
            catch (SQLiteException sQLiteException) {
                zze.this.zzFm().zzFE().zzj("Failed to verify columns on table that was just created", string);
                throw sQLiteException;
            }
        }

        @WorkerThread
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            this.zza(sQLiteDatabase, "events", "CREATE TABLE IF NOT EXISTS events ( app_id TEXT NOT NULL, name TEXT NOT NULL, lifetime_count INTEGER NOT NULL, current_bundle_count INTEGER NOT NULL, last_fire_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,lifetime_count,current_bundle_count,last_fire_timestamp", null);
            this.zza(sQLiteDatabase, "user_attributes", "CREATE TABLE IF NOT EXISTS user_attributes ( app_id TEXT NOT NULL, name TEXT NOT NULL, set_timestamp INTEGER NOT NULL, value BLOB NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,set_timestamp,value", null);
            this.zza(sQLiteDatabase, "apps", "CREATE TABLE IF NOT EXISTS apps ( app_id TEXT NOT NULL, app_instance_id TEXT, gmp_app_id TEXT, resettable_device_id_hash TEXT, last_bundle_index INTEGER NOT NULL, last_bundle_end_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id)) ;", "app_id,app_instance_id,gmp_app_id,resettable_device_id_hash,last_bundle_index,last_bundle_end_timestamp", zzbbU);
            this.zza(sQLiteDatabase, "queue", "CREATE TABLE IF NOT EXISTS queue ( app_id TEXT NOT NULL, bundle_end_timestamp INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,bundle_end_timestamp,data", null);
            this.zza(sQLiteDatabase, "raw_events_metadata", "CREATE TABLE IF NOT EXISTS raw_events_metadata ( app_id TEXT NOT NULL, metadata_fingerprint INTEGER NOT NULL, metadata BLOB NOT NULL, PRIMARY KEY (app_id, metadata_fingerprint));", "app_id,metadata_fingerprint,metadata", null);
            this.zza(sQLiteDatabase, "raw_events", "CREATE TABLE IF NOT EXISTS raw_events ( app_id TEXT NOT NULL, name TEXT NOT NULL, timestamp INTEGER NOT NULL, metadata_fingerprint INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,name,timestamp,metadata_fingerprint,data", null);
            this.zza(sQLiteDatabase, "event_filters", "CREATE TABLE IF NOT EXISTS event_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, event_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, event_name, audience_id, filter_id));", "app_id,audience_id,filter_id,event_name,data", null);
            this.zza(sQLiteDatabase, "property_filters", "CREATE TABLE IF NOT EXISTS property_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, property_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, property_name, audience_id, filter_id));", "app_id,audience_id,filter_id,property_name,data", null);
            this.zza(sQLiteDatabase, "audience_filter_values", "CREATE TABLE IF NOT EXISTS audience_filter_values ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, current_results BLOB, PRIMARY KEY (app_id, audience_id));", "app_id,audience_id,current_results", null);
        }

        @WorkerThread
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT >= 9) {
                File file = new File(sQLiteDatabase.getPath());
                file.setReadable(false, false);
                file.setWritable(false, false);
                file.setReadable(true, true);
                file.setWritable(true, true);
            }
        }

        @WorkerThread
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }

    static interface zzb {
        public void zzc(zzsp.zze var1);

        public boolean zza(long var1, zzsp.zzb var3);
    }

    public static class zza {
        long zzbbX;
        long zzbbY;
        long zzbbZ;
        long zzbca;
    }
}

