/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.common.zzc;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class zzad
extends zzaa {
    private final zza alO;
    private zzm alP;
    private Boolean alQ;
    private final zzf alR;
    private final zzah alS;
    private final List<Runnable> alT = new ArrayList<Runnable>();
    private final zzf alU;

    protected zzad(zzx zzx2) {
        super(zzx2);
        this.alS = new zzah(zzx2.zzyw());
        this.alO = new zza();
        this.alR = new zzf(zzx2){

            @Override
            public void run() {
                zzad.this.zzzu();
            }
        };
        this.alU = new zzf(zzx2){

            @Override
            public void run() {
                zzad.this.zzbsd().zzbsx().log("Tasks have been queued for a long time");
            }
        };
    }

    @Override
    protected void zzwv() {
    }

    @WorkerThread
    public boolean isConnected() {
        this.zzwu();
        this.zzzg();
        return this.alP != null;
    }

    @WorkerThread
    protected void zzbur() {
        this.zzwu();
        this.zzzg();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.alP;
                if (zzm2 == null) {
                    zzad.this.zzbsd().zzbsv().log("Failed to send measurementEnabled to service");
                    return;
                }
                try {
                    zzm2.zzb(zzad.this.zzbrv().zzlv(zzad.this.zzbsd().zzbtd()));
                    zzad.this.zzzt();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbsd().zzbsv().zzj("Failed to send measurementEnabled to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zzc(final EventParcel eventParcel, final String string) {
        zzab.zzy((Object)((Object)eventParcel));
        this.zzwu();
        this.zzzg();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.alP;
                if (zzm2 == null) {
                    zzad.this.zzbsd().zzbsv().log("Discarding data. Failed to send event to service");
                    return;
                }
                try {
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        zzm2.zza(eventParcel, zzad.this.zzbrv().zzlv(zzad.this.zzbsd().zzbtd()));
                    } else {
                        zzm2.zza(eventParcel, string, zzad.this.zzbsd().zzbtd());
                    }
                    zzad.this.zzzt();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbsd().zzbsv().zzj("Failed to send event to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final UserAttributeParcel userAttributeParcel) {
        this.zzwu();
        this.zzzg();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.alP;
                if (zzm2 == null) {
                    zzad.this.zzbsd().zzbsv().log("Discarding data. Failed to set user attribute");
                    return;
                }
                try {
                    zzm2.zza(userAttributeParcel, zzad.this.zzbrv().zzlv(zzad.this.zzbsd().zzbtd()));
                    zzad.this.zzzt();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbsd().zzbsv().zzj("Failed to send attribute to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<UserAttributeParcel>> atomicReference, final boolean bl) {
        this.zzwu();
        this.zzzg();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzm zzm2 = zzad.this.alP;
                        if (zzm2 == null) {
                            zzad.this.zzbsd().zzbsv().log("Failed to get user properties");
                            return;
                        }
                        atomicReference.set(zzm2.zza(zzad.this.zzbrv().zzlv(null), bl));
                        zzad.this.zzzt();
                    }
                    catch (RemoteException remoteException) {
                        zzad.this.zzbsd().zzbsv().zzj("Failed to get user properties", (Object)remoteException);
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zzbuo() {
        this.zzwu();
        this.zzzg();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.alP;
                if (zzm2 == null) {
                    zzad.this.zzbsd().zzbsv().log("Discarding data. Failed to send app launch");
                    return;
                }
                try {
                    zzm2.zza(zzad.this.zzbrv().zzlv(zzad.this.zzbsd().zzbtd()));
                    zzad.this.zzzt();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbsd().zzbsv().zzj("Failed to send app launch to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    private void zzzt() {
        this.zzwu();
        this.alS.start();
        if (!this.ahD.zzbty()) {
            this.alR.zzv(this.zzbsf().zzabx());
        }
    }

    @WorkerThread
    void zzaai() {
        this.zzwu();
        this.zzzg();
        if (this.isConnected()) {
            return;
        }
        if (this.alQ == null) {
            this.alQ = this.zzbse().zzbtj();
            if (this.alQ == null) {
                this.zzbsd().zzbtc().log("State of service unknown");
                this.alQ = this.zzbut();
                this.zzbse().zzcb(this.alQ);
            }
        }
        if (this.alQ.booleanValue()) {
            this.zzbsd().zzbtc().log("Using measurement service");
            this.alO.zzbuw();
        } else {
            if (!this.ahD.zzbty() && this.zzbus()) {
                this.zzbsd().zzbtc().log("Using local app measurement service");
                Intent intent = new Intent("com.google.android.gms.measurement.START");
                intent.setComponent(new ComponentName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.alO.zzy(intent);
                return;
            }
            if (this.zzbsf().zzabd()) {
                this.zzbsd().zzbtc().log("Using direct local measurement implementation");
                this.zza(new zzy(this.ahD, true));
            } else {
                this.zzbsd().zzbsv().log("Not in main process. Unable to use local measurement implementation. Please register the AppMeasurementService service in the app manifest");
            }
        }
    }

    private boolean zzbus() {
        Intent intent;
        PackageManager packageManager = this.getContext().getPackageManager();
        List list = packageManager.queryIntentServices(intent = new Intent().setClassName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
        return list != null && list.size() > 0;
    }

    @WorkerThread
    protected boolean zzbut() {
        this.zzwu();
        this.zzzg();
        if (this.zzbsf().zzabc()) {
            return true;
        }
        this.zzbsd().zzbtc().log("Checking service availability");
        int n = zzc.zzang().isGooglePlayServicesAvailable(this.getContext());
        switch (n) {
            case 0: {
                this.zzbsd().zzbtc().log("Service available");
                return true;
            }
            case 1: {
                this.zzbsd().zzbtc().log("Service missing");
                return false;
            }
            case 18: {
                this.zzbsd().zzbsx().log("Service updating");
                return true;
            }
            case 2: {
                this.zzbsd().zzbtb().log("Service container out of date");
                return true;
            }
            case 3: {
                this.zzbsd().zzbsx().log("Service disabled");
                return false;
            }
            case 9: {
                this.zzbsd().zzbsx().log("Service invalid");
                return false;
            }
        }
        return false;
    }

    @WorkerThread
    private void zza(zzm zzm2) {
        this.zzwu();
        zzab.zzy((Object)zzm2);
        this.alP = zzm2;
        this.zzzt();
        this.zzbuv();
    }

    @WorkerThread
    public void disconnect() {
        this.zzwu();
        this.zzzg();
        try {
            zzb zzb2 = zzb.zzaux();
            zzb2.zza(this.getContext(), (ServiceConnection)this.alO);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
        this.alP = null;
    }

    @WorkerThread
    private void onServiceDisconnected(ComponentName componentName) {
        this.zzwu();
        if (this.alP != null) {
            this.alP = null;
            this.zzbsd().zzbtc().zzj("Disconnected from device MeasurementService", componentName);
            this.zzbuu();
        }
    }

    @WorkerThread
    private void zzzu() {
        this.zzwu();
        if (!this.isConnected()) {
            return;
        }
        this.zzbsd().zzbtc().log("Inactivity, disconnecting from AppMeasurementService");
        this.disconnect();
    }

    @WorkerThread
    private void zzbuu() {
        this.zzwu();
        this.zzaai();
    }

    @WorkerThread
    private void zzo(Runnable runnable) throws IllegalStateException {
        this.zzwu();
        if (this.isConnected()) {
            runnable.run();
        } else {
            if ((long)this.alT.size() >= this.zzbsf().zzbrh()) {
                this.zzbsd().zzbsv().log("Discarding data. Max runnable queue size reached");
                return;
            }
            this.alT.add(runnable);
            if (!this.ahD.zzbty()) {
                this.alU.zzv(60000L);
            }
            this.zzaai();
        }
    }

    @WorkerThread
    private void zzbuv() {
        this.zzwu();
        this.zzbsd().zzbtc().zzj("Processing queued up service tasks", this.alT.size());
        for (Runnable runnable : this.alT) {
            this.zzbsc().zzm(runnable);
        }
        this.alT.clear();
        this.alU.cancel();
    }

    protected class zza
    implements ServiceConnection,
    zzd.zzb,
    zzd.zzc {
        private volatile boolean alX;
        private volatile zzo alY;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzy(Intent intent) {
            zzad.this.zzwu();
            Context context = zzad.this.getContext();
            zzb zzb2 = zzb.zzaux();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.alX) {
                    zzad.this.zzbsd().zzbtc().log("Connection attempt already in progress");
                    return;
                }
                this.alX = true;
                zzb2.zza(context, intent, (ServiceConnection)zzad.this.alO, 129);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzab.zzhi((String)"MeasurementServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                Object object;
                if (iBinder == null) {
                    this.alX = false;
                    zzad.this.zzbsd().zzbsv().log("Service connected with null binder");
                    return;
                }
                zzm zzm2 = null;
                try {
                    object = iBinder.getInterfaceDescriptor();
                    if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(object)) {
                        zzm2 = zzm.zza.zzjf(iBinder);
                        zzad.this.zzbsd().zzbtc().log("Bound to IMeasurementService interface");
                    } else {
                        zzad.this.zzbsd().zzbsv().zzj("Got binder with a wrong descriptor", object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbsd().zzbsv().log("Service connect failed to get IMeasurementService");
                }
                if (zzm2 == null) {
                    this.alX = false;
                    try {
                        zzb.zzaux().zza(zzad.this.getContext(), (ServiceConnection)zzad.this.alO);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    object = zzm2;
                    zzad.this.zzbsc().zzm(new Runnable((zzm)object){
                        final /* synthetic */ zzm alZ;
                        {
                            this.alZ = zzm2;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.alX = false;
                                if (!zzad.this.isConnected()) {
                                    zzad.this.zzbsd().zzbtc().log("Connected to service");
                                    zzad.this.zza(this.alZ);
                                }
                            }
                        }
                    });
                }
            }
        }

        @MainThread
        public void onServiceDisconnected(final ComponentName componentName) {
            zzab.zzhi((String)"MeasurementServiceConnection.onServiceDisconnected");
            zzad.this.zzbsd().zzbtb().log("Service disconnected");
            zzad.this.zzbsc().zzm(new Runnable(){

                @Override
                public void run() {
                    zzad.this.onServiceDisconnected(componentName);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzbuw() {
            zzad.this.zzwu();
            Context context = zzad.this.getContext();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.alX) {
                    zzad.this.zzbsd().zzbtc().log("Connection attempt already in progress");
                    return;
                }
                if (this.alY != null) {
                    zzad.this.zzbsd().zzbtc().log("Already awaiting connection attempt");
                    return;
                }
                this.alY = new zzo(context, Looper.getMainLooper(), this, this);
                zzad.this.zzbsd().zzbtc().log("Connecting to remote service");
                this.alX = true;
                this.alY.zzarx();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnected(@Nullable Bundle bundle) {
            zzab.zzhi((String)"MeasurementServiceConnection.onConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    final zzm zzm2 = (zzm)this.alY.zzasa();
                    this.alY = null;
                    zzad.this.zzbsc().zzm(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.alX = false;
                                if (!zzad.this.isConnected()) {
                                    zzad.this.zzbsd().zzbtb().log("Connected to remote service");
                                    zzad.this.zza(zzm2);
                                }
                            }
                        }
                    });
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    this.alY = null;
                    this.alX = false;
                }
            }
        }

        @MainThread
        public void onConnectionSuspended(int n) {
            zzab.zzhi((String)"MeasurementServiceConnection.onConnectionSuspended");
            zzad.this.zzbsd().zzbtb().log("Service connection suspended");
            zzad.this.zzbsc().zzm(new Runnable(){

                @Override
                public void run() {
                    zzad.this.onServiceDisconnected(new ComponentName(zzad.this.getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzab.zzhi((String)"MeasurementServiceConnection.onConnectionFailed");
            zzp zzp2 = zzad.this.ahD.zzbtp();
            if (zzp2 != null) {
                zzp2.zzbsx().zzj("Service connection failed", connectionResult);
            }
            zza zza2 = this;
            synchronized (zza2) {
                this.alX = false;
                this.alY = null;
            }
        }
    }
}

