/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzapn;
import com.google.android.gms.internal.zzapo;
import com.google.android.gms.internal.zzuf;
import com.google.android.gms.internal.zzuh;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzx;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zze
extends zzaa {
    private static final Map<String, String> aim = new ArrayMap(16);
    private final zzc ain;
    private final zzah aio = new zzah(this.zzyw());

    zze(zzx zzx2) {
        super(zzx2);
        String string = this.zzaab();
        this.ain = new zzc(this.getContext(), string);
    }

    @Override
    protected void zzwv() {
    }

    @WorkerThread
    public void beginTransaction() {
        this.zzzg();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public void setTransactionSuccessful() {
        this.zzzg();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public void endTransaction() {
        this.zzzg();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzbsd().zzbsv().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            long l3 = l;
            return l;
        }
    }

    @WorkerThread
    SQLiteDatabase getWritableDatabase() {
        this.zzwu();
        try {
            return this.ain.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsx().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    String zzaab() {
        if (!this.zzbsf().zzabc()) {
            return this.zzbsf().zzacc();
        }
        if (this.zzbsf().zzabd()) {
            return this.zzbsf().zzacc();
        }
        this.zzbsd().zzbsy().log("Using secondary database");
        return this.zzbsf().zzacd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzi zzaq(String string, String string2) {
        zzab.zzhr((String)string);
        zzab.zzhr((String)string2);
        this.zzwu();
        this.zzzg();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var5_6 = null;
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzi zzi2 = new zzi(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzbsd().zzbsv().log("Got multiple records for event aggregates, expected one");
            }
            zzi zzi3 = zzi2;
            return zzi3;
        }
    }

    @WorkerThread
    public void zza(zzi zzi2) {
        zzab.zzy((Object)zzi2);
        this.zzwu();
        this.zzzg();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzi2.zzcjf);
        contentValues.put("name", zzi2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzi2.aiC));
        contentValues.put("current_bundle_count", Long.valueOf(zzi2.aiD));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzi2.aiE));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("events", null, contentValues, 5);
            if (l == -1L) {
                this.zzbsd().zzbsv().log("Failed to insert/update event aggregates (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Error storing event aggregates", (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzar(String string, String string2) {
        zzab.zzhr((String)string);
        zzab.zzhr((String)string2);
        this.zzwu();
        this.zzzg();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = sQLiteDatabase.delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzbsd().zzbtc().zzj("Deleted user attribute rows:", n);
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzd("Error deleting user attribute", string, string2, (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzy(String string, int n) {
        zzab.zzhr((String)string);
        this.zzwu();
        this.zzzg();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string, string, String.valueOf(n)});
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zze("Error pruning currencies", string, (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public boolean zza(zzak zzak2) {
        long l;
        zzab.zzy((Object)zzak2);
        this.zzwu();
        this.zzzg();
        zzak zzak3 = this.zzas(zzak2.zzcjf, zzak2.mName);
        if (zzak3 == null && (zzal.zzmj(zzak2.mName) ? (l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzak2.zzcjf})) >= (long)this.zzbsf().zzbqy() : (l = this.zzb("select count(1) from user_attributes where app_id=?", new String[]{zzak2.zzcjf})) >= (long)this.zzbsf().zzbqz())) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzak2.zzcjf);
        contentValues.put("name", zzak2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzak2.amx));
        this.zza(contentValues, "value", zzak2.zzcnn);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l2 = sQLiteDatabase.insertWithOnConflict("user_attributes", null, contentValues, 5);
            if (l2 == -1L) {
                this.zzbsd().zzbsv().log("Failed to insert/update user property (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Error storing user property", (Object)sQLiteException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzak zzas(String string, String string2) {
        zzab.zzhr((String)string);
        zzab.zzhr((String)string2);
        this.zzwu();
        this.zzzg();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"set_timestamp", "value"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var5_6 = null;
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zzb(cursor, 1);
            zzak zzak2 = new zzak(string, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzbsd().zzbsv().log("Got multiple records for user property, expected one");
            }
            zzak zzak3 = zzak2;
            return zzak3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<zzak> zzlm(String string) {
        zzab.zzhr((String)string);
        this.zzwu();
        this.zzzg();
        ArrayList<zzak> arrayList = new ArrayList<zzak>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"name", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(this.zzbsf().zzbqz()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzak> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zzb(cursor, 2);
                if (object2 == null) {
                    this.zzbsd().zzbsv().log("Read invalid user property value, ignoring it");
                    continue;
                }
                zzak zzak2 = new zzak(string, (String)object, l, object2);
                arrayList.add(zzak2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public com.google.android.gms.measurement.internal.zza zzln(String string) {
        zzab.zzhr((String)string);
        this.zzwu();
        this.zzzg();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_5 = null;
                return null;
            }
            com.google.android.gms.measurement.internal.zza zza2 = new com.google.android.gms.measurement.internal.zza(this.ahD, string);
            zza2.zzky(cursor.getString(0));
            zza2.zzkz(cursor.getString(1));
            zza2.zzla(cursor.getString(2));
            zza2.zzaz(cursor.getLong(3));
            zza2.zzau(cursor.getLong(4));
            zza2.zzav(cursor.getLong(5));
            zza2.setAppVersion(cursor.getString(6));
            zza2.zzlc(cursor.getString(7));
            zza2.zzax(cursor.getLong(8));
            zza2.zzay(cursor.getLong(9));
            zza2.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zza2.zzbc(cursor.getLong(11));
            zza2.zzbd(cursor.getLong(12));
            zza2.zzbe(cursor.getLong(13));
            zza2.zzbf(cursor.getLong(14));
            zza2.zzba(cursor.getLong(15));
            zza2.zzbb(cursor.getLong(16));
            zza2.zzaw(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zza2.zzlb(cursor.getString(18));
            zza2.zzbg(cursor.getLong(19));
            zza2.zzbpr();
            if (cursor.moveToNext()) {
                this.zzbsd().zzbsv().log("Got multiple records for app, expected one");
            }
            com.google.android.gms.measurement.internal.zza zza3 = zza2;
            return zza3;
        }
    }

    @WorkerThread
    public void zza(com.google.android.gms.measurement.internal.zza zza2) {
        zzab.zzy((Object)zza2);
        this.zzwu();
        this.zzzg();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zza2.zzsh());
        contentValues.put("app_instance_id", zza2.zzawo());
        contentValues.put("gmp_app_id", zza2.zzbps());
        contentValues.put("resettable_device_id_hash", zza2.zzbpt());
        contentValues.put("last_bundle_index", Long.valueOf(zza2.zzbqc()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zza2.zzbpv()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zza2.zzbpw()));
        contentValues.put("app_version", zza2.zzxc());
        contentValues.put("app_store", zza2.zzbpy());
        contentValues.put("gmp_version", Long.valueOf(zza2.zzbpz()));
        contentValues.put("dev_cert_hash", Long.valueOf(zza2.zzbqa()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zza2.zzbqb()));
        contentValues.put("day", Long.valueOf(zza2.zzbqg()));
        contentValues.put("daily_public_events_count", Long.valueOf(zza2.zzbqh()));
        contentValues.put("daily_events_count", Long.valueOf(zza2.zzbqi()));
        contentValues.put("daily_conversions_count", Long.valueOf(zza2.zzbqj()));
        contentValues.put("config_fetched_time", Long.valueOf(zza2.zzbqd()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zza2.zzbqe()));
        contentValues.put("app_version_int", Long.valueOf(zza2.zzbpx()));
        contentValues.put("firebase_instance_id", zza2.zzbpu());
        contentValues.put("daily_error_events_count", Long.valueOf(zza2.zzbqk()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5);
            if (l == -1L) {
                this.zzbsd().zzbsv().log("Failed to insert/update app (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Error storing app", (Object)sQLiteException);
        }
    }

    public long zzlo(String string) {
        zzab.zzhr((String)string);
        this.zzwu();
        this.zzzg();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = String.valueOf(this.zzbsf().zzll(string));
            long l = sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string2});
            return l;
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Error deleting over the limit events", (Object)sQLiteException);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zza zza(long l, String string, boolean bl, boolean bl2, boolean bl3) {
        zzab.zzhr((String)string);
        this.zzwu();
        this.zzzg();
        String[] stringArray = new String[]{string};
        zza zza2 = new zza();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzbsd().zzbsx().zzj("Not updating daily counts, app is not known", string);
                zza zza3 = zza2;
                return zza3;
            }
            long l2 = cursor.getLong(0);
            if (l2 == l) {
                zza2.aiq = cursor.getLong(1);
                zza2.aip = cursor.getLong(2);
                zza2.air = cursor.getLong(3);
                zza2.ais = cursor.getLong(4);
            }
            ++zza2.aiq;
            if (bl) {
                ++zza2.aip;
            }
            if (bl2) {
                ++zza2.air;
            }
            if (bl3) {
                ++zza2.ais;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zza2.aip));
            contentValues.put("daily_events_count", Long.valueOf(zza2.aiq));
            contentValues.put("daily_conversions_count", Long.valueOf(zza2.air));
            contentValues.put("daily_error_events_count", Long.valueOf(zza2.ais));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zza zza4 = zza2;
            return zza4;
        }
    }

    @WorkerThread
    public void zzd(String string, byte[] byArray) {
        zzab.zzhr((String)string);
        this.zzwu();
        this.zzzg();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{string});
            if (l == 0L) {
                this.zzbsd().zzbsv().log("Failed to update remote config (got 0)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Error storing remote config", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zzlp(String string) {
        zzab.zzhr((String)string);
        this.zzwu();
        this.zzzg();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_5 = null;
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzbsd().zzbsv().log("Got multiple records for app config, expected one");
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public void zza(zzuh.zze zze2) {
        byte[] byArray;
        Object object;
        this.zzwu();
        this.zzzg();
        zzab.zzy((Object)zze2);
        zzab.zzhr((String)zze2.zzck);
        zzab.zzy((Object)zze2.anz);
        this.zzbsh();
        long l = this.zzyw().currentTimeMillis();
        if (zze2.anz < l - this.zzbsf().zzbrf() || zze2.anz > l + this.zzbsf().zzbrf()) {
            this.zzbsd().zzbsx().zze("Storing bundle outside of the max uploading time span. now, timestamp", l, zze2.anz);
        }
        try {
            int n = zze2.aM();
            object = new byte[n];
            zzapo zzapo2 = zzapo.zzbe((byte[])object);
            zze2.zza(zzapo2);
            zzapo2.az();
            byArray = this.zzbrz().zzj((byte[])object);
        }
        catch (IOException iOException) {
            this.zzbsd().zzbsv().zzj("Data loss. Failed to serialize bundle", iOException);
            return;
        }
        this.zzbsd().zzbtc().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.zzck);
        contentValues.put("bundle_end_timestamp", zze2.anz);
        contentValues.put("data", byArray);
        try {
            object = this.getWritableDatabase();
            long l2 = object.insert("queue", null, contentValues);
            if (l2 == -1L) {
                this.zzbsd().zzbsv().log("Failed to insert bundle (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Error storing bundle", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public String zzbsg() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue where app_id not in (select app_id from apps where measurement_enabled=0) order by rowid limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            Object var4_6 = null;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<Pair<zzuh.zze, Long>> zzn(String string, int n, int n2) {
        this.zzwu();
        this.zzzg();
        zzab.zzbo((n > 0 ? 1 : 0) != 0);
        zzab.zzbo((n2 > 0 ? 1 : 0) != 0);
        zzab.zzhr((String)string);
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzuh.zze, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzuh.zze, Long>> arrayList = new ArrayList<Pair<zzuh.zze, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzbrz().zzw((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzbsd().zzbsv().zze("Failed to unzip queued bundle", string, iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                object = zzapn.zzbd((byte[])byArray);
                zzuh.zze zze2 = new zzuh.zze();
                try {
                    zzuh.zze cfr_ignored_0 = (zzuh.zze)zze2.zzb((zzapn)object);
                }
                catch (IOException iOException) {
                    this.zzbsd().zzbsv().zze("Failed to merge queued bundle", string, iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzuh.zze, Long>)Pair.create((Object)zze2, (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzuh.zze, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    public void zzbh(long l) {
        this.zzwu();
        this.zzzg();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(l)};
        int n = sQLiteDatabase.delete("queue", "rowid=?", stringArray);
        if (n != 1) {
            this.zzbsd().zzbsv().log("Deleted fewer rows from queue than expected");
        }
    }

    @WorkerThread
    void zzbsh() {
        this.zzwu();
        this.zzzg();
        if (!this.zzbsm()) {
            return;
        }
        long l = this.zzbse().akb.get();
        long l2 = this.zzyw().elapsedRealtime();
        if (Math.abs(l2 - l) > this.zzbsf().zzbrg()) {
            this.zzbse().akb.set(l2);
            this.zzbsi();
        }
    }

    @WorkerThread
    void zzbsi() {
        this.zzwu();
        this.zzzg();
        if (!this.zzbsm()) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(this.zzyw().currentTimeMillis()), String.valueOf(this.zzbsf().zzbrf())};
        int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
        if (n > 0) {
            this.zzbsd().zzbtc().zzj("Deleted stale rows. rowsDeleted", n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, zzuf.zza[] zzaArray) {
        this.zzzg();
        this.zzwu();
        zzab.zzhr((String)string);
        zzab.zzy((Object)zzaArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            this.zzlq(string);
            for (zzuf.zza zza2 : zzaArray) {
                this.zza(string, zza2);
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    void zzlq(String string) {
        this.zzzg();
        this.zzwu();
        zzab.zzhr((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=?", new String[]{string});
        sQLiteDatabase.delete("event_filters", "app_id=?", new String[]{string});
    }

    void zzz(String string, int n) {
        this.zzzg();
        this.zzwu();
        zzab.zzhr((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
        sQLiteDatabase.delete("event_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private void zza(String string, zzuf.zza zza2) {
        void var7_13;
        this.zzzg();
        this.zzwu();
        zzab.zzhr((String)string);
        zzab.zzy((Object)zza2);
        zzab.zzy((Object)zza2.amB);
        zzab.zzy((Object)zza2.amA);
        if (zza2.amz == null) {
            this.zzbsd().zzbsx().log("Audience with no ID");
            return;
        }
        int n = zza2.amz;
        for (zzuf.zzb zzb2 : zza2.amB) {
            if (zzb2.amD != null) continue;
            this.zzbsd().zzbsx().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", string, zza2.amz);
            return;
        }
        for (zzuf.zzb zzb2 : zza2.amA) {
            if (zzb2.amD != null) continue;
            this.zzbsd().zzbsx().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", string, zza2.amz);
            return;
        }
        boolean bl = true;
        zzuf.zzb[] zzbArray = zza2.amB;
        int n2 = zzbArray.length;
        boolean bl2 = false;
        while (var7_13 < n2) {
            zzuf.zzb zzb3 = zzbArray[var7_13];
            if (!this.zza(string, n, zzb3)) {
                bl = false;
                break;
            }
            ++var7_13;
        }
        if (bl) {
            void var7_15;
            zzbArray = zza2.amA;
            n2 = zzbArray.length;
            boolean bl3 = false;
            while (var7_15 < n2) {
                zzuf.zzb zzb4 = zzbArray[var7_15];
                if (!this.zza(string, n, (zzuf.zze)zzb4)) {
                    bl = false;
                    break;
                }
                ++var7_15;
            }
        }
        if (!bl) {
            this.zzz(string, n);
        }
    }

    @WorkerThread
    private boolean zza(String string, int n, zzuf.zzb zzb2) {
        zzapo zzapo2;
        byte[] byArray;
        this.zzzg();
        this.zzwu();
        zzab.zzhr((String)string);
        zzab.zzy((Object)zzb2);
        if (TextUtils.isEmpty((CharSequence)zzb2.amE)) {
            this.zzbsd().zzbsx().zze("Event filter had no event name. Audience definition ignored. audienceId, filterId", n, String.valueOf(zzb2.amD));
            return false;
        }
        try {
            int n2 = zzb2.aM();
            byArray = new byte[n2];
            zzapo2 = zzapo.zzbe((byte[])byArray);
            zzb2.zza(zzapo2);
            zzapo2.az();
        }
        catch (IOException iOException) {
            this.zzbsd().zzbsv().zzj("Configuration loss. Failed to serialize event filter", iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.amD);
        contentValues.put("event_name", zzb2.amE);
        contentValues.put("data", byArray);
        try {
            zzapo2 = this.getWritableDatabase();
            long l = zzapo2.insertWithOnConflict("event_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzbsd().zzbsv().log("Failed to insert event filter (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Error storing event filter", (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private boolean zza(String string, int n, zzuf.zze zze2) {
        zzapo zzapo2;
        byte[] byArray;
        this.zzzg();
        this.zzwu();
        zzab.zzhr((String)string);
        zzab.zzy((Object)zze2);
        if (TextUtils.isEmpty((CharSequence)zze2.amT)) {
            this.zzbsd().zzbsx().zze("Property filter had no property name. Audience definition ignored. audienceId, filterId", n, String.valueOf(zze2.amD));
            return false;
        }
        try {
            int n2 = zze2.aM();
            byArray = new byte[n2];
            zzapo2 = zzapo.zzbe((byte[])byArray);
            zze2.zza(zzapo2);
            zzapo2.az();
        }
        catch (IOException iOException) {
            this.zzbsd().zzbsv().zzj("Configuration loss. Failed to serialize property filter", iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.amD);
        contentValues.put("property_name", zze2.amT);
        contentValues.put("data", byArray);
        try {
            zzapo2 = this.getWritableDatabase();
            long l = zzapo2.insertWithOnConflict("property_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzbsd().zzbsv().log("Failed to insert property filter (got -1)");
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Error storing property filter", (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzuf.zzb>> zzat(String string, String string2) {
        this.zzzg();
        this.zzwu();
        zzab.zzhr((String)string);
        zzab.zzhr((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzuf.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzapn zzapn2 = zzapn.zzbd((byte[])byArray);
                zzuf.zzb zzb2 = new zzuf.zzb();
                try {
                    zzuf.zzb cfr_ignored_0 = (zzuf.zzb)zzb2.zzb(zzapn2);
                }
                catch (IOException iOException) {
                    this.zzbsd().zzbsv().zze("Failed to merge filter", string, iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzuf.zzb> arrayList = (ArrayList<zzuf.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzuf.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzuf.zze>> zzau(String string, String string2) {
        this.zzzg();
        this.zzwu();
        zzab.zzhr((String)string);
        zzab.zzhr((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzuf.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzapn zzapn2 = zzapn.zzbd((byte[])byArray);
                zzuf.zze zze2 = new zzuf.zze();
                try {
                    zzuf.zze cfr_ignored_0 = (zzuf.zze)zze2.zzb(zzapn2);
                }
                catch (IOException iOException) {
                    this.zzbsd().zzbsv().zze("Failed to merge filter", string, iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzuf.zze> arrayList = (ArrayList<zzuf.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzuf.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    void zza(String string, int n, zzuh.zzf zzf2) {
        zzapo zzapo2;
        byte[] byArray;
        this.zzzg();
        this.zzwu();
        zzab.zzhr((String)string);
        zzab.zzy((Object)zzf2);
        try {
            int n2 = zzf2.aM();
            byArray = new byte[n2];
            zzapo2 = zzapo.zzbe((byte[])byArray);
            zzf2.zza(zzapo2);
            zzapo2.az();
        }
        catch (IOException iOException) {
            this.zzbsd().zzbsv().zzj("Configuration loss. Failed to serialize filter results", iOException);
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("current_results", byArray);
        try {
            zzapo2 = this.getWritableDatabase();
            long l = zzapo2.insertWithOnConflict("audience_filter_values", null, contentValues, 5);
            if (l == -1L) {
                this.zzbsd().zzbsv().log("Failed to insert filter results (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Error storing filter results", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, zzuh.zzf> zzlr(String string) {
        this.zzzg();
        this.zzwu();
        zzab.zzhr((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_4 = null;
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzapn zzapn2 = zzapn.zzbd((byte[])byArray);
                zzuh.zzf zzf2 = new zzuh.zzf();
                try {
                    zzuh.zzf cfr_ignored_0 = (zzuh.zzf)zzf2.zzb(zzapn2);
                }
                catch (IOException iOException) {
                    this.zzbsd().zzbsv().zzd("Failed to merge filter results. appId, audienceId, error", string, n, iOException);
                    continue;
                }
                arrayMap.put(n, zzf2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    void zzls(String string) {
        this.zzzg();
        this.zzwu();
        zzab.zzhr((String)string);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = 0;
            String[] stringArray = new String[]{string};
            n = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("apps", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("event_filters", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("property_filters", "app_id=?", stringArray);
            if ((n += sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray)) > 0) {
                this.zzbsd().zzbtc().zze("Deleted application data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zze("Error deleting application data. appId, error", string, (Object)sQLiteException);
        }
    }

    @WorkerThread
    void zza(ContentValues contentValues, String string, Object object) {
        zzab.zzhr((String)string);
        zzab.zzy((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
        } else if (object instanceof Long) {
            contentValues.put(string, (Long)object);
        } else if (object instanceof Double) {
            contentValues.put(string, (Double)object);
        } else {
            throw new IllegalArgumentException("Invalid value type");
        }
    }

    @WorkerThread
    @TargetApi(value=11)
    static int zza(Cursor cursor, int n) {
        int n2;
        if (Build.VERSION.SDK_INT >= 11) {
            return cursor.getType(n);
        }
        SQLiteCursor sQLiteCursor = (SQLiteCursor)cursor;
        CursorWindow cursorWindow = sQLiteCursor.getWindow();
        if (cursorWindow.isNull(n2 = cursor.getPosition(), n)) {
            return 0;
        }
        if (cursorWindow.isLong(n2, n)) {
            return 1;
        }
        if (cursorWindow.isFloat(n2, n)) {
            return 2;
        }
        if (cursorWindow.isString(n2, n)) {
            return 3;
        }
        if (cursorWindow.isBlob(n2, n)) {
            return 4;
        }
        return -1;
    }

    @WorkerThread
    Object zzb(Cursor cursor, int n) {
        int n2 = zze.zza(cursor, n);
        switch (n2) {
            case 0: {
                this.zzbsd().zzbsv().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzbsd().zzbsv().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzbsd().zzbsv().zzj("Loaded invalid unknown value type, ignoring it", n2);
        return null;
    }

    @WorkerThread
    public long zzbsj() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    public long zzbsk() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public long zzb(zzuh.zze zze2) throws IOException {
        byte[] byArray;
        this.zzwu();
        this.zzzg();
        zzab.zzy((Object)zze2);
        zzab.zzhr((String)zze2.zzck);
        try {
            int n = zze2.aM();
            byArray = new byte[n];
            zzapo zzapo2 = zzapo.zzbe((byte[])byArray);
            zze2.zza(zzapo2);
            zzapo2.az();
        }
        catch (IOException iOException) {
            this.zzbsd().zzbsv().zzj("Data loss. Failed to serialize event metadata", iOException);
            throw iOException;
        }
        long l = this.zzbrz().zzy(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.zzck);
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Error storing raw event metadata", (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    public boolean zzbsl() {
        long l = this.zzb("select count(1) > 0 from raw_events", (String[])null);
        return l != 0L;
    }

    public void zzac(List<Long> list) {
        zzab.zzy(list);
        this.zzwu();
        this.zzzg();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzbsd().zzbsv().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public void zzlt(String string) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string, string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Failed to remove unused event metadata", (Object)sQLiteException);
        }
    }

    public long zzlu(String string) {
        zzab.zzhr((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzbi(long l) {
        this.zzwu();
        this.zzzg();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzbsd().zzbtc().log("No expired configs for apps with pending events");
                Object var5_5 = null;
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string, long l, zzb zzb2) {
        zzab.zzy((Object)zzb2);
        this.zzwu();
        this.zzzg();
        try (Cursor cursor = null;){
            String string2;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if (TextUtils.isEmpty((CharSequence)string)) {
                cursor = sQLiteDatabase.rawQuery("select app_id, metadata_fingerprint from raw_events where app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", new String[]{String.valueOf(l)});
                if (!cursor.moveToFirst()) {
                    return;
                }
                string = cursor.getString(0);
                string2 = cursor.getString(1);
                cursor.close();
            } else {
                cursor = sQLiteDatabase.rawQuery("select metadata_fingerprint from raw_events where app_id = ? order by rowid limit 1;", new String[]{string});
                if (!cursor.moveToFirst()) {
                    return;
                }
                string2 = cursor.getString(0);
                cursor.close();
            }
            cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id=? and metadata_fingerprint=?", new String[]{string, string2}, null, null, "rowid", "2");
            if (!cursor.moveToFirst()) {
                this.zzbsd().zzbsv().log("Raw event metadata record is missing");
                return;
            }
            byte[] byArray = cursor.getBlob(0);
            zzapn zzapn2 = zzapn.zzbd((byte[])byArray);
            zzuh.zze zze2 = new zzuh.zze();
            try {
                zzuh.zze cfr_ignored_0 = (zzuh.zze)zze2.zzb(zzapn2);
            }
            catch (IOException iOException) {
                this.zzbsd().zzbsv().zze("Data loss. Failed to merge raw event metadata", string, iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return;
            }
            if (cursor.moveToNext()) {
                this.zzbsd().zzbsx().log("Get multiple raw event metadata records, expected one");
            }
            cursor.close();
            zzb2.zzc(zze2);
            cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, "app_id=? and metadata_fingerprint=?", new String[]{string, string2}, null, null, "rowid", null);
            if (!cursor.moveToFirst()) {
                this.zzbsd().zzbsx().log("Raw event data disappeared while in transaction");
                return;
            }
            do {
                long l2 = cursor.getLong(0);
                byArray = cursor.getBlob(3);
                zzapn2 = zzapn.zzbd((byte[])byArray);
                zzuh.zzb zzb3 = new zzuh.zzb();
                try {
                    zzuh.zzb cfr_ignored_1 = (zzuh.zzb)zzb3.zzb(zzapn2);
                }
                catch (IOException iOException) {
                    this.zzbsd().zzbsv().zze("Data loss. Failed to merge raw event", string, iOException);
                    continue;
                }
                zzb3.name = cursor.getString(1);
                zzb3.ano = cursor.getLong(2);
                if (zzb2.zza(l2, zzb3)) continue;
                return;
            } while (cursor.moveToNext());
        }
    }

    public void zza(zzh zzh2, long l) {
        Object object;
        zzuh.zzc zzc2;
        this.zzwu();
        this.zzzg();
        zzab.zzy((Object)zzh2);
        zzab.zzhr((String)zzh2.zzcjf);
        zzuh.zzb zzb2 = new zzuh.zzb();
        zzb2.anp = zzh2.aiA;
        zzb2.ann = new zzuh.zzc[zzh2.aiB.size()];
        int n = 0;
        for (String string : zzh2.aiB) {
            zzc2 = new zzuh.zzc();
            zzb2.ann[n++] = zzc2;
            zzc2.name = string;
            Object object2 = zzh2.aiB.get(string);
            this.zzbrz().zza(zzc2, object2);
        }
        try {
            int n2 = zzb2.aM();
            object = new byte[n2];
            zzc2 = zzapo.zzbe((byte[])object);
            zzb2.zza((zzapo)zzc2);
            zzc2.az();
        }
        catch (IOException iOException) {
            this.zzbsd().zzbsv().zzj("Data loss. Failed to serialize event params/data", iOException);
            return;
        }
        this.zzbsd().zzbtc().zze("Saving event, name, data size", zzh2.mName, ((Object)object).length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzh2.zzcjf);
        contentValues.put("name", zzh2.mName);
        contentValues.put("timestamp", Long.valueOf(zzh2.pJ));
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("data", (byte[])object);
        try {
            zzc2 = this.getWritableDatabase();
            long l2 = zzc2.insert("raw_events", null, contentValues);
            if (l2 == -1L) {
                this.zzbsd().zzbsv().log("Failed to insert raw event (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbsd().zzbsv().zzj("Error storing raw event", (Object)sQLiteException);
        }
    }

    private boolean zzbsm() {
        return this.getContext().getDatabasePath(this.zzaab()).exists();
    }

    static {
        aim.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        aim.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        aim.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        aim.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        aim.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        aim.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        aim.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        aim.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        aim.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        aim.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        aim.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        aim.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        aim.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
        aim.put("app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;");
        aim.put("firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;");
        aim.put("daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;");
    }

    private class zzc
    extends SQLiteOpenHelper {
        zzc(Context context, String string) {
            super(context, string, null, 1);
        }

        @WorkerThread
        public SQLiteDatabase getWritableDatabase() {
            if (!zze.this.aio.zzx(zze.this.zzbsf().zzbra())) {
                throw new SQLiteException("Database open failed");
            }
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zze.this.aio.start();
                zze.this.zzbsd().zzbsv().log("Opening the database failed, dropping and recreating it");
                String string = zze.this.zzaab();
                zze.this.getContext().getDatabasePath(string).delete();
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zze.this.aio.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zze.this.zzbsd().zzbsv().zzj("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
            try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
                Collections.addAll(hashSet, cursor.getColumnNames());
            }
            return hashSet;
        }

        @WorkerThread
        private void zza(SQLiteDatabase sQLiteDatabase, String string, String string2, Map<String, String> map) throws SQLiteException {
            Set<String> set = this.zzb(sQLiteDatabase, string);
            for (String string3 : string2.split(",")) {
                if (set.remove(string3)) continue;
                throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
            }
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    if (set.remove(entry.getKey())) continue;
                    sQLiteDatabase.execSQL((String)entry.getValue());
                }
            }
            if (!set.isEmpty()) {
                throw new SQLiteException(new StringBuilder(30 + String.valueOf(string).length()).append("Table ").append(string).append(" table has extra columns").toString());
            }
        }

        @WorkerThread
        private void zza(SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, Map<String, String> map) throws SQLiteException {
            if (!this.zza(sQLiteDatabase, string)) {
                sQLiteDatabase.execSQL(string2);
            }
            try {
                this.zza(sQLiteDatabase, string, string3, map);
            }
            catch (SQLiteException sQLiteException) {
                zze.this.zzbsd().zzbsv().zzj("Failed to verify columns on table that was just created", string);
                throw sQLiteException;
            }
        }

        @WorkerThread
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            this.zza(sQLiteDatabase, "events", "CREATE TABLE IF NOT EXISTS events ( app_id TEXT NOT NULL, name TEXT NOT NULL, lifetime_count INTEGER NOT NULL, current_bundle_count INTEGER NOT NULL, last_fire_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,lifetime_count,current_bundle_count,last_fire_timestamp", null);
            this.zza(sQLiteDatabase, "user_attributes", "CREATE TABLE IF NOT EXISTS user_attributes ( app_id TEXT NOT NULL, name TEXT NOT NULL, set_timestamp INTEGER NOT NULL, value BLOB NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,set_timestamp,value", null);
            this.zza(sQLiteDatabase, "apps", "CREATE TABLE IF NOT EXISTS apps ( app_id TEXT NOT NULL, app_instance_id TEXT, gmp_app_id TEXT, resettable_device_id_hash TEXT, last_bundle_index INTEGER NOT NULL, last_bundle_end_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id)) ;", "app_id,app_instance_id,gmp_app_id,resettable_device_id_hash,last_bundle_index,last_bundle_end_timestamp", aim);
            this.zza(sQLiteDatabase, "queue", "CREATE TABLE IF NOT EXISTS queue ( app_id TEXT NOT NULL, bundle_end_timestamp INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,bundle_end_timestamp,data", null);
            this.zza(sQLiteDatabase, "raw_events_metadata", "CREATE TABLE IF NOT EXISTS raw_events_metadata ( app_id TEXT NOT NULL, metadata_fingerprint INTEGER NOT NULL, metadata BLOB NOT NULL, PRIMARY KEY (app_id, metadata_fingerprint));", "app_id,metadata_fingerprint,metadata", null);
            this.zza(sQLiteDatabase, "raw_events", "CREATE TABLE IF NOT EXISTS raw_events ( app_id TEXT NOT NULL, name TEXT NOT NULL, timestamp INTEGER NOT NULL, metadata_fingerprint INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,name,timestamp,metadata_fingerprint,data", null);
            this.zza(sQLiteDatabase, "event_filters", "CREATE TABLE IF NOT EXISTS event_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, event_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, event_name, audience_id, filter_id));", "app_id,audience_id,filter_id,event_name,data", null);
            this.zza(sQLiteDatabase, "property_filters", "CREATE TABLE IF NOT EXISTS property_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, property_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, property_name, audience_id, filter_id));", "app_id,audience_id,filter_id,property_name,data", null);
            this.zza(sQLiteDatabase, "audience_filter_values", "CREATE TABLE IF NOT EXISTS audience_filter_values ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, current_results BLOB, PRIMARY KEY (app_id, audience_id));", "app_id,audience_id,current_results", null);
        }

        @WorkerThread
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT >= 9) {
                File file = new File(sQLiteDatabase.getPath());
                file.setReadable(false, false);
                file.setWritable(false, false);
                file.setReadable(true, true);
                file.setWritable(true, true);
            }
        }

        @WorkerThread
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }

    static interface zzb {
        public void zzc(zzuh.zze var1);

        public boolean zza(long var1, zzuh.zzb var3);
    }

    public static class zza {
        long aip;
        long aiq;
        long air;
        long ais;
    }
}

