/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzx;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;

public class zzw
extends zzaa {
    private zzd akz;
    private zzd akA;
    private final PriorityBlockingQueue<FutureTask<?>> akB;
    private final BlockingQueue<FutureTask<?>> akC;
    private final Thread.UncaughtExceptionHandler akD;
    private final Thread.UncaughtExceptionHandler akE;
    private final Object akF = new Object();
    private final Semaphore akG = new Semaphore(2);
    private volatile boolean akH;
    private static final AtomicLong akI = new AtomicLong(Long.MIN_VALUE);

    zzw(zzx zzx2) {
        super(zzx2);
        this.akB = new PriorityBlockingQueue();
        this.akC = new LinkedBlockingQueue();
        this.akD = new zzb("Thread death: Uncaught exception on worker thread");
        this.akE = new zzb("Thread death: Uncaught exception on network thread");
    }

    @Override
    protected void zzwv() {
    }

    @Override
    public void zzwu() {
        if (Thread.currentThread() != this.akz) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzbrs() {
        if (Thread.currentThread() != this.akA) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzzg();
        zzab.zzy(callable);
        zzc<V> zzc2 = new zzc<V>(callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.akz) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzzg();
        zzab.zzy(callable);
        zzc<V> zzc2 = new zzc<V>(callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.akz) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public void zzm(Runnable runnable) throws IllegalStateException {
        this.zzzg();
        zzab.zzy((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzc<?> zzc2) {
        Object object = this.akF;
        synchronized (object) {
            this.akB.add(zzc2);
            if (this.akz == null) {
                this.akz = new zzd("Measurement Worker", this.akB);
                this.akz.setUncaughtExceptionHandler(this.akD);
                this.akz.start();
            } else {
                this.akz.zznk();
            }
        }
    }

    public void zzn(Runnable runnable) throws IllegalStateException {
        this.zzzg();
        zzab.zzy((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on network thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(FutureTask<?> futureTask) {
        Object object = this.akF;
        synchronized (object) {
            this.akC.add(futureTask);
            if (this.akA == null) {
                this.akA = new zzd("Measurement Network", this.akC);
                this.akA.setUncaughtExceptionHandler(this.akE);
                this.akA.start();
            } else {
                this.akA.zznk();
            }
        }
    }

    static class zza
    extends RuntimeException {
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String akJ;

        public zzb(String string) {
            zzab.zzy((Object)string);
            this.akJ = string;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            zzw.this.zzbsd().zzbsv().zzj(this.akJ, throwable);
        }
    }

    private final class zzc<V>
    extends FutureTask<V>
    implements Comparable<zzc> {
        private final long akL;
        private final boolean akM;
        private final String akJ;

        zzc(Callable<V> callable, boolean bl, String string) {
            super(callable);
            zzab.zzy((Object)string);
            this.akL = akI.getAndIncrement();
            this.akJ = string;
            this.akM = bl;
            if (this.akL == Long.MAX_VALUE) {
                zzw.this.zzbsd().zzbsv().log("Tasks index overflow");
            }
        }

        zzc(Runnable runnable, boolean bl, String string) {
            super(runnable, null);
            zzab.zzy((Object)string);
            this.akL = akI.getAndIncrement();
            this.akJ = string;
            this.akM = bl;
            if (this.akL == Long.MAX_VALUE) {
                zzw.this.zzbsd().zzbsv().log("Tasks index overflow");
            }
        }

        @Override
        protected void setException(Throwable throwable) {
            zzw.this.zzbsd().zzbsv().zzj(this.akJ, throwable);
            if (throwable instanceof zza) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
            }
            super.setException(throwable);
        }

        public int zzb(zzc zzc2) {
            if (this.akM != zzc2.akM) {
                return this.akM ? -1 : 1;
            }
            if (this.akL < zzc2.akL) {
                return -1;
            }
            if (this.akL > zzc2.akL) {
                return 1;
            }
            zzw.this.zzbsd().zzbsw().zzj("Two tasks share the same index. index", this.akL);
            return 0;
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.zzb((zzc)object);
        }
    }

    private final class zzd
    extends Thread {
        private final Object akN;
        private final BlockingQueue<FutureTask<?>> akO;

        public zzd(String string, BlockingQueue<FutureTask<?>> blockingQueue) {
            zzab.zzy((Object)string);
            zzab.zzy(blockingQueue);
            this.akN = new Object();
            this.akO = blockingQueue;
            this.setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    zzw.this.akG.acquire();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
            }
            try {
                while (true) {
                    FutureTask futureTask;
                    if ((futureTask = (FutureTask)this.akO.poll()) != null) {
                        futureTask.run();
                        continue;
                    }
                    Object object = this.akN;
                    synchronized (object) {
                        if (this.akO.peek() == null && !zzw.this.akH) {
                            try {
                                this.akN.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.zza(interruptedException);
                            }
                        }
                    }
                    object = zzw.this.akF;
                    synchronized (object) {
                        if (this.akO.peek() == null) {
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = zzw.this.akF;
                synchronized (object) {
                    zzw.this.akG.release();
                    zzw.this.akF.notifyAll();
                    if (this == zzw.this.akz) {
                        zzw.this.akz = null;
                    } else if (this == zzw.this.akA) {
                        zzw.this.akA = null;
                    } else {
                        zzw.this.zzbsd().zzbsv().log("Current scheduler thread is neither worker nor network");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zznk() {
            Object object = this.akN;
            synchronized (object) {
                this.akN.notifyAll();
            }
        }

        private void zza(InterruptedException interruptedException) {
            zzw.this.zzbsd().zzbsx().zzj(String.valueOf(this.getName()).concat(" was interrupted"), interruptedException);
        }
    }
}

