/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class zzn
extends zzaa {
    private static final X500Principal apj = new X500Principal("CN=Android Debug,O=Android,C=US");
    private String zzcpe;
    private String G;
    private int apk;
    private String anD;
    private String F;
    private long apl;
    private String anw;

    zzn(zzx zzx2) {
        super(zzx2);
    }

    @Override
    protected void zzym() {
        Object object;
        boolean bl;
        CharSequence charSequence;
        Object object2;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = this.getContext().getPackageName();
        PackageManager packageManager = this.getContext().getPackageManager();
        if (packageManager == null) {
            this.zzbvg().zzbwc().log("PackageManager is null, app identity information might be inaccurate");
        } else {
            string = packageManager.getInstallerPackageName(string4);
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                object2 = packageManager.getPackageInfo(this.getContext().getPackageName(), 0);
                if (object2 != null) {
                    charSequence = packageManager.getApplicationLabel(((PackageInfo)object2).applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = ((PackageInfo)object2).versionName;
                    n = ((PackageInfo)object2).versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzbvg().zzbwc().zzj("Error retrieving package info: appName", string3);
            }
        }
        this.zzcpe = string4;
        this.anD = string;
        this.G = string2;
        this.apk = n;
        this.F = string3;
        this.apl = 0L;
        object2 = zzal.zzfi("MD5");
        if (object2 == null) {
            this.zzbvg().zzbwc().log("Could not get MD5 instance");
            this.apl = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zzbwb()) {
                    charSequence = packageManager.getPackageInfo(this.getContext().getPackageName(), 64);
                    if (((PackageInfo)charSequence).signatures != null && ((PackageInfo)charSequence).signatures.length > 0) {
                        byte[] byArray = ((MessageDigest)object2).digest(((PackageInfo)charSequence).signatures[0].toByteArray());
                        this.apl = zzal.zzx(byArray);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzbvg().zzbwc().zzj("Package name not found", (Object)nameNotFoundException);
            }
        }
        charSequence = this.zzbvi().zzact() ? zzqw.zzb((Context)this.getContext(), (String)"-", (boolean)true) : zzqw.zzcb((Context)this.getContext());
        boolean bl2 = bl = charSequence != null && charSequence.isSuccess();
        if (!bl) {
            this.zzdr((Status)charSequence);
        }
        boolean bl3 = false;
        if (bl) {
            object = this.zzbvi().zzbud();
            if (this.zzbvi().zzbuc()) {
                this.zzbvg().zzbwh().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                this.zzbvg().zzbwh().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && this.zzbvi().zzasm()) {
                this.zzbvg().zzbwh().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl3 = true;
                this.zzbvg().zzbwj().log("Collection enabled");
            }
        }
        this.anw = "";
        if (!this.zzbvi().zzact()) {
            try {
                object = zzqw.zzasl();
                Object object3 = this.anw = TextUtils.isEmpty((CharSequence)object) ? "" : object;
                if (bl3) {
                    this.zzbvg().zzbwj().zze("App package, google app id", this.zzcpe, this.anw);
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.zzbvg().zzbwc().zzj("getGoogleAppId or isMeasurementEnabled failed with exception", illegalStateException);
            }
        }
    }

    protected void zzdr(Status status) {
        if (status == null) {
            this.zzbvg().zzbwc().log("GoogleService failed to initialize (no status)");
        } else {
            this.zzbvg().zzbwc().zze("GoogleService failed to initialize, status", status.getStatusCode(), status.getStatusMessage());
        }
    }

    AppMetadata zzmi(String string) {
        return new AppMetadata(this.zzti(), this.zzbsr(), this.zzyt(), this.zzbwa(), this.zzbsx(), this.zzbsy(), this.zzbsz(), string, this.anq.isEnabled(), !this.zzbvh().aqe, this.zzbvh().zzbst());
    }

    String zzti() {
        this.zzaax();
        return this.zzcpe;
    }

    String zzbsr() {
        this.zzaax();
        return this.anw;
    }

    String zzyt() {
        this.zzaax();
        return this.G;
    }

    int zzbwa() {
        this.zzaax();
        return this.apk;
    }

    String zzbsx() {
        this.zzaax();
        return this.anD;
    }

    long zzbsy() {
        return this.zzbvi().zzbsy();
    }

    long zzbsz() {
        this.zzaax();
        return this.apl;
    }

    boolean zzbwb() {
        try {
            PackageInfo packageInfo = this.getContext().getPackageManager().getPackageInfo(this.getContext().getPackageName(), 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
                return x509Certificate.getSubjectX500Principal().equals(apj);
            }
        }
        catch (CertificateException certificateException) {
            this.zzbvg().zzbwc().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzbvg().zzbwc().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }
}

