/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzx;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;

public class zzw
extends zzaa {
    private zzd atG;
    private zzd atH;
    private final PriorityBlockingQueue<FutureTask<?>> atI;
    private final BlockingQueue<FutureTask<?>> atJ;
    private final Thread.UncaughtExceptionHandler atK;
    private final Thread.UncaughtExceptionHandler atL;
    private final Object atM = new Object();
    private final Semaphore atN = new Semaphore(2);
    private volatile boolean atO;
    private static final AtomicLong atP = new AtomicLong(Long.MIN_VALUE);

    zzw(zzx zzx2) {
        super(zzx2);
        this.atI = new PriorityBlockingQueue();
        this.atJ = new LinkedBlockingQueue();
        this.atK = new zzb("Thread death: Uncaught exception on worker thread");
        this.atL = new zzb("Thread death: Uncaught exception on network thread");
    }

    @Override
    protected void zzzy() {
    }

    @Override
    public void zzzx() {
        if (Thread.currentThread() != this.atG) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzbvo() {
        if (Thread.currentThread() != this.atH) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public boolean zzdg() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzy(callable);
        zzc<V> zzc2 = new zzc<V>(callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.atG) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzy(callable);
        zzc<V> zzc2 = new zzc<V>(callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.atG) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public void zzm(Runnable runnable) throws IllegalStateException {
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzy((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzc<?> zzc2) {
        Object object = this.atM;
        synchronized (object) {
            this.atI.add(zzc2);
            if (this.atG == null) {
                this.atG = new zzd("Measurement Worker", this.atI);
                this.atG.setUncaughtExceptionHandler(this.atK);
                this.atG.start();
            } else {
                this.atG.zzpi();
            }
        }
    }

    public void zzn(Runnable runnable) throws IllegalStateException {
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzy((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on network thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(FutureTask<?> futureTask) {
        Object object = this.atM;
        synchronized (object) {
            this.atJ.add(futureTask);
            if (this.atH == null) {
                this.atH = new zzd("Measurement Network", this.atJ);
                this.atH.setUncaughtExceptionHandler(this.atL);
                this.atH.start();
            } else {
                this.atH.zzpi();
            }
        }
    }

    static class zza
    extends RuntimeException {
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String atQ;

        public zzb(String string) {
            com.google.android.gms.common.internal.zzaa.zzy((Object)string);
            this.atQ = string;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            zzw.this.zzbwb().zzbwy().zzj(this.atQ, throwable);
        }
    }

    private final class zzc<V>
    extends FutureTask<V>
    implements Comparable<zzc> {
        private final long atS;
        private final boolean atT;
        private final String atQ;

        zzc(Callable<V> callable, boolean bl, String string) {
            super(callable);
            com.google.android.gms.common.internal.zzaa.zzy((Object)string);
            this.atS = atP.getAndIncrement();
            this.atQ = string;
            this.atT = bl;
            if (this.atS == Long.MAX_VALUE) {
                zzw.this.zzbwb().zzbwy().log("Tasks index overflow");
            }
        }

        zzc(Runnable runnable, boolean bl, String string) {
            super(runnable, null);
            com.google.android.gms.common.internal.zzaa.zzy((Object)string);
            this.atS = atP.getAndIncrement();
            this.atQ = string;
            this.atT = bl;
            if (this.atS == Long.MAX_VALUE) {
                zzw.this.zzbwb().zzbwy().log("Tasks index overflow");
            }
        }

        @Override
        protected void setException(Throwable throwable) {
            zzw.this.zzbwb().zzbwy().zzj(this.atQ, throwable);
            if (throwable instanceof zza) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
            }
            super.setException(throwable);
        }

        public int zzb(@NonNull zzc zzc2) {
            if (this.atT != zzc2.atT) {
                return this.atT ? -1 : 1;
            }
            if (this.atS < zzc2.atS) {
                return -1;
            }
            if (this.atS > zzc2.atS) {
                return 1;
            }
            zzw.this.zzbwb().zzbwz().zzj("Two tasks share the same index. index", this.atS);
            return 0;
        }

        @Override
        public /* synthetic */ int compareTo(@NonNull Object object) {
            return this.zzb((zzc)object);
        }
    }

    private final class zzd
    extends Thread {
        private final Object atU;
        private final BlockingQueue<FutureTask<?>> atV;

        public zzd(String string, BlockingQueue<FutureTask<?>> blockingQueue) {
            com.google.android.gms.common.internal.zzaa.zzy((Object)string);
            com.google.android.gms.common.internal.zzaa.zzy(blockingQueue);
            this.atU = new Object();
            this.atV = blockingQueue;
            this.setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    zzw.this.atN.acquire();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
            }
            try {
                while (true) {
                    FutureTask futureTask;
                    if ((futureTask = (FutureTask)this.atV.poll()) != null) {
                        futureTask.run();
                        continue;
                    }
                    Object object = this.atU;
                    synchronized (object) {
                        if (this.atV.peek() == null && !zzw.this.atO) {
                            try {
                                this.atU.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.zza(interruptedException);
                            }
                        }
                    }
                    object = zzw.this.atM;
                    synchronized (object) {
                        if (this.atV.peek() == null) {
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = zzw.this.atM;
                synchronized (object) {
                    zzw.this.atN.release();
                    zzw.this.atM.notifyAll();
                    if (this == zzw.this.atG) {
                        zzw.this.atG = null;
                    } else if (this == zzw.this.atH) {
                        zzw.this.atH = null;
                    } else {
                        zzw.this.zzbwb().zzbwy().log("Current scheduler thread is neither worker nor network");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzpi() {
            Object object = this.atU;
            synchronized (object) {
                this.atU.notifyAll();
            }
        }

        private void zza(InterruptedException interruptedException) {
            zzw.this.zzbwb().zzbxa().zzj(String.valueOf(this.getName()).concat(" was interrupted"), interruptedException);
        }
    }
}

